<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

/** @var \Akeeba\BRS\Platform\View\Finalise\Html $this */

$text = $this->getContainer()->get('language');
?>

<?php if ($this->autoprepend_disabled): ?>
	<div class="alert alert-warning mb-3">
		<?= $text->text('FINALISE_AUTOPREPEND_WARN')?>
	</div>
<?php endif; ?>

<?php if($this->replace_warnings):?>
	<div class="card border-warning mb-3">
		<h4 class="card-header bg-warning text-white">
			<?= $text->text('FINALISE_REPLACEMENTS_WARN')?>
		</h4>
		<div class="card-body">
			<?= $text->sprintf('FINALISE_REPLACEMENTS_WARN_BODY', implode('<br/>', $this->replace_warnings))?>
		</div>
	</div>
<?php endif; ?>

<?= $this->loadAnyTemplate('finalise/minimal') ?>
