<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_AKEEBA') or die();

/** @var \Akeeba\BRS\Platform\View\Replacedata\Html $this */

$text = $this->getContainer()->get('language');
?>

<div class="alert alert-info">
	<span class="fa fa-info-circle me-1" aria-hidden="true"></span>
	<?= $text->text('SETUP_LBL_REPLACEDATA_INTRO') ?>
</div>

<div id="replacementsGUI">
	<div class="card border-primary mb-3">
		<h3 class="card-header bg-primary text-white">
			<?= $text->text('SETUP_LBL_REPLACEDATA_REPLACEMENTS_HEAD') ?>
		</h3>

		<div class="card-body">
			<div id="textBoxEditor">
				<p class="form-text d-none">
					<?= $text->text('SETUP_LBL_REPLACEDATA_REPLACEMENTS_HELP') ?>
				</p>

				<div class="container">
					<div class="row row-cols-2">
						<div class="col">
							<h4>
								<?= $text->text('SETUP_LBL_REPLACEDATA_FROM') ?>
							</h4>
							<textarea rows="5" name="replaceFrom" class="w-100"
							          id="replaceFrom"><?= implode("\n", array_keys($this->replacements)) ?></textarea>
						</div>

						<div class="col">
							<h4>
								<?= $text->text('SETUP_LBL_REPLACEDATA_TO') ?>
							</h4>
							<textarea rows="5" name="replaceTo" class="w-100"
							          id="replaceTo"><?= implode("\n", $this->replacements) ?></textarea>
						</div>
					</div>
				</div>
			</div>

			<div id="keyValueEditor" class="d-none">
				<p class="form-text d-none">
					<?= $text->text('SETUP_LBL_REPLACEDATA_REPLACEMENTS_JSGUI_HELP') ?>
				</p>
				<div id="keyValueContainer" class="w-100"></div>
			</div>
		</div>

	</div>

	<div class="card border-info">
		<h3 class="card-header bg-info text-white">
			<?= $text->text('SETUP_LBL_REPLACEDATA_TABLES_HEAD') ?>
		</h3>

		<div class="card-body">
			<p class="form-text d-none">
				<?= $text->text('SETUP_LBL_REPLACEDATA_TABLES_HELP') ?>
			</p>

			<div class="container">
				<div class="row">
					<div class="col-8">

						<div class="row mb-3">
							<div class="col">
								<div class="form-check form-switch">
									<input type="checkbox" class="form-check-input"
									       id="replaceguid" name="replaceguid"
									       role="switch" value="1"
									       checked="checked"
									>
									<label for="replaceguid" class="form-check-label">
										<?= $text->text('SETUP_LBL_REPLACEDATA_TABLES_REPLACEGUID') ?>
									</label>
								</div>
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_REPLACEDATA_TABLES_REPLACEGUID_HELP') ?>
								</div>
							</div>
						</div>

						<select multiple size="10" id="extraTables" class="form-select">
							<?php if (!empty($this->otherTables))
							{
								foreach ($this->otherTables as $table):
									$selected = '';

									// Mark the table as selected only if it has the same db prefix of the main site AND it's not a table in the blacklist
									if ((substr($table, 0, $this->prefixLen) == $this->prefix) && !in_array($table, $this->deselectTables))
									{
										$selected = 'selected="selected"';
									}
									?>
									<option value="<?= $this->escape($table) ?>" <?= $selected ?>><?= $this->escape($table) ?></option>
								<?php endforeach;
							} ?>
						</select>
					</div>

					<div class="col">
						<div>
							<button type="button" id="showAdvanced" class="btn btn-primary" data-bs-toggle="collapse"
									data-bs-target="#replaceThrottle" aria-expanded="false" aria-controls="replaceThrottle"
							>
								<span class="fa fa-gears me-1" aria-hidden="true"></span>
								<?= $text->text('SETUP_SHOW_ADVANCED') ?>
							</button>
						</div>
						<div id="replaceThrottle" class="collapse mt-3">
							<h4><?= $text->text('SETUP_ADVANCE_OPTIONS') ?></h4>

							<div class="mb-3">
								<label for="column_size" class="form-label">
									<?= $text->text('SETUP_REPLACE_DATA_COLUMNSIZE') ?>
								</label>
								<div class="input-group">
									<input type="text" id="column_size" name="column_size" class="form-control" value="1048576" />
									<span class="input-group-text">
										<?= $text->text('SETUP_REPLACEDATA_UOM_BYTES') ?>
									</span>
								</div>
								<div class="form-text d-none"><?= $text->text('SETUP_REPLACE_DATA_COLUMNSIZE_HELP') ?></div>
							</div>

							<div class="mb-3">
								<label for="batchSize" class="form-label">
									<?= $text->text('SETUP_REPLACE_DATA_BATCHSIZE') ?>
								</label>
								<div class="input-group">
									<input type="text" id="batchSize" name="batchSize" class="form-control" value="100" />
									<span class="input-group-text">
										<?= $text->text('SETUP_REPLACEDATA_UOM_ROWS') ?>
									</span>
								</div>
							</div>

							<div class="mb-3">
								<label for="min_exec" class="form-label">
									<?= $text->text('SETUP_REPLACE_DATA_MIN_EXEC') ?>
								</label>
								<div class="input-group">
									<input type="text" id="min_exec" name="min_exec" class="form-control" value="0" />
									<span class="input-group-text">
										<?= $text->text('SETUP_REPLACEDATA_UOM_SECONDS') ?>
									</span>
								</div>
							</div>

							<div class="mb-3">
								<label for="max_exec" class="form-label">
									<?= $text->text('SETUP_REPLACE_DATA_MAX_EXEC') ?>
								</label>
								<div class="input-group">
									<input type="text" id="max_exec" name="max_exec" class="form-control" value="3" />
									<span class="input-group-text">
										<?= $text->text('SETUP_REPLACEDATA_UOM_SECONDS') ?>
									</span>
								</div>
							</div>

							<div class="mb-3">
								<label for="runtime_bias" class="form-label">
									<?= $text->text('SETUP_REPLACE_DATA_RUNTIME_BIAS') ?>
								</label>
								<div class="input-group">
									<input type="text" id="runtime_bias" name="runtime_bias" class="form-control" value="75" />
									<span class="input-group-text">
										<?= $text->text('SETUP_REPLACEDATA_UOM_PERCENT') ?>
									</span>
								</div>
							</div>

							<a href="index.php?view=replacedata&force=1" class="btn btn-danger btn-sm">
								<span class="fa fa-fire-alt me-1" aria-hidden="true"></span>
								<?= $text->text('SETUP_LBL_REPLACEDATA_BTN_RESET') ?>
							</a>
						</div>
					</div>
				</div>
			</div>

		</div>

	</div>
</div>

<div id="replacementsProgress" class="card border-info d-none">
	<h3 class="card-header bg-info text-white">
		<?= $text->text('SETUP_LBL_REPLACEDATA_PROGRESS_HEAD') ?>
	</h3>

	<div class="card-body">
		<p class="text-muted small">
			<?= $text->text('SETUP_LBL_REPLACEDATA_PROGRESS_HELP') ?>
		</p>
		<pre id="replacementsProgressText"></pre>
		<div id="blinkenlights" class="text-center">
			<span class="badge bg-secondary">&nbsp;&nbsp;&nbsp;</span>
			<span class="badge bg-primary">&nbsp;&nbsp;&nbsp;</span>
			<span class="badge bg-secondary">&nbsp;&nbsp;&nbsp;</span>
			<span class="badge bg-primary">&nbsp;&nbsp;&nbsp;</span>
		</div>
	</div>
</div>

<?php /* Replacement retry after error */ ?>
<div id="retry-panel" class="d-none">
	<div class="card border-warning">
		<h3 class="card-header bg-warning text-white">
			<?= $text->text('SETUP_REPLACE_HEADER_RETRY') ?>
		</h3>
		<div id="retryframe" class="card-body">
			<p><?= $text->text('SETUP_REPLACE_TEXT_FAILEDRETRY') ?></p>
			<p>
				<strong>
					<?= $text->text('SETUP_REPLACE_TEXT_WILLRETRY') ?>
					<span id="akeeba-retry-timeout">0</span>
					<?= $text->text('SETUP_REPLACE_TEXT_WILLRETRYSECONDS') ?>
				</strong>
				<br />
				<button class="btn btn-sm btn-danger" id="retryCancel">
					<span class="fa fa-xmark me-1"></span>
					<?= $text->text('SETUP_REPLACEDATA_BTN_CANCEL') ?>
				</button>
				<button class="btn btn-sm btn-success" id="retryResume">
					<span class="fa fa-retweet me-1"></span>
					<?= $text->text('SETUP_REPLACE_TEXT_BTNRESUME') ?>
				</button>
			</p>

			<p><?= $text->text('SETUP_REPLACE_TEXT_LASTERRORMESSAGEWAS') ?></p>
			<p id="replacement-error-message-retry"></p>
			<pre id="replacement-error-context-retry" class="text-muted small"></pre>
		</div>
	</div>
</div>

<?php /* Replacement error (halt) */ ?>
<div id="error-panel" class="d-none">
	<div class="card border-danger">
		<h3 class="card-header bg-danger text-white">
			<?= $text->text('SETUP_REPLACE_HEADER_REPLACEFAILED') ?>
		</h3>
		<div id="errorframe" class="card-body">
			<p>
				<?= $text->text('SETUP_REPLACE_TEXT_REPLACEFAILED') ?>
			</p>
			<p id="replacement-error-message"></p>
			<pre id="replacement-error-context" class="text-muted small"></pre>

			<div class="alert alert-info" id="error-panel-troubleshooting">
				<p>
					<?= $text->sprintf('SETUP_REPLACE_TEXT_RTFMTOSOLVE', 'https://www.akeeba.com/documentation/akeeba-solo/angie-wordpress-replace.html') ?>
				</p>
				<p>
					<?= $text->sprintf('SETUP_REPLACE_TEXT_SOLVEISSUE_PRO', 'https://www.akeeba.com/support.html') ?>
				</p>
			</div>

			<a class="btn btn-lg btn-dark" id="errorShowDocs"
			   href="https://www.akeeba.com/documentation/akeeba-solo/angie-wordpress-replace.html" target="_blank">
				<span class="fa fa-book-open me-1" aria-hidden="true"></span>
				<?= $text->text('SETUP_REPLACE_TROUBLESHOOTINGDOCS') ?>
			</a>
		</div>
	</div>
</div>

<?php /* Replacement warnings */ ?>
<div id="warning-panel" class="mt-3 d-none">
	<div class="card border-warning">
		<h3 class="card-header bg-warning text-white">
			<?= $text->text('SETUP_REPLACE_HEADER_REPLACEWARNING') ?>
		</h3>

		<div id="warnings-list" class="card-body">
		</div>
	</div>
</div>
