<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

defined('_AKEEBA') || die;

/** @var \Akeeba\BRS\Platform\View\Setup\Html $this */

use Akeeba\BRS\Framework\Helper\Select;

$text         = $this->getContainer()->get('language');
$selectHelper = new Select($this->getContainer());
?>
<form name="setupForm" action="index.php" method="post" class="container">
	<input type="hidden" name="view" value="setup" />
	<input type="hidden" name="task" value="apply" />

	<div class="container">
		<div class="row row-cols-1 row-cols-md-2">
			<!-- Site parameters -->
			<div class="col">
				<div class="card border-primary mb-3" style="margin-top: 0">
					<h3 class="card-header bg-primary text-white">
						<?= $text->text('SETUP_HEADER_SITEPARAMS') ?>
					</h3>

					<div class="card-body">
						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="blogname">
								<?= $text->text('SETUP_LBL_SITENAME') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="blogname" name="blogname" class="form-control"
									   value="<?= $this->stateVars->blogname ?>" required="required" aria-required="true" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_SITENAME_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="blogdescription">
								<?= $text->text('SETUP_LBL_TAGLINE') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="blogdescription" name="blogdescription" class="form-control"
									   value="<?= $this->stateVars->blogdescription ?>" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_TAGLINE_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="homeurl">
								<?= $text->text('SETUP_LBL_WPHOME') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="homeurl" name="homeurl" class="form-control"
									   value="<?= $this->stateVars->homeurl ?>" required="required" aria-required="true" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_WPHOME_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="siteurl">
								<?= $text->text('SETUP_LBL_WPSITE') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="siteurl" name="siteurl" class="form-control"
									   value="<?= $this->stateVars->siteurl ?>" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_WPSITE_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="dbcharset">
								<?= $text->text('SETUP_LBL_CHARSET') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="dbcharset" name="dbcharset" class="form-control"
									   value="<?= $this->stateVars->dbcharset ?>" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_CHARSET_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="dbcollation">
								<?= $text->text('SETUP_LBL_COLLATION') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="dbcollation" name="dbcollation" class="form-control"
									   value="<?= $this->stateVars->dbcollation ?>" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LBL_COLLATION_HELP') ?>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
			<!-- Server config handling -->
			<div class="col">
				<div class="card border-warning mb-3">
					<h3 class="card-header bg-warning text-white">
						<?= $text->text('SETUP_HEADER_SERVERCONFIG') ?>
					</h3>

					<div class="card-body">
						<?php if ($this->hasAutoPrepend): ?>
							<div class="alert alert-warning">
							<?= $text->sprintf('SETUP_LBL_SERVERCONFIG_AUTOPREPEND_WARN', 'http://php.net/manual/en/ini.core.php#ini.auto-prepend-file') ?>
						</div>
						<?php endif; ?>

						<?php if ($this->hasHtaccess): ?>
							<div class="row mb-3">
								<label class="col-sm-3 col-form-label" for="htaccessHandling"><?= $text->text('SETUP_LBL_HTACCESSCHANGE_LBL') ?></label>
								<div class="col-sm-9">
									<?= $selectHelper->genericlist(
										$this->htaccessOptions, 'htaccessHandling', [
										'list.selected' => $this->htaccessOptionSelected,
										'list.attr'     => [
											'class' => 'form-select',
										],
									]
									) ?>
									<div class="form-text d-none">
										  <?= $text->text('SETUP_LBL_HTACCESSCHANGE_WORDPRESS_DESC') ?>
									</div>
								</div>
							</div>
						<?php endif; ?>

						<div class="row mb-3">
							<div class="col offset-sm-3">
								<div class="form-check form-switch">
									<input type="checkbox" class="form-check-input"
										   id="disable_autoprepend" name="disable_autoprepend"
										   role="switch" value="1"
										<?= $this->auto_prepend['disabled'] ?>
										<?= $this->auto_prepend['checked'] ?>
									>
									<label for="disable_autoprepend" class="form-check-label"
										<?= $this->auto_prepend['disabled'] ?>
									>
										<?= $text->text('SETUP_LBL_SERVERCONFIG_AUTOPREPEND') ?>
									</label>
								</div>
							</div>
						</div>

						<div class="row mb-3">
							<div class="col offset-sm-3">
								<div class="form-check form-switch">
									<input type="checkbox" class="form-check-input"
										   id="removehtpasswd" name="removehtpasswd"
										   role="switch" value="1"
										<?= $this->removeHtpasswdOptions['disabled'] ?>
										<?= $this->removeHtpasswdOptions['checked'] ?>
									>
									<label for="removehtpasswd" class="form-check-label"
										<?= $this->removeHtpasswdOptions['disabled'] ?>
									>
										<?= $text->text('SETUP_LBL_SERVERCONFIG_REMOVEHTPASSWD') ?>
									</label>
								</div>
								<div class="form-text d-none">
									<?= $text->text($this->removeHtpasswdOptions['help']) ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="row row-cols-1 row-cols-md-2">
			<!-- Administrator / Super Administrator -->
			<div class="col">
				<div class="card border-secondary mb-3">
					<h3 class="card-header bg-secondary text-white">
						<?= $text->text('SETUP_HEADER_SUPERADMINPARAMS') ?>
					</h3>

					<div class="card-body">
						<div class="row mb-3">
							<label class="col-sm-3 col-form-label" for="superuserid">
								<?= $text->text('SETUP_LABEL_SUPERADMIN') ?>
							</label>
							<div class="col-sm-9">
								<?= $selectHelper->superusers() ?>
								<div class="form-text d-none">
									<?= $text->text('SETUP_LABEL_SUPERADMIN_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3" id="superuseremail_container">
							<label class="col-sm-3 col-form-label" for="superuseremail">
								<?= $text->text('SETUP_LABEL_SUPERUSEREMAIL') ?>
							</label>
							<div class="col-sm-9">
								<input type="text" id="superuseremail" name="superuseremail" class="form-control"
									   value="" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LABEL_SUPERADMINEMAIL_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3" id="superuserpassword_container">
							<label class="col-sm-3 col-form-label" for="superuserpassword">
								<?= $text->text('SETUP_LABEL_SUPERUSERPASSWORD') ?>
							</label>
							<div class="col-sm-9">
								<input type="password" id="superuserpassword" name="superuserpassword" class="form-control"
									   value="" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LABEL_SUPERADMINDPASSWORD_HELP') ?>
								</div>
							</div>
						</div>

						<div class="row mb-3" id="superuserpasswordrepeat_container">
							<label class="col-sm-3 col-form-label" for="superuserpasswordrepeat">
								<?= $text->text('SETUP_LABEL_SUPERUSERPASSWORDREPEAT') ?>
							</label>
							<div class="col-sm-9">
								<input type="password" id="superuserpasswordrepeat" name="superuserpasswordrepeat"
									   class="form-control" value="" />
								<div class="form-text d-none">
									<?= $text->text('SETUP_LABEL_SUPERUSERPASSWORDREPEAT_HELP') ?>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</form>