<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\BRS\Platform\Cli\Step;

defined('_AKEEBA') or die();

use Akeeba\BRS\Framework\Cli\AbstractInstallationStep;

class Finalise extends AbstractInstallationStep
{
	/**
	 * @inheritDoc
	 */
	public function isApplicable(): bool
	{
		return true;
	}

	/**
	 * @inheritDoc
	 */
	public function validate(): void
	{
		// No-op
	}

	/**
	 * @inheritDoc
	 */
	public function execute(): void
	{
		$output = $this->getContainer()->get('output');
		$model  = $this->getContainer()->get('mvcFactory')->model('Finalise');

		$output->title( 'Updating .htaccess');

		$model->updatehtaccess();
	}
}