<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\BRS\Platform\Controller;

defined('_AKEEBA') or die();

use Akeeba\BRS\Controller\AbstractSetup;

/**
 * Controller for the Site Setup step for WordPress sites.
 *
 * @since  10.0
 */
class Setup extends AbstractSetup
{
	protected $nextView = 'replacedata';

	public function apply(): void
	{
		/** @var \Akeeba\BRS\Platform\Model\Setup $model */
		$model = $this->getThisModel();
		$input = $this->getContainer()->get('input');
		// ⚠️ DO NOT CHANGE THE DEFAULT VALUE. Getting the state of a CB *MUST* use the default value 0.
		$model->setState('disable_autoprepend', $input->getBool('disable_autoprepend', false));
		// ⚠️ DO NOT CHANGE THE DEFAULT VALUE. Getting the state of a CB *MUST* use the default value 0.
		$model->setState('removehtpasswd', $input->getBool('removehtpasswd', false));
		$model->setState('htaccessHandling', $input->getCmd('htaccessHandling', 'none'));

		parent::apply();
	}


}