<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\BRS\Platform\View\Finalise;

defined('_AKEEBA') or die();

class Html extends \Akeeba\BRS\View\Finalise\Html
{
	/**
	 * Did we get any warning during the replace step? If so, warn the user.
	 *
	 * @var   array
	 * @since 10.0
	 */
	public $replace_warnings = [];

	/**
	 * The user disabled auto-prepend scripts? If so, warn them to re-enable them.
	 *
	 * @var   bool
	 * @since 10.0
	 */
	public $autoprepend_disabled = false;

	/** @inheritDoc */
	public function onBeforeMain(): bool
	{
		$this->getContainer()->get('application')
			->getDocument()
			->addMediaScript('finalise.js');

		$session                    = $this->getContainer()->get('session');
		$this->autoprepend_disabled = $session->get('autoprepend_disabled', false);
		$this->replace_warnings     = $session->get('replacedata.warnings', []);

		return parent::onBeforeMain();
	}

}