<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\BRS\Platform\View\Replacedata;

defined('_AKEEBA') or die();

use Akeeba\BRS\Framework\Mvc\View;
use Akeeba\BRS\Platform\Model\Replacedata;
use Akeeba\BRS\View\StepsTrait;

/**
 * View Controller for the Replace Data step on WordPress.
 *
 * @since  10.0
 */
class Html extends View
{
	use StepsTrait;

	/**
	 * The replacements which will be applied.
	 *
	 * @var   array
	 * @since 10.0
	 */
	public $replacements = [];

	/**
	 * Tables to automatically deselet.
	 *
	 * @var   array
	 * @since 10.0
	 */
	public $deselectTables = [];

	/**
	 * Non-core tables which are not automatically selected.
	 *
	 * @var   array
	 * @since 10.0
	 */
	public $otherTables = [];

	/**
	 * The database prefix.
	 *
	 * @var   string
	 * @since 10.0
	 */
	public $prefix = '';

	/**
	 * The length of the database prefix.
	 *
	 * @var   int
	 * @since 10.0
	 */
	public $prefixLen = 0;

	/**
	 * Runs when showing the main page.
	 *
	 * @return  bool
	 * @since   10.0
	 */
	public function onBeforeMain(): bool
	{
		/** @var \Akeeba\BRS\Framework\Document\Html $doc */
		$doc = $this->getContainer()->get('application')->getDocument();
		$text = $this->getContainer()->get('language');
		$doc->addMediaScript('replacedata.js');

		$doc->setHelpURL('https://www.akeeba.com/documentation/brs/wordpress-replace.html');

		$doc->appendButton('GENERAL_BTN_INLINE_HELP', 'btn-outline-info', 'fa-info-circle', 'show-help');
		$this->addButtonPreviousStep();
		$this->addButtonNextStep(true);
		$this->addButtonSubmitStep();

		$doc->addScriptOptions(
			'nextStep.url', $this->getContainer()->get('steps')->nextStep()->getUri()->toString()
		);

		$doc->addScriptLanguage('SETUP_LBL_REPLACEDATA_FROM');
		$doc->addScriptLanguage('SETUP_LBL_REPLACEDATA_TO');
		$doc->addScriptLanguage('SETUP_LBL_REPLACEDATA_DELETE');

		// For debugging purposes.
		$force = $this->getContainer()->get('input')->getBool('force', false);

		/** @var Replacedata $model */
		$model = $this->getModel();

		$this->replacements   = $model->getReplacements(false, $force);
		$this->otherTables    = $model->getNonCoreTables();
		$this->deselectTables = $model->getDeselectedTables();
		$this->prefix         = $model->getDbo()->getPrefix();
		$this->prefixLen      = strlen($this->prefix);

		return true;
	}
}