<?php
/*
 *  © 2017 Framelova. All rights reserved. Privacy Policy
 *  Creado: 01/12/2017
 *  Por: JCR
 *  Descripción: This is called via Ajax to return data type json to app
 */
header('Content-Type: application/javascript');
include_once '../brules/utilsObj.php';
include_once '../brules/usuariosObj.php';
include_once '../brules/catConfiguracionesObj.php';
include_once '../brules/EmailFunctionsObj.php';
include_once '../brules/comunicadosObj.php';
include_once '../brules/catTiposLugarObj.php';
include_once '../brules/catLugaresObj.php';
include_once '../brules/catTipoContactosObj.php';
include_once '../brules/catTelefonosEmergenciaObj.php';
include_once '../brules/seguridadObj.php';
include_once '../brules/codigoValidacionObj.php';
include_once '../brules/datosUsuarioObj.php';
include_once '../brules/mensajesObj.php';
include_once '../brules/registroDispositivosObj.php';
include_once '../brules/catRptCiudadanosObj.php';
include_once '../brules/rptCiudadanoUsuarioObj.php';
include_once '../brules/documentosUsuarioObj.php';
include_once '../brules/catBolsatrabajoObj.php';
include_once '../brules/bolsatrabajoObj.php';
include_once '../brules/catTipojornadaObj.php';
include_once '../brules/infolegalCategoriasObj.php';
include_once '../brules/infolegalEnlacesObj.php';
include_once '../brules/catTipoMultaObj.php';
include_once '../brules/foliosMultasObj.php';
include_once '../brules/rptMascotasObj.php';
include_once '../brules/imagenesMascotaObj.php';
include_once '../brules/respMascotasObj.php';
include_once '../brules/respPersonasObj.php';
include_once '../brules/catAyudasObj.php';
include_once '../brules/rptPersonasObj.php';
include_once '../brules/imagenesPersonaObj.php';
include_once '../brules/catEstatusObj.php';
include_once '../brules/eventosApObj.php';
include_once '../brules/catCategoriaApObj.php';

include_once '../brules/peticionesObj.php';
include_once '../brules/peticionCoordenadasObj.php';
include_once '../brules/usuariosTurnoObj.php';
include_once '../brules/vehiculosObj.php';
include_once '../brules/vehiculosEstacionadosObj.php';
include_once '../brules/coordenadasVehiculoObj.php';
include_once '../brules/rechazosPatrullaObj.php';
include_once '../brules/buzonCiudadanoObj.php';
include_once '../brules/catUnidadesRutasObj.php'; //Imp. 25/10/19
include_once '../brules/catComiteObj.php';
include_once '../brules/catCuentasObj.php';
include_once '../brules/historicosObj.php';
include_once '../brules/calificarAtencionObj.php';
include_once '../brules/catStatusAsignacionObj.php';
include_once '../brules/historicoAsignadosObj.php';
include_once '../brules/historialDesconexionInternetObj.php';
include_once '../brules/historialInicioSesionObj.php';
include_once '../brules/historialPrimerSegundoPlanoObj.php';
include_once '../brules/historialSegundoPrimerPlanoObj.php';
include_once '../brules/historicoConexionBotonLLaveroObj.php';
include_once '../brules/imagenesMascotasVistasObj.php';
include_once '../brules/imagenesPersonasVistasObj.php';
include_once '../common/globalFunctions.php';
include_once '../brules/formulariosObJ.php';
include_once '../brules/opcionesPreguntaObj.php';
include_once '../brules/PreguntaFormularioObj.php';
include_once '../brules/catEstatusFormularioObj.php';
include_once '../brules/gruposFormularioObj.php';
include_once '../brules/FormularioRespuestaObj.php';
include_once '../brules/catBotonesLlaveroObj.php';
include_once "tplink-framelova.php";
include_once "shelly.php";
include_once '../brules/usuarioVehiculoObj.php';
include_once '../brules/permisosUsuarioPatrulleroOBJ.php';
include_once '../brules/histoUbicacionObj.php';
// include_once '../brules/catFormularioObj.php';
// include_once '../brules/datosCatFormulariosObj.php';

//Fisrt check the function name
$function = "";
if (isset($_GET['funct'])) {
  $function = $_GET['funct'];
} elseif (isset($_POST['funct'])) {
  $function = $_POST['funct'];
}
// //Fisrt check the function name
// $function= $_GET['funct'];

switch ($function) {
  case "patrullasDisponiblesInicioSesion":
    patrullasDisponiblesInicioSesion();
    break;
  case "loginUser":
    loginUser($_GET['callback'], $_GET['email'], $_GET['password'], $_GET['idRegDispositivo'], $_GET['plataforma'], $_GET['vehiculo']);
    break;
  case "unidadNoDisponible":
    unidadNoDisponible($_GET['callback'], $_GET['unidad']);
    break;
  case "validateCredentials":
    validateCredentials($_GET['callback'], $_GET['email'], $_GET['password']);
    break;
  case "checkDoubleLogin":
    checkDoubleLogin($_GET['callback'], $_GET['token'], $_GET['idUsuario']);
    break;
  case "revisarCambioComite":
    revisarCambioComite($_GET['callback'], $_GET['idUsuario'], $_GET['idComite']);
    break;
  case "checkPeticionActiva":
    checkPeticionActiva($_GET['callback'], $_GET['idUsuario']);
    break;
  case "configuracionPorId":
    configuracionPorId($_GET['callback'], $_GET['idConf']);
    break;
  case "obtComunicados":
    obtComunicados($_GET['callback'], $_GET['tipoOpc']);
    break;
  case "obtTipoLugares":
    obtTipoLugares($_GET['callback']);
    break;
  case "obtLugares":
    obtLugares($_GET['callback'], $_GET['tipoLugarId']);
    break;
  case "correoBuzonCiudadano":
    $datosJson = (isset($_GET['datosJson'])) ? $_GET['datosJson'] : $_POST['datosJson'];
    $arrfotosSubidas = (isset($_GET['arrfotosSubidas'])) ? $_GET['arrfotosSubidas'] : $_POST['arrfotosSubidas'];
    $callback = (isset($_GET['callback'])) ? $_GET['callback'] : '';
    correoBuzonCiudadano($callback, $datosJson, $arrfotosSubidas);
    break;
  case "crearOpinionCalificarAtencion":
    $callback = (isset($_GET['callback'])) ? $_GET['callback'] : '';
    $datosJson = isset($_GET['datosJson']) ? $_GET['datosJson'] : $_POST['datosJson'];
    $idUsuario = isset($_GET['idUsuario']) ? $_GET['idUsuario'] : $_POST['idUsuario'];
    crearOpinionCalificarAtencion($callback, $datosJson, $idUsuario);
    break;
  case "obtTelsEmergencia":
    obtTelsEmergencia($_GET['callback']);
    break;
  case "recuperarContrasenia":
    recuperarContrasenia($_GET['callback'], $_GET['email']);
    break;
  case "codigoValidacionCorreo":
    codigoValidacionCorreo($_GET['callback'], $_GET['email'], $_GET['celular']);
    break;
  case "codigoValidacionSMS":
    codigoValidacionSMS($_GET['callback'], $_GET['celular']);
    break;
  case "checkCodigoValidacion":
    checkCodigoValidacion($_GET['callback'], $_GET['codigo']);
    break;
  case "codigoValidacionCorreoCiudadanoPie":
    codigoValidacionCorreoCiudadanoPie($_GET['callback'], $_GET['email'], $_GET['celular']);
    break;
  case "codigoValidacionSMSCiudadanoPie":
    codigoValidacionSMSCiudadanoPie($_GET['callback'], $_GET['email'], $_GET['celular']);
    break;
  case "checkCodigoValidacionCiudadanoPie":
    checkCodigoValidacionCiudadanoPie($_GET['callback'], $_GET['codigo'], $_GET['email'], $_GET['celular']);
    break;
  case "validarCorreoCrearCuenta":
    validarCorreoCrearCuenta($_GET['callback'], $_GET['email']);
    break;
  case "creaCuentaCiudadano":
    creaCuentaCiudadano($_GET['callback']);
    break;
  case "crearCuentaCiudadanoPie":
    $callback = isset($_GET['callback']) ? $_GET['callback'] : '';
    $datosJson = isset($_GET['datosJson']) ? $_GET['datosJson'] : $_POST['datosJson'];
    $fotoUsuario = isset($_GET['fotoUsuario']) ? $_GET['fotoUsuario'] : $_POST['fotoUsuario'];
    crearCuentaCiudadanoPie($callback, $datosJson, $fotoUsuario);
    break;
  case "obtDatosUsuarioPorId":
    obtDatosUsuarioPorId($_GET['callback'], $_GET['idUsuario']);
    break;
  case "actDatosCuenta":
    actDatosCuenta($_GET['callback'], $_GET['datosJson']);
    break;
  case "accionesNotificacion":
    accionesNotificacion($_GET['callback'], $_GET['idMensaje'], $_GET['campo'], $_GET['valor']);
    break;
  case "obtOpcReporteCiudadano":
    obtOpcReporteCiudadano($_GET['callback']);
    break;
  case "reporteCiudadano":
    reporteCiudadano($_GET['callback'], $_GET['datosJson'], $_GET['idUsuario'], $_GET['lat'], $_GET['long'], $_GET['arrfotosSubidas']);
    break;
  case "obtReportesCiudadanoPorId":
    obtReportesCiudadanoPorId($_GET['callback'], $_GET['idUsuario']);
    break;
  case "ObtCatBolsaTrabajo":
    ObtCatBolsaTrabajo($_GET['callback']);
    break;
  case "ObtPuestosBolsaTrabajoPorIdCat":
    ObtPuestosBolsaTrabajoPorIdCat($_GET['callback'], $_GET['idCat']);
    break;
  case "obtInfoLegalCategorias":
    obtInfoLegalCategorias($_GET['callback']);
    break;
  case "ObtEnlacesInfoLegalPorIdCat":
    ObtEnlacesInfoLegalPorIdCat($_GET['callback'], $_GET['idCat']);
    break;
  case "obtTiposMulta":
    obtTiposMulta($_GET['callback']);
    break;
  case "checkFolioMulta":
    checkFolioMulta($_GET['callback'], $_GET['idCat'], $_GET['folio']);
    break;
  case "obtMascotasPerdidas":
    obtMascotasPerdidas($_GET['callback']);
    break;
  case "obtTodasMascotasPerdidas":
    obtTodasMascotasPerdidas($_GET['callback']);
    break;
  case "reporteMascotaPerdida":
    reporteMascotaPerdida($_GET['callback'], $_GET['datosJson'], $_GET['arrfotosSubidas'], $_GET['idUsuario']);
    break;
  case "obtMascotasPorId":
    obtMascotasPorId($_GET['callback'], $_GET['idRptMascota']);
    break;
  case "reporteMascotaVista":
    reporteMascotaVista($_GET['callback'], $_GET['datosJson'], $_GET['arrfotosSubidas'], $_GET['idUsuario']);
    break;
  case "reactivarMascotaPerdida":
    reactivarMascotaPerdida($_GET['callback'], $_GET['idRptMascota']);
    break;
  case "miMascotaEncontrada":
    miMascotaEncontrada($_GET['callback'], $_GET['idRptMascota']);
    break;
  case "obtAyudaPorAlias":
    obtAyudaPorAlias();
    break;
  case "obtAyudaPorId":
    obtAyudaPorId($_GET['callback'], $_GET['idAyuda']);
    break;
  case "obtPersonasPerdidas":
    obtPersonasPerdidas($_GET['callback']);
    break;
  case "obtPersonaPorId":
    obtPersonaPorId($_GET['callback'], $_GET['idRptPersona']);
    break;
  case "reportePersonaPerdida":
    reportePersonaPerdida($_GET['callback'], $_GET['datosJson'], $_GET['arrfotosSubidas'], $_GET['idUsuario']);
    break;
  case "reportePersonaVista":
    reportePersonaVista($_GET['callback'], $_GET['datosJson'], $_GET['arrfotosSubidas'], $_GET['idUsuario']);
    break;
  case "reactivarPersonaPerdida":
    reactivarPersonaPerdida($_GET['callback'], $_GET['idRptPersona']);
    break;
  case "miPersonaEncontrada":
    miPersonaEncontrada($_GET['callback'], $_GET['idRptPersona']);
    break;
    //Reportes
  case "reporteCiudadanoPorDia":
    reporteCiudadanoPorDia($_GET['callback'], $_GET['fromDate'], $_GET['toDate'], $_GET['idCompare']);
    break;
  case "reportCiudadanoUsuarioCategorias":
    reportCiudadanoUsuarioCategorias($_GET['callback'], $_GET['fromDate'], $_GET['toDate'], $_GET['idCompare']);
    break;
  case "reportCiudadanoUsuarioEstatus":
    reportCiudadanoUsuarioEstatus($_GET['callback'], $_GET['fromDate'], $_GET['toDate'], $_GET['idCompare']);
    break;
    //Eventos de la agenda publica
  case "obtEventosAP":
    obtEventosAP($_GET['callback'], $_GET['categoria'], $_GET['fromDate'], $_GET['toDate']);
    break;
    //Evento por su id
  case "obtEventoAPPorId":
    obtEventoAPPorId($_GET['callback'], $_GET['idEvento']);
    break;
  case "obtCategoriasAP":
    obtCategoriasAP($_GET['callback']);
    break;
  case "pushMultaServicio":
    pushMultaServicio($_GET['callback'], $_GET['idUsuario'], $_GET['tipo']);
    break;
  case "solicitudPeticion":
    solicitudPeticion($_GET['callback'], $_GET['idUsuario'], $_GET['latitud'], $_GET['longitud'], $_GET['idTipoPeticion'], $_GET['idPeticionActual'], $_GET['tipoBotonPresionado']);
    break;
  case "actualizaCampoPeticion":
    actualizaCampoPeticion($_GET['callback']);
    break;
  case "ObtNotificaciones":
    ObtNotificaciones($_GET['callback'], $_GET['idPeticion']);
    break;
  case "ObtNotificacionesPatrulla":
    ObtNotificacionesPatrulla($_GET['callback'], $_GET['idUsuario']);
    break;
  case "ObtReportesSinFinalizar":
    ObtReportesSinFinalizar($_GET['callback'], $_GET['idUsuario']);
    break;
  case "peticionAsignada":
    peticionAsignada();
    break;
  case "datosAsignadoPeticion":
    datosAsignadoPeticion();
    break;
  case "horaNotificacion":
    horaNotificacion();
    break;
  case "respuestaNotificacionAsignado":
    respuestaNotificacionAsignado();
    break;
  case "actualizaCampoHistoricoAsignaciones":
    actualizaCampoHistoricoAsignaciones($_GET['callback']);
    break;
  case "estatusPatrulla50m":
    estatusPatrulla50m();
    break;
  case "guardarMotivoFinAsignacion":
    guardarMotivoFinAsignacion();
    break;
  case "estatusPatrulla50mAutomatico":
    estatusPatrulla50mAutomatico();
    break;
  case "nuevaHoraDesconexion":
    nuevaHoraDesconexion();
    break;
  case "registroPrimerSegundoPlano":
    registroPrimerSegundoPlano();
    break;
  case "registroSegundoPrimerPlano":
    registroSegundoPrimerPlano();
    break;
  case "peticionFinalizada":
    peticionFinalizada();
    break;
  case "peticionCancelada":
    peticionCancelada();
    break;
  case "salvarComentarioChat":
    salvarComentarioChat($_GET['callback'], $_GET['idUsuario'], $_GET['idRolUsuario'], $_GET['idPeticion'], $_GET['comentario']);
    break;
  case "updateCoordenadasPatrulla":
    updateCoordenadasPatrulla();
    break;
  case "getPeticionActiva":
    getPeticionActiva();
    break;
  case "enviarMensajeAdjunto":
    enviarMensajeAdjunto();
    break;
    //Imp. 25/10/19
  case "obtInfoUnidadRuta":
    obtInfoUnidadRuta();
    break;
  case "obtComites":
    obtComites();
    break;
  case "consultaUltimaPeticionAlmacenada":
    consultaUltimaPeticionAlmacenada($_GET['callback']);
    break;
  case "pruebaBackground":
    pruebaBackground($_GET['callback'], $_GET['cou']);
    break;
  case "insertVehiculoEstacionado":
    insertVehiculoEstacionado();
    break;
  case "nuevoInicioDeSesion":
    nuevoInicioDeSesion();
    break;
  case "finalizarSesionPatrulla":
    finalizarSesionPatrulla();
    break;
  case "guardarConexionBotonLLavero":
    guardarConexionBotonLLavero();
    break;
  case "verificarSiSesionContinuaActiva":
    verificarSiSesionContinuaActiva($_GET['callback'], $_GET['idInicioSesion']);
    break;
  case "formulario":
    formulario($_GET['callback'], $_GET['id'], $_GET['idrol']);
    break;
  case "formularioAll":
    formularioAll($_GET['callback'], $_GET['idrol']);
    break;
  case "getGrupo":
    getGrupo($_GET['callback'], $_GET['idparam'], $_GET['opciones'], $_GET['idformulario'], $_GET['version'], $_GET['idrol'], $_GET['idPregunta']);
    break;
    //case "getimagen":
    //getimagen($_GET['callback'], $_GET['id']);
    //break;
  case "GuardarFormulariorespuesta":
    GuardarFormulariorespuesta($_GET['callback'], $_GET['idP'], $_GET['respuesta'], $_GET['idUser'], $_GET['opcionesID'], $_GET['folio']);
    break;
  case "eliminarPreguntaRespuesta":
    eliminarPreguntaRespuesta($_GET['callback'], $_GET['idPregunta'], $_GET['folio'], $_GET['IdUser']);
    break;
  case "contadorNotificaciones":
    contadorNotificaciones($_GET['callback'], $_GET['idUser']);
    break;
  case "getCatalogoBotonesLLaveros":
    getCatalogoBotonesLLaveros($_GET['callback']);
    break;
  case "ObtReporteshistoricoPeticion":
    ObtReporteshistoricoPeticion($_GET['callback'], $_GET['idUsuario'], $_GET['fechaP'], $_GET['fechaS']);
    break;
  case "ObtReporteshistoricoPeticionPorID":
    ObtReporteshistoricoPeticionPorID($_GET['callback'], $_GET['idUsuario'], $_GET['fechaP'], $_GET['fechaS'], $_GET['id']);
    break;
  case "datosPatrullero":
    datosPatrullero($_GET['callback'], $_GET['idUsuario']);
    break;
  case "enviarPushMonitor":
    enviarPushMonitor($_GET['callback'], $_GET['iduser'], $_GET['permisojson']);
    break;

  default:
    echo "Not valid call";
}

function patrullasDisponiblesInicioSesion()
{
  $vehiculosObj = new vehiculosObj();
  $totalPatrullas = $vehiculosObj->vehiculosInicioSesion();

  if ($totalPatrullas != 0) {
    $arr = array("success" => true, "patrullas" => $totalPatrullas);
  } else {
    $arr = array("success" => false);
  }

  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}

/* Llamar cuando hay error Cross-Origin Read Blocking (CORB) */

//Probamos que se este ejecutando en backgroun la app
function pruebaBackground($callback, $cou)
{

  //Creamos un archivo de texto y escribimos algo que nos diga que nos estamos comunicando con la app en background

  $file = fopen("archivo.txt", "w");
  fwrite($file, "Peticion en background:" . $cou . PHP_EOL);
  fclose($file);

  $arr = array("success" => true);


  echo $callback . '(' . json_encode($arr) . ');';
}

// >>>> RHS Logica para validar peticion activa
function consultaUltimaPeticionAlmacenada($callback)
{
  $peticionesObj = new peticionesObj();


  if (isset($_GET['idPeticionActLocal'])) {

    if ($_GET['idPeticionActLocal'] > 0) {

      $ultimaPeticionRecibida = $peticionesObj->PeticionesPorId($_GET['idPeticionActLocal']);

      if ($ultimaPeticionRecibida->estatusId == 3) {
        $arr = array("success" => true, "msg" => "ended");
      } else {
        $arr = array("success" => true, "msg" => "active");
      }
    } else {
      $arr = array("success" => false, "msg" => "zero");
    }
  } else {
    $arr = array("success" => false, "msg" => "empty");
  }

  echo $callback . '(' . json_encode($arr) . ');';
}
// <<<< Termina logica de validacion de peticion activa

// >>>> RHS Logica para autoasignacion de peticion desde la app >>>>
function verPeticionApp($idPeticion)
{
  //$file = fopen("archivo.txt", "w");
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionesObj = new peticionesObj();
  $vehiculosObj = new vehiculosObj();
  $catConfiguracionesObj = new catConfiguracionesObj();

  $peticion = $peticionesObj->PeticionesPorId($idPeticion);
  switch ($peticion->tipoPeticionId) {
    case 0:
      $tipoVehiculoId = "3,4";
      break;
    case 1:
      $tipoVehiculoId = "2,4";
      break;
    case 2:
      $tipoVehiculoId = "1,4";
      break;
    case 4:
      $tipoVehiculoId = "1,4";
      break;
    default:
      $tipoVehiculoId = 0;
      break;
  }
  //fwrite($file, "tipoVehiculoId: " . $tipoVehiculoId . PHP_EOL);
  $vehiculosdisponiblesPeticion = [];
  $vehiculosdisponibles = $usuariosTurnoObj->ObtTodosVehiculosDisponibles($tipoVehiculoId); // aqui viene los veiculos  TODOS
  $alarmaComiteDisponible = false;
  $alarmaComite = $vehiculosObj->VehiculosPorComite($peticion->idComiteUsuario); // PIDE LA ALRMA DE MANDO 
  $datosCatConf = $catConfiguracionesObj->ObtConfiguracionByID(5); // TRAEL EN OTRA TABLA DE BASE DE DATOS A LA ALARMA  DE MANDO
  $alarmaCentroMando = $datosCatConf->valor; // HAY UNA CAMPO LLAMADA VALOR EN LA LINEA ANTERIOR 


  foreach ($vehiculosdisponibles as $vehiculosdisponible) {
    if ($vehiculosdisponible->idRechazoPatrulla == 0 || $vehiculosdisponible->idRechazoPatrulla == null || $vehiculosdisponible->idPeticion != $idPeticion || $vehiculosdisponible->idPeticion == $idPeticion) {
      if ($vehiculosdisponible->vehiculoId != $alarmaCentroMando) {
        $vehiculosdisponiblesPeticion[] = $vehiculosdisponible;  // tenemos tos los veiculos menos a control de mando
      }
    }
    //verificar que la alarma de su comite este en los vehiculos disponibles:
    if ($alarmaComite->idVehiculo == $vehiculosdisponible->vehiculoId) {
      $alarmaComiteDisponible = true;
    }
  }

  obtUnidadesCercanasApp($peticion, $vehiculosdisponiblesPeticion);
}
// bien verPeticionApp
function obtUnidadesCercanasApp($peticion, $vehiculos)
{

  $vehiculosObj = new vehiculosObj();
  $peticionesObj = new peticionesObj();
  $vehCercanos = [];
  $lat1 = $peticion->latitud; // datos de la peticion 
  $lon1 = $peticion->longitud;
  foreach ($vehiculos as $key => $value) {
    $colIndex = $vehiculos[$key]; // CONTIENE TODO LOS VEHICULOS CONTOO SUS CAMPOS.
    if ($colIndex != null) { // entra por que si tiiene datos
      $lat2 = $colIndex->latitud; // datos de los veiculos 
      $lon2 = $colIndex->longitud;
      $km = getDistanceToCoords($lat1, $lon1, $lat2, $lon2);
      $dataSuc = array(
        'idUserTurno' => $colIndex->idUserTurno,
        'conductor' => $colIndex->conductor,
        'idUserTurno' => $colIndex->idUserTurno,
        'latitud' => $colIndex->latitud,
        'longitud' => $colIndex->longitud,
        'matricula' => $colIndex->matricula,
        'tipoVehiculoId' => $colIndex->tipoVehiculoId,
        'turnoId' => $colIndex->turnoId,
        'unidad' => $colIndex->unidad,
        'usuarioVehiculoId' => $colIndex->usuarioVehiculoId,
        'km' => (float) $km,
        'vehiculoId' => $colIndex->vehiculoId,
        'idRechazoPatrulla' => $colIndex->idRechazoPatrulla,
        'idPeticion' => $colIndex->idPeticion,
        'estatusAlarma' => $colIndex->estatusAlarma,
        'idComite' => $colIndex->idComite,
        'soloComite' => $colIndex->soloComite,
        'distanciaAlarma' => $colIndex->distanciaAlarma,
        'usuarioTurnoVehiculoId' => $colIndex->usuarioVehiculoId,
        'activoV' => $colIndex->activoV,
        'estatusId' => $colIndex->estatusId


        // rechazo:  rechazoRes
      );
      // el if es para las colonias si entra pero eso depende la alrma o veiculo :)
      if ($peticion->opcComite == 1 && $peticion->idComiteUsuario == $colIndex->idComite && (float) $km <= ($colIndex->distanciaAlarma / 100)) {
        //$vehCercanos.push($dataSuc);
        array_push($vehCercanos, $dataSuc);
        //fwrite($file, "Por comite" . PHP_EOL);
        //fwrite($file, "Unidad: " . $colIndex->unidad ." km: ". $km . PHP_EOL);
      }
      // Validamos si esta a menos de 100m de una alarma 28/03/2020 Rafa
      //Alarmas con distancia mayor a 100m se discriminan
      if ($colIndex->tipoVehiculoId == 1) {
        array_push($vehCercanos, $dataSuc);
      } else if ((float) $km < ($colIndex->distanciaAlarma / 1000)) {
        array_push($vehCercanos, $dataSuc);

        //$vehCercanos.push($dataSuc);
        //fwrite($file, "Sin comite" . PHP_EOL);
        //fwrite($file, "Unidad: " . $colIndex->unidad ." km: ". $km . PHP_EOL);
      }
    }
    // Verificar si la alarma de comité se encuentra dentro de los vehiculos cercanos:
    $alarmaComite = $vehiculosObj->VehiculosPorComite($peticion->idComiteUsuario);

    $almComEnVehCercanos = false;
    foreach ($vehCercanos as $vehCercano) {
      if ($alarmaComite->idVehiculo == $vehCercano['vehiculoId']) {
        $almComEnVehCercanos = true;
      }
    }
    $petActualizada = $peticionesObj->PeticionesPorId($peticion->idPeticion);

    $statusAsignacionId = $petActualizada->statusAsignacionId;
    if ($almComEnVehCercanos == false) {
      if ($statusAsignacionId == 4) {
        $dataviculo_mas = $vehiculosObj->VerAlarma_masCercana($peticion->idPeticion);
        //print_r($dataviculo_mas);
        //PROPUESTA DE DAVID BUENO PARA VER  COMO PODEMOS REALIZAR LOS CAMBIOS 
      } elseif ($statusAsignacionId == null) {
        $peticionesObj->ActualizarCampoPeticion(
          "statusAsignacionId",
          catStatusAsignacionObj::ALM_COMITE_FUERA_RANGO,
          $peticion->idPeticion
        );
      }
    }
  } // todo bien

  //ejemplo real
  
  // for ($r = 0; $r < (count($vehCercanos) - 1); $r++) { //2
  //   for ($s = 0; $s < (count($vehCercanos) - $r); $s++) { // 3 
  //     $kmTemp1 = $vehCercanos[$s]["km"]; //0.1
  //     if ($vehCercanos[$s + 1] != null) {
  //       $kmTemp2 = $vehCercanos[$s + 1]["km"]; //0.19
  //       //fwrite($file, "kmTemp1 " . $kmTemp1 ." mayor que kmTemp2: " . $kmTemp2 . PHP_EOL);
  //       if ($kmTemp1 > $kmTemp2) {
  //         $aux = $vehCercanos[$s]; //guardamos el numero mayor en el auxiliar
  //         $vehCercanos[$s] = $vehCercanos[$s + 1]; //guardamos el numero menor en el lugar correspondiente
  //         $vehCercanos[$s + 1] = $aux; //asignamos el auxiliar en el lugar correspondiente
  //       }
  //     }
  //   }
  // }

  for ($r = 0; $r < count($vehCercanos) - 1; $r++) { // Límite exterior ajustado
    for ($s = 0; $s < count($vehCercanos) - 1 - $r; $s++) { // Límite interior ajustado
      $kmTemp1 = $vehCercanos[$s]["km"];
      if (isset($vehCercanos[$s + 1])) { // Verifica si existe el índice $s + 1
        $kmTemp2 = $vehCercanos[$s + 1]["km"];
        if ($kmTemp1 > $kmTemp2) {
          $aux = $vehCercanos[$s];
          $vehCercanos[$s] = $vehCercanos[$s + 1];
          $vehCercanos[$s + 1] = $aux;
        }
      }
    }
  }
  
  actualizaPeticionVecinalApp($peticion, $vehCercanos);
} // todo bien  en obtUnidadesCercanasApp

function actualizaPeticionVecinalApp($peticion, $vehCercanos)
{
  include_once "shelly.php";
  $shelly = new shellyB();
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $peticionesObj = new peticionesObj();
  $usuariosObj = new usuariosObj();

  ///actualizar peticion vecinal utiliza peticion y vehiculos cercanos
  $arrayVehiculosExcluidos = [];
  $arrayVehiculoUnicos = [];
  $arraAlarmasPrendidas = [];
  $arrapatrullaPrendidas = [];
  $arrayAlarmasExcluidos = [];
  $bandLocalizarAlarma = 0;

  if (count($vehCercanos) == 0) {
    asignarUsuarioTurnoApp(0, $peticion->idPeticion, $peticion->asignado);
  }
  // vamos aver si el ciudadano es solo comite o  no
  $soloComite = $usuariosObj->DatosUser($peticion->usuarioId);

  if ($soloComite->idComite > 0) { //solo comite con alarmas con el mismo comite con el usario si no se asigna una alarma sin solo comite
    $ultimoVehiculo = end($vehCercanos);
    foreach ($vehCercanos as $vehiculo) {

      if ($vehiculo['tipoVehiculoId'] == 1) { // patrulla vehiculo
        // comentar si se quiere asignar patrullas en petcion
        // patrulla 
        // if ($vehiculo['activoV'] == 1) {
        //   if ($vehiculo['estatusId'] == 1 && $vehiculo['estatusAlarma'] == 1) {
        //     if ($bandLocalizarPatrullas == 0) {
        //       if (count($arrapatrullaPrendidas) >= 0) {
        //         $bandLocalizarPatrullas = 1;
        //         $idPatrulla = $vehiculo['idUserTurno'];
        //         $historicoAsignadosObj = new historicoAsignadosObj();
        //         $historicoAsignadosObj->idUsuarioTurno = $idPatrulla;
        //         $historicoAsignadosObj->tipoAsignacion = "App";
        //         $historicoAsignadosObj->idPeticion = $peticion->idPeticion;
        //         $historicoAsignadosObj->GuardarAsignacionesPatrulla();
        //         // $updateEst = $peticionesObj->ActualizarCampoPeticion("estatusId", 2, $peticion->idPeticion);
        //         sedMsjPatrulleroPeticion($idPatrulla);
        //         //$peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", $idPatrulla, $peticion->idPeticion);
        //         asignarUsuarioTurnoApp($idPatrulla, $peticion->idPeticion);
        //       }
        //     }
        //   }
        // }
      } elseif ($vehiculo['tipoVehiculoId'] == 4) { // alarmas
        if ($vehiculo['activoV'] == 1) {

          if ($vehiculo['soloComite'] == 1 && $vehiculo['estatusAlarma'] == 1 && $vehiculo['estatusId'] == 1 && $soloComite->idComite == $vehiculo['idComite']) { // solo comite con idcomite del usuario 
            if ($bandLocalizarAlarma == 0) {
              if (count($arraAlarmasPrendidas) >= 0) { /// si la alarma ya esta prendida  se ignora
                $bandLocalizarAlarma = 1;
                $idVehiculo = $vehiculo['vehiculoId'];
                $idvehiculoTipo = $vehiculosObj->VehiculosPorId($idVehiculo);
                $cuenta = $catCuentasObj->CuentaPorNombre($idvehiculoTipo->cuenta);
                $alarmaId = $idvehiculoTipo->alarmaId;
                $estadoapi = $shelly->respuesta_de_api($cuenta->token, $alarmaId, $cuenta->servidor);
                $estadoshelly = $shelly->LineaShelly($cuenta->token, $alarmaId, $cuenta->servidor, $cuenta->tipo);

                if ($cuenta->tipo == "tplink") {
                  verifyTokenAndServer($vehiculo['vehiculoId']);
                  $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                  if (is_array($resEncenderAlmApp)) {
                    $resErrorCode = $resEncenderAlmApp["error_code"];
                    $peticionesObj->ActualizarCampoPeticion("encendidoAlm", $resErrorCode, $peticion->idPeticion);
                    $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                  }
                  switch ($resErrorCode) {
                    case -20651:
                      verifyTokenAndServer($vehiculo['vehiculoId']);
                      // Volvemos a encender alarma y guardamos el codigo de error del segundo encendido en bd:
                      $resSegundoEncedido = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                      if (is_array($resSegundoEncedido)) {
                        $resErrorCode = $resSegundoEncedido["error_code"];
                        $peticionesObj->ActualizarCampoPeticion("segundoEncendidoAlm", $resErrorCode, $peticion->idPeticion);
                        $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                      }
                      break;
                  }
                } elseif (strstr($cuenta->tipo, "shelly") !== false) {
                  if ($estadoapi[0] == 200) {
                    if ($estadoshelly[0] == true) {
                      verifyTokenAndServer($vehiculo['vehiculoId']);
                      $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                      $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                      $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                    } elseif ($estadoshelly[0] == false) {
                      verifyTokenAndServer($vehiculo['vehiculoId']);
                      $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                      $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                      //$peticionesObj->actualizarStatusComunicacion(-20571, $peticion->idPeticion);
                      $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                    }
                  } elseif ($estadoapi[0] == 400) {
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                    $peticionesObj->actualizarStatusComunicacion(-20580, $peticion->idPeticion);
                  }
                }

                asignarUsuarioTurnoApp($vehiculo['idUserTurno'], $peticion->idPeticion, $peticion->asignado);
                $peticionesObj->ActualizarCampoPeticion(
                  "statusAsignacionId",
                  catStatusAsignacionObj::ALM_PMI_ASIGNADA,
                  $peticion->idPeticion
                );
                EnviarmsjComite($soloComite);
              }
            }
          } elseif ($vehiculo['soloComite'] == 0 && $vehiculo['estatusAlarma'] == 1 && $vehiculo['estatusId'] == 1) { // sin solo comite por cercania 
            if ($bandLocalizarAlarma == 0) {
              $bandLocalizarAlarma = 1;
              $idVehiculo = $vehiculo['vehiculoId'];
              $idvehiculoTipo = $vehiculosObj->VehiculosPorId($idVehiculo);
              $cuenta = $catCuentasObj->CuentaPorNombre($idvehiculoTipo->cuenta);
              $alarmaId = $idvehiculoTipo->alarmaId;
              $estadoapi = $shelly->respuesta_de_api($cuenta->token, $alarmaId, $cuenta->servidor);
              $estadoshelly = $shelly->LineaShelly($cuenta->token, $alarmaId, $cuenta->servidor, $cuenta->tipo);

              if ($cuenta->tipo == "tplink") {
                verifyTokenAndServer($vehiculo['vehiculoId']);
                $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                if (is_array($resEncenderAlmApp)) {
                  $resErrorCode = $resEncenderAlmApp["error_code"];
                  $peticionesObj->ActualizarCampoPeticion("encendidoAlm", $resErrorCode, $peticion->idPeticion);
                  $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                }
                switch ($resErrorCode) {
                  case -20651:
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    // Volvemos a encender alarma y guardamos el codigo de error del segundo encendido en bd:
                    $resSegundoEncedido = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                    if (is_array($resSegundoEncedido)) {
                      $resErrorCode = $resSegundoEncedido["error_code"];
                      $peticionesObj->ActualizarCampoPeticion("segundoEncendidoAlm", $resErrorCode, $peticion->idPeticion);
                      $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                    }
                    break;
                }
              } elseif (strstr($cuenta->tipo, "shelly") !== false) {
                if ($estadoapi[0] == 200) {
                  if ($estadoshelly[0] == true) {
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                    $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                    $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                  } elseif ($estadoshelly[0] == false) {
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                    $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                    //$peticionesObj->actualizarStatusComunicacion(-20571, $peticion->idPeticion);
                    $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                  }
                } elseif ($estadoapi[0] == 400) {
                  verifyTokenAndServer($vehiculo['vehiculoId']);
                  $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                  $peticionesObj->actualizarStatusComunicacion(-20580, $peticion->idPeticion);
                }
              }

              asignarUsuarioTurnoApp($vehiculo['idUserTurno'], $peticion->idPeticion, $peticion->asignado);
              $peticionesObj->ActualizarCampoPeticion(
                "statusAsignacionId",
                catStatusAsignacionObj::ALM_PMI_ASIGNADA,
                $peticion->idPeticion
              );
            }
          } elseif ($ultimoVehiculo['idUserTurno'] == $vehiculo['idUserTurno']) {
            if ($bandLocalizarAlarma == 0) {
              $peticionesObj->ActualizarCampoPeticion(
                "statusAsignacionId",
                catStatusAsignacionObj::ALM_COMITE_OCUPADA,
                $peticion->idPeticion
              );
            }
          }
        }
      }
    }
  } else {
    $ultimoVehiculo = end($vehCercanos);
    foreach ($vehCercanos as $vehiculo) {

      if ($vehiculo['tipoVehiculoId'] == 1) { // patrulla vehiculo
        // comentar si se quiere asignar patrullas en petcion
        // patrulla 
        // if ($vehiculo['activoV'] == 1) {
        //   if ($vehiculo['estatusId'] == 1 && $vehiculo['estatusAlarma'] == 1) {
        //     if ($bandLocalizarPatrullas == 0) {
        //       if (count($arrapatrullaPrendidas) >= 0) {
        //         $bandLocalizarPatrullas = 1;
        //         $idPatrulla = $vehiculo['idUserTurno'];
        //         $historicoAsignadosObj = new historicoAsignadosObj();
        //         $historicoAsignadosObj->idUsuarioTurno = $idPatrulla;
        //         $historicoAsignadosObj->tipoAsignacion = "App";
        //         $historicoAsignadosObj->idPeticion = $peticion->idPeticion;
        //         $historicoAsignadosObj->GuardarAsignacionesPatrulla();
        //         // $updateEst = $peticionesObj->ActualizarCampoPeticion("estatusId", 2, $peticion->idPeticion);
        //         sedMsjPatrulleroPeticion($idPatrulla);
        //         //$peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", $idPatrulla, $peticion->idPeticion);
        //         asignarUsuarioTurnoApp($idPatrulla, $peticion->idPeticion);
        //       }
        //     }
        //   }
        // }
      } elseif ($vehiculo['tipoVehiculoId'] == 4) { // alarmas
        if ($vehiculo['activoV'] == 1) {
          if ($vehiculo['soloComite'] == 0 && $vehiculo['estatusAlarma'] == 1 && $vehiculo['estatusId'] == 1) { // sin solo comite por cercania 
            if ($bandLocalizarAlarma == 0) {
              $bandLocalizarAlarma = 1;
              $idVehiculo = $vehiculo['vehiculoId'];
              $idvehiculoTipo = $vehiculosObj->VehiculosPorId($idVehiculo);
              $cuenta = $catCuentasObj->CuentaPorNombre($idvehiculoTipo->cuenta);
              $alarmaId = $idvehiculoTipo->alarmaId;
              $estadoapi = $shelly->respuesta_de_api($cuenta->token, $alarmaId, $cuenta->servidor);
              $estadoshelly = $shelly->LineaShelly($cuenta->token, $alarmaId, $cuenta->servidor, $cuenta->tipo);

              if ($cuenta->tipo == "tplink") {
                verifyTokenAndServer($vehiculo['vehiculoId']);
                $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                if (is_array($resEncenderAlmApp)) {
                  $resErrorCode = $resEncenderAlmApp["error_code"];
                  $peticionesObj->ActualizarCampoPeticion("encendidoAlm", $resErrorCode, $peticion->idPeticion);
                  $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                }
                switch ($resErrorCode) {
                  case -20651:
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    // Volvemos a encender alarma y guardamos el codigo de error del segundo encendido en bd:
                    $resSegundoEncedido = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                    if (is_array($resSegundoEncedido)) {
                      $resErrorCode = $resSegundoEncedido["error_code"];
                      $peticionesObj->ActualizarCampoPeticion("segundoEncendidoAlm", $resErrorCode, $peticion->idPeticion);
                      $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                    }
                    break;
                }
              } elseif (strstr($cuenta->tipo, "shelly") !== false) {
                if ($estadoapi[0] == 200) {
                  if ($estadoshelly[0] == true) {
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                    $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                    $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                  } elseif ($estadoshelly[0] == false) {
                    verifyTokenAndServer($vehiculo['vehiculoId']);
                    $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                    $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                    //$peticionesObj->actualizarStatusComunicacion(-20571, $peticion->idPeticion);
                    $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                  }
                } elseif ($estadoapi[0] == 400) {
                  verifyTokenAndServer($vehiculo['vehiculoId']);
                  $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                  $peticionesObj->actualizarStatusComunicacion(-20580, $peticion->idPeticion);
                }
              }

              asignarUsuarioTurnoApp($vehiculo['idUserTurno'], $peticion->idPeticion, $peticion->asignado);
              $peticionesObj->ActualizarCampoPeticion(
                "statusAsignacionId",
                catStatusAsignacionObj::ALM_PMI_ASIGNADA,
                $peticion->idPeticion
              );
            }
          } elseif ($ultimoVehiculo['idUserTurno'] == $vehiculo['idUserTurno']) {
            if ($bandLocalizarAlarma == 0) {
              $peticionesObj->ActualizarCampoPeticion(
                "statusAsignacionId",
                catStatusAsignacionObj::ALM_COMITE_OCUPADA,
                $peticion->idPeticion
              );
            }
          }
        }
      }
    }
  }

}
// aqui arriba ya prende la alarma.

function asignarUsuarioTurnoApp($idUserTurno, $idPeticion, $peticionAsignada = null)
{
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionesObj = new peticionesObj();
  $vehiculosObj = new vehiculosObj();
  $historicoAsignadosObj = new historicoAsignadosObj();

  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual

  $peticion = $peticionesObj->PeticionesPorId($idPeticion);
  $user = $usuariosTurnoObj->obtUsuarioPorIdUsuarioTurno($idUserTurno);
  $updateEst = $peticionesObj->ActualizarCampoPeticion("estatusId", 2, $idPeticion); // se actualiza el estatus en 2 para que se sepa que la patrulla esta asignada
  //$update = $peticionesObj->ActualizarCampoPeticion("usuarioTurnoId", $idUserTurno, $idPeticion);
  $peticionesObj->ActualizarCampoPeticion("asignado", 1, $idPeticion);
  $peticionesObj->ActualizarCampoPeticion("fechaAsignacion", $dateTime, $idPeticion);
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorId($idUserTurno);
  //$dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 2, $dataTurno->vehiculoId);
  if ($dataTurno->tipoVehiculoId == 1) {
    //patrulla ocupada por notificar
    $dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusAlarma", 2, $dataTurno->vehiculoId);
    //$update = $peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", $idUserTurno, $idPeticion);
    $regDispObj = new registroDispositivo();
    $peticion = $peticionesObj->PeticionesPorId($idPeticion);
    $turno = $usuariosTurnoObj->UsuariosTurnoPorId($idUserTurno);
    $regDispObj->usuarioId = $turno->usuarioVehiculoId;
    $colRegDisp = $regDispObj->obtTodosRegDispositivoPorIdUsr();

    //Diferencia
    $diferencia = obtenerDiferenciaPorFechaHoy($peticion->fechaCreacion, $dateTime, "%H:%i:%s");
    $peticionesObj->ActualizarCampoPeticion("tiempoAtendio", $diferencia, $idPeticion);
  } else {
    // alarma 
    $dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 2, $dataTurno->vehiculoId);
    $update = $peticionesObj->ActualizarCampoPeticion("usuarioTurnoId", $idUserTurno, $idPeticion);
  }

}

function encenderAlarmaApp($idVehiculo, $accionAlm, $historico = "", $usuarioId = 0, $idPeticion)
{
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $peticionesObj = new peticionesObj();
  $vehiculo = $vehiculosObj->VehiculosPorId($idVehiculo);
  //$toggle = ($vehiculo->estatusAlarma == 1)?true:false;
  $accion = ($accionAlm != null && $accionAlm != "") ? $accionAlm : "";
  //$estatusUpd = ($vehiculo->estatusAlarma == 1) ? 2 : 1;
  $estatusUpd = ($accion == 0 || $accion == "0") ? 1 : 2;
  /*$estatusUpd=1;
  if($accion == 0 || $accion == "0"){
    $estatusUpd=1;
  }else{
    $estatusUpd=2;
  }*/
  $accionFinal = ($accion == 1) ? true : false;

  $vehiculosObj->ActualizarCampoVehiculos("estatusAlarma", $estatusUpd, $idVehiculo);


  // 30/03/2020 JAIR Guardar en historico la accion si asi se requiere
  if ($historico != "") {
    if ($historico == 1) {
      $historicosObj = new historicosObj();
      $accionH = ($accion == 1) ? "encendido_manual" : "apagado_manual";

      $arrJson = array("accion" => $accionH, "tabla" => "alarmas", "idUsuario" => $usuarioId, "idAlarma" => $idVehiculo);
      $historicosObj->jsonUserTurn = json_encode($arrJson);
      $historicosObj->tipoHist = 1;
      $historicosObj->GuardarHistoricos();
    }
  }

  $cuenta = $catCuentasObj->CuentaPorNombre($vehiculo->cuenta);

  if ($cuenta->tipo == "tplink") {
    $alarmaId = $vehiculo->alarmaId;
    $useUrl = $vehiculo->server;
    $token = $cuenta->token;
    $tplink = new TpLinkFramelova();
    $res = $tplink->plugSwitch($useUrl, $token, array(    // bool, default false
      "deviceId" => $alarmaId, // deviceId, default none
      "useUrl" => $useUrl      // optional specify appServerUrl (Previously provided)
    ), $accionFinal);
  } elseif (strstr($cuenta->tipo, "shelly") !== false) {

    $alarmaId = $vehiculo->alarmaId;
    $token = $cuenta->token;
    $shellyserver = $cuenta->servidor;
    $shelly = new shellyB();
    $res = $shelly->SwithPlug($token, $alarmaId, $accionFinal, $shellyserver);
  }
  return $res;
  //$return_arr = array("res" => $res);

  //echo $callback . '(' . json_encode($return_arr) . ');';
}

function getDistanceToCoords($lat1, $lon1, $lat2, $lon2)
{
  $R = 6371; // Radius of the earth in km

  $dLat = _deg2rad($lat2 - $lat1); // deg2rad below
  $dLon = _deg2rad($lon2 - $lon1);

  $a = sin($dLat / 2) * sin($dLat / 2) + cos(_deg2rad($lat1)) * cos(_deg2rad($lat2)) * sin($dLon / 2) * sin($dLon / 2);

  $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

  $d = $R * $c; // Distance in km

  return number_format($d, 2);
}

function _deg2rad($deg)
{
  return $deg * (M_PI / 180);
}
//<<<< RHS Termina logica de autoaignacion de peticion desde app <<<<

function unidadNoDisponible($callback, $unidad)
{
  $vehiculosObj = new vehiculosObj();

  $vehiculosObj->ActualizarCampoVehiculos("estatusId", 2, $unidad);

  $arr = array("success" => true);

  echo $callback . '(' . json_encode($arr) . ');';
}

function loginUser($callback, $email, $password, $idRegDispositivo, $plataforma, $vehiculo)
{
  $usuariosObj = new usuariosObj();
  $regDispObj = new registroDispositivo();
  $vehiculosObj = new vehiculosObj();
  $datosUsuarioObj = new datosUsuarioObj();
  $catComiteObj = new catComiteObj();
  $catComiteObj = new catComiteObj();
  $usuariosTurnoObj = new usuariosTurnoObj();

  $usuario = $usuariosObj->LoginUser(stripslashes(trim($email)), stripslashes(trim($password)));
  $idUsuario = $usuario->idUsuario;
  $idRol = $usuario->idRol;

  if ($idUsuario < 1) {
    $res = array(
      "success" => false,
      "message" => "los datos de acceso son incorrectos",
      "datosIncorrectos" => true
    );
    echo $callback . '(' . json_encode($res) . ');';
    exit();
  }

  if ($usuario->valido < 1) {
    $res = array(
      "success" => false,
      "message" => "el usuario aun no ha sido validado por un administrador",
      "usrValido" => false
    );
    echo $callback . '(' . json_encode($res) . ');';
    exit();
  }

  if (!$usuariosObj->verficarComiteConAlarma($idUsuario)) {
    $res = array(
      "success" => false,
      "comiteConAlarma" => false,
      "message" => "el comité al que esta asociado el usuario no tiene una alarma asignada"
    );
    echo $callback . '(' . json_encode($res) . ');';
    exit();
  }

  if ($usuariosObj->checkPeticionActiva($idUsuario)) {
    $res = array(
      "success" => false,
      "message" => "tiene una peticion activa en otro dispositivo",
      "sinPeticionActiva" => false
    );
    echo $callback . '(' . json_encode($res) . ');';
    exit();
  }


  switch ($idRol) {
    case rolesObj::MIEMBRO_COMITE:
      $datosUsuario = $datosUsuarioObj->obtDatosUsuarioPorUsuarioId($idUsuario);
      $comite = $catComiteObj->ComitePorId($datosUsuario->idComite);
      //$alarma = $vehiculosObj->Get_Alarma_solo_comite($comite->idComite);
      $alarma  = $vehiculosObj->VehiculosPorComite($comite->idComite);

      $res = array(
        "success" => true,
        "message" => "ciudadano comité logueado correctamente",
        "idUsr" => $idUsuario,
        "userName" => $usuario->nombre,
        "password" => $usuario->password,
        "telefono" => $datosUsuario->telefono,
        "active" => $usuario->activo,
        "email" => $usuario->email,
        "idRol" => $usuario->idRol,
        "tipoCuenta" => "Miembro de Comité",
        "idComite" => $comite->idComite,
        "nombreComite" => $comite->nombre,
        "idAlarma" => $alarma->idVehiculo,
        "latitudAlarma" => $alarma->latitud,
        "longitudAlarma" => $alarma->longitud,
        "distanciaAlarma" => $alarma->distanciaAlarma,
      );

      break;

    case rolesObj::UNIDAD:
      $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($idUsuario);
      $Verificacion = $usuariosTurnoObj->VerificarVehiculoAsociado($vehiculo);
      foreach ($Verificacion as $UserTurno) {
        if ($UserTurno->idUserTurno !== $dataTurno->idUserTurno) {
          $usuariosTurnoObj->ActualizarCampoUsuarioTurnoUVid("vehiculoId", 0, $UserTurno->usuarioVehiculoId);
        }
      }
      $usuariosTurnoObj->ActualizarCampoUsuarioTurnoUVid("vehiculoId", $vehiculo, $dataTurno->usuarioVehiculoId);
      $res = array(
        "success" => true,
        "idUsr" => $idUsuario,
        "userName" => $usuario->nombre,
        "password" => $usuario->password,
        "active" => $usuario->activo,
        "email" => $email,
        "idRol" => $usuario->idRol,
        "idUnidad" => $vehiculo,
        "idTipoUnidad" => 1
      );
      break;

    case rolesObj::CIUDADANO_PIE:
      $datosUsuario = $datosUsuarioObj->obtDatosUsuarioPorUsuarioId($idUsuario);
      $comite = $catComiteObj->ComitePorId($datosUsuario->idComite);
      $alarma = $vehiculosObj->VehiculosPorComite($comite->idComite);
      $res = array(
        "success" => true,
        "message" => "cuidadano a pie logueado correctamente",
        "idUsr" => $idUsuario,
        "userName" => $usuario->nombre,
        "active" => $usuario->activo,
        "email" => $usuario->email,
        "password" => $usuario->password,
        "telefono" => $datosUsuario->telefono,
        "idRol" => $usuario->idRol,
        "tipoCuenta" => "Ciudadano a Pie",
      );
      if ($comite->idComite != NULL) {
        $res["idComite"] = $comite->idComite;
        $res["nombreComite"] = $comite->nombre;
        $res["idAlarma"] = $alarma->idVehiculo;
        $res["latitudAlarma"] = $alarma->latitud;
        $res["longitudAlarma"] = $alarma->longitud;
        $res["distanciaAlarma"] = $alarma->distanciaAlarma;
      }
      break;
  }

  $regDispObj->idRegDispositivo = $idRegDispositivo;
  $regDispObj->usuarioId = $idUsuario;
  $regDispObj->plataforma = $plataforma;
  //Verificar si el usuario ya cuenta con un id de dispositivo para solo actualizarlo
  $colRegDisp = $regDispObj->obtTodosRegDispositivoPorIdUsr();
  if (count($colRegDisp) > 0) {
    //obtener el id de la fila
    $idReg = 0;
    foreach ($colRegDisp as $elemRegDisp) {
      $idReg = $elemRegDisp->idReg;
    }
    //Actualizar registro
    $regDispObj->idReg = $idReg;
    $regDispObj->ActRegActivo();
  } else {
    //Crear registro
    //Comprobar que el registro no este vacio para no registrar basura
    if ($idRegDispositivo != "") {
      $regDispObj->Salvar();
    }
  }


  echo $callback . '(' . json_encode($res) . ');';
}

//Obtener el aviso de privaciadad
function configuracionPorId($callback, $idConf)
{
  $confObj = new catConfiguracionesObj();
  $colConfig = $confObj->ObtConfiguracionByID($idConf);

  //verifica
  if ($colConfig->idConfiguracion > 0) {
    $arr = array("success" => true, "idConf" => $idConf, "nombre" => $colConfig->nombre, "valor" => $colConfig->valor);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

//obtener coleccion de noticias y comunicados segun el tipo de sesion (opcTurista, opcCiudadano)
function obtComunicados($callback, $tipoOpc)
{
  include "../common/config.php";
  $dirname = dirname(__DIR__);
  $comunicadoObj = new comunicadosObj();
  $arrComunicados = array(); //Se envia a la aplicacion

  //Coleccion de comunicados
  $colComunicados = $comunicadoObj->GetAllComunicados(1, $tipoOpc);
  // echo "<pre>";
  // print_r($colComunicados);
  // echo "</pre>";

  //Comprobar que existen comunicados
  if (count($colComunicados) > 0) {
    foreach ($colComunicados as $elemCom) {
      if ($elemCom->imgComunicado != "") {
        $urlImg = $siteURL . 'upload/comunicados/' . $elemCom->imgComunicado;
        $pathUrlImg = $dirname . '/upload/comunicados/' . $elemCom->imgComunicado;

        //verificar que exista en carpeta
        if (!file_exists($pathUrlImg)) {
          $urlImg = $siteURL . 'upload/comunicados/img_default.png';
        }
      } else {
        $urlImg = $siteURL . 'upload/comunicados/img_default.png';
      }

      // $urlShare = $siteURL."comunicado.php?id=".$elemCom->idComunicado;
      $arrComunicados[] = array(
        "idComunicado" => $elemCom->idComunicado,
        "titulo" => $elemCom->titulo,
        "descripcionCorta" => $elemCom->descripcionCorta,
        "urlImagen" => $urlImg,
        "fechaCreacion" => convertirAFechaCompleta($elemCom->fechaCreacion),
        "urlCompartir" => "",
        "contenido" => $elemCom->contenido
      );
    }
    $arr = array("success" => true, "colComunicados" => $arrComunicados);
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//obtener coleccion de tipos de lugar
function obtTipoLugares($callback)
{
  $catTiposLugarObj = new catTiposLugarObj();

  //Coleccion de tipos de lugar
  $colTipoLugares = $catTiposLugarObj->GetAllCatTiposLugarObj(1);
  // echo "<pre>";
  // print_r($colTipoLugares);
  // echo "</pre>";

  if (count($colTipoLugares) > 0) {
    foreach ($colTipoLugares as $key => $elem) {
      if ($elem->urlImg != "" && file_exists("../upload/tipos_lugar/" . $elem->urlImg)) {
        $colTipoLugares[$key]->urlImg = "upload/tipos_lugar/" . $elem->urlImg;
      } else {
        $colTipoLugares[$key]->urlImg = "upload/tipos_lugar/default.png";
      }
    }
  }
  $arr = array("success" => true, "colTipoLugares" => $colTipoLugares);

  echo $callback . '(' . json_encode($arr) . ');';
}

//obtener coleccion de tipos de lugar
function obtLugares($callback, $tipoLugarId)
{
  $catLugaresObj = new catLugaresObj();

  //Coleccion de lugares
  $colLugares = $catLugaresObj->GetAllCatLugaresObj(1, $tipoLugarId);

  if (count($colLugares) > 0) {
    foreach ($colLugares as $key => $elem) {
      if ($elem->urlImg != "" && file_exists("../upload/lugares/" . $elem->urlImg)) {
        $colLugares[$key]->urlImg = "upload/lugares/" . $elem->urlImg;
      } else {
        $colLugares[$key]->urlImg = "upload/lugares/default.png";
      }
    }
  }

  $arr = array("success" => true, "colLugares" => $colLugares);

  echo $callback . '(' . json_encode($arr) . ');';
}


//enviar email de correo ciudadano
function correoBuzonCiudadano($callback, $datosJson, $arrfotosSubidas)
{
  $opc = (isset($_GET['callback'])) ? 'get' : 'post';
  $tipoContactoObj = new catTipoContactosObj();
  include "../common/config.php";
  $dirname = dirname(__DIR__);
  $emailObj = new EmailFunctions();

  // $isblob = false;
  // $destino = '';

  // $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
  // $dateTime = $dateByZone->format('d m Y H:i:s'); //fecha Actual
  // // echo mysqli_error($this->connectionStatus);
  // if(!file_exists("log_post.txt")){
  //   $file = fopen("log_post.txt", "w");
  //   fclose($file);
  // }
  // $file = fopen("log_post.txt", "a");

  // foreach($_POST as $key => $value){
  //   fwrite($file, $key." ".$value . PHP_EOL. PHP_EOL);
  // }

  // foreach($_FILES as $key => $value){
  //   fwrite($file, $key." ".$value . PHP_EOL. PHP_EOL);
  // }

  // fclose($file);

  // if( isset($_FILES['picture']) && !$_FILES['picture']['error'] ){
  //   $isblob = true;

  //   $save_folder = '../upload/buzon_ciudadano';
  //   $extension = obtenerExtension($_FILES['picture']['name']);
  //   $newNameImg = generarPassword(10, TRUE, TRUE, FALSE, FALSE).".".$extension;
  //   $destino = $save_folder.$newNameImg;

  //   file_put_contents( $destino, file_get_contents($_FILES['picture']['tmp_name']) );
  // }

  $arrDatos = json_decode($datosJson);
  $buzonCiudadanoObj = new buzonCiudadanoObj();
  $buzonCiudadanoObj->tipoContacto = $arrDatos->tipo_contacto_bc;
  $buzonCiudadanoObj->mensaje = $arrDatos->mensaje_bc;
  $buzonCiudadanoObj->testigo = (count($arrDatos->opc_testigo_bc) > 0) ? "1" : "0";
  $buzonCiudadanoObj->anonimo = (count($arrDatos->opc_anonimo_bc) > 0) ? "1" : "0";
  $buzonCiudadanoObj->telefono = $arrDatos->telefono_bc;
  $buzonCiudadanoObj->nombreCiudadano = $arrDatos->nombre_bc;
  $buzonCiudadanoObj->evidencias = (isset($arrDatos->hidd_base64img) && $arrDatos->hidd_base64img != "") ? urldecode($arrDatos->hidd_base64img) : $arrfotosSubidas;
  // $buzonCiudadanoObj->evidencias = ($destino != "")?$destino:$arrfotosSubidas;
  $buzonCiudadanoObj->GuardarbuzonCiudadanoObj();
  //Se guarda el buzon cuidadano
  // echo "<pre>";
  // var_dump($arrDatos);
  // // var_dump($arrDatos);
  // die();
  //
  $tipo_contacto_bc = $arrDatos->tipo_contacto_bc; //Subjet
  // $opc_anonimo_bc = $arrDatos->opc_anonimo_bc;
  // $mensaje_bc = $arrDatos->mensaje_bc;  //mensaje
  // $opc_testigo_bc = (count($arrDatos->opc_testigo_bc)>0)?"Si":"No";
  // $nombre_bc = $arrDatos->nombre_bc;  //Nombre cuidadano
  // $telefono_bc = $arrDatos->telefono_bc;  //tel cuidadano

  //Obtener telefono segun el tipo
  $datosTipoContacto = $tipoContactoObj->ObtTipoContactoPorId($tipo_contacto_bc);
  $emaiDefault = "mauricio.sanchez@framelova.com";
  $emailEnviar = ($datosTipoContacto->email != "") ? $datosTipoContacto->email : $emaiDefault;
  $rutaArchivo = ($arrfotosSubidas != "") ? $dirname . "/upload/buzon_ciudadano/" . $arrfotosSubidas : "";
  $rutaArchivo = ($arrDatos->hidd_base64img != "") ? urldecode($arrDatos->hidd_base64img) : "";

  // echo "<pre>";
  // print_r($arrDatos);
  // print_r($datosTipoContacto);
  // echo "</pre>";

  $subject = $datosTipoContacto->nombre;
  $res = $emailObj->enviarBuzonCiudadano($subject, $emailEnviar, $arrDatos, $rutaArchivo);
  // $res = 1;
  if ($buzonCiudadanoObj->idBuzonCiudadano > 0) {
    $arr = array("success" => true, "res" => $res, "opc" => $opc, "idBuzonCiudadano" => $buzonCiudadanoObj->idBuzonCiudadano, "isblob" => $isblob, "destino" => $destino);
  } else {
    $arr = array("success" => false, "res" => $res, "opc" => $opc, "idBuzonCiudadano" => $buzonCiudadanoObj->idBuzonCiudadano, "isblob" => $isblob, "destino" => $destino);
  }

  //Jair AGO 2020 Validar post o get
  if ($callback == '') {
    header('Access-Control-Allow-Origin: *');
    header('Access-Control-Allow-Methods: POST');
    header('Access-Control-Max-Age: 1000');
    echo json_encode($arr);
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}



/* Insertar opinión de Calificar la atención */
function crearOpinionCalificarAtencion($callback, $datosJson, $idUsuario)
{
  include "../common/config.php";

  $dataForm = json_decode($datosJson);
  $calificarAtencionObj = new calificarAtencionObj();
  $calificarAtencionObj->crearOpinionCalificarAtencionObj($dataForm, $idUsuario);

  $response = array("success" => true);

  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Max-Age: 1000');
  echo $callback . '(' . json_encode($response) . ');';
}

//obtener coleccion de telefonos de emergencia
function obtTelsEmergencia($callback)
{
  include "../common/config.php";
  $catTelEmergenciaObj = new catTelefonosEmergenciaObj();

  $colTelefonos = $catTelEmergenciaObj->GetAllCatTelefonosEmergencia(1);
  if (count($colTelefonos) > 0) {
    foreach ($colTelefonos as $keyTel => $elemTel) {
      if ($elemTel->urlImg != "" && file_exists("../upload/contactos_emergencia/" . $elemTel->urlImg)) {
        // $colTelefonos[$keyTel]->urlImg = $siteURL."upload/contactos_emergencia/".$elemTel->urlImg;
        $colTelefonos[$keyTel]->urlImg = "upload/contactos_emergencia/" . $elemTel->urlImg;
      } else {
        // $colTelefonos[$keyTel]->urlImg = $siteURL."upload/contactos_emergencia/default.png";
        $colTelefonos[$keyTel]->urlImg = "upload/contactos_emergencia/telefono.png";
      }
    }
  }

  $arr = array("success" => true, "colTelefonos" => $colTelefonos);
  echo $callback . '(' . json_encode($arr) . ');';
}

//recupera la contrasela y le manda un correo al cliente
function recuperarContrasenia($callback, $email)
{
  $userObj = new usuariosObj();
  $emailObj = new EmailFunctions();
  $datosUsr = $userObj->UserByEmail($email);

  //verifica que el usuario exista
  if ($datosUsr->idUsuario > 0 && ($datosUsr->idRol == 3 || $datosUsr->idRol == 10)) {
    //generar un correo con un enlace de resetear contrasenia
    $resMail = $emailObj->reseteoContrasenia($email, $datosUsr->nombre, $datosUsr->idUsuario); //HABILITAR

    //TODO: borrar
    // //generar una nueva contrasenia
    // $nuevoPass = generarPassword(6, true, true,   false, false);
    // //actualizar la nueva contrasenia del usuario
    // $userObj->ActualizarUsuario("password", $nuevoPass, $userObj->idUsuario);
    //Enviar datos de acceso
    // $emailObj->RecuperarDatosDeAcceso($email, $userObj->nombre, $nuevoPass);
    //Fin borrar

    $arr = array("success" => true, "resMail" => $resMail);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

//enviar codigo de validacion por correo
function codigoValidacionCorreo($callback, $email, $celular)
{
  $codigoValidacionObj = new codigoValidacionObj();
  $emailObj = new EmailFunctions();

  $codigo = genValidationCode($email, $celular);
  $subject = "Código de validación";

  //Enviar correo
  $res = $emailObj->EnviarCodigo($subject, trim($email), $codigo);

  if ($res > 0) {
    $arr = array("success" => true, "res" => $res);
  } else {
    $arr = array("success" => false, "res" => $res);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

//Comprobar el codigo de validacion escrito
function checkCodigoValidacion($callback, $codigo)
{
  $res = validaCodigo(trim($codigo));
  if ($res > 0) {
    $arr = array("success" => true, "res" => $res);
  } else {
    $arr = array("success" => false, "res" => $res);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//Metodo que comprueba si el correo no existe
function validarCorreoCrearCuenta($callback, $email)
{
  $userObj = new usuariosObj();
  $datosUsr = $userObj->UserByEmail(trim($email));

  //verifica que el usuario exista
  if ($datosUsr->idUsuario == 0) {
    $arr = array("success" => true); //Si no existe correo es correcto
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//Enviar codigo de validacion por SMS para miembro de comité
function codigoValidacionSMS($callback, $celular)
{
  $codigo = genValidationCode($celular);
  //Enviar SMS
  $mensaje = "Tu codigo para validar tu cuenta en SAI es: " . $codigo;
  $res = enviarSMS($mensaje, $celular); //HABILITAR
  // $res = true; //DESHABILITAR

  if ($res == true) {
    $arr = array("success" => true, "res" => $res);
  } else {
    $arr = array("success" => false, "res" => $res);
  }

  // $arr = array("success"=>false, "celular"=>$celular);
  echo $callback . '(' . json_encode($arr) . ');';
}

//enviar codigo de validacion por correo para ciudadano a pie
function codigoValidacionCorreoCiudadanoPie($callback, $email, $celular)
{
  $codigoValidacionObj = new codigoValidacionObj();
  $emailObj = new EmailFunctions();

  $codigo = generateValidationCodeCiudadanoPie($email, $celular);
  $subject = "Código de validación";
  $idcode = $codigoValidacionObj->obtenerCodigoValidacionByCodigo($codigo);
  //Enviar correo
  $res = $emailObj->EnviarCodigo($subject, trim($email), $codigo);

  if ($res > 0) {
    $arr = array("success" => true, "res" => $res, "email" => $email, "celular" => $celular);
  } else {
    $arr = array("success" => false, "res" => $res);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//enviar código de validación por SMS para miembro de comité
function codigoValidacionSMSCiudadanoPie($callback, $email, $celular)
{
  $codigo = generateValidationCodeCiudadanoPie($email, $celular);
  //Enviar SMS
  $mensaje = "Tu código para validar tu cuenta en SAI Tehuacán: " . $codigo;
  $res = enviarSMS($mensaje, $celular); //HABILITAR
  // $res = true; //DESHABILITAR

  if ($res == true) {
    $arr = array("success" => true, "res" => $res, "email" => $email, "celular" => $celular);
  } else {
    $arr = array("success" => false, "res" => $res);
  }

  // $arr = array("success"=>false, "celular"=>$celular);
  echo $callback . '(' . json_encode($arr) . ');';
}

// checar que el codigo de validacion sea correcto y coincida con el email y numero de telfono del ciudadano
function checkCodigoValidacionCiudadanoPie($callback, $codigo, $email, $celular)
{
  $esValido = validaCodigoCiudadanoPie(trim($codigo), $email, $celular);
  $arr = ($esValido == 1) ?
    array("success" => true, "message" => "El codigo existe y coincide con email y contraseña", "email" => $email, "celular" => $celular) :
    array("success" => false, "message" => "el codigo introducido no es valido");
  echo $callback . '(' . json_encode($arr) . ');';
}

//Enviar pedido de venta correo a los gerentes asociados al vendedor
function creaCuentaCiudadano($callback)
{
  $userObj = new usuariosObj();
  $emailObj = new EmailFunctions();
  $datoUsuarioObj = new datosUsuarioObj();
  $docUsuarioObj = new documentosUsuarioObj();
  $comites = new catComiteObj();

  $arrdatos = json_decode($_POST['datosJson']);
  /*
  //variables prueba
  $arrdatos = array();
  $arrdatos["amaterno_crearcuenta"] = "Garcia";
  $arrdatos["apaterno_crearcuenta"] = "Ramirez";
  $arrdatos["codigo_crearcuenta"] = "mvd4d";
  $arrdatos["email_crearcuenta"] = "karlos.0@live.com.mx";
  $arrdatos["nombre_crearcuenta"] = "Carlos";
  $arrdatos["telefono_crearcuenta"] = "2225336420";
  $arrdatos["tipoValidacion"] = 2;
  $arrdatos["doc_crearcuenta"] = 3;
  $_POST["arrfotosSubidas"] = "153617238841135cdv_photo_001.jpg";
  $arrdatos = (object)$arrdatos;
  echo "<pre>";
  print_r($arrdatos);
  echo "</pre>";

  $arrfotosSubidas = $_POST["arrfotosSubidas"];
  if($arrfotosSubidas!="" && isset($arrdatos->doc_crearcuenta)){
    $docUsuarioObj->tipoDocId = $arrdatos->doc_crearcuenta;
    $docUsuarioObj->valido = 0;
    $docUsuarioObj->urlImg = $arrfotosSubidas;
    $docUsuarioObj->GuardarDocumentoUsuario();
    echo "Inserta";
  }else{
    echo "no inserta";
  }
  exit();
  */
  // echo "<pre>";print_r($arrDatos);echo "</pre>";die();
  //Setear datos para ser salvados
  $tipoValidacion = ($arrdatos->tipoValidacion == 1 || $arrdatos->tipoValidacion == 2) ? $arrdatos->tipoValidacion : 0;
  $nombreCompleto = $arrdatos->nombre_crearcuenta . " " . $arrdatos->apaterno_crearcuenta . " " . $arrdatos->amaterno_crearcuenta;
  $password = generarPassword(6);
  $userObj->idRol = 3;
  $userObj->nombre = $nombreCompleto;
  $userObj->email = $arrdatos->email_crearcuenta;
  $userObj->password = $password;
  $userObj->activo = 1;
  $userObj->tipoValidacion = $tipoValidacion;
  $userObj->valido = 0;
  $userObj->GuardarUsuario();  //Salvar ciudadano

  if ($userObj->idUsuario > 0) {
    //setear datos para la tabla de datos usuarios
    $datoUsuarioObj->usuarioId = $userObj->idUsuario;
    $datoUsuarioObj->clave = generarFolio($userObj->idUsuario);
    $datoUsuarioObj->nombre = $arrdatos->nombre_crearcuenta;
    $datoUsuarioObj->aPaterno = $arrdatos->apaterno_crearcuenta;
    $datoUsuarioObj->aMaterno = $arrdatos->amaterno_crearcuenta;
    $datoUsuarioObj->telefono = $arrdatos->telefono_crearcuenta;
    $datoUsuarioObj->calle = $arrdatos->calle_crearcuenta;
    $datoUsuarioObj->numero = $arrdatos->numero_crearcuenta;
    $datoUsuarioObj->colonia = $arrdatos->colonia_crearcuenta;
    $datoUsuarioObj->cp = $arrdatos->cp_crearcuenta;
    $datoUsuarioObj->numComite = $arrdatos->numcomite_crearcuenta;
    $datoUsuarioObj->idComite = $arrdatos->numcomite_crearcuenta;
    $datoUsuarioObj->GuardarDatosUsuario();

    if ($datoUsuarioObj->idDatoUsuario > 0) {
      //Salvar imagen en caso de existir en tabla documentos usuario
      $arrfotosSubidas = $_POST["arrfotosSubidas"];
      if ($arrfotosSubidas != "" && isset($arrdatos->doc_crearcuenta)) {
        $docUsuarioObj->tipoDocId = $arrdatos->doc_crearcuenta;
        $docUsuarioObj->valido = 0;
        $docUsuarioObj->urlImg = $arrfotosSubidas;
        $docUsuarioObj->GuardarDocumentoUsuario();
      }

      //mandar correo con sus datos de acceso a la aplicacion
      $comiteUsr = $comites->ComitePorId($arrdatos->numcomite_crearcuenta);
      $emailObj->EnviarDatosDeAcceso(trim($arrdatos->email_crearcuenta), $nombreCompleto, $password, $comiteUsr->nombre);
      $arr = array("success" => true, "arrDatos" => $arrdatos);
    } else {
      $arr = array("success" => false, "arrDatos" => $arrdatos);
    }
  } else {
    $arr = array("success" => false, "arrDatos" => $arrdatos);
  }

  // echo "<pre>";
  // print_r($arrdatos);
  // print_r($arr);
  // echo "</pre>";

  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Max-Age: 1000');
  echo json_encode($arr);
}

// crear cuenta para ciudadano a pie
function crearCuentaCiudadanoPie($callback, $datosJson, $fotoUsuario)
{
  $emailObj = new EmailFunctions();
  $datoUsuarioObj = new datosUsuarioObj();
  $gbFunctionsObj = new globalFunctions();
  $datosForm = json_decode($datosJson);
  /** Crear objeto para hacer INSERT en tabla usuarios */
  $userObj = new usuariosObj();
  $ROL_CIUDADANO_PIE = 10;
  $tipoValidacion = $datosForm->tipoValidacion_crearcuentaciudadanopie;
  $nombreCompleto = $datosForm->nombre . " " . $datosForm->apaterno . " " . $datosForm->amaterno;
  $password = generarPassword(6);
  $params = array(
    $ROL_CIUDADANO_PIE,
    $nombreCompleto,
    $datosForm->email,
    $password,
    1, // esta activo? 1=SI 0=NO
    $tipoValidacion,
    0, // ya es valido?
  );
  $userObj->GuardarUsuarioCiudadanoPie($params);
  if ($userObj->idUsuario <= 0) {
    $res = array("success" => false, "message" => "no se pudo crear al usuario", "idUsuario" => $userObj->idUsuario);
  }
  /** Crear objeto para hacer INSERT en tabla datos_usuario */

  $params = array(
    $userObj->idUsuario,
    generarFolio($userObj->idUsuario), // es la clave
    $datosForm->nombre,
    $datosForm->apaterno,
    $datosForm->amaterno,
    $datosForm->numeroCelular,
    $datosForm->calle,
    $datosForm->numeroDomicilio,
    $datosForm->colonia,
    $datosForm->codigoPostal,
    (isset($datosForm->imgName)) ? $datosForm->imgName . ".jpg" : $fotoUsuario
  );
  $datoUsuarioObj->GuardarDatosUsuarioCidadanoPie($params);
  if ($datoUsuarioObj->idDatoUsuario <= 0) {
    $res = array("success" => false, "message" => "no se pudo guardar los datos del usuario", "idUsuario" => $userObj->idUsuario, "idDatoUsuario" => $datoUsuarioObj->idDatoUsuario);
  }

  // mandar correo al ciudadano con sus credenciales de acceso
  $emailObj->EnviarDatosDeAcceso(trim($datosForm->email), $nombreCompleto, $password, "");
  $res = array("success" => true, "message" => "usuario creado y datos de usuario guardados");

  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Max-Age: 1000');
  echo $callback . '(' . json_encode($res) . ');';
}

// Obtener datos del usuario por id
function obtDatosUsuarioPorId($callback, $idUsuario)
{
  $userObj = new usuariosObj();
  $datoUsuarioObj = new datosUsuarioObj();
  $tblUsuario = $userObj->UserByID($idUsuario); //obtener datos de la tabla usuarios

  if ($tblUsuario->idUsuario > 0) {
    //obtener datos completos de la tabla datos_usuarios
    $tblDatosUsuario = $datoUsuarioObj->obtDatosUsuarioPorUsuarioId($tblUsuario->idUsuario);
    if ($tblDatosUsuario->idDatoUsuario > 0) {
      $arr = array("success" => true, "tblUsuario" => $tblUsuario, "tblDatosUsuario" => $tblDatosUsuario);
    } else {
      $arr = array("success" => false);
    }
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
  // echo "<pre>";
  // print_r($tblUsuario);
  // print_r($tblDatosUsuario);
  // echo "</pre>";
}

// Actualizar datos de la cuenta del ciudadano
function actDatosCuenta($callback, $datosJson)
{
  $userObj = new usuariosObj();
  $datoUsuarioObj = new datosUsuarioObj();

  $arrDatos = json_decode($datosJson); //obtener datos
  $dateByZone = obtDateTimeZone();

  $datosUsr = $userObj->UserByID($arrDatos->idUsuario);
  if ($datosUsr->idUsuario > 0) {
    $nombreCompleto = $arrDatos->nombre . " " . $arrDatos->apaterno . " " . $arrDatos->amaterno;
    $userObj->ActualizarUsuario("email", $arrDatos->email, $datosUsr->idUsuario);
    $userObj->ActualizarUsuario("nombre", $nombreCompleto, $datosUsr->idUsuario);
    $userObj->ActualizarUsuario("fechaAct", $dateByZone->fechaHora, $datosUsr->idUsuario);
    $userObj->ActualizarUsuario("password", $arrDatos->contrasenia, $datosUsr->idUsuario);

    //Actualizar en tabla datos_usuario
    $datoUsuarioObj->actDatoUsuarioCampoPorUsuarioId("nombre", $arrDatos->nombre, $datosUsr->idUsuario);
    $datoUsuarioObj->actDatoUsuarioCampoPorUsuarioId("aPaterno", $arrDatos->apaterno, $datosUsr->idUsuario);
    $datoUsuarioObj->actDatoUsuarioCampoPorUsuarioId("aMaterno", $arrDatos->amaterno, $datosUsr->idUsuario);
    $datoUsuarioObj->actDatoUsuarioCampoPorUsuarioId("telefono", $arrDatos->telefono, $datosUsr->idUsuario);
    $datoUsuarioObj->actDatoUsuarioCampoPorUsuarioId("fechaAct", $dateByZone->fechaHora, $datosUsr->idUsuario);

    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}




//actualizar la columna de mostrar a 0 para que ya no se despliegue en la lista del app
function accionesNotificacion($callback, $idMensaje, $campo, $valor)
{
  $msgObj = new mensajesObj();
  $resAct = $msgObj->ActualizarMensaje($campo, $valor, $idMensaje);
  if ($resAct > 0) {
    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function obtOpcReporteCiudadano($callback)
{
  include "../common/config.php";
  $catRptCObj = new catRptCiudadanosObj();
  $colCatRptC = $catRptCObj->GetAllCatRptCiudadanos(1);

  if (count($colCatRptC) > 0) {
    foreach ($colCatRptC as $keyRpt => $elemRpt) {
      if ($elemRpt->urlImg != "" && file_exists("../upload/rpt_ciudadano_cat/" . $elemRpt->urlImg)) {
        $colCatRptC[$keyRpt]->urlImg = "upload/rpt_ciudadano_cat/" . $elemRpt->urlImg;
      } else {
        $colCatRptC[$keyRpt]->urlImg = "upload/rpt_ciudadano_cat/default.png";
      }
    }
  }

  $arr = array("success" => true, "colCatRptC" => $colCatRptC);
  echo $callback . '(' . json_encode($arr) . ');';
}

function reporteCiudadano($callback, $datosJson, $idUsuario, $lat, $long, $arrfotosSubidas)
{
  $rptCUsrObj = new rptCiudadanoUsuarioObj();
  $arrDatos = json_decode($datosJson); //obtener datos

  $rptCUsrObj->rptCId = $arrDatos->hidd_idRptC;
  $rptCUsrObj->usuarioId = $idUsuario;
  $rptCUsrObj->folio = generarPassword(6, false, true, false, false);
  $rptCUsrObj->estatus = 1;
  $rptCUsrObj->urlImg = ($arrfotosSubidas != "") ? $arrfotosSubidas : "";
  $rptCUsrObj->ubicacion = $lat . "," . $long;
  $rptCUsrObj->comentario = $arrDatos->comentario_rptc;
  $rptCUsrObj->datosJson = $datosJson;

  //Salvar
  $rptCUsrObj->GuardarRptCiudadanoUsuario();
  if ($rptCUsrObj->idRptCUsuario > 0) {
    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }

  // echo "<pre>";
  // print_r($arrDatos);
  // echo "</pre>";
  // echo $datosJson;

  // $arr = array("success"=>true, "lat"=>$lat, "long"=>$long, "idUsuario"=>$idUsuario);
  echo $callback . '(' . json_encode($arr) . ');';
}

//obtener coleccion de reportes del ciudadano por su id
function obtReportesCiudadanoPorId($callback, $idUsuario)
{
  include "../common/config.php";
  $rptCUsrObj = new rptCiudadanoUsuarioObj();
  $colRptCUrs = $rptCUsrObj->obtRptCiudadanoUsuarioPorIdUsr($idUsuario);
  $colEstatusRpt = array("1" => "Recibido", "2" => "En revisión", "3" => "Atendido");

  if (count($colRptCUrs) > 0) {
    foreach ($colRptCUrs as $keyRpt => $elemRpt) {
      if ($elemRpt->urlImg != "" && file_exists("../upload/rpt_ciudadano/" . $elemRpt->urlImg)) {
        $colRptCUrs[$keyRpt]->urlImg = "upload/rpt_ciudadano/" . $elemRpt->urlImg;
      } else {
        $colRptCUrs[$keyRpt]->urlImg = "";
      }

      //Agregar el nombre del tipo de reporte
      $catRptCObj = new catRptCiudadanosObj();
      $colCatRptC = $catRptCObj->obtCatRptCiudadanosPorId($elemRpt->rptCId);
      if (isset($colCatRptC->idRptC)) {
        $colRptCUrs[$keyRpt]->{"nombreRptC"} = $colCatRptC->nombre;
      }

      //Agregar es nombre del estatus
      $colRptCUrs[$keyRpt]->{"nombreEstatusRpt"} = $colEstatusRpt[$elemRpt->estatus];
    }
  }
  // echo "<pre>";
  // print_r($colRptCUrs);
  // echo "</pre>";

  $arr = array("success" => true, "colRptCUrs" => $colRptCUrs);
  echo $callback . '(' . json_encode($arr) . ');';
}


// Obtener la lista de categorias de la bolsa de trabajo
function ObtCatBolsaTrabajo($callback, $opc = "")
{
  $catBTObj = new catBolsatrabajoObj();
  $colCategoriaBT = $catBTObj->ObtCatBolsaTrabajo(1);

  if (count($colCategoriaBT) > 0) {
    $arr = array("success" => true, "colCategoriaBT" => $colCategoriaBT);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}

// Obtener la lista de los puestos de la bolsa de trabajo
function ObtPuestosBolsaTrabajoPorIdCat($callback, $idCat, $opc = "")
{
  $btObj = new bolsatrabajoObj();
  $colPuestosBT = $btObj->ObtBolsaTrabajoPuestos(1, $idCat);

  if (count($colPuestosBT) > 0) {
    foreach ($colPuestosBT as $keyP => $elemP) {
      if ($elemP->urlImgEmp != "" && file_exists("../upload/empresas/" . $elemP->urlImgEmp)) {
        $colPuestosBT[$keyP]->urlImgEmp = "upload/empresas/" . $elemP->urlImgEmp;
      } else {
        $colPuestosBT[$keyP]->urlImgEmp = 'upload/empresas/img_default.png';
      }
      //para el sueldo
      // if(!is_string($elemP->sueldo)){
      //   $colPuestosBT[$keyP]->sueldo = number_format($elemP->sueldo,2);
      // }

      //Agregar la jornada en caso de existir
      if ($elemP->tipoJornadaId != "" && $elemP->tipoJornadaId > 0) {
        $catTJorObj = new catTipojornadaObj();
        $colCatTJor = $catTJorObj->ObtTipoJornadaPorId($elemP->tipoJornadaId);
        $colPuestosBT[$keyP]->{"nombreJornada"} = $colCatTJor->nombre;
      } else {
        $colPuestosBT[$keyP]->{"nombreJornada"} = "";
      }
    }
    $arr = array("success" => true, "colPuestosBT" => $colPuestosBT);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}


// Obtener la lista de categorias de informacion legal
function obtInfoLegalCategorias($callback, $opc = "")
{
  $infoLCatObj = new infolegalCategoriasObj();
  $colCategoriaIL = $infoLCatObj->ObtInfolegalCategorias(1);

  if (count($colCategoriaIL) > 0) {
    $arr = array("success" => true, "colCategoriaIL" => $colCategoriaIL);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}

// Obtener la lista de enlaces de informacion legal por su categoria
function ObtEnlacesInfoLegalPorIdCat($callback, $idCat, $opc = "")
{
  $infoLEnlacesObj = new infolegalEnlacesObj();
  $colEnlacesIL = $infoLEnlacesObj->ObtInfolegalEnlaces(1, $idCat);

  if (count($colEnlacesIL) > 0) {
    $arr = array("success" => true, "colEnlacesIL" => $colEnlacesIL);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}


// Obtener el catalogo de tipos de multa
function obtTiposMulta($callback, $opc = "")
{
  $catTipoMultaObj = new catTipoMultaObj();
  $colCatTiposMulta = $catTipoMultaObj->ObtCatTipoMultas(1);

  if (count($colCatTiposMulta) > 0) {
    $arr = array("success" => true, "colCatTiposMulta" => $colCatTiposMulta);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}

// comprobar si el folio es correcto respecto a su tipo de multa
function checkFolioMulta($callback, $idCat, $folio)
{
  $folioMultaObj = new foliosMultasObj();
  $datosFolioM = $folioMultaObj->folioMultaPorTipoMFolio($idCat, $folio);

  // echo "<pre>";
  // print_r($datosFolioM);
  // echo "</pre>";

  if ($datosFolioM->idFolioMulta > 0) {
    // $datosFolioM->cantidad = number_format($datosFolioM->cantidad,2);
    $arr = array("success" => true, "datosFolioM" => $datosFolioM);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}


//obtener coleccion de mascotas perdidas activas
function obtMascotasPerdidas($callback)
{
  $rptMascotaObj = new rptMascotasObj();

  //Coleccion de mascotas perdidas
  $colMascotasPerdidas = $rptMascotaObj->ObtRptMascotas(1);

  if (count($colMascotasPerdidas) > 0) {
    foreach ($colMascotasPerdidas as $key => $elem) {
      //Obtener la primera imagen
      $imgMascotaObj = new imagenesMascotaObj();
      $colImg = $imgMascotaObj->ObtImgMascotas($elem->idRptMascota);

      $colMascotasPerdidas[$key]->{"urlImg"} = "upload/mascotas_perdidas/default.png";  //Por defecto
      if (count($colImg) > 0) {
        if ($colImg[0]->urlImg != "" && file_exists("../upload/mascotas_perdidas/" . $colImg[0]->urlImg)) {
          $colMascotasPerdidas[$key]->{"urlImg"} = "upload/mascotas_perdidas/" . $colImg[0]->urlImg;
        }
      }
    }
  }

  $arr = array("success" => true, "colMascotasPerdidas" => $colMascotasPerdidas);

  echo $callback . '(' . json_encode($arr) . ');';
}

//obtener coleccion de mascotas perdidas
function obtTodasMascotasPerdidas($callback)
{
  $rptMascotaObj = new rptMascotasObj();
  $colMascotasPerdidas = $rptMascotaObj->ObtTodasMascotasPerdidasObj();

  if (count($colMascotasPerdidas) > 0) {
    foreach ($colMascotasPerdidas as $key => $elem) {
      //Obtener la primera imagen
      $imgMascotaObj = new imagenesMascotaObj();
      $colImg = $imgMascotaObj->ObtImgMascotas($elem->idRptMascota);

      $colMascotasPerdidas[$key]->{"urlImg"} = "upload/mascotas_perdidas/default.png";  //Por defecto
      if (count($colImg) > 0) {
        if ($colImg[0]->urlImg != "" && file_exists("../upload/mascotas_perdidas/" . $colImg[0]->urlImg)) {
          $colMascotasPerdidas[$key]->{"urlImg"} = "upload/mascotas_perdidas/" . $colImg[0]->urlImg;
        }
      }
    }
  }

  $arr = array("success" => true, "colMascotasPerdidas" => $colMascotasPerdidas);

  echo $callback . '(' . json_encode($arr) . ');';
}

//Salvar reporte mascota perdida
function reporteMascotaPerdida($callback, $datosJson, $arrfotosSubidas, $idUsuario)
{
  $rptMascotaObj = new rptMascotasObj();
  $arrDatos = json_decode($datosJson); //obtener datos

  // echo "<pre>";
  // print_r($arrDatos);
  // echo "</pre>";
  // exit();

  $rptMascotaObj->nombreContacto = $arrDatos->nombreContacto_rptmp;
  $rptMascotaObj->emailContacto = $arrDatos->emailContacto_rptmp;
  $rptMascotaObj->telContacto = $arrDatos->telContacto_rptmp;
  $rptMascotaObj->nombreMascota = $arrDatos->nombreMascota_rptmp;
  $rptMascotaObj->colExtraviado = $arrDatos->colExtraviado_rptmp;
  $rptMascotaObj->fechaExtraviado = conversionFechas($arrDatos->fechaExtraviado_rptmp);
  $rptMascotaObj->descripcion = $arrDatos->descripcion_rptmp;
  $rptMascotaObj->activo = 1;
  $rptMascotaObj->idUsuario = $idUsuario;

  //Salvar
  $rptMascotaObj->GuardarRptMascota();
  if ($rptMascotaObj->idRptMascota > 0) {
    //Subir imagenes en caso de existir
    if ($arrfotosSubidas != "") {
      $arrImg = explode(",", $arrfotosSubidas);
      foreach ($arrImg as $elemImg) {
        $imgMascotaObj = new imagenesMascotaObj();
        $imgMascotaObj->rptMascotaId = $rptMascotaObj->idRptMascota;
        $imgMascotaObj->urlImg = $elemImg;
        $imgMascotaObj->GuardarImgMascota();
      }
    }

    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

//Obtener la informacion de la mascota por su id
function obtMascotasPorId($callback, $idRptMascota)
{
  include "../common/config.php";
  $dirname = dirname(__DIR__);
  $rptMascotaObj = new rptMascotasObj();
  $imgMascotaObj = new imagenesMascotaObj();

  $colMascota = $rptMascotaObj->obtRptMascotaPorId($idRptMascota);
  $colImg = array();

  if ($colMascota->idRptMascota > 0) {
    $colImg = $imgMascotaObj->ObtImgMascotas($colMascota->idRptMascota);
    if (count($colImg) > 0) {
      foreach ($colImg as $key => $elem) {
        if ($elem->urlImg != "") {
          $urlImg = 'upload/mascotas_perdidas/' . $elem->urlImg;
          $pathUrlImg = $dirname . '/upload/mascotas_perdidas/' . $elem->urlImg;

          //verificar que exista en carpeta
          if (!file_exists($pathUrlImg)) {
            $urlImg = 'upload/mascotas_perdidas/img_default.png';
          }
        } else {
          $urlImg = 'upload/mascotas_perdidas/img_default.png';
        }
        $colImg[$key]->urlImg = $urlImg;
      }
    }
    $arr = array("success" => true, "colMascota" => $colMascota, "colImg" => $colImg);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
  // echo "<pre>";
  // print_r($arr);
  // echo "</pre>";
}

//Reportar mascota vista
function reporteMascotaVista($callback, $datosJson, $arrfotosSubidas, $idUsuario)
{
  $respMascotaObj = new respMascotasObj();
  $arrDatos = json_decode($datosJson); //obtener datos

  // echo "<pre>";
  // print_r($arrDatos);
  // echo "</pre>";
  // exit();
  $respMascotaObj->rptMascotaId = $arrDatos->hidd_idRptMascota_vista;
  $respMascotaObj->nombreContacto = $arrDatos->nombreContacto_rptmv;
  $respMascotaObj->emailContacto = $arrDatos->emailContacto_rptmv;
  $respMascotaObj->telContacto = $arrDatos->telContacto_rptmv;
  $respMascotaObj->descripcion = $arrDatos->descripcion_rptmv;
  $respMascotaObj->fechaVisto = conversionFechas($arrDatos->fechaExtraviado_rptmv);
  $respMascotaObj->ubicacion = $arrDatos->auxUbicacionMascota;
  $respMascotaObj->idUsuario = $idUsuario;
  //Salvar
  $respMascotaObj->GuardarRespMascota();

  if ($respMascotaObj->idRespMascota > 0) {
    //Subir imagenes en caso de existir
    if ($arrfotosSubidas != "") {
      $arrImg = explode(",", $arrfotosSubidas);
      foreach ($arrImg as $elemImg) {
        $imagenesMascotasVistasObj = new imagenesMascotasVistasObj();
        $imagenesMascotasVistasObj->rptMascotaId = $respMascotaObj->idRespMascota;
        $imagenesMascotasVistasObj->urlImg = $elemImg;
        $imagenesMascotasVistasObj->GuardarImgMascotaVista();
      }
    }

    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function reactivarMascotaPerdida($callback, $idRptMascota)
{
  $rptMascotaObj = new rptMascotasObj();
  $datosRptMascota = $rptMascotaObj->obtRptMascotaPorId($idRptMascota);

  if ($datosRptMascota->idRptMascota > 0) {
    if ($datosRptMascota->activo == 1 || $datosRptMascota->activo == 2) {
      $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
      $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
      $daymas15dias = new DateTime("15 days", new DateTimeZone("America/Mexico_City"));
      $fecha15diasMas = $daymas15dias->format("Y-m-d H:i:s");

      $rptMascotaObj->updateCampoRptMascotas("activo", $datosRptMascota->activo + 1, $idRptMascota);
      $rptMascotaObj->updateCampoRptMascotas("fechaCaducidad", $fecha15diasMas, $idRptMascota);
      $rptMascotaObj->updateCampoRptMascotas("fechaActualizacion", $dateTime, $idRptMascota);

      $arr = array("success" => true, "msg" => "Reporte actualizado, caducará en 15 días más.");
    } else if ($datosRptMascota->activo == 3) {
      $arr = array("success" => true, "msg" => "No se puede reactivar el reporte más de 3 veces. Realice uno nuevo en caso de ser necesario.");
    }
  } else {
    $arr = array("success" => true, "msg" => "Mascota no existente");
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function miMascotaEncontrada($callback, $idRptMascota)
{
  $rptMascotaObj = new rptMascotasObj();
  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual

  $rptMascotaObj->updateCampoRptMascotas("encontrada", 1, $idRptMascota);
  $rptMascotaObj->updateCampoRptMascotas("fechaEncontrado", $dateTime, $idRptMascota);

  $arr = array("success" => true, "msg" => "Registro guardado con éxito.");
  echo $callback . '(' . json_encode($arr) . ');';
}

//Obtener la ayudas por su id
function obtAyudaPorAlias()
{
  $callback = (isset($_GET['callback']) != "") ? $_GET['callback'] : "";
  $alias = (isset($_GET['idAyuda']) != "") ? $_GET['idAyuda'] : "";

  $dirname = dirname(__DIR__);
  $catAyudaObj = new catAyudasObj();
  $datosAyuda = $catAyudaObj->ObtAyudaPorAlias($alias);
  if ($datosAyuda->idAyuda > 0) {
    if ($datosAyuda->urlImg != "") {
      $urlImg = 'upload/ayudas/' . $datosAyuda->urlImg;
      $pathUrlImg = $dirname . '/upload/ayudas/' . $datosAyuda->urlImg;

      //verificar que exista en carpeta
      if (!file_exists($pathUrlImg)) {
        $urlImg = "";
      }
    } else {
      $urlImg = "";
    }
    $datosAyuda->urlImg = $urlImg;

    $arr = array("success" => true, "datosAyuda" => $datosAyuda);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function obtAyudaPorId($callback, $idAyuda)
{
  $dirname = dirname(__DIR__);
  $catAyudaObj = new catAyudasObj();
  $datosAyuda = $catAyudaObj->ObtAyudaPorId($idAyuda);

  if ($datosAyuda->idAyuda > 0) {
    if ($datosAyuda->urlImg != "") {
      $urlImg = 'upload/ayudas/' . $datosAyuda->urlImg;
      $pathUrlImg = $dirname . '/upload/ayudas/' . $datosAyuda->urlImg;

      //verificar que exista en carpeta
      if (!file_exists($pathUrlImg)) {
        $urlImg = "";
      }
    } else {
      $urlImg = "";
    }
    $datosAyuda->urlImg = $urlImg;

    $arr = array("success" => true, "datosAyuda" => $datosAyuda);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}


//obtener coleccion de personas extraviadas
function obtPersonasPerdidas($callback)
{
  $rptPersonaObj = new rptPersonasObj();

  //Coleccion de mascotas extraviadas
  $colPersonasPerdidas = $rptPersonaObj->ObtTodasPersonasPerdidas();

  if (count($colPersonasPerdidas) > 0) {
    foreach ($colPersonasPerdidas as $key => $elem) {
      //para la imagen de la persona
      $imgPersonaObj = new imagenesPersonaObj();
      $colImg = $imgPersonaObj->ObtImgPersona($elem->idRptPersona);

      $colPersonasPerdidas[$key]->{"urlImg"} = "upload/personas_desaparecidas/default.png";  //Por defecto
      if (count($colImg) > 0) {
        if ($colImg[0]->urlImg != "" && file_exists("../upload/personas_desaparecidas/" . $colImg[0]->urlImg)) {
          $colPersonasPerdidas[$key]->{"urlImg"} = "upload/personas_desaparecidas/" . $colImg[0]->urlImg;
        }
      }
    }
  }

  $arr = array("success" => true, "colPersonasPerdidas" => $colPersonasPerdidas);
  echo $callback . '(' . json_encode($arr) . ');';
}

//Obtener la informacion de la persona por su id
function obtPersonaPorId($callback, $idRptPersona)
{
  include "../common/config.php";
  $dirname = dirname(__DIR__);
  $rptPersonaObj = new rptPersonasObj();
  $imgPersonaObj = new imagenesPersonaObj();

  $colPersona = $rptPersonaObj->ObtRptPersonaPorId($idRptPersona);
  $colImg = array();

  if ($colPersona->idRptPersona > 0) {
    $colImg = $imgPersonaObj->ObtImgPersona($colPersona->idRptPersona);
    if (count($colImg) > 0) {
      foreach ($colImg as $key => $elem) {
        if ($elem->urlImg != "") {
          $urlImg = 'upload/personas_desaparecidas/' . $elem->urlImg;
          $pathUrlImg = $dirname . '/upload/personas_desaparecidas/' . $elem->urlImg;

          //verificar que exista en carpeta
          if (!file_exists($pathUrlImg)) {
            $urlImg = 'upload/personas_desaparecidas/default.png';
          }
        } else {
          $urlImg = 'upload/personas_desaparecidas/default.png';
        }
        $colImg[$key]->urlImg = $urlImg;
      }
    }
    $arr = array("success" => true, "colPersona" => $colPersona, "colImg" => $colImg);
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//Salvar reporte persona perdida
function reportePersonaPerdida($callback, $datosJson, $arrfotosSubidas, $idUsuario)
{
  $rptPersonasObj = new rptPersonasObj();
  $arrDatos = json_decode($datosJson); //obtener datos

  $rptPersonasObj->nombrePersona = $arrDatos->nombrePersona_rptmp;
  // $rptPersonasObj->emailContacto = $arrDatos->emailContacto_rptmp;
  $rptPersonasObj->numeroContacto = $arrDatos->telContacto_rptmp;
  $rptPersonasObj->lugarExtravio = $arrDatos->colExtraviado_rptmp;
  $rptPersonasObj->fechaExtraviado = conversionFechas($arrDatos->fechaExtraviado_rptmp);
  $rptPersonasObj->descripcion = $arrDatos->descripcion_rptmp;
  $rptPersonasObj->nombreContacto = $arrDatos->nombreContacto_rptmp;
  $rptPersonasObj->correoContacto = $arrDatos->emailContacto_rptmp;
  $rptPersonasObj->idUsuario = $idUsuario;
  //Salvar
  $rptPersonasObj->GuardarRptPersona();
  if ($rptPersonasObj->idRptPersona > 0) {
    //Subir imagenes en caso de existir
    if ($arrfotosSubidas != "") {
      $arrImg = explode(",", $arrfotosSubidas);
      foreach ($arrImg as $elemImg) {
        $imgPersonaObj = new imagenesPersonaObj();
        $imgPersonaObj->rptPersonaId = $rptPersonasObj->idRptPersona;
        $imgPersonaObj->urlImg = $elemImg;
        $imgPersonaObj->GuardarImgPersona();
      }
    }

    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

//Reportar persona vista
function reportePersonaVista($callback, $datosJson, $arrfotosSubidas, $idUsuario)
{
  $respPersonasObj = new respPersonasObj();
  $arrDatos = json_decode($datosJson); //obtener datos

  $respPersonasObj->rptPersonaId = $arrDatos->hidd_idRptPersona_vista;
  $respPersonasObj->nombreContacto = $arrDatos->nombreContacto_rptpv;
  $respPersonasObj->emailContacto = $arrDatos->emailContacto_rptpv;
  $respPersonasObj->telContacto = $arrDatos->telContacto_rptpv;
  $respPersonasObj->descripcion = $arrDatos->descripcion_rptpv;
  $respPersonasObj->fechaVisto = conversionFechas($arrDatos->fechaExtraviado_rptpv);
  $respPersonasObj->ubicacion = $arrDatos->auxUbicacionPersona;
  $respPersonasObj->idUsuario = $idUsuario;
  //Salvar
  $respPersonasObj->GuardarResPersona();

  if ($respPersonasObj->idRespPersona > 0) {
    //Subir imagenes en caso de existir
    if ($arrfotosSubidas != "") {
      $arrImg = explode(",", $arrfotosSubidas);
      foreach ($arrImg as $elemImg) {
        $imagenesPersonasVistasObj = new imagenesPersonasVistasObj();
        $imagenesPersonasVistasObj->rptPersonaId = $respPersonasObj->idRespPersona;
        $imagenesPersonasVistasObj->urlImg = $elemImg;
        $imagenesPersonasVistasObj->GuardarImgPersonaVista();
      }
    }

    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function reactivarPersonaPerdida($callback, $idRptPersona)
{
  $rptPersonasObj = new rptPersonasObj();
  $datosRptPersona = $rptPersonasObj->ObtRptPersonaPorId($idRptPersona);

  if ($datosRptPersona->idRptPersona > 0) {
    if ($datosRptPersona->activo == 1 || $datosRptPersona->activo == 2) {
      $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
      $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
      $daymas15dias = new DateTime("15 days", new DateTimeZone("America/Mexico_City"));
      $fecha15diasMas = $daymas15dias->format("Y-m-d H:i:s");

      $rptPersonasObj->updateCampoRptPersonas("activo", $datosRptPersona->activo + 1, $idRptPersona);
      $rptPersonasObj->updateCampoRptPersonas("fechaCaducidad", $fecha15diasMas, $idRptPersona);
      $rptPersonasObj->updateCampoRptPersonas("fechaActualizacion", $dateTime, $idRptPersona);

      $arr = array("success" => true, "msg" => "Reporte actualizado, caducará en 15 días más.");
    } else if ($datosRptPersona->activo == 3) {
      $arr = array("success" => true, "msg" => "No se puede reactivar el reporte más de 3 veces. Realice uno nuevo en caso de ser necesario.");
    }
  } else {
    $arr = array("success" => true, "msg" => "Mascota no existente");
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function miPersonaEncontrada($callback, $idRptPersona)
{
  $rptPersonasObj = new rptPersonasObj();
  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual

  $rptPersonasObj->updateCampoRptPersonas("encontrada", 1, $idRptPersona);
  $rptPersonasObj->updateCampoRptPersonas("fechaEncontrado", $dateTime, $idRptPersona);

  $arr = array("success" => true, "msg" => "Registro guardado con éxito.");
  echo $callback . '(' . json_encode($arr) . ');';
}

function reporteCiudadanoPorDia($callback, $fromDate, $toDate, $idCompare)
{
  $rptCiudadanoUsuarioObj = new rptCiudadanoUsuarioObj();
  $totalesResult = array();
  $horasResult = array();

  $fechaDesde = conversionFechas($fromDate) . " 00:00:00";
  $fechaHasta = conversionFechas($toDate) . " 00:00:00";
  //cuenta el numero de dias entre 2 fechas
  $diasTranscurridos = obtTotalDiasEntreFechas($fechaDesde, $fechaHasta);
  $result = $rptCiudadanoUsuarioObj->GetAllRptCiudadanoUsuarioByFecha(conversionFechas($fromDate), conversionFechas($toDate));

  //Restar un dia a la fecha de inicio para que no rompa la grafica
  $fecha = explode(" ", $fechaDesde);
  $nuevafecha = strtotime('-' . (1) . 'day', strtotime($fecha[0]));
  $nuevafecha = date('Y-m-d', $nuevafecha);
  $DiaNuevaFecha = explode("-", $nuevafecha);

  $totalesResult["total_0"] = 0;
  $fechasResult["total_0"] = $DiaNuevaFecha;

  //Recorremos el total de dia para el conteo total por dia
  for ($i = 0; $i <= $diasTranscurridos + 1; $i++) {
    // $fecha = explode(" ",$fechaRegistro);
    // $nuevafecha = strtotime ( '+'.$i.'day' , strtotime ( $fecha[0] ) ) ;
    $nuevafecha = strtotime('+' . $i . 'day', strtotime(conversionFechas($fromDate)));
    $nuevafecha = date('Y-m-d', $nuevafecha);
    $cont = 0;
    foreach ($result as $key) {
      if ($key->fechaCreacion2 == $nuevafecha) {
        $cont++;
      }
    }
    $DiaNuevaFecha = explode("-", $nuevafecha);
    $totalesResult["total_" . ($i + 1)] = $cont;
    $fechasResult["total_" . ($i + 1)] = $DiaNuevaFecha;
  }
  $result = array("result" => true, "arrayTotal" => $totalesResult, "fechaMin" => min($fechasResult), "fechaMax" => max($fechasResult), "arrFechas" => $fechasResult);
  echo $callback . '(' . json_encode($result) . ');';
}

function reportCiudadanoUsuarioCategorias($callback, $fromDate, $toDate, $idCompare)
{
  $rptCiudadanoUsuarioObj = new rptCiudadanoUsuarioObj();
  $catRptCiudadanosObj = new catRptCiudadanosObj();
  $totalesResult = array();
  $horasResult = array();

  $fechaDesde = conversionFechas($fromDate) . " 00:00:00";
  $fechaHasta = conversionFechas($toDate) . " 00:00:00";
  //cuenta el numero de dias entre 2 fechas
  $diasTranscurridos = obtTotalDiasEntreFechas($fechaDesde, $fechaHasta);  //Se ocupara posteriormente

  $result = $rptCiudadanoUsuarioObj->GetAllRptCiudadanoUsuarioByFecha(conversionFechas($fromDate), conversionFechas($toDate));
  $categorias = $catRptCiudadanosObj->GetAllCatRptCiudadanos(1);  //solo obtiene las activas

  $fecha = explode(" ", $fechaHasta);
  $nuevafecha = strtotime('-' . (1) . 'day', strtotime($fecha[0]));
  $nuevafecha = date('Y-m-d', $nuevafecha);
  $DiaNuevaFecha = explode("-", $nuevafecha);
  $totalesResult["total_0"] = 0;
  $horasResult["total_0"] = "";

  //Recorremos el total de categorias para el conteo total por categoria
  for ($i = 0; $i < count($categorias); $i++) {
    $cont = 0;
    foreach ($result as $key) {
      if ($key->rptCId == $categorias[$i]->idRptC) {
        $cont++;
      }
    }
    $totalesResult["total_" . ($i + 1)] = $cont;
    $horasResult["total_" . ($i + 1)] = $categorias[$i]->nombre;
  }
  $totalesResult["total_" . (count($categorias) + 1)] = 0;
  $horasResult["total_" . (count($categorias) + 1)] = "";
  $result = array("result" => true, "arrayTotal" => $totalesResult, "fechaMin" => min($horasResult), "fechaMax" => max($horasResult), "arrFechas" => $horasResult);
  echo $callback . '(' . json_encode($result) . ');';
}

function reportCiudadanoUsuarioEstatus($callback, $fromDate, $toDate, $idCompare)
{
  $rptCiudadanoUsuarioObj = new rptCiudadanoUsuarioObj();
  $catEstatusObj = new catEstatusObj();
  $totalesResult = array();
  $horasResult = array();

  $fechaDesde = conversionFechas($fromDate) . " 00:00:00";
  $fechaHasta = conversionFechas($toDate) . " 00:00:00";

  //cuenta el numero de dias entre 2 fechas
  $diasTranscurridos = obtTotalDiasEntreFechas($fechaDesde, $fechaHasta);  //Se ocupara posteriormente

  $result = $rptCiudadanoUsuarioObj->GetAllRptCiudadanoUsuarioByFecha(conversionFechas($fromDate), conversionFechas($toDate));
  $estatus = $catEstatusObj->GetAllCatEstatusObj();  //obtener todos los estatus

  $fecha = explode(" ", $fechaHasta);
  $nuevafecha = strtotime('-' . (1) . 'day', strtotime($fecha[0]));
  $nuevafecha = date('Y-m-d', $nuevafecha);
  $DiaNuevaFecha = explode("-", $nuevafecha);
  $totalesResult["total_0"] = 0;
  $horasResult["total_0"] = "";

  for ($i = 0; $i < count($estatus); $i++) {
    $cont = 0;
    foreach ($result as $key) {
      if ($key->estatus == $estatus[$i]->idEstatus) {
        $cont++;
      }
    }
    $totalesResult["total_" . ($i + 1)] = $cont;
    $horasResult["total_" . ($i + 1)] = $estatus[$i]->nombre;
  }
  $totalesResult["total_" . (count($estatus) + 1)] = 0;
  $horasResult["total_" . (count($estatus) + 1)] = "";
  $result = array("result" => true, "arrayTotal" => $totalesResult, "fechaMin" => min($horasResult), "fechaMax" => max($horasResult), "arrFechas" => $horasResult);
  echo $callback . '(' . json_encode($result) . ');';
}


// Obtener coleccion de eventos de la agenda publica
function obtEventosAP($callback, $categoria, $fromDate, $toDate)
{
  include "../common/config.php";
  $dirname = dirname(__DIR__);
  $eventoApObj = new eventosApObj();
  $categoria = ($categoria != "") ? $categoria : 0;

  $colEventos = $eventoApObj->ObtEventosAp(1, $categoria, conversionFechas($fromDate), conversionFechas($toDate));

  if (count($colEventos) > 0) {
    foreach ($colEventos as $key => $elem) {
      //para la imagen de la persona
      if ($elem->urlImg != "" && file_exists("../upload/eventos/" . $elem->urlImg)) {
        $colEventos[$key]->{"urlImg"} = "upload/eventos/" . $elem->urlImg;
      } else {
        $colEventos[$key]->{"urlImg"} = "upload/eventos/default.png";
      }

      //Formato de fecha inicio
      $colEventos[$key]->{"fechaEvento"} = convertirAFechaCompleta2($elem->fechaInicio);
      //Formato de fecha fin
      if ($elem->fechaFin != "") {
        $colEventos[$key]->{"fechaEventoFin"} = convertirAFechaCompleta2($elem->fechaFin);
      } else {
        $colEventos[$key]->{"fechaEventoFin"} = "";
      }
    }
    $arr = array("success" => true, "colEventos" => $colEventos);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
  // echo "<pre>";
  // print_r($arr);
  // echo "</pre>";
}

// Obtener coleccion de eventos de la agenda publica
function obtEventoAPPorId($callback, $idEvento)
{
  include "../common/config.php";
  $dirname = dirname(__DIR__);
  $eventoApObj = new eventosApObj();

  $datosEvento = $eventoApObj->ObtEventoApPorId($idEvento);
  if ($datosEvento->idEvento > 0) {
    if ($datosEvento->urlImg != "" && file_exists("../upload/eventos/" . $datosEvento->urlImg)) {
      $datosEvento->urlImg = "upload/eventos/" . $datosEvento->urlImg;
    } else {
      $datosEvento->urlImg = "upload/eventos/default.png";
    }
    //Formato de fecha
    $datosEvento->{"fechaEvento"} = convertirAFechaCompleta2($datosEvento->fechaInicio);
    //Formato de fecha fin
    if ($datosEvento->fechaFin != "") {
      $datosEvento->{"fechaEventoFin"} = convertirAFechaCompleta2($datosEvento->fechaFin);
    } else {
      $datosEvento->{"fechaEventoFin"} = "";
    }

    $arr = array("success" => true, "datosEvento" => $datosEvento);
  } else {
    $arr = array("success" => false);
  }

  echo $callback . '(' . json_encode($arr) . ');';
  // echo "<pre>";
  // print_r($datosEvento);
  // echo "</pre>";
}

// Obtener categorias de la agenda publica
function obtCategoriasAP($callback, $opc = "")
{
  $catCatAPObj = new catCategoriaApObj();
  $colCatAgendaP = $catCatAPObj->ObtCategoriasAp(1);

  if (count($colCatAgendaP) > 0) {
    $arr = array("success" => true, "colCatAgendaP" => $colCatAgendaP);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}


// Obtener categorias de la agenda publica
function pushMultaServicio($callback, $idUsuario, $tipo)
{
  $mensajesObj = new mensajesObj();
  $regDispObj = new registroDispositivo();

  //checar que exista el usuario
  if ($idUsuario != "" && $idUsuario > 0) {
    //consultar el id del dispositivo
    $regDispObj->usuarioId = $idUsuario;
    $colRegDisp = $regDispObj->obtTodosRegDispositivoPorIdUsr();
    $regid = "";
    if (count($colRegDisp) > 0) {
      foreach ($colRegDisp as $elemRegDisp) {
        $regid = $elemRegDisp->idRegDispositivo;
      }
    }

    $titulo = ($tipo == "servicio") ? "Pago de servicio" : "Pago de multa";
    $contenido = "Tu pago se ha realizado correctamente";

    //Setar datos
    $mensajesObj->usuarioId = $idUsuario;
    $mensajesObj->leido = 0;
    $mensajesObj->mostrar = 1;
    $mensajesObj->titulo = $titulo;
    $mensajesObj->contenido = $contenido;
    $mensajesObj->idUsuarioCmb = 1;
    $mensajesObj->GuardarMensajesObj(); //Salvar mensaje en db

    //Comprobar si se salvo para despues enviar el mensaje push
    $mensajePush = "";
    if ($mensajesObj->idMensaje > 0) {
      if ($regid != "") {
        $resPush = gcmSendPrueba($regid, $titulo);
        // echo $resPush;
        $objPush = json_decode($resPush);
        if ($objPush->success == 1) {
          $mensajePush = "El mensaje push se envio al dispositivo.";
        } else {
          $mensajePush = "El mensaje push no fue posible enviarlo.";
        }
      } else {
        $mensajePush = "El usuario no cuenta con un registro de dispositivo.";
      }
    } else {
      $mensajePush = "El mensaje no fue salvado.";
    }

    $arr = array("success" => true, "idUsuario" => $idUsuario, "tipo" => $tipo, "mensajePush" => $mensajePush);
    exit();
  } else {
    $arr = array("success" => false);
  }


  // if(count($colCatAgendaP)>0){
  //     $arr = array("success"=>true, "colCatAgendaP"=>$colCatAgendaP);
  // }else{
  //     $arr = array("success"=>false);
  // }

  echo $callback . '(' . json_encode($arr) . ');';
}


//Metodo que envia notificaciones push al dispositivo "Para android"
function gcmSendPrueba($regid, $message)
{
  $apiKey = 'AIzaSyBSh7RqTjkttVm_TPvPlY0XGC_fE9s9agY';
  //api key admin-secon-beta https://console.developers.google.com/iam-admin/iam/project?project=admin-secon-beta
  $gcmUrl = 'https://android.googleapis.com/gcm/send';

  // Send message:
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $gcmUrl);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt(
    $ch,
    CURLOPT_HTTPHEADER,
    array(
      'Authorization: key=' . $apiKey,
      'Content-Type: application/json'
    )
  );
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode(
    array(
      'registration_ids' => array($regid),
      'data' => array(
        'message' => $message
      )
    ),
    JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP
  ));

  $result = curl_exec($ch);
  //if ($result === false) {
  //    throw new \Exception(curl_error($ch));
  //}
  curl_close($ch);

  return $result;
}

// Metodo para levantar la peticion del usuario 
function solicitudPeticion($callback, $idUsuario, $latitud, $longitud, $idTipoPeticion, $idPeticionActual, $tipoBotonPresionado)
{
  // llamadas a los obj
  $peticionesObj = new peticionesObj();
  $datosUsuarioObj = new datosUsuarioObj();
  $registroDispositivo = new registroDispositivo();
  $peticionCoordenadasObj = new peticionCoordenadasObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $vehiculosObj = new vehiculosObj();
  $coordenadasVehiculoObj = new coordenadasVehiculoObj();
  $usuariosObj = new usuariosObj();
  $catCuentasObj = new catCuentasObj();
  $shelly = new shellyB();
  $histoUbicacionObj = new histoUbicacionObj();

  // validaciones 
  if (!empty($idUsuario) && !empty($tipoBotonPresionado)) {
    // preguntamos si el usuario esta validado
    //$valido = $usuariosObj->ValidacionUser($idUsuario); no imprementador por no autolizacion 

  $registroDispositivo->usuarioId = $idUsuario;
  $registroUsuario = $registroDispositivo->obtTodosRegDispositivoPorIdUsr();
  $peticionActiva = $peticionesObj->ObtPeticionesUserBYEstatus2($idUsuario, "1,2,5");
  $peticionCerrada = $peticionesObj->ObtPeticionesUserBYCerradoApp($idUsuario, "0");

  if ($idPeticionActual == 0 && $peticionActiva->idPeticion == 0 && $peticionCerrada->idPeticion == 0) {
    liberarOcupadas();
    $opcComite = (isset($_GET["opcComite"])) ? $_GET["opcComite"] : 0;
    $dtsUsuario = $datosUsuarioObj->obtDatosUsuarioPorUsuarioId($idUsuario);
    $peticionesObj->tipoPeticionId = $idTipoPeticion;
    $peticionesObj->usuarioId = $idUsuario;
    $peticionesObj->registroId = 0; //$registroUsuario[0]->idReg;
    $peticionesObj->coordenadasInicio = $latitud . ", " . $longitud;
    $peticionesObj->usuarioOperadorId = 0; // se optiene el operador disponible del algoritmo
    $peticionesObj->estatusId = 1;
    $peticionesObj->activo = 1;
    $peticionesObj->opcComite = $opcComite; //Opcion para saber si se prende la alarma del comite o no
    $peticionesObj->comiteUsuario = (($dtsUsuario->idComite == NULL) ? 0 : $dtsUsuario->idComite);
    $peticionesObj->GuardarPeticion();

    $histoUbicacionObj->peticionId = $peticionesObj->idPeticion;
    $histoUbicacionObj->usuarioId = $idUsuario;
    $histoUbicacionObj->latitud = $latitud;
    $histoUbicacionObj->longitud = $longitud;
    
    $histoUbicacionObj->GuardarUbicacion();
    

    $catConfiguracionesObj = new catConfiguracionesObj();
    // consultamos el id de la alarma centro de mando 
    $confAlarma = $catConfiguracionesObj->ObtConfiguracionByID(5);
    // obtenemos todos los datos de la alarma CM
    $centroMando = $vehiculosObj->VehiculosPorId($confAlarma->valor);
    // TRAEMOS TAMBIEN LA CUENTA QUE PERTENECE LA  ALARMA CM
    $cuenta = $catCuentasObj->CuentaPorNombre($centroMando->cuenta);

    // VERIFICAMO QUE TIPO DE ALARMA ES
    if ($cuenta->tipo == "tplink") {
      //Prendemos la alarma CM
      $resultAlarma = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
      //Acrualizamos la alarma CM
      $peticionesObj->ActualizarCampoPeticion("primerEncendidoCM", $resultAlarma["error_code"], $peticionesObj->idPeticion);
      //2 se inserta en la tabla de coordenadas
      if ($peticionesObj->idPeticion > 0) { // verifica si se inserto la peticion
        $peticionCoordenadasObj->latitud = $latitud;
        $peticionCoordenadasObj->longitud = $longitud;
        $peticionCoordenadasObj->peticionId = $peticionesObj->idPeticion;
        $peticionCoordenadasObj->registroId = 0; //$registroUsuario[0]->idReg;
        $peticionCoordenadasObj->usuarioId = $idUsuario;
        $peticionCoordenadasObj->GuardarPeticionCoordenadas();
        // Guardamnos las cordenadas de la peticion.
        if ($peticionCoordenadasObj->idCoordenadasPet > 0) {
          // creamos el msj para que el usurio pueda ver en pantalla que si peticion esta en proceso que la revisen
          $arr = array(
            "success" => true,
            "unidad" => false,
            "idPeticion" => $peticionesObj->idPeticion,
            "msj" => "Espere mientras su petici&oacute;n es atendida por un operador",
            "estatus" => "enviada",
            "estatusFin" => 1,
            "opc" => "nueva peticion creada"
          );
          // actualizamos eñ tipo de boton que detono la petecion
          $peticionesObj->ActualizarCampoPeticion("tipoBoton", $tipoBotonPresionado, $peticionesObj->idPeticion);
          // aqui vamos a asignar la alarma y la patrulla
          verPeticionApp($peticionesObj->idPeticion);

          //Realizamos proceso de verificacion de codigo de error
          if ($resultAlarma["error_code"] !== 0 && $resultAlarma["error_code"] != "0") {
            $tplink = new TpLinkFramelova();
            //Verificamos que error ocurrio
            if ($resultAlarma["error_code"] == -20571) { //Alarma offline (deviceId correcto y token correcto) verificamos el servidor
              //Realizamos proceso para validar servidor y volver a consultar con el servidor correcto
              $responseServer = $tplink->verifyServer($cuenta->token, $centroMando->alarmaId, $centroMando->server);
              if ($responseServer['equals'] == false) { //El servidor obtenido no coincide con el de base de datos y lo actualizamos
                //Actualizamos en base de datos
                $resupd = $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("server", $responseServer["serverFound"], $centroMando->alarmaId);
                //Validamos actualizacion
                if ($resupd > 0) { //El servidor se actualizo
                  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
                  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
                  $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("fechaActualizacion", $dateTime, $centroMando->alarmaId);
                  //Volvemos a realizar el encendido para ver si se corrigio el problema
                  $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                  $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                  /*if($responseStatus["error_code"] == -20571){
                      //$enLinea=false;
                    }else if($responseStatus["error_code"] == 0){
                      //$enLinea=true;
                    }*/
                } else { //Ocurrio algun tipo de error
                  //Realizamos una segunda prueba de encendido
                  $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                  $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                }
              } else { //El servidor si coincide
                //Volvemos a encender alarma y guardamos el codigo de error del segundo
                $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
              }
            } else if ($resultAlarma["error_code"] == -20651) { //Token expired (validar token, servidor, estatus y devceId)
              //Realizamos proceso de revision de token y actualizacion
              $responseToken = $tplink->returnToken($cuenta->usario, $cuenta->password);
              // Validamos que el token este direfente a la de base de  datos 
              if ($cuenta->token != $responseToken["result"]['token']) { //Actualizamos en base de datos
                $updCuenta = $catCuentasObj->ActualizarCampoCuenta("token", $responseToken["result"]['token'], $cuenta->idCuenta);
                if ($updCuenta > 0) { // actualizamos el token de la cuenta
                  //$token="updated";
                  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
                  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
                  $histToken = array("cuenta" => $cuenta, "tokenAnt" => $cuenta->token, "tokenNuevo" => $responseToken["result"]['token'], "fecha" => $dateTime);
                  $historicosObj = new historicosObj();
                  $historicosObj->jsonUserTurn = json_encode($histToken);
                  $historicosObj->tipoHist = 4;
                  $historicosObj->GuardarHistoricos();
                  //Validamos server
                  $responseServer = $tplink->verifyServer($responseToken["result"]['token'], $centroMando->alarmaId, $centroMando->server);
                  if ($responseServer['equals'] == false) { //El servidor obtenido no coincide con el de base de datos y lo actualizamos
                    //Actualizamos en base de datos
                    $resupd = $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("server", $responseServer["serverFound"], $centroMando->alarmaId);
                    //Validamos actualizacion
                    if ($resupd > 0) { //El servidor se actualizo
                      //$serv="updated";
                      $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
                      $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
                      $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("fechaActualizacion", $dateTime, $centroMando->alarmaId);
                      //Volvemos a realizar el encendido para ver si se corrigio el problema
                      $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                      $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                    } else { //Ocurrio algun tipo de error
                      $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                      $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                    }
                  } else { //El servidor si coincide
                    //Volvemos a realizar el encendido para ver si se corrigio el problema
                    $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                    $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                  }
                } else { // ocurrio un error en actualizar cuenta en BD
                  //Volvemos a realizar el encendido para ver si se corrigio el problema
                  $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                  $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                }
              } else { //El token de la BD y el de la Api son iguales asi que no se actualiza

                // validamos que el servidor es el correcto
                $responseServer = $tplink->verifyServer($responseToken["result"]['token'], $centroMando->alarmaId, $centroMando->server);
                if ($responseServer['equals'] == false) { //El servidor obtenido no coincide con el de base de datos y lo actualizamos
                  //Actualizamos en base de datos
                  $resupd = $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("server", $responseServer["serverFound"], $centroMando->alarmaId);
                  //Validamos actualizacion
                  if ($resupd > 0) { //El servidor se actualizo
                    $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
                    $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
                    $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("fechaActualizacion", $dateTime, $centroMando->alarmaId);
                    //Volvemos a realizar el encendido para ver si se corrigio el problema
                    $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                    $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                  } else { //Ocurrio algun tipo de error
                    //Volvemos a realizar el encendido para ver si se corrigio el problema
                    $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                    $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                  }
                } else { //El servidor si coincide
                  //Volvemos a realizar el encendido para ver si se corrigio el problema
                  $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
                  $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
                }
              }
            } else if ($resultAlarma["error_code"] == -20580) { // DeviceId no reconocido ()
              //$deviceId="unknow";
              //Termina el proceso hasta que cambien la configuracion
              //Volvemos a realizar el encendido para ver si se corrigio el problema
              $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
              $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
            } else if ($resultAlarma["error_code"] == -20002) { //Timeout
              //$mensajeEnLinea="timeout";
              $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
              $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
            } else { //Termina el proceso ya que sucedio algun error desconocido
              //$mensajeEnLinea="unknow";
              $segundoEncedido = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
              $peticionesObj->ActualizarCampoPeticion("segundoEncendidoCM", $segundoEncedido["error_code"], $peticionesObj->idPeticion);
            }
          }
        } else {
          $arr = array(
            "success" => false,
            "unidad" => false,
            "idPeticion" => $peticionesObj->idPeticion,
            "estatusFin" => 0,
            "opc" => "no se creo nueva peticion",
            "resultAlarma" => $resultAlarma
          );
        }
      }  // fin $peticionesObj->idPeticion > 0

    } elseif (strstr($cuenta->tipo, "shelly") !== false) {
      // Se prende la alarma CM 
      $resultAlarma = encenderAlarma($confAlarma->valor, 1, 1, $idUsuario);
      // estado de la api de shelly depende el id de la alarma CM
      $estadoapi = $shelly->respuesta_de_api($cuenta->token, $centroMando->alarmaId, $cuenta->servidor);
      $estadoshelly = $shelly->LineaShelly($cuenta->token, $centroMando->alarmaId, $cuenta->servidor, $cuenta->tipo);

      if ($estadoapi[0] == 200) {
        if ($estadoshelly[0] == true) { // alarma en linea
          if ($estadoshelly[1] == true) { //alarma prendida correctamente
            $peticionesObj->ActualizarCampoPeticion(
              "primerEncendidoCM",
              0,
              $peticionesObj->idPeticion
            );
          }
        } elseif ($estadoshelly[0] == false) { // estdo fuea de liena por internet o luz
          $peticionesObj->ActualizarCampoPeticion(
            "primerEncendidoCM",
            -20571,
            $peticionesObj->idPeticion
          );
        }
      }

      if ($peticionesObj->idPeticion > 0) {
        $peticionCoordenadasObj->latitud = $latitud;
        $peticionCoordenadasObj->longitud = $longitud;
        $peticionCoordenadasObj->peticionId = $peticionesObj->idPeticion;
        $peticionCoordenadasObj->usuarioId = $idUsuario;
        $peticionCoordenadasObj->GuardarPeticionCoordenadas();

        if ($peticionCoordenadasObj->idCoordenadasPet > 0) {
          $arr = array(
            "success" => true,
            "unidad" => false,
            "idPeticion" => $peticionesObj->idPeticion,
            "msj" => "Espere mientras su petici&oacute;n es atendida por un operador",
            "estatus" => "enviada",
            "estatusFin" => 1,
            "opc" => "nueva peticion creada"
          );

          // Actualiza peticion de pende el boton 
          $peticionesObj->ActualizarCampoPeticion("tipoBoton", $tipoBotonPresionado, $peticionesObj->idPeticion);
          // asignamos alarmas y patrulleros 
          verPeticionApp($peticionesObj->idPeticion);
          // revisamos que ocurrio con la alarma CM
          $estadoAlarmaCM = $peticionesObj->PeticionesPorId($peticionesObj->idPeticion);
          if ($estadoAlarmaCM->primerEncendidoCM != 0 || $estadoAlarmaCM->primerEncendidoCM != "0") { // si hubo un error se veremos por que con AlarmaCM
            if ($estadoapi[0] == 400) { // indentificador mal en base de datos 
              $peticionesObj->ActualizarCampoPeticion(
                "primerEncendidoCM",
                -20580,
                $peticionesObj->idPeticion
              );
            } elseif ($estadoapi[0] == 401) { // token no válido: en base de datos
              $peticionesObj->ActualizarCampoPeticion(
                "primerEncendidoCM",
                -20651,
                $peticionesObj->idPeticion
              );
            } else { // en espera mucho tiempo ver a detalle 
              $peticionesObj->ActualizarCampoPeticion(
                "primerEncendidoCM",
                -20002,
                $peticionesObj->idPeticion
              );
            }
          }
        } else {
          $arr = array(
            "success" => false,
            "unidad" => false,
            "idPeticion" => $peticionesObj->idPeticion,
            "estatusFin" => 0,
            "opc" => "no se creo nueva peticion",
            "resultAlarma" => $resultAlarma
          );
        }
      } // fin $peticionesObj->idPeticion > 0


    }
  } elseif ($idPeticionActual > 0) {

    $dataPeticion = $peticionesObj->PeticionesPorId($idPeticionActual);


    $valorPermisos = !empty($_GET['permisosApp']) ? $_GET['permisosApp'] : '{}';

    $peticionesObj->ActualizarCampoPeticion("permissionsApp", $valorPermisos, $dataPeticion->idPeticion);


    // if (isset($_GET['permisosApp'])) {
    //   $peticionesObj->ActualizarCampoPeticion("permissionsApp", $_GET['permisosApp'], $dataPeticion->idPeticion);
    // }

    if ($dataPeticion->estatusId == 3) {

      if ($dataPeticion->usuarioTurnoVehiculoId == null || $dataPeticion->usuarioTurnoVehiculoId == 0) {
        $arr = array("success" => true, "unidad" => false, "estatusFin" => $dataPeticion->estatusId, "idPeticion" => $dataPeticion->idPeticion);
      } else {
        // datos de la patrula en tablas correspondiente
        $DataUsuarioTurno = $usuariosTurnoObj->UsuariosTurnoPorId($dataPeticion->usuarioTurnoVehiculoId);
        $dataVehiculo = $vehiculosObj->VehiculosPorId($DataUsuarioTurno->vehiculoId);
        $dataCoordenadasVehiculo = $coordenadasVehiculoObj->CoordenadasVehiculoPorIdVehiculo($dataVehiculo->idVehiculo);
        $arr = array(
          "success" => true,
          "unidad" => true,
          "numunidad" => $dataVehiculo->unidad,
          "matricula" => $dataVehiculo->matricula,
          "latitud" => $dataCoordenadasVehiculo->latitud,
          "longitud" => $dataCoordenadasVehiculo->longitud,
          "estatusFin" => $dataPeticion->estatusId,
          "idPeticion" => $dataPeticion->idPeticion
        );
      }
    } else {

      $peticionCoordenadasObj->ActualizarCampoPeticionCoordendasBYPet("latitud", $latitud, $dataPeticion->idPeticion);
      $peticionCoordenadasObj->ActualizarCampoPeticionCoordendasBYPet("longitud", $longitud, $dataPeticion->idPeticion);

      $histoUbicacionObj->peticionId = $idPeticionActual;
      $histoUbicacionObj->usuarioId = $idUsuario;
      $histoUbicacionObj->latitud = $latitud;
      $histoUbicacionObj->longitud = $longitud;
      
      $histoUbicacionObj->GuardarUbicacion();
    

      if ($dataPeticion->usuarioTurnoId == 0 && $dataPeticion->estatusId == 1) {

        $arr = array(
          "success" => true,
          "unidad" => false,
          "idPeticion" => $dataPeticion->idPeticion,
          "estatusFin" => $dataPeticion->estatusId,
          "opc" => "no se creo peticion, existia sin asignar"
        );
      } else {
        // se obtienen todos los datos de la patrulla y del usuario en turno
        $dataUser = $usuariosTurnoObj->UsuariosTurnoPorId($dataPeticion->usuarioTurnoVehiculoId);
        $dataVehiculo = $vehiculosObj->VehiculosPorId($dataUser->vehiculoId); //se obtienen los datos del vehiculo
        //Se obtienen las coordenadas
        $dataCoordenadasVehiculo = $coordenadasVehiculoObj->CoordenadasVehiculoPorIdVehiculo($dataVehiculo->idVehiculo);
        if ($dataCoordenadasVehiculo->vehiculoId > 0) {
          $arr = array(
            "success" => true,
            "unidad" => true,
            "numunidad" => $dataVehiculo->unidad,
            "matricula" => $dataVehiculo->matricula,
            "latitud" => $dataCoordenadasVehiculo->latitud,
            "longitud" => $dataCoordenadasVehiculo->longitud,
            "estatusFin" => $dataPeticion->estatusId,
            "idPeticion" => $dataPeticion->idPeticion
          );
        } else {
          $arr = array(
            "success" => true,
            "unidad" => false,
            "idPeticion" => $dataPeticion->idPeticion,
            "estatusFin" => $dataPeticion->estatusId
          );
        }
      }

      if ($dataPeticion->estatusId == 5 || $dataPeticion->estatusId == 2) {
        $arr = array_merge($arr, array("msj" => "Su solicitud esta siendo atendida", "estatus" => "leida"));
      }
      if ($dataPeticion->estatusId == 1) {
        $arr = array_merge($arr, array("msj" => "Espere mientras su petici&oacute;n es atendida por un operador", "estatus" => "enviada"));
      }
    }
  } elseif ($peticionCerrada->idPeticion > 0) {
    $res = $peticionesObj->ActualizarCampoPeticion("cerradoEnApp", 1, $peticionCerrada->idPeticion);
    $arr = array("success" => true, "unidades" => false, "estatusFin" => $peticionCerrada->estatusId, "idPeticion" => $peticionCerrada->idPeticion);
  }
  }else{
  }

  echo $callback . '(' . json_encode($arr) . ');';
}


//Obtener el aviso de privaciadad
function actualizaCampoPeticion($callback)
{
  $peticionesObj = new peticionesObj();
  $res = $peticionesObj->ActualizarCampoPeticion($_GET["campo"], $_GET["valor"], $_GET["idPeticion"]);

  $arr = array("success" => true, "res" => $res);

  echo $callback . '(' . json_encode($arr) . ');';
}


function encenderAlarma($idVehiculo, $accion, $historico, $idUsuario)
{
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $vehiculo = $vehiculosObj->VehiculosPorId($idVehiculo);


  //$accion = (isset($_GET["accion"])) ? $_GET["accion"] : "";

  $estatusUpd = ($accion == 0 || $accion == "0") ? 1 : 2;

  $accionFinal = ($accion == 1) ? true : false;

  $vehiculosObj->ActualizarCampoVehiculos("estatusAlarma", $estatusUpd, $idVehiculo);

  // 30/03/2020 JAIR Guardar en historico la accion si asi se requiere

  if ($historico == 1) {
    $historicosObj = new historicosObj();
    $accionH = ($accion == 1) ? "encendido_manual" : "apagado_manual";

    $arrJson = array("accion" => $accionH, "tabla" => "alarmas", "idUsuario" => $idUsuario, "idAlarma" => $idVehiculo);
    $historicosObj->jsonUserTurn = json_encode($arrJson);
    $historicosObj->tipoHist = 1;
    $historicosObj->GuardarHistoricos();
  }


  $cuenta = $catCuentasObj->CuentaPorNombre($vehiculo->cuenta);
  //bear
  if ($cuenta->tipo == "tplink") {
    $alarmaId = $vehiculo->alarmaId;
    $useUrl = $vehiculo->server;
    $token = $cuenta->token;
    //require 'tplink.class.php';

    $tplink = new TpLinkFramelova();
    $res = $tplink->plugSwitch($useUrl, $token, array(    // bool, default false
      "deviceId" => $alarmaId, // deviceId, default none
      "useUrl" => $useUrl      // optional specify appServerUrl (Previously provided)
    ), $accionFinal);
  } elseif (strstr($cuenta->tipo, "shelly") !== false) {

    $alarmaId = $vehiculo->alarmaId;
    $token = $cuenta->token;
    $shellyserver = $cuenta->servidor;
    $shelly = new shellyB();
    $res = $shelly->SwithPlug($token, $alarmaId, $accionFinal, $shellyserver);
  }

  $return_arr = array("res" => $res);

  return $res;
}

function peticionAsignada()
{
  $peticionesObj = new peticionesObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionCoordenadasObj = new peticionCoordenadasObj();
  $historicoAsignadosObj = new historicoAsignadosObj();
  // $usuariosObj = new usuariosObj();
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']);
  $peticion = $peticionesObj->PeticionesPorIdUsuarioEst2($dataTurno->idUserTurno, 2);
  $coordenadasPet = $peticionCoordenadasObj->PeticionCoordenadasPorIdPeticion($peticion->idPeticion);
  $userData = $peticionesObj->PeticionesPorId($peticion->idPeticion);
  $dataAsignado = $historicoAsignadosObj->obtDatosAsignadoById($_GET['idAsignacion']);
  // $userData=$usuariosObj->UserByID($peticion->usuarioId);
  if ($peticion->idPeticion == 0) {
    $arr = array(
      "success" => false,
      "dataturno" => $dataTurno,
      "peticion" => $peticion,
      "coordenadas" => $coordenadasPet,
      "userdata" => $userData,
      "idUsuario" => $_GET['idUsuario'],
      "asignado" => $dataAsignado
    );
  } else {
    $arr = array("success" => true, "resultado" => true, "peticion" => $peticion, "peticionCoor" => $coordenadasPet, "userData" => $userData, "asignado" => $dataAsignado);
  }
  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}

//historial asignados 02/08/22 - MSA
function datosAsignadoPeticion()
{
  $historicoAsignadosObj = new historicoAsignadosObj();

  $resultDataAsignado = $historicoAsignadosObj->historicoAsignacionesPorIdPeticion($_GET['idPeticion']);

  $arr = array("success" => true, "datosAsignado" => $resultDataAsignado);
  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}

function horaNotificacion()
{
  $historicoAsignadosObj = new historicoAsignadosObj();

  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("idInicioSesion", $_GET['idInicioSesion'], $_GET['idAsignacion']);
  $horaNotificacion = $historicoAsignadosObj->ActualizarHoraRespuestaAsignaciones("fechaHoraNotificacion", $_GET['idAsignacion']);

  $arr = array("success" => true, "horaNotificacion" => $horaNotificacion);
  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}

function actualizaCampoHistoricoAsignaciones($callback)
{
  $historicoAsignadosObj = new historicoAsignadosObj();

  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones($_GET["campo"], $_GET["valor"], $_GET["idAsignacion"]);
  if ($_GET["campo"] == 'comentarioVehiculo') {
    $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
    $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("fechaHoraReporteFinal", $dateTime, $_GET["idAsignacion"]);
  }
  $arr = array("success" => true);

  echo $callback . '(' . json_encode($arr) . ');';
}

function respuestaNotificacionAsignado()
{
  $historicoAsignadosObj = new historicoAsignadosObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionesObj = new peticionesObj();
  $vehiculosObj = new vehiculosObj();


  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("asignacionAceptada", $_GET['asignacionAceptada'], $_GET['idAsignacion']);
  $historicoAsignadosObj->ActualizarHoraRespuestaAsignaciones("fechaHoraAceptacionNegacion", $_GET['idAsignacion']);
  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("coordenadasRespuestaNotificacion", $_GET['coordenadasPatrulla'], $_GET['idAsignacion']);

  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']);
  $peticion = $peticionesObj->PeticionesPorIdUsuarioEst($dataTurno->idUserTurno, 2); //   se optienen los datos de la peticion

  if ($_GET['asignacionAceptada'] == 1 || $_GET['asignacionAceptada'] == '1') {
    $peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", $dataTurno->idUserTurno, $_GET['idPeticion']);
  }
  if ($_GET['asignacionAceptada'] == 0 || $_GET['asignacionAceptada'] == '0') {
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("tiempoRecorrido", "00:00:00", $_GET['idAsignacion']);
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("distanciaRecorrida", "Sin distancia recorrida", $_GET['idAsignacion']);
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("estatusVehiculo50m", "Solicitud rechazada", $_GET['idAsignacion']);
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("fechaHoraRespuestaVehiculo50m", "0000-00-00 00:00:00", $_GET['idAsignacion']);
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("motivoDesasignacion", 4, $_GET['idAsignacion']);
    $historicoAsignadosObj->ActualizarHoraRespuestaAsignaciones("fechaHoraDesasignacion", $_GET['idAsignacion']);
    $dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusAlarma", 1, $dataTurno->vehiculoId);
    $peticionesObj->ActualizarCampoPeticion("estatusId", 1, $peticion->idPeticion); // se actualiza el estatus de de la peticion en 1
    $peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", 0, $peticion->idPeticion); // se actualiza el id de usuario en turno
    // metodo para asignar 
    buscarPatrulleromasCercano($_GET['idAsignacion'], $_GET['idPeticion']);
  }

  $dataTurno01 = $historicoAsignadosObj->obtDatosAsignadoById($_GET['idAsignacion']);
  $diferencia01 = obtenerDiferenciaPorFechaHoy($dataTurno01->fechaHoraNotificacion, $dataTurno01->fechaHoraAceptacionNegacion, "%H:%i:%s");
  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("tiempoRespuestaNotificacion", $diferencia01, $_GET['idAsignacion']);
}

function estatusPatrulla50m()
{
  $historicoAsignadosObj = new historicoAsignadosObj();

  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("estatusVehiculo50m", $_GET['estatus'], $_GET['idAsignacion']);
  $resAsi = $historicoAsignadosObj->ActualizarHoraRespuestaAsignaciones("fechaHoraRespuestaVehiculo50m", $_GET['idAsignacion']);

  $callback = $_GET['callback'];
  if ($resAsi == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true, "resultado" => true);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function estatusPatrulla50mAutomatico()
{
  $historicoAsignadosObj = new historicoAsignadosObj();

  $resAsi = $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("fechaHoraAutomaticoVehiculo50m", $_GET['datetime'], $_GET['idAsignacion']);

  $callback = $_GET['callback'];
  if ($resAsi == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function guardarMotivoFinAsignacion()
{
  $historicoAsignadosObj = new historicoAsignadosObj();

  $resAsi = $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("motivoCancelacionAsignacion", $_GET['motivo'], $_GET['idAsignacion']);

  $callback = $_GET['callback'];
  if ($resAsi == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function insertVehiculoEstacionado()
{
  $vehiculosEstacionadosObj = new vehiculosEstacionadosObj();
  $usuariosTurnoObj = new usuariosTurnoObj();

  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']);
  $tiempoEstacionado = obtenerDiferenciaPorFechaHoy($_GET['fechaHoraInicioEstacionamiento'], $_GET['fechaHoraFinEstacionamiento'], "%H:%i:%s");

  $vehiculosEstacionadosObj->fechaHoraInicioEstacionamiento = $_GET['fechaHoraInicioEstacionamiento'];
  $vehiculosEstacionadosObj->fechaHoraFinEstacionamiento = $_GET['fechaHoraFinEstacionamiento'];
  $vehiculosEstacionadosObj->coordenadasEstacionamiento = $_GET['coordenadasEstacionamiento'];
  $vehiculosEstacionadosObj->idUsuarioTurno = $dataTurno->idUserTurno;
  $vehiculosEstacionadosObj->idUsuario = $_GET['idUsuario'];
  $vehiculosEstacionadosObj->tiempoEstacionado = $tiempoEstacionado;
  $vehiculosEstacionadosObj->idInicioSesion = $_GET['idInicioSesion'];;
  $vehiculosEstacionadosObj->GuardarVehiculoEstacionado();

  $callback = $_GET['callback'];
  if ($dataTurno->idUserTurno == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function nuevoInicioDeSesion()
{
  $historialInicioSesionObj = new historialInicioSesionObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $vehiculosObj = new vehiculosObj();

  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']);
  $historialInicioSesionObj->fechaHoraInicioSesion = $_GET['fechaHoraInicioSesion'];
  $historialInicioSesionObj->idUsuarioTurno = $dataTurno->idUserTurno;
  $historialInicioSesionObj->idUsuario = $_GET['idUsuario'];
  $historialInicioSesionObj->vehiculoId = $_GET['idVehiculo'];
  $historialInicioSesionObj->GuardarHistorialInicioSesion();

  $vehiculosObj->ActualizarCampoVehiculos("estatusId", 1, $_GET['idVehiculo']);

  $return = $historialInicioSesionObj->obtIdInicioSesionPorHoraUsuario($_GET['fechaHoraInicioSesion'], $_GET['idUsuario']);

  $callback = $_GET['callback'];
  if ($return == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true, "NuevoInicio" => $return);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function finalizarSesionPatrulla()
{
  $historialInicioSesionObj = new historialInicioSesionObj();

  $datosLoggin = $historialInicioSesionObj->obtDatosUsrLogginPorIdInicio($_GET['idInicioSesion']);
  $tiempoLoggin = obtenerDiferenciaPorFechaHoy($datosLoggin->fechaHoraInicioSesion, $_GET['horaFin'], "%H:%i:%s");

  $historialInicioSesionObj->ActualizarCampoHistorialInicioSesion("usuarioCerrarSesion", $_GET['usuarioCerrarSesion'], $_GET['idInicioSesion']);
  $historialInicioSesionObj->ActualizarCampoHistorialInicioSesion("fechaHoraCierreSesion", $_GET['horaFin'], $_GET['idInicioSesion']);
  $return = $historialInicioSesionObj->ActualizarCampoHistorialInicioSesion("tiempoLoggeado", $tiempoLoggin, $_GET['idInicioSesion']);

  $callback = $_GET['callback'];
  if ($return == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function peticionFinalizada()
{
  $peticionesObj = new peticionesObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionCoordenadasObj = new peticionCoordenadasObj();
  $vehiculosObj = new vehiculosObj();
  $historicoAsignadosObj = new historicoAsignadosObj();
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']);
  $peticion = $peticionesObj->PeticionesPorIdUsuarioEst($dataTurno->idUserTurno, 2);
  $update = $peticionesObj->ActualizarCampoPeticion("estatusId", 3, $peticion->idPeticion);
  $dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 1, $dataTurno->vehiculoId);
  sleep(10);
  $peticionCoordenadasObj->DeletePeticionCoordenadasPorIdUsuario($peticion->usuarioId);
  $resDel = $peticionesObj->DeletePeticionesPorIdUser($peticion->usuarioId);

  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("motivoDesasignacion", 3, $_GET['idAsignacion']);
  $historicoAsignadosObj->ActualizarHoraRespuestaAsignaciones("fechaHoraDesasignacion", $_GET['idAsignacion']);

  $consultaParaTiempo = $historicoAsignadosObj->obtDatosAsignadoById($_GET['idAsignacion']);
  $diferencia = obtenerDiferenciaPorFechaHoy($consultaParaTiempo->fechaHoraAceptacionNegacion, $consultaParaTiempo->fechaHoraDesasignacion, "%H:%i:%s");
  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("tiempoRecorrido", $diferencia, $_GET['idAsignacion']);

  $callback = $_GET['callback'];
  if ($resDel == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function peticionCancelada()
{
  $peticionesObj = new peticionesObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionCoordenadasObj = new peticionCoordenadasObj();
  $vehiculosObj = new vehiculosObj();
  $historicoAsignadosObj = new historicoAsignadosObj();
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']); // se opcienen los datos del usuario en turno
  $peticion = $peticionesObj->PeticionesPorIdUsuarioEst($dataTurno->idUserTurno, 2); //   se optienen los datos de la peticion
  $update0 = $peticionesObj->ActualizarCampoPeticion("estatusId", 1, $peticion->idPeticion); // se actualiza el estatus de de la peticion en 1
  $update = $peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", 0, $peticion->idPeticion); // se actualiza el id de usuario en turno
  $dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 1, $dataTurno->vehiculoId);
  $vehiculosObj->ActualizarCampoVehiculos("estatusAlarma", 1, $dataTurno->vehiculoId);

  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("motivoDesasignacion", 3, $_GET['idAsignacion']);
  $historicoAsignadosObj->ActualizarHoraRespuestaAsignaciones("fechaHoraDesasignacion", $_GET['idAsignacion']);
  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("coordenadasDesasignacion", $_GET['coordenadasFin'], $_GET['idAsignacion']);

  $consultaParaTiempo = $historicoAsignadosObj->obtDatosAsignadoById($_GET['idAsignacion']);
  $diferencia = obtenerDiferenciaPorFechaHoy($consultaParaTiempo->fechaHoraAceptacionNegacion, $consultaParaTiempo->fechaHoraDesasignacion, "%H:%i:%s");
  $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("tiempoRecorrido", $diferencia, $_GET['idAsignacion']);

  if ($consultaParaTiempo->estatusVehiculo50m == null) {
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("estatusVehiculo50m", "Sin estatus", $_GET['idAsignacion']);
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("fechaHoraRespuestaVehiculo50m", "0000-00-00 00:00:00", $_GET['idAsignacion']);
  }

  if ($consultaParaTiempo->distanciaRecorrida == null) {
    $coordenadasAsignado1 = $historicoAsignadosObj->obtDatosAsignadoById($_GET['idAsignacion']);
    $coordenadas1 = $coordenadasAsignado1->coordenadasRespuestaNotificacion;
    $coordenadas2 = $coordenadasAsignado1->coordenadasDesasignacion;

    $split1 = explode(",", $coordenadas1);
    $split2 = explode(",", $coordenadas2);

    $km = getDistanceToCoords($split1[0], $split1[1], $split2[0], $split2[1]);
    $historicoAsignadosObj->ActualizarCampohistoricoAsignaciones("distanciaRecorrida", $km . " km", $_GET['idAsignacion']);
  }

  $vehiculoId = $dataTurno->vehiculoId;
  $rechazosPatrullaObj = new rechazosPatrullaObj();
  $rechazosPatrullaObj->idVehiculo = $dataTurno->vehiculoId;
  $rechazosPatrullaObj->idPeticion = $peticion->idPeticion;
  $rechazosPatrullaObj->motivo = "";
  $rechazosPatrullaObj->GuardarRechazosPatrulla();

  /*$vehiculosObj2 = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $vehiculo = $vehiculosObj2->VehiculosPorId($vehiculoId);

  $cuenta = $catCuentasObj->CuentaPorNombre($vehiculo->cuenta);
  $alarmaId = $vehiculo->alarmaId;
  $useUrl = $vehiculo->server;
  $token = $cuenta->token;

  include_once "tplink-framelova.php";

  $tplink = new TpLinkFramelova();
  $res = $tplink->plugSwitch($useUrl, $token, array(    // bool, default false
    "deviceId" => $alarmaId, // deviceId, default none
    "useUrl" => $useUrl      // optional specify appServerUrl (Previously provided)
  ), false);*/

  $callback = $_GET['callback'];
  if ($update->usuarioTurnoId == 0) {
    $arr = array("success" => true);
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//Obtener notificaciones por el id del usuario
function ObtNotificaciones($callback, $idPeticion, $opc = "")
{
  $msgObj = new mensajesObj();
  $colMensajes = $msgObj->GetallMensajesObj($idPeticion, "ASC");
  if (count($colMensajes) > 0) {
    $arr = array("success" => true, "colNotificaciones" => $colMensajes);
  } else {
    $arr = array("success" => false);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}

function ObtNotificacionesPatrulla($callback, $idUsuario, $opc = "")
{
  $msgObj = new mensajesObj();
  $colMensajes = $msgObj->ObtTodosMensajes("", "", $idUsuario, 1);
  if (count($colMensajes) > 0) {
    $arr = array("success" => true, "colNotificaciones" => $colMensajes);
  } else {
    $arr = array("success" => true, "colNotificaciones" => 0);
  }

  //si es 1 entonces regresar el arreglo de lo contrario  regresa en json
  if ($opc == 1) {
    return $arr;
  } else {
    echo $callback . '(' . json_encode($arr) . ');';
  }
}

function ObtReportesSinFinalizar($callback, $idUsuario)
{
  $historicoAsignadosObj = new historicoAsignadosObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($idUsuario);
  $colReportes = $historicoAsignadosObj->obtReportesSinFinalizar($dataTurno->idUserTurno);

  if (count($colReportes) > 0) {
    $arr = array("success" => true, "colReportes" => $colReportes);
  } else {
    $arr = array("success" => false);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

// Obtener categorias de la agenda publica
function salvarComentarioChat($callback, $idUsuario, $idRolUsuario, $idPeticion, $comentario)
{
  $mensajesObj = new mensajesObj();
  $mensaje = "El mensaje no fue salvado.";
  //checar que exista el usuario
  if ($idUsuario != "" && $idUsuario > 0) {
    if ($idRolUsuario == 3 || $idRolUsuario == 10) {
      $tipMsg = 3;
    } else if ($idRolUsuario == 4) {
      $tipMsg = 4;
    }

    $contenido = $comentario;
    $idReporte = $idPeticion;
    //Setar datos
    $mensajesObj->usuarioId = $idUsuario;
    $mensajesObj->leido = 0;
    $mensajesObj->mostrar = 1;
    $mensajesObj->titulo = "";
    $mensajesObj->contenido = $contenido;
    $mensajesObj->idReporte = $idReporte;
    $mensajesObj->idTipoMensaje = $tipMsg;
    $mensajesObj->GuardarMensajesObj(); //Salvar mensaje en db
    //Comprobar si se salvo para despues enviar el mensaje push
    $mensajePush = "";
    if ($mensajesObj->idMensaje > 0) {
      /*if($regid!=""){
        $resPush = gcmSendPrueba($regid, $titulo);
        // echo $resPush;
        $objPush = json_decode($resPush);
        if($objPush->success==1){
          $mensajePush = "El mensaje push se envio al dispositivo.";
        }else{
          $mensajePush = "El mensaje push no fue posible enviarlo.";
        }
      }else{
        $mensajePush = "El usuario no cuenta con un registro de dispositivo.";
      }*/
      $mensaje = "El mensaje fue salvado.";
      $arr = array("success" => true, "mensajeResp" => $mensaje);
    } else {
      $arr = array("success" => false, "mensajeResp" => $mensaje);
    }
  } else {
    $arr = array("success" => false, "mensajeResp" => $mensaje);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

//Guardar registros de las desconexiones de internet - MSA
function nuevaHoraDesconexion()
{
  $historialDesconexionInternetObj = new historialDesconexionInternetObj();
  $usuariosTurnoObj = new usuariosTurnoObj();

  $dataTurno0 = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUser']);

  $diferencia = obtenerDiferenciaPorFechaHoy($_GET['horaDesconexion'], $_GET['horaNuevaConexion'], "%H:%i:%s");

  $historialDesconexionInternetObj->fechaHoraDesconexion = $_GET['horaDesconexion'];
  $historialDesconexionInternetObj->fechaHoraNuevaConexion = $_GET['horaNuevaConexion'];
  $historialDesconexionInternetObj->tiempoDesconexion = $diferencia;
  $historialDesconexionInternetObj->idUsuarioTurno = $dataTurno0->idUserTurno;
  $historialDesconexionInternetObj->idPeticion = $_GET['idPeticion'];
  $historialDesconexionInternetObj->idAsignado = $_GET['idAsignado'];
  $historialDesconexionInternetObj->idInicioSesion = $_GET['idInicioSesion'];
  $historialDesconexionInternetObj->GuardarHistorialDesconexiones();

  // validacion 
  if ($historialDesconexionInternetObj->idDesconexion > 0) {
    gestionarPushMonitor($_GET['idUser'],1);
  }
  $arr = array("success" => true, "usrTurno" => $dataTurno0->idUserTurno);
  $callback = $_GET['callback'];

  echo $callback . '(' . json_encode($arr) . ');';
}

function registroPrimerSegundoPlano()
{
  $historialPrimerSegundoPlanoObj = new historialPrimerSegundoPlanoObj();
  $usuariosTurnoObj = new usuariosTurnoObj();

  $dataTurno0 = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUser']);
  $diferencia = obtenerDiferenciaPorFechaHoy($_GET['hora1Plano'], $_GET['hora2Plano'], "%H:%i:%s");

  $historialPrimerSegundoPlanoObj->fechaHora1plano = $_GET['hora1Plano'];
  $historialPrimerSegundoPlanoObj->fechaHora2plano = $_GET['hora2Plano'];
  $historialPrimerSegundoPlanoObj->tiempoActivo = $diferencia;
  $historialPrimerSegundoPlanoObj->idUsuarioTurno = $dataTurno0->idUserTurno;
  $historialPrimerSegundoPlanoObj->idPeticion = $_GET['idPeticion'];
  $historialPrimerSegundoPlanoObj->idAsignado = $_GET['idAsignado'];
  $historialPrimerSegundoPlanoObj->idInicioSesion = $_GET['idInicioSesion'];
  $historialPrimerSegundoPlanoObj->peticionesObtenidas = $_GET['arrayPeticiones'];
  $historialPrimerSegundoPlanoObj->asignacionesObtenidas = $_GET['arrayAsignaciones'];
  $planos = $historialPrimerSegundoPlanoObj->GuardarHistorialPrimerSegundoPlano();

  $arr = array("success" => true, "nuevaRegistoPlanos" => $planos);
  $callback = $_GET['callback'];

  echo $callback . '(' . json_encode($arr) . ');';
}

function registroSegundoPrimerPlano()
{
  $historialSegundoPrimerPlanoObj = new historialSegundoPrimerPlanoObj();
  $usuariosTurnoObj = new usuariosTurnoObj();

  $dataTurno0 = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUser']);
  $diferencia = obtenerDiferenciaPorFechaHoy($_GET['hora2Plano'], $_GET['hora1Plano'], "%H:%i:%s");

  $historialSegundoPrimerPlanoObj->fechaHora2plano = $_GET['hora2Plano'];
  $historialSegundoPrimerPlanoObj->fechaHora1plano = $_GET['hora1Plano'];
  $historialSegundoPrimerPlanoObj->tiempoInactivo = $diferencia;
  $historialSegundoPrimerPlanoObj->idUsuarioTurno = $dataTurno0->idUserTurno;
  $historialSegundoPrimerPlanoObj->idPeticion = $_GET['idPeticion'];
  $historialSegundoPrimerPlanoObj->idAsignado = $_GET['idAsignado'];
  $historialSegundoPrimerPlanoObj->idInicioSesion = $_GET['idInicioSesion'];
  $historialSegundoPrimerPlanoObj->peticionesObtenidas = $_GET['arrayPeticiones'];
  $historialSegundoPrimerPlanoObj->asignacionesObtenidas = $_GET['arrayAsignaciones'];
  $historialSegundoPrimerPlanoObj->GuardarHistorialSegundoPrimerPlano();

  $arr = array("success" => true);
  $callback = $_GET['callback'];

  echo $callback . '(' . json_encode($arr) . ');';
}

function updateCoordenadasPatrulla()
{
  $usuariosTurnoObj = new usuariosTurnoObj();
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorIdUser($_GET['idUsuario']);
  $coordenadasVehiculoObj = new coordenadasVehiculoObj();
  $coordenadasVehiculoObj->ActualizarCampoPeticionCoordendas("latitud", $_GET['latitud'], $dataTurno->vehiculoId);
  $dataCoord = $coordenadasVehiculoObj->ActualizarCampoPeticionCoordendas("longitud", $_GET['longitud'], $dataTurno->vehiculoId);
  if ($dataCoord > 0) {
    $arr = array("success" => true, "dataCoord" => $dataCoord, "longitud" => $_GET['longitud'], "latitud" => $_GET['latitud']);
  } else {
    $arr = array("success" => false, "dataCoord" => $dataCoord, "longitud" => $_GET['longitud'], "latitud" => $_GET['latitud']);
  }
  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}

function getPeticionActiva()
{
  $peticionesObj = new peticionesObj();
  // $dataPeticion= $peticionesObj->ObtPeticionesUserBYEstatus($_GET['idUser'],1);
  //JAIR 19/03/2020 Obtener por varios estatus
  $dataPeticion = $peticionesObj->ObtPeticionesUserBYEstatus2($_GET['idUser'], "1,2,5");

  //$fh = fopen("prueba-yayo2.txt", 'a');
  //fwrite($fh, "\n".$dataPeticion->idPeticion);
  //fclose($fh);
  if ($dataPeticion->idPeticion > 0) {
    $arr = array("success" => true, "idPeticion" => $dataPeticion->idPeticion);
  } else {
    $arr = array("success" => true, "idPeticion" => 0);
  }

  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}
function enviarMensajeAdjunto()
{
  $mensajesObj = new mensajesObj();
  $mensajesObj->usuarioId = $_GET["idUsuario"];
  $mensajesObj->leido = 0;
  $mensajesObj->mostrar = 1;
  $mensajesObj->titulo = $_GET['titulo'];
  $mensajesObj->contenido = $_GET["comentario"];
  $mensajesObj->idConcepto = 0;
  $mensajesObj->idReporte = $_GET["idPeticion"];
  $mensajesObj->idUsuarioCmb = 0;
  $mensajesObj->imagen = $_GET['imagen'];
  $mensajesObj->idTipoMensaje = $_GET["idTipoMensaje"];
  $mensajesObj->GuardarMensajesObj();
  $res = $mensajesObj->idMensaje;
  if ($res > 0) {
    $arr = array("success" => true, "res" => $res);
  } else {
    $arr = array("success" => true, "res" => $res);
  }
  $callback = $_GET['callback'];
  echo $callback . '(' . json_encode($arr) . ');';
}


// Imp. 25/10/19
// Obtener informacion de la unidad ruta
function obtInfoUnidadRuta()
{
  $callback = (isset($_GET['callback']) != "") ? $_GET['callback'] : "";
  $idUnidadRuta = (isset($_GET['idUnidadRuta']) != "") ? $_GET['idUnidadRuta'] : 0;
  $arr = array("success" => false);

  $catUnidadesRutasObj = new catUnidadesRutasObj();

  if ($idUnidadRuta > 0) {
    $datosUnidadRuta = $catUnidadesRutasObj->ObtUnidadRutaPorId($idUnidadRuta);
    $arr = array("success" => true, "datosUnidadRuta" => $datosUnidadRuta);
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function obtComites()
{
  $callback = (isset($_GET['callback']) != "") ? $_GET['callback'] : "";

  $catComiteObj = new catComiteObj();

  // $comites = $catComiteObj->GetAllComites(1);
  $comites = $catComiteObj->getComitesConAlarma();
  //natsort($comites);
  $arr = array("success" => true, "comites" => $comites);

  echo $callback . '(' . json_encode($arr) . ');';
}

function enviarPushACliente($idUsuario, $titulo, $mensajeCompleto, $tipo, $creador, $idRpt = 0)
{

  $msgObj = new mensajesObj();
  $regDispObj = new registroDispositivo();
  $resPush = "";
  if ($idUsuario > 0) {

    //>>>Logica para mandar un push al cliente<<<
    //obtener el id del dispositivo
    $regDispObj->usuarioId = $idUsuario;
    $colRegDisp = $regDispObj->obtTodosRegDispositivoPorIdUsr();
    //Si existe registro de dispositivo enviar push
    if (count($colRegDisp) > 0) {

      //Salvar el mensaje
      $msjTitulo = $titulo;
      $msjCompleto = $mensajeCompleto;
      $msgObj->usuarioId = $idUsuario;
      $msgObj->leido = 0;
      $msgObj->mostrar = 1;
      $msgObj->titulo = $msjTitulo;
      $msgObj->contenido = $msjCompleto;
      $msgObj->idConcepto = $tipo;
      $msgObj->idReporte = $idRpt;
      $msgObj->idUsuarioCmb = $creador;
      $msgObj->GuardarMensajesObj();
      //Recorrer cada registro de dispositivo
      foreach ($colRegDisp as $elemReg) {
        //Checar la plataforma
        //Envio a android
        if ($elemReg->plataforma == 0) {
          $resPush = $regDispObj->gcmSend($elemReg->idRegDispositivo, "" . $msjTitulo);
        }
        if ($elemReg->plataforma == 1) {
          $resPush = $regDispObj->gcmSend($elemReg->idRegDispositivo, $mensajeCompleto . $msjTitulo, 'ios');
        }

        return $resPush;
      }
    }
  }
}


//Con para cambiar de estatus las alarmas que se queden colgadas
function liberarOcupadas()
{

  $vehiculosObj = new vehiculosObj();
  $peticionesObj = new peticionesObj();
  $historicosObj = new historicosObj();

  $histAlmOcupadas = array();
  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual

  //Consultamos las alarmas ocupadas
  $alarmas = $vehiculosObj->ObtTodosVehiculos(4, 2, "");

  if (count($alarmas) > 0) {

    foreach ($alarmas as $alarma) {

      //Consultamos si alarma tiene alguna peticion activa
      $peticiones = $peticionesObj->ObtPeticionesActivasPorAlarma($alarma->idVehiculo, 2);

      if (count($peticiones) > 0 && $peticiones != null) { //Si tienes peticiones activa

        //No realizamos proceso de actulizacion
        //Guardamos historial
        /*foreach ($peticiones as $peticion) {

          $histAlarma = array(
            "idVehiculo"=>$alarma->idVehiculo,
            "matricula" => $alarma->matricula,
            "estatusIdAlarma"=>$alarma->estatusId,
            "idPeticion" => $peticion->idPeticion,
            "estatusIdPeticion" => $peticion->estatusId,
            "accion" => "*",
            "estadoFinalAlarma"=>$alarma->estatusId,
            "nota"=>"Sin accion"
          );

          array_push($histAlmOcupadas, $histAlarma);

        }*/
      } else { // No tiene peticiones activas

        //Liberamos alarma
        $responseUpd = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 1, $alarma->idVehiculo);

        if ($responseUpd > 0) { //Se actualizo correctamente

          //Guardamos historial
          $histAlarma = array(
            "idVehiculo" => $alarma->idVehiculo,
            "matricula" => $alarma->matricula,
            "estatusIdAlarma" => $alarma->estatusId,
            "idPeticion" => "*",
            "estatusIdPeticion" => "*",
            "accion" => "actualizar",
            "estadoFinalAlarma" => 1,
            "nota" => "Liberada"
          );

          array_push($histAlmOcupadas, $histAlarma);
        } else { // No se actualizo

          //Guardamos historial
          $histAlarma = array(
            "idVehiculo" => $alarma->idVehiculo,
            "matricula" => $alarma->matricula,
            "estatusIdAlarma" => $alarma->estatusId,
            "idPeticion" => "*",
            "estatusIdPeticion" => "*",
            "accion" => "actualizar",
            "estadoFinalAlarma" => $alarma->estatusId,
            "nota" => "No se pudo liberar alarma"
          );

          array_push($histAlmOcupadas, $histAlarma);
        }
      }
    }

    if (count($histAlmOcupadas) > 0 && $histAlmOcupadas != null) {
      $historicosObj->jsonUserTurn = json_encode($histAlmOcupadas);
      $historicosObj->tipoHist = 5;
      $historicosObj->fechaCreacion = $dateTime;
      $historicosObj->GuardarHistoricos();
    }
  }
}

function checkDoubleLogin($callback, $token, $idUsuario)
{
  $usuariosObj = new usuariosObj();
  $checkToken = $usuariosObj->checkDoublelogin($token, $idUsuario);
  

  if ($checkToken->mismoDispositivo == 1) {
    $res = array("success" => false, "message" => "entrando desde el mismo dispositivo");
  } else {
    $res = array("success" => true, "message" => "acceso negado porque se incio sesion en otro dispositivo");
  }

  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Max-Age: 1000');
  echo $callback . '(' . json_encode($res) . ');';
}

/* Revisar que el usuario no tenga una peticion activa en otro dispositivo */
function checkPeticionActiva($callback, $idUsuario)
{
  $usuariosObj = new usuariosObj();

  if ($usuariosObj->checkPeticionActiva($idUsuario)) {
    $res = array("success" => false, "message" => "no puede iniciar sesion, hay una peticion activa en otro dispositivo");
  } else {
    $res = array("success" => true, "message" => "puede iniciar sesion, no hay peticion activa");
  }

  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Max-Age: 1000');
  echo $callback . '(' . json_encode($res) . ');';
}

/* Validar el email y la contraseña del usuario */
function validateCredentials($callback, $email, $password)
{
  $usuariosObj = new usuariosObj();
  $data = $usuariosObj->validateCredentials($email, $password);

  if ($data->credencialesValidas == 1) {
    $res = array("success" => true, "message" => "email y password validos");
  } else {
    $res = array("success" => false, "message" => "email y password invalidos");
  }

  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Methods: POST');
  header('Access-Control-Max-Age: 1000');
  echo $callback . '(' . json_encode($res) . ');';
}

/* Revisar si el usuario ahora pertenece a otro comite*/
function revisarCambioComite($callback, $idUsuario, $idComite)
{
  $usuariosObj = new usuariosObj();
  $vehiculosObj = new vehiculosObj();

  $usuario = $usuariosObj->UserById($idUsuario);
  $comite = $usuariosObj->getComite($idUsuario);
  if (isset($comite->idComite) == false) {
    $res = array(
      "success" => false,
      "message" => "el usuario no tiene comité",
      "sinComite" => true,
      "userName" => $usuario->nombre,
      "emailUser" => $usuario->email
    );
  } else {
    $alarma = $vehiculosObj->VehiculosPorComite($comite->idComite);
    if ($idComite != $comite->idComite) {
      $res = array(
        "success" => true,
        "message" => "el comité del usuario cambió",
        "userName" => $usuario->nombre,
        "emailUser" => $usuario->email,
        "idComite" => $comite->idComite,
        "nombreComite" => $comite->nombre,
        "idAlarma" => $alarma->idVehiculo,
        "latitudAlarma" => $alarma->latitud,
        "longitudAlarma" => $alarma->longitud,
        "distanciaAlarma" => $alarma->distanciaAlarma,
      );
    } else {
      $res = array(
        "success" => false,
        "message" => "el comité del usuario no ha cambiado",
        "sinComite" => false,
        "userName" => $usuario->nombre,
        "emailUser" => $usuario->email,
        "idAlarma" => $alarma->idVehiculo,
        "latitudAlarma" => $alarma->latitud,
        "longitudAlarma" => $alarma->longitud,
        "distanciaAlarma" => $alarma->distanciaAlarma,
      );
    }
  }

  echo $callback . '(' . json_encode($res) . ');';
}

/* Realizar un segundo encendido para la alarma de la calle */
function verifyTokenAndServer($idVehiculo)
{
  $tplink = new TpLinkFramelova();
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $historicosObj = new historicosObj();
  $peticionesObj = new peticionesObj();

  // Realizamos el proceso de revision de token y actualizacion
  $almCalle = $vehiculosObj->VehiculosPorId($idVehiculo);
  $cuentaAlmCalle = $catCuentasObj->CuentaPorNombre($almCalle->cuenta);
  if ($cuentaAlmCalle->tipo == "tplink") {
    $responseToken = $tplink->returnToken($cuentaAlmCalle->usario, $cuentaAlmCalle->password);
    if ($cuentaAlmCalle->token != $responseToken["result"]['token']) { // el token retornado es diferente al que esta en db:

      $resActualizarCuenta = $catCuentasObj->ActualizarCampoCuenta("token", $responseToken["result"]['token'], $cuentaAlmCalle->idCuenta);

      if ($resActualizarCuenta > 0) { // se actualizo correctamente en bd:

        $fechaActual = (new DateTime("now", new DateTimeZone('America/Mexico_City')))->format('Y-m-d H:i:s');
        $histToken = array(
          "cuenta" => $cuentaAlmCalle->nombre,
          "tokenAnt" => $cuentaAlmCalle->token,
          "tokenNuevo" => $responseToken["result"]['token'],
          "fecha" => $fechaActual
        );

        $historicosObj->jsonUserTurn = json_encode($histToken);
        $historicosObj->tipoHist = 4;
        $historicosObj->GuardarHistoricos();
      }
    }

    // Validamos el servidor
    $responseServer = $tplink->verifyServer($responseToken["result"]['token'], $almCalle->alarmaId, $almCalle->server);
    if ($responseServer['equals'] == false) { // el servidor obtenido no coincide con el de base de datos y lo actualizamos:
      $resActualizarVehiculo = $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("server", $responseServer["serverFound"], $almCalle->alarmaId);
      if ($resActualizarVehiculo > 0) { // se actualizo correctamente en bd:

        $fechaActual = (new DateTime("now", new DateTimeZone('America/Mexico_City')))->format('Y-m-d H:i:s');
        $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("fechaActualizacion", $fechaActual, $almCalle->alarmaId);
      }
    }
  }
}

function guardarConexionBotonLLavero()
{
  $historicoConexionBotonLLaveroObj = new historicoConexionBotonLLaveroObj();

  $fechaHoraActual = (new DateTime("now", new DateTimeZone('America/Mexico_City')))->format('Y-m-d H:i:s');

  $historicoConexionBotonLLaveroObj->idUsuario = $_GET['idUsuario'];
  $historicoConexionBotonLLaveroObj->idBotonLLavero = $_GET['idBotonLLavero'];
  $historicoConexionBotonLLaveroObj->fechaHoraConexion = $fechaHoraActual;
  $historicoConexionBotonLLaveroObj->tipoConexion = $_GET['tipoConexion'];
  $historicoConexionBotonLLaveroObj->GuardarHistorialConexionBotonLLavero();

  $return = $historicoConexionBotonLLaveroObj->obtIdConexionBLEPorHoraUsuario($fechaHoraActual, $_GET['idUsuario']);



  $callback = $_GET['callback'];
  if ($return == 0) {
    $arr = array("success" => false);
  } else {
    $arr = array("success" => true, "conexionGuardada" => $return);
  }
  echo $callback . '(' . json_encode($arr) . ');';
}

function verificarSiSesionContinuaActiva($callback, $idInicioSesion)
{
  $historialInicioSesionObj = new historialInicioSesionObj();

  $datosLoggin = $historialInicioSesionObj->obtDatosUsrLogginPorIdInicio($idInicioSesion);
  if ($datosLoggin->fechaHoraCierreSesion != null && $datosLoggin->usuarioCerrarSesion != null) {
    $res = array("success" => true);
  } else {
    $res = array("success" => false);
  }

  echo "$callback(" . json_encode($res) . ");";
}

//nuevo modulo de historicoPeticiones
function ObtReporteshistoricoPeticion($callback, $idUser, $fechaP, $fechaS)
{

  $usuarioVehiculoObj = new usuarioVehiculoObj();
  $historicoAsignadosObj = new historicoAsignadosObj();
  $datosusuariovehiculo = $usuarioVehiculoObj->getUsuarioporid($idUser);
  $datoshistiricoasignado = $historicoAsignadosObj->obtenerAsignacionPeticion($datosusuariovehiculo->idUserTurno, $fechaP, $fechaS);

  if (count($datoshistiricoasignado) > 0) {
    $res = array("success" => true, "datos" => $datoshistiricoasignado);
  } else {
    $res = array("success" => false);
  }


  echo "$callback(" . json_encode($res) . ");";
}

function ObtReporteshistoricoPeticionPorID($callback, $idUser, $fechaP, $fechaS, $id)
{
  $usuarioVehiculoObj = new usuarioVehiculoObj();
  $historicoAsignadosObj = new historicoAsignadosObj();
  $datosusuariovehiculo = $usuarioVehiculoObj->getUsuarioporid($idUser);
  $datoshistiricoasignado = $historicoAsignadosObj->obtenerAsignacionPeticion($datosusuariovehiculo->idUserTurno, $fechaP, $fechaS, $id);

  if (count($datoshistiricoasignado) > 0) {
    $res = array("success" => true, "datos" => $datoshistiricoasignado);
  } else {
    $res = array("success" => false);
  }


  echo "$callback(" . json_encode($res) . ");";
}

//metodo Para Enviar msj push de la peticion cuidadano
function sedMsjPatrulleroPeticion($idUsuarioTurno)
{
  $usuariosTurnoObj = new usuariosTurnoObj();
  $usuarioVehiculoObj = new usuarioVehiculoObj();
  $regDispObj = new registroDispositivo();
  $msgObj = new mensajesObj();


  $datos = $usuariosTurnoObj->metodoPorIDuserTurno($idUsuarioTurno);
  $datos_vehiculoUser = $usuarioVehiculoObj->UsuarioVehiculoPorId($datos->usuarioVehiculoId);
  $datosRegistroDispositivos = $regDispObj->getPorIdUser($datos_vehiculoUser->usuarioId);

  $titulo = "Peticion asignada";
  $mensajeCompleto = "Usted tiene una nueva petición asignada, por favor, atienda.";
  //Salvar el mensaje
  $msgObj->usuarioId = $datos_vehiculoUser->usuarioId;
  $msgObj->leido = 0;
  $msgObj->mostrar = 1;
  $msgObj->titulo = $titulo;
  $msgObj->contenido = $mensajeCompleto;
  $msgObj->idConcepto = null;
  $msgObj->imagen = null;
  $msgObj->idReporte = 0;
  $msgObj->idUsuarioCmb = 0;
  $msgObj->GuardarMensajesObj();

  $regid = $datosRegistroDispositivos->idRegDispositivo;
  $plataforma = $datosRegistroDispositivos->plataforma;
  if ($regid != "") {
    if ($plataforma == 0) {
      $resPush = $regDispObj->gcmSend($regid, $mensajeCompleto, $titulo);
      $objPush = json_decode($resPush);
      if ($objPush->success == 1) {
        return $resPush;
      } else {
        return 0;
      }

      return 1;
    }
    if ($plataforma == 1) {
      $resPush = $regDispObj->gcmSend($regid, "Contenido mensaje", "Titulo", 'ios');
      $objPush = json_decode($resPush);
      if (isset($objPush->success) && $objPush->success == 1) {
        return $resPush;
      } else {
        return 0;
      }

      return 1;
    }
  }
}



// FOMULARIOS --
function formularioAll($callback, $idrol)
{
  $formulariosObJ = new formulariosObJ();
  $catEstatusFormularioObj = new catEstatusFormularioObj();

  $dataformulariosAll = $formulariosObJ->getAllformulario();
  $dataEstatus = $catEstatusFormularioObj->getEstatusFormulario();
  $html = '';
  $head = '';
  foreach ($dataformulariosAll as $elemento) {
    switch ($idrol) {
      case 1:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 2:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 3:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 4:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 5:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 6:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 7:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 8:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 9:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      case 10:
        if (strpos($elemento->PermisoROL, $idrol) !== false) {
          $html .= obtenerformulario($elemento);
        }
        break;
      default:
        # code...
        break;
    }
  }
  if (count($dataformulariosAll) == 0) {
    $head .= '<div>';
    $head .= '<h6> Sin formularios</h6>';
    $head .= '</div>';
  } else {
    $head .= '<div>';
    $head .= '<h6 style=' . 'text-align:center;' . ' > Registo de todo los formularios en  proceso Formularios </h6>';
    $head .= '</div>';
  }
  $arr = array("success" => true, "formularios" => $html, "head" => $head);
  echo $callback . '(' . json_encode($arr) . ');';
}
function obtenerformulario($elemento)
{
  $html = '';
  if ($elemento->nombre_estatus == "En proceso") {
    $html .= '<div>';
    $html .= "<div class='row' style='padding-left: 9px;'>";
    $html .= "<div class ='col-8'>";
    $html .= "<h4>" . $elemento->nombre . "</h4>";
    $html .= "<h6>" . $elemento->descripcion . "</h6>";
    $html .= "</div>";
    $html .= "<div class='col-4' style='padding-right: 29px;padding-top: 41px;width: 64px;'>";
    $html .= "<input class='button button-fill color-blue' type='button' onclick='Iradromulario(" . $elemento->idFormulario . ',' . $elemento->idEstatusFormulario . ")' value = '+'>";
    $html .= "</div>";
    $html .= "</div>";
    $html .= "</div>";
  } elseif ($elemento->nombre_estatus == "Finalizado") {
    $html .= '<div>';
    $html .= "<div class='row' style='padding-left: 9px;'>";
    $html .= "<div class ='col-8'>";
    $html .= "<h4>" . $elemento->nombre . "</h4>";
    $html .= "<h6>" . $elemento->descripcion . "</h6>";
    $html .= "</div>";
    $html .= "<div class='col-4' style='padding-right: 29px;padding-top: 41px;width: 64px;'>";
    $html .= "<input class='button button-fill color-blue' type='button' onclick='Iradromulario(" . $elemento->idFormulario . ',' . $elemento->idEstatusFormulario . ")' value = '+'>";
    $html .= "</div>";
    $html .= "</div>";
    $html .= "</div>";
  } elseif ($elemento->nombre_estatus == "Inicio") {
    $html .= '<div>';
    $html .= "<div class='row' style='padding-left: 9px;'>";
    $html .= "<div class ='col-8'>";
    $html .= "<h4>" . $elemento->nombre . "</h4>";
    $html .= "<h6>" . $elemento->descripcion . "</h6>";
    $html .= "</div>";
    $html .= "<div class='col-4' style='padding-right: 29px;padding-top: 41px;width: 64px;'>";
    $html .= "<input class='button button-fill color-blue' type='button' onclick='Iradromulario(" . $elemento->idFormulario . ',' . $elemento->idEstatusFormulario . ")' value = '+'>";
    $html .= "</div>";
    $html .= "</div>";
    $html .= "</div>";
  }
  return $html;
}

function formulario($callback, $id, $idrol)
{
  $formulariosObJ = new formulariosObJ();
  $opcionesPreguntaObj = new opcionesPreguntaObj();
  $PreguntaFormularioObj = new PreguntaFormularioObj();
  $gruposFormularioObj = new gruposFormularioObj();




  // datos principales
  $datosformulario = $formulariosObJ->GetFormurarioPorId($id);
  $datosGrupos = $gruposFormularioObj->getAllGrupos($id, $datosformulario->version);
  $Preguntas = $PreguntaFormularioObj->getPreguntaPorId($id, $datosGrupos->idGruposFormularios, $datosformulario->version, $idrol);
  $datosPreguntas = '';

  foreach ($Preguntas as $pregunta) {

    switch ($pregunta->idTipoPreguntas) {
      case '1':
        $datosPreguntas .= PintarPeguntaTipoTEXTO($pregunta, 1);
        break;
      case '2':
        $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormularioArray($id, $pregunta->idPreguntaFormulario, $datosformulario->version, $idrol);
        $datosPreguntas .= PintarPreguntasTipoMultipleConVariasRespuesta($pregunta, $datosOpcionesPregunta);

        break;
      case '3':
        $datosPreguntas .= PintarPreguntasTipoMultipleConUnicaRespuesta($pregunta, $id, $datosformulario, $idrol);
        break;
      case '4':
        $datosPreguntas .= PintarPeguntaTipoTEXTO($pregunta, 2);
        break;
      case '5':
        $datosPreguntas .= PintarPeguntaTipoUbicacion($pregunta);
        break;
      case '6':
        $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormulario($id, $pregunta->idPreguntaFormulario, $datosformulario->version, $idrol);
        $datosPreguntas .= Creaciongrupos($pregunta, $datosOpcionesPregunta, $datosformulario, $idrol);
        break;
      case '7':
        $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormulario($id, $pregunta->idPreguntaFormulario, $datosformulario->version, $idrol);
        $datosPreguntas .= pintarGrupoconBoton($pregunta, $datosOpcionesPregunta, $datosformulario, $idrol);
        break;
      case '8':
        $datosPreguntas .= PreguntaImagen($pregunta, $datosformulario, $idrol);
        break;

      default:
        # code...
        break;
    }
  }





  // head de formulario //
  $formularioHead = '';
  $formularioHead .= "<h6 class = 'TituloFormulario' >" . $datosformulario->nombre . "</h6> ";
  $formularioHead .= "<h6 class = 'DescripcionFormulario'>" . $datosformulario->descripcion . "</h6> ";
  $formularioHead .= "<h6 class = 'DescripcionFormulario'>Datos presentados por Sistema</h6> ";
  // aqui traemos una funcion para que solo nos separe los pregunta y opciones de preguntas, con la version actual del formulario y el id rol 
  $arr = array("success" => true, "formularios" => $formularioHead, "preguntas" => $datosPreguntas);

  echo $callback . '(' . json_encode($arr) . ');';
}

function opcionesChebox($Opciones, $pregunta, $params, $idPregunta)
{
  $contformularios = '';
  foreach ($Opciones as $opc) {
    if ($params == 1) {
      $contformularios .= "<div class ='resul" . $pregunta->idPreguntaFormulario . "'>";

      $contformularios .= "<label class='item-checkbox item-content' onclick=VerificarChebosFormulario('chebox" . $opc->idOpcionPregunta . "'," . $idPregunta . "," . $pregunta->idPreguntaFormulario . ") >";
      $contformularios .= "<input style='display: none;' type='checkbox' name='demo-checkbox' value='" . $opc->idOpcionPregunta . "'  id ='chebox" . $opc->idOpcionPregunta . "'>";
      $contformularios .= "<i class='icon icon-checkbox'></i>";
      $contformularios .= "<div class='item-inner'>";
      $contformularios .= "<div class='item-title'style='white-space: break-spaces;'>" . $opc->valor . "</div>";
      $contformularios .= " </div>";
      $contformularios .= "</label>";

      if ($opc->valor == 'Otra respuesta') {
        $contformularios .= "<div style = 'display: none;margin-left :18px;' id='OtraRespuesta" . $opc->idOpcionPregunta . "'>";
        $contformularios .= opcioneText(1, $pregunta, '', $idPregunta);
        $contformularios .= " </div>";
      }
      $contformularios .= " </div>";
    } elseif ($params == 2) {
      $contformularios .= "<label class='item-checkbox item-content' onclick=VerificarChebosFormulario('chebox" . $opc->idOpcionPregunta . "'," . $pregunta->idPreguntaFormulario . "," . $opc->idOpcionPregunta . ") >";
      $contformularios .= "<input style='display: none;' type='checkbox' name='demo-checkbox' value='" . $opc->idOpcionPregunta . "'  id ='chebox" . $opc->idOpcionPregunta . "'>";
      $contformularios .= "<i class='icon icon-checkbox'></i>";
      $contformularios .= "<div class='item-inner'>";
      $contformularios .= "<div class='item-title'style='white-space: break-spaces;'>" . $opc->valor . "</div>";
      $contformularios .= " </div>";
      $contformularios .= "</label>";

      if ($opc->valor == 'Otra respuesta') {
        $contformularios .= "<div style = 'display: none;margin-left :18px;' id='OtraRespuesta" . $opc->idOpcionPregunta . "'>";
        $contformularios .= opcioneText(1, $pregunta, '', $idPregunta);
        $contformularios .= " </div>";
      }
    }
  }
  return $contformularios;
}
function opcionesradio($datosOpc, $pregunta, $params, $idPregunta)
{
  $contformularios = '';
  if ($params == 1) {
    foreach ($datosOpc as $opciones) {
      $contformularios .= "<div class ='resul" . $pregunta->idPreguntaFormulario . "'>";
      if ($opciones->valor == 'Otra respuesta') {
        $contformularios .= "<label class='radio' style='display: flex;align-items: center;padding-left: 30px;' onclick=verTextoRadio('resul$pregunta->idPreguntaFormulario','radio$opciones->idOpcionPregunta',1)>";
      } else {
        $contformularios .= "<label class='radio' style='display: flex;align-items: center;padding-left: 30px;' onclick=verTextoRadio('resul$pregunta->idPreguntaFormulario','radio$opciones->idOpcionPregunta',2)>";
      }
      $contformularios .= "<input type='radio' name='demo-checkbox' value='" . $opciones->idOpcionPregunta . "' id ='radio" . $opciones->idOpcionPregunta . "'>";
      $contformularios .= "<i class='icon icon-radio' style=' border: #007aff;border-top-style: solid;border-top-width: 1px;border-right-style: solid;border-right-width: 1px;border-bottom-width: 1px;border-bottom-style: solid;border-left-width: 1px;border-left-style: solid;'></i>";
      $contformularios .= "<div class='item-inner'>";
      $contformularios .= "<div class='item-title'style='white-space: break-spaces;'>" . $opciones->valor . "</div>";
      $contformularios .= " </div>";
      $contformularios .= "</label>";

      if ($opciones->valor == 'Otra respuesta') {
        $contformularios .= "<div style = 'display: none;margin-left :30px;' id='OtraRespuesta" . $opciones->idOpcionPregunta . "'>";
        $contformularios .= opcioneText(1, $pregunta, '', $idPregunta);
        $contformularios .= " </div>";
      }
      $contformularios .= " </div>";
    }
  } elseif ($params == 2) {
    $contformularios .= "<div class ='radiolabel" . $pregunta->idPreguntaFormulario . "'>";

    foreach ($datosOpc as $opciones) {

      if ($opciones->valor == 'Otra respuesta') {
        $contformularios .= "<label class='radio' style='display: flex; align-items: center; padding-left: 30px;' onclick=verTextoRadio('radiolabel$pregunta->idPreguntaFormulario','radio$opciones->idOpcionPregunta',1,$pregunta->idPreguntaFormulario)>";
      } else {
        $contformularios .= "<label class='radio' style='display: flex; align-items: center; padding-left: 30px;' onclick=verTextoRadio('radiolabel$pregunta->idPreguntaFormulario','radio$opciones->idOpcionPregunta',2,$pregunta->idPreguntaFormulario)>";
      }
      $contformularios .= "<input type='radio' name='demo-checkbox' value='" . $opciones->idOpcionPregunta . "' id ='radio" . $opciones->idOpcionPregunta . "'>";
      $contformularios .= "<i class='icon icon-radio' style=' border: #007aff; border-top-style: solid; border-top-width: 1px; border-right-style: solid; border-right-width: 1px; border-bottom-width: 1px; border-bottom-style: solid; border-left-width: 1px; border-left-style: solid;'></i>";
      $contformularios .= "<div class='item-inner'>";
      $contformularios .= "<div class='item-title' style='white-space: break-spaces;'>" . $opciones->valor . "</div>";
      $contformularios .= " </div>";
      $contformularios .= "</label>";

      if ($opciones->valor == 'Otra respuesta') {
        $contformularios .= "<div style = 'display: none; margin-left :30px;' id='OtraRespuesta" . $opciones->idOpcionPregunta . "'>";
        $contformularios .= opcioneText(1, $pregunta, '', $idPregunta);
        $contformularios .= " </div>";
      }
    }

    $contformularios .= " </div>";
  }

  return $contformularios;
}

function opcioneText($params, $pregunta, $id, $idPregunta)
{
  $contformularios = '';
  if ($params == 2) {

    if ($id == null) {
      $contformularios .= "<textarea id='text" . $pregunta->idPreguntaFormulario . "'  placeholder='Respuesta abierta' class='input-with-value' style='height: 150px;width: 100%; background: white;' onblur = GuardarTexto('text" . $pregunta->idPreguntaFormulario . "'," . $pregunta->idPreguntaFormulario . ")></textarea>";
    } else {
      $contformularios .= "<div style='display:flex;justify-content:space-around; flex-wrap:wrap;margin-bottom:8px;  '>";
      $contformularios .= "<label style ='display: flex;flex-direction: row; align-items: baseline;'> " . $pregunta->pregunta . "";
      $contformularios .= "<textarea id='$id'  placeholder='Respuesta abierta' class='input-with-value' style='height: 150px;width: 100%; background: white;margin-left: 9px' onclick=Dirigir('$id'," . $pregunta->idPreguntaFormulario . ")></textarea>";
      $contformularios .= "</label>";
      $contformularios .= "</div>";
    }
  } elseif ($params == 1) {
    if ($id == null) {
      $contformularios .= "<input id='text" . $pregunta->idPreguntaFormulario . "' type='text'  placeholder='Respuesta abierta' onblur=\"GuardarTexto('text" . $pregunta->idPreguntaFormulario . "'," . $idPregunta . ")\"/>";
    } else {
      $contformularios .= "<div style='display:flex;justify-content:space-around; flex-wrap:wrap;margin-bottom:8px;  '>";
      $contformularios .= "<label style ='display: flex;flex-direction: row; align-items: baseline;'> " . $pregunta->pregunta . "";
      $contformularios .= "<input id='$id' type='text'  placeholder='Respuesta abierta' onblur=\"GuardarTexto('$id'," . $idPregunta . ")\"/>";
      $contformularios .= "</label>";
      $contformularios .= "</div>";
    }
  }
  return $contformularios;
}

function opcionestime($pregunta, $params)
{
  $contformularios = '';
  //print_r($pregunta);exit;
  if ($params == 1) {
    $contformularios .= "<label style='margin-left: 37px;'>Ingrese la hora</label>";
    $contformularios .= "<input type='time' id='horaInput$pregunta->idPreguntaFormulario' class='form-control' style='margin-left: 67px;width: 150px;border-bottom: 1px solid blue;margin-top: 14px;margin-bottom: 15px;' onblur=ObtnerTime(1,$pregunta->idPreguntaFormulario) />";
  } elseif ($params == 2) {
    $contformularios .= "<div id='horaDIV$pregunta->idPreguntaFormulario'>";
    $contformularios .= "<label style='margin-left: 37px;'>Ingrese la primera hora</label>";
    //$contformularios .= "<input type='time' id='horaP$pregunta->idPreguntaFormulario' class='form-control' style='margin-left: 67px;width: 150px;border-bottom: 1px solid blue;margin-top: 14px;margin-bottom: 15px;'/>";
    $contformularios .= "<input type='time' id='horaP$pregunta->idPreguntaFormulario' class='form-control' style='margin-left: 67px;width: 150px;border-bottom: 1px solid blue;margin-top: 14px;margin-bottom: 15px;' onblur=ObtnerTime(2,$pregunta->idPreguntaFormulario) />";
    $contformularios .= "<label style='margin-left: 37px;'>Ingrese la segunda hora</label>";
    $contformularios .= "<input type='time' id='horaS$pregunta->idPreguntaFormulario' class='form-control' style='margin-left: 67px;width: 150px;border-bottom: 1px solid blue;margin-top: 14px;margin-bottom: 15px;' onblur=ObtnerTime(2,$pregunta->idPreguntaFormulario) />";
    $contformularios .= "</div>";
  }
  return $contformularios;
}


function PintarPeguntaTipoTEXTO($pregunta, $params)
{

  $contformularios = '';

  //$contformularios .= "<div class='inputPregunta' id =$pregunta->idPreguntaFormulario>";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='{$pregunta->idTipoPreguntas}'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";


  $contformularios .= "<label class='item-checkbox item-checkbox-icon-end item-content' style='display: flex;align-items: center; background: white;'>";
  $contformularios .= "<div class='item-title'style='white-space: break-spaces; width: 100%;'>";
  $contformularios .= opcioneText($params, $pregunta, '', $pregunta->idPreguntaFormulario);
  $contformularios .= " </div>";
  $contformularios .= "</label>";

  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";

  return $contformularios;
}

function PintarPreguntasTipoMultipleConVariasRespuesta($pregunta, $Opciones)
{
  $contformularios = '';
  //$contformularios .= "<div class = 'inputPregunta' id =" . 'inPUT' .$pregunta->idPreguntaFormulario.">";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='{$pregunta->idTipoPreguntas}'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content' id='PreguntaChebox" . $pregunta->idPreguntaFormulario . "'>";
  $contformularios .= opcionesChebox($Opciones, $pregunta, 2, $pregunta->idPreguntaFormulario);
  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  return $contformularios;
}

function PintarPeguntaTipoUbicacion($pregunta)
{
  $contformularios = '';

  //$contformularios .= "<div class = 'inputPregunta' id =" . 'inPUT' . $pregunta->idPreguntaFormulario . ">";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='{$pregunta->idTipoPreguntas}'";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";


  $contformularios .= "<div class='pg_formularios__chatContainer' id='chat_buttonBox' >";
  $contformularios .= "<a id='pg_formularios__openChat' class='button button-fill button-small popup-open chat' href='#' data-popup='.popup_formulario' onclick='formularioMapa($pregunta->idPreguntaFormulario)' >Ubicacion";
  $contformularios .= "</a>";

  $contformularios .= "<input id='cordenadasGuardadas$pregunta->idPreguntaFormulario' type='text' style='display: none;'  />";
  $contformularios .= "<textarea id='UbicacionGuardada$pregunta->idPreguntaFormulario' readonly></textarea>";
  $contformularios .= "</div>";



  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";


  $contformularios .= "<div class='popup popup_formulario' style='height: inherit;'>";

  $contformularios .= "<div class='block text_right'>";
  $contformularios .= "<p class='row'>";
  $contformularios .= "<div><img src='images/logo_serpub.png' width='100' /></div>";
  $contformularios .= "<div><a id='close_chat' class='link popup-close' href='#'> <span><i class='f7-icons'>close_round_fill</i></span> </a></p></div>";
  $contformularios .= "</div>";
  $contformularios .= "<div style='HEIGHT: 78PX;'>";
  $contformularios .= "<textarea id='pac-input$pregunta->idPreguntaFormulario' type='text' placeholder='Buscar lugares' style='height: 40px;width: 100%;'></textarea>";
  $contformularios .= "<button onclick='buscarDireccion($pregunta->idPreguntaFormulario)'>Buscar</button>";
  $contformularios .= "</div>";

  $contformularios .= "<div style='height: 78%;margin-top :17px;' id='formularioMapa$pregunta->idPreguntaFormulario'></div>";


  $contformularios .= "</div>";

  return $contformularios;
}

function PintarPreguntasTipoMultipleConUnicaRespuesta($pregunta, $id, $formulario, $idrol)
{
  $opcionesPreguntaObj = new opcionesPreguntaObj();
  $resul = '';
  switch ($pregunta->idTipodeElemento) {
    case '1':
      $resul .= CreacionInputTiempo($pregunta, 1);
      break;
    case '2':
      $resul .= CreacionInputFechayhora($pregunta, 1);
      break;
    case '3':
      $resul .= CreacionInputFechayhora($pregunta, 2);
      break;
    case '4':
      $resul .= CreacionInputTiempo($pregunta, 2);
      break;
    case '5':
      $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormularioArray($id, $pregunta->idPreguntaFormulario, $formulario->version, $idrol);
      $resul .= CreacionInputRadio($pregunta, $datosOpcionesPregunta);
      break;

    default:
      # code...
      break;
  }

  return $resul;
}

function Creaciongrupos($pregunta, $datosOpciones, $formulario, $idrol)
{

  $preguntaConOpciones = '';
  switch ($pregunta->idTipodeElemento) {
    case '6':
      $preguntaConOpciones .= PintarPreguntasTipoCatalogo($pregunta, $datosOpciones, $formulario, $idrol);
      break;
    case '7':
      $preguntaConOpciones .= PintarPreguntaGrupos($pregunta, $datosOpciones, $formulario, $idrol);
      break;

    default:
      # code...
      break;
  }
  return $preguntaConOpciones;
}



function CreacionInputTiempo($pregunta, $params)
{
  $contformularios = '';
  //$contformularios .= "<div class = 'inputPregunta' id =" . 'inPUT' . $pregunta->idPreguntaFormulario . ">";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='E$pregunta->idTipodeElemento'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";
  $contformularios .= opcionestime($pregunta, $params);
  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";

  return $contformularios;
}

function CreacionInputFechayhora($pregunta, $params)
{
  $contformularios = '';

  // $contformularios .= "<div class = 'inputPregunta' id =" . 'inPUT' . $pregunta->idPreguntaFormulario . ">";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='E$pregunta->idTipodeElemento'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";
  $contformularios .= FechaHora($params, $pregunta);
  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";

  return $contformularios;
}

function FechaHora($params, $pregunta)
{
  $contformularios = '';
  if ($params == 1) {
    $contformularios .= "<label style='margin-left: 37px;'>Ingrese la  fecha y hora </label>";
    $contformularios .= "<input type='datetime-local' class='form-control' style='border-bottom: 1px solid blue; margin-left: 67px;width: 150px; font-size:15px;' onblur=obtenerfechaHora(1,$pregunta->idPreguntaFormulario) id='Fechahora$pregunta->idPreguntaFormulario' />";
  } elseif ($params == 2) {
    $contformularios .= "<div id ='Fechahora$pregunta->idPreguntaFormulario'>";
    $contformularios .= "<label style='margin-left: 37px;'>Ingrese la primera fecha y hora </label>";
    $contformularios .= "<input type='datetime-local' class='form-control' style='border-bottom: 1px solid blue; margin-left: 67px;width: 202px; font-size:15px;' onblur=obtenerfechaHora(2,$pregunta->idPreguntaFormulario) />";
    $contformularios .= "<label style='margin-left: 37px;'>Ingrese la segunda fecha y hora </label>";
    $contformularios .= "<input type='datetime-local' class='form-control' style='border-bottom: 1px solid blue; margin-left: 67px;width: 202px; font-size:15px;' onblur=obtenerfechaHora(2,$pregunta->idPreguntaFormulario) />";
    $contformularios .= "</div>";
  }
  return $contformularios;
}

function CreacionInputRadio($pregunta, $datosOpc)
{
  $contformularios = '';

  //$contformularios .= "<div class = 'inputPregunta' id =" . 'inPUT' .$pregunta->idPreguntaFormulario.">";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='{$pregunta->idTipoPreguntas}'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";

  $contformularios .= opcionesradio($datosOpc, $pregunta, 2, $pregunta->idPreguntaFormulario);

  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";

  return $contformularios;
}



function PintarPreguntasTipoCatalogo($pregunta, $datosOPC, $formulario, $idrol)
{
  $PreguntaFormularioObj = new PreguntaFormularioObj();

  $Preguntas = $PreguntaFormularioObj->getPreguntaPorId($formulario->idFormulario, $datosOPC->valor, $formulario->version, $idrol);

  $NAME = $Preguntas[0]->idTipodeElemento;
  $contformularios = '';

  // cambiar el idTipode pregunta por elemento mas la e
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='E$NAME'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";

  $contformularios .= "<form class='searchbar'>";
  $contformularios .= "<div class='searchbar-inner'>";
  $contformularios .= "<div class='searchbar-input-wrap'>";
  $contformularios .= "<input type='Search' placeholder='Search' onkeyup=filterItems(this,'searchResults" . $pregunta->idPreguntaFormulario . "')>";
  $contformularios .= "<i class='searchbar-icon'></i>";
  $contformularios .= "<span class='input-clear-button'></span>";
  $contformularios .= "</div>";
  $contformularios .= "<span class='searchbar-disable-button'>Cancel</span>";
  $contformularios .= "</div>";
  $contformularios .= "</form>";

  $contformularios .= "<div class='list12 searchbar-found' id='searchResults$pregunta->idPreguntaFormulario'>";
  $contformularios .= "<ul style='list-style: none;'>";

  foreach ($Preguntas as $datopregunta) {

    if ($datopregunta->idTipodeElemento == 9) {
      $contformularios .= PintarPreguntasTipoCatalogosubPregunta($pregunta, $datopregunta, 1, $pregunta->idPreguntaFormulario);
    } elseif ($datopregunta->idTipodeElemento == 8) {
      $contformularios .= PintarPreguntasTipoCatalogosubPregunta($pregunta, $datopregunta, 2, $pregunta->idPreguntaFormulario);
    }
  }

  $contformularios .= "</ul>";
  $contformularios .= "</div>";

  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";

  return $contformularios;
}

function PintarPreguntasTipoCatalogosubPregunta($pregunta, $datopregunta, $params, $idPregunta)
{
  $contformularios = '';


  $contformularios .= "<li class='item-content-primera'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='list accordion-list'>";
  $contformularios .= "<ul>";

  $contformularios .= radioYcheckbox($pregunta, $datopregunta, $params);

  $contformularios .= "<div class='accordion-item-content' >";

  $contformularios .= opcionesCatalogoPregunta($datopregunta, $idPregunta);

  $contformularios .= "</div>";

  $contformularios .= "</li>";


  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</li>";

  return $contformularios;
}

function radioYcheckbox($pregunta, $datopregunta, $params)
{
  $contformularios = '';

  if ($params == 1) {
    $contformularios .= "<li class='accordion-item'>";
    $contformularios .= "<a href='#' class='item-link item-content' onclick=\"activarcheckbox('pregunta_checkbox" . $datopregunta->idPreguntaFormulario . "',$pregunta->idPreguntaFormulario)\">";
    $contformularios .= "<div class='item-inner'>";
    $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
    $contformularios .= "<label class='checkbox' style='display: flex;align-items: center;'>";
    $contformularios .= "<input type='checkbox' id='pregunta_checkbox" . $datopregunta->idPreguntaFormulario . "' value = '$datopregunta->idPreguntaFormulario'>";
    $contformularios .= "<i class='icon icon-checkbox'></i>";
    $contformularios .= "$datopregunta->pregunta</label>";
    $contformularios .= "</div>";
    $contformularios .= "</div>";
    $contformularios .= "</a>";
  } elseif ($params == 2) {
    $contformularios .= "<li class='accordion-item'>";
    $contformularios .= "<a href='#' class='item-link item-content' onclick=\"activar('pregunta_radio" . $datopregunta->idPreguntaFormulario . "')\">";
    $contformularios .= "<div class='item-inner'>";
    $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
    $contformularios .= "<label class='radio' style='display: flex;align-items: center;'>";
    $contformularios .= "<input type='radio' id='pregunta_radio" . $datopregunta->idPreguntaFormulario . "'>";
    $contformularios .= "<i class='icon icon-radio' style=' border: #007aff;border-top-style: solid;border-top-width: 1px;border-right-style: solid;border-right-width: 1px;border-bottom-width: 1px;border-bottom-style: solid;border-left-width: 1px;border-left-style: solid;'></i>";
    $contformularios .= "$datopregunta->pregunta</label>";
    $contformularios .= "</div>";
    $contformularios .= "</div>";
    $contformularios .= "</a>";
  }
  return $contformularios;
}

function opcionesCatalogoPregunta($pregunta, $idPregunta)
{

  $contformularios = '';

  $contformularios .= "<form class='searchbar'>";
  $contformularios .= "<div class='searchbar-inner'>";
  $contformularios .= "<div class='searchbar-input-wrap'>";
  $contformularios .= "<input type='search' placeholder='Search' onkeyup=segundabusqueda(this,'searchResults" . $pregunta->idPreguntaFormulario . "','resul" . $pregunta->idPreguntaFormulario . "')>";
  $contformularios .= "<i class='searchbar-icon'></i>";
  $contformularios .= "<span class='input-clear-button'></span>";
  $contformularios .= "</div>";
  $contformularios .= "<span class='searchbar-disable-button'>Cancel</span>";
  $contformularios .= "</div>";
  $contformularios .= "</form>";

  $contformularios .= "<div class='list searchbar-found'  id='searchResults" . $pregunta->idPreguntaFormulario . "' >";
  $contformularios .= "<ul>";


  $contformularios .= opcionescatPreguntasub($pregunta, $idPregunta);


  $contformularios .= "</ul>";
  $contformularios .= "</div>";

  return $contformularios;
}

function opcionescatPreguntasub($pregunta, $idPregunta)
{
  $opcionesPreguntaObj = new opcionesPreguntaObj();
  $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormularioArray($pregunta->idFormulario, $pregunta->idPreguntaFormulario, $pregunta->version_formulario, $pregunta->idrol);
  $contformularios = '';


  if ($pregunta->idTipodeElemento == 9) {
    $contformularios .= "<li class='item-content" . $pregunta->idPreguntaFormulario . "'>";
    $contformularios .= "<div class='item-inner'>";
    $contformularios .= "<div class='item-title" . $pregunta->idPreguntaFormulario . "'>";
    $contformularios .= opcionesChebox($datosOpcionesPregunta, $pregunta, 1, $idPregunta);
    $contformularios .= "</div>";
    $contformularios .= "</div>";
    $contformularios .= "</li>";
  } elseif ($pregunta->idTipodeElemento == 8) {
    $contformularios .= "<li class='item-content" . $pregunta->idPreguntaFormulario . "'>";
    $contformularios .= "<div class='item-inner'>";
    $contformularios .= "<div class='item-title" . $pregunta->idPreguntaFormulario . "'>";
    $contformularios .= opcionesradio($datosOpcionesPregunta, $pregunta, 1, $idPregunta);
    $contformularios .= "</div>";
    $contformularios .= "</div>";
    $contformularios .= "</li>";
  }

  return $contformularios;
}


function PintarPreguntaGrupos($pregunta, $opciones, $formulario, $idrol)
{
  $PreguntaFormularioObj = new PreguntaFormularioObj();

  $Preguntas = $PreguntaFormularioObj->getPreguntaPorId($formulario->idFormulario, $opciones->valor, $formulario->version, $idrol);

  $NAME = $pregunta->idTipodeElemento;
  $yes = 'si' . $pregunta->idPreguntaFormulario;
  $no = 'no' . $pregunta->idPreguntaFormulario;

  $contformularios = '';
  //$contformularios .= "<div class = 'inputPregunta' id =" . 'inPUT' .$pregunta->idPreguntaFormulario.">";
  $contformularios .= "<div class='inputPregunta' id='{$pregunta->idPreguntaFormulario}' name='E$NAME'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $pregunta->orden_pregunta . '.' . $pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";

  $contformularios .= "<label class='radio' style='padding-left: 20%;padding-right: 20%;' onclick= grupos('$yes',$pregunta->idPreguntaFormulario) ><input type='radio' name='demo-radio-inline' id= '$yes' value='si' ><i class='icon-radio'></i>Si</label>";

  $contformularios .= "<label class='radio' onclick= grupos('$no',$pregunta->idPreguntaFormulario) ><input type='radio' name='demo-radio-inline'  id= '$no' value= 'no' ><i class='icon-radio'></i>No</label>";

  $contformularios .= "<div id='mostar$pregunta->idPreguntaFormulario' style='display:none;' >";

  $contformularios .= obtenerpreguntas($Preguntas, $formulario->idFormulario, $formulario, $idrol);

  $contformularios .= "</div>";


  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";

  return $contformularios;
}

function obtenerpreguntas($Preguntas, $id, $datosformulario, $idrol)
{
  $opcionesPreguntaObj = new opcionesPreguntaObj();
  $datosPreguntas = '';
  foreach ($Preguntas as $pregunta) {

    switch ($pregunta->idTipoPreguntas) {
      case '1':
        $datosPreguntas .= PintarPeguntaTipoTEXTO($pregunta, 1);

        break;
      case '2':
        $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormularioArray($id, $pregunta->idPreguntaFormulario, $datosformulario->version, $idrol);
        $datosPreguntas .= PintarPreguntasTipoMultipleConVariasRespuesta($pregunta, $datosOpcionesPregunta);

        break;
      case '3':
        $datosPreguntas .= PintarPreguntasTipoMultipleConUnicaRespuesta($pregunta, $id, $datosformulario, $idrol);
        break;
      case '4':
        $datosPreguntas .= PintarPeguntaTipoTEXTO($pregunta, 2);
        break;
      case '5':
        $datosPreguntas .= PintarPeguntaTipoUbicacion($pregunta);
        break;
      case '6':
        $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormulario($id, $pregunta->idPreguntaFormulario, $datosformulario->version, $idrol);
        $datosPreguntas .= Creaciongrupos($pregunta, $datosOpcionesPregunta, $datosformulario, $idrol);
        break;
      case '7':
        $datosOpcionesPregunta = $opcionesPreguntaObj->OpcionesPreguntaPorIDFormulario($id, $pregunta->idPreguntaFormulario, $datosformulario->version, $idrol);
        $datosPreguntas .= pintarGrupoconBoton($pregunta, $datosOpcionesPregunta, $datosformulario, $idrol);
        break;

      default:
        # code...
        break;
    }
  }
  return $datosPreguntas;
}

function pintarGrupoconBoton($Pregunta, $opciones, $formulario, $idrol)
{
  $PreguntaFormularioObj = new PreguntaFormularioObj();


  $Preguntas = $PreguntaFormularioObj->getPreguntaPorId($formulario->idFormulario, $opciones->valor, $formulario->version, $idrol);
  $contformularios = '';
  $contformularios .= "<div class='inputPregunta' id='{$Pregunta->idPreguntaFormulario}' name='{$Pregunta->idTipoPreguntas}'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $Pregunta->orden_pregunta . '.' . $Pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";

  $contformularios .= "<div id='anadirGrupo$Pregunta->idPreguntaFormulario'>";
  $contformularios .= "</div >";

  $contformularios .= "<div style= 'margin-right: 49px;display: flex;'>";

  $contformularios .= "<label class='radio' style='padding-left: 20%;padding-right: 20%;'>  Quieres añadir mas respuesta</label>";

  $contformularios .= "<input class='button button-fill color-blue' type='button' value='+' style='width:48px;' onclick='AnadirGrupo(\"anadirGrupo$Pregunta->idPreguntaFormulario\",$opciones->valor,$formulario->idFormulario,\"$formulario->version\",$idrol,$Pregunta->idPreguntaFormulario)'>";

  $contformularios .= "<input class='button button-fill color-blue' type='button'  value = '-' style='width:48px;margin-left: 33px;'  onclick='eliminargrupo(\"anadirGrupo$Pregunta->idPreguntaFormulario\")'>";
  $contformularios .= "</div >";




  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  return $contformularios;
}
function getTiopcion($Preguntas, $id, $idPregunta)
{
  $datosPreguntas = '';
  foreach ($Preguntas as $pregunta) {

    switch ($pregunta->idTipoPreguntas) {
      case '1':
        $datosPreguntas .= opcioneText(1, $pregunta, $id, $idPregunta);

        break;
      case '4':
        $datosPreguntas .= opcioneText(2, $pregunta, $id, $idPregunta);
        break;
      default:
        # code...
        break;
    }
  }
  return $datosPreguntas;
}

function getGrupo($callback, $idparam, $opciones, $idformulario, $version, $idrol, $idPregunta)
{
  $PreguntaFormularioObj = new PreguntaFormularioObj();
  $Preguntas = $PreguntaFormularioObj->getPreguntaPorId($idformulario, $opciones, $version, $idrol);
  $data = '';
  $data .= "<div style='margin-bottom:10px;'>";
  $data .= getTiopcion($Preguntas, $idparam, $idPregunta);
  $data .= "</div>";
  $arr = array("success" => true, "opcion" => $data);

  echo $callback . '(' . json_encode($arr) . ');';
}

// function getimagen($callback, $id)
// {

//   $contformularios = '';
//   $contformularios .= "<div style='display:flex; align-items: center; justify-content:space-around;'>";
//   $contformularios .= "<div class='item-title'>Aguntar Foto</div>";
//   $contformularios .= "<a href='#' id='$id' class='btnPhotoAlbum' onclick=subifoto(\"$id\")><i class='f7-icons color-black'>cloud_upload</i></a>";
//   $contformularios .= "</div>";
//   $arr = array("success" => true, "opcion" => $contformularios);

//   echo $callback . '(' . json_encode($arr) . ');';
// }

function PreguntaImagen($Pregunta, $formulario, $idrol)
{

  $contformularios = '';
  $contformularios .= "<div class='inputPregunta' id='{$Pregunta->idPreguntaFormulario}' name='{$Pregunta->idTipoPreguntas}'>";
  $contformularios .= " <div class='list accordion-list'>";
  $contformularios .= "<ul>";
  $contformularios .= " <li class='accordion-item accordion-item-opened'>";
  $contformularios .= "<a href='' class='item-link item-content'>";
  $contformularios .= "<div class='item-inner'>";
  $contformularios .= "<div class='item-title' style='white-space: pre-line;'>";
  $contformularios .= "<label> " . $Pregunta->orden_pregunta . '.' . $Pregunta->pregunta . "";
  $contformularios .= "</label>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  $contformularios .= "</a>";
  $contformularios .= "<div class='accordion-item-content'>";


  //$contformularios .= "<div id='resultImages$Pregunta->idPreguntaFormulario'></div>";
  $contformularios .= "<div id='Img$Pregunta->idPreguntaFormulario' ></div>";
  $contformularios .= "<input type='text' id='idImg$Pregunta->idPreguntaFormulario' style='visibility:hidden;'  value='0' />  ";


  $contformularios .= "<div style='display:flex;justify-content:space-around;'>";
  // $contformularios .= "<input class='button button-fill color-blue' type='button' value='Agrgar imagen +' style='width:auto;' onclick=anadirImg('Img$Pregunta->idPreguntaFormulario')>";
  //$contformularios .= "<input class='button button-fill color-blue' type='button' value='Eliminar imagen +' style='width:auto;' onclick=eliminarimg('Img$Pregunta->idPreguntaFormulario')>";
  $contformularios .= "<div style='display:flex; align-items: center; justify-content:space-around;'>";
  $contformularios .= "<div class='item-title'>Aguntar Foto</div>";
  $contformularios .= "<a href='#'  class='btnPhotoAlbum' onclick=subifoto('Img$Pregunta->idPreguntaFormulario',$Pregunta->idPreguntaFormulario)><i class='f7-icons color-black'>cloud_upload</i></a>";
  $contformularios .= "</div>";







  $contformularios .= "</div>";


  $contformularios .= "</div>";
  $contformularios .= "</li>";
  $contformularios .= "</ul>";
  $contformularios .= "</div>";
  $contformularios .= "</div>";
  return $contformularios;
}

//guardar formulario
function generarFolio1()
{
  // Obtén la fecha actual
  $fecha = new DateTime();

  // Construye el folio utilizando la fecha y un número aleatorio
  $folio = 'F' .
    $fecha->format('YmdHis') .
    str_pad(mt_rand(1, 9999), 4, '0', STR_PAD_LEFT);

  return $folio;
}

function GuardarFormulariorespuesta($callback, $id, $respuesta, $idUser, $opcionesID, $folio)
{
  $FormularioRespuestaObj = new FormularioRespuestaObj();
  // validacion si el id opciones de la respuesta es un array o no.
  if (is_array($opcionesID)) {
    $idOpciones = json_encode($opcionesID);
  } else {
    $idOpciones = $opcionesID;
  }
  if (is_array($respuesta)) {
    $text = json_encode($respuesta);
  } else {
    $text = $respuesta;
  }

  // validacíon del folio si no tiene nada la variable folio entonces generamos uno folio.
  // si en el caso de que este lleno vamos a verificar si es una insercion a la bd o actualizacíon.
  if ($folio == null) {
    // insertar primera pregunta sin folio sin registar
    $folio = generarFolio1();
    $resul = guardarPregunta($id, $text, $folio, $idUser, $idOpciones);
  } else {
    // verificamos si la pregunta ya esta en la bd para actualizar o insertar
    $up = $FormularioRespuestaObj->verificarOBJ($id, $folio);
    if ($up->idRespuestaPregunta > 0) {
      // actualizar pregunta ya en base de datos
      $idPreguntaUP = $up->idRespuestaPregunta;
      $actualizado = ActualizarRespuestaFormulario($idPreguntaUP, $id, $text, $idUser, $idOpciones, $folio);
      $resul = $actualizado[0];
    } else {
      // insertal nueva pregunta con el folio ya creado
      $resul = guardarPregunta($id, $text, $folio, $idUser, $idOpciones);
    }
  }

  $arr = array("success" => true, "folioBD" => $resul);
  echo $callback . '(' . json_encode($arr) . ');';
}



function guardarPregunta($id, $respuesta, $folio, $idUser, $opcionesID)
{

  $FormularioRespuestaObj = new FormularioRespuestaObj();
  $FormularioRespuestaObj->idPreguntaFormulario = $id;
  $FormularioRespuestaObj->idUsuario = $idUser;
  $FormularioRespuestaObj->idOpcionPregunta = $opcionesID;
  $FormularioRespuestaObj->respuesta = $respuesta;
  $FormularioRespuestaObj->finalizado = 0;
  $FormularioRespuestaObj->folio = $folio;
  $FormularioRespuestaObj->GuardarRespuestaFormulario();
  $BDfolio = $FormularioRespuestaObj->__get('folio');
  //print_r($BDfolio);exit;
  return $BDfolio;
}

function ActualizarRespuestaFormulario($idRespuesta, $id, $respuesta, $idUser, $opcionesID, $folio)
{

  $FormularioRespuestaObj = new FormularioRespuestaObj();
  $FormularioRespuestaObj->idPreguntaFormulario = $id;
  $FormularioRespuestaObj->idUsuario = $idUser;
  $FormularioRespuestaObj->idOpcionPregunta = $opcionesID;
  $FormularioRespuestaObj->respuesta = $respuesta;
  $FormularioRespuestaObj->finalizado = 0;
  $FormularioRespuestaObj->folio = $folio;
  $FormularioRespuestaObj->idRespuestaPregunta = $idRespuesta;
  $Actualizado = $FormularioRespuestaObj->UpdateRespuesta();
  $BDfolio = $FormularioRespuestaObj->__get('folio');
  return [$BDfolio, $Actualizado];
}


function eliminarPreguntaRespuesta($callback, $idPregunta, $folio, $IdUser)
{
  $opcionesPreguntaObj = new opcionesPreguntaObj();
  $FormularioRespuestaObj = new FormularioRespuestaObj();
  if (isset($folio)) {
    $DATOS = $opcionesPreguntaObj->PorIDpregunta($idPregunta);
    foreach ($DATOS as $value) {
      $validar = $FormularioRespuestaObj->verificarOBJ($value->idPreguntaFormulario, $folio);
      // validacion si esta en la bd la respuesta
      if ($validar->idRespuestaPregunta > 0) {
        $Eliminar = $FormularioRespuestaObj->eliminmarRespuestaObj($validar->idRespuestaPregunta);
      }
    }
    if ($Eliminar == 1) {
      $arr = array("success" => true);
    } else {
      $arr = array("success" => false);
    }
  }

  echo $callback . '(' . json_encode($arr) . ');';
}

function contadorNotificaciones($callback, $idUsuario)
{
  $mensajesObj = new mensajesObj();

  $colMensajes = $mensajesObj->ObtTodosMensajes("", "", $idUsuario, 1);
  $contMsgNoLeidos = 0;

  if (count($colMensajes) > 0) {
    foreach ($colMensajes as $elemNot) {
      if ($elemNot->leido == 0) {
        $contMsgNoLeidos += 1;
      }
    }
  }
  $arr = array("success" => true, "msgNoLeidos" => $contMsgNoLeidos);

  echo $callback . '(' . json_encode($arr) . ');';
}

function getCatalogoBotonesLLaveros($callback)
{
  $catBotonesLlaveroObj = new catBotonesLlaveroObj();

  $botones = $catBotonesLlaveroObj->getCatBotonesLlaveros();

  $arr = array("success" => true, "botones" => $botones);

  echo $callback . '(' . json_encode($arr) . ');';
}

function datosPatrullero($callback, $id)
{
  // instancias de los obj de las base de datos
  $vehiculosObj = new vehiculosObj();
  $datos = $vehiculosObj->GetPorIDPatrullero($id);

  $arr = array("success" => true, "datosUsuarios" => $datos);
  echo $callback . '(' . json_encode($arr) . ');';
}

// metodo para buscar patrullero si el patrullero no acepta la peticion

function buscarPatrulleromasCercano($idAsignacion, $idPeticion)
{
  $historicoAsignadosObj = new historicoAsignadosObj();
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionesObj = new peticionesObj();



  $datosPeticion = $peticionesObj->PeticionesPorId($idPeticion);
  $datosAsignados = $historicoAsignadosObj->obtenerAsignacionPoridPeticion($idPeticion);
  $Patrulleros = $usuariosTurnoObj->MetodoParaPatrulleros();

  $usuariosAsignados = [];
  foreach ($datosAsignados as $datos) {
    $usuariosAsignados[] = $datos->idUsuarioTurno;
  }


  $patrullerosFiltrados = [];


  foreach ($Patrulleros as $patrullero) {
    if (!in_array($patrullero->idUserTurno, $usuariosAsignados)) {
      $patrullerosFiltrados[] = $patrullero;
    }
  }


  foreach ($patrullerosFiltrados as $key => $patrulleros) {
    $patrullerosFiltrados[$key]->distancia = calcularDistancias(
      $datosPeticion->latitud,
      $datosPeticion->longitud,
      $patrulleros->latitud,
      $patrulleros->longitud
    );
  }

  // Ordenar los patrulleros por la distancia (menor a mayor)
  usort($patrullerosFiltrados, function ($a, $b) {
    return $a->distancia <=> $b->distancia;
  });

  if (!empty($patrullerosFiltrados)) {
    $primerPatrullero = reset($patrullerosFiltrados); // Obtiene el primer elemento
    asignarPatrulleromas_Cercano($datosPeticion, $primerPatrullero);
  }
}


function calcularDistancias($lat1, $lon1, $lat2, $lon2)
{
  $radioTierra = 6371; // Radio de la tierra en kilómetros

  $dLat = deg2rad($lat2 - $lat1);
  $dLon = deg2rad($lon2 - $lon1);

  $a = sin($dLat / 2) * sin($dLat / 2) +
    cos(deg2rad($lat1)) * cos(deg2rad($lat2)) *
    sin($dLon / 2) * sin($dLon / 2);
  $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

  return $radioTierra * $c; // Retorna la distancia en kilómetros
}


function asignarPatrulleromas_Cercano($peticion, $vehiculo)
{
  $historicoAsignadosObj = new historicoAsignadosObj();
  $idPatrulla = $vehiculo->idUserTurno;
  //sleep(seconds: 5);
  // validar
  sleep(5);
  $validar = $historicoAsignadosObj->obtenerAsignacionPoridPeticionvalidar($peticion->idPeticion, $idPatrulla);

  if ($validar->idAsignacion == 0) {
    $historicoAsignadosObj = new historicoAsignadosObj();
    $historicoAsignadosObj->idUsuarioTurno = $idPatrulla;
    $historicoAsignadosObj->tipoAsignacion = "App";
    $historicoAsignadosObj->idPeticion = $peticion->idPeticion;
    $historicoAsignadosObj->GuardarAsignacionesPatrulla();
    sedMsjPatrulleroPeticion($idPatrulla);
    asignarUsuarioTurnoApp($idPatrulla, $peticion->idPeticion);
  } else {
    print_r("xd");
  }
  // $historicoAsignadosObj = new historicoAsignadosObj();
  // $historicoAsignadosObj->idUsuarioTurno = $idPatrulla;
  // $historicoAsignadosObj->tipoAsignacion = "App";
  // $historicoAsignadosObj->idPeticion = $peticion->idPeticion;
  // $historicoAsignadosObj->GuardarAsignacionesPatrulla();
  // sedMsjPatrulleroPeticion($idPatrulla);
  // asignarUsuarioTurnoApp($idPatrulla, $peticion->idPeticion);
}

function EnviarmsjComite($datos)
{
  $dtUsrObj = new datosUsuarioObj();
  $usr = $dtUsrObj->obtDatosUsuarioPorUsuarioId($datos->idUsuario);

  $usrsComite = $dtUsrObj->getMiembrosComite($usr->idComite);

  foreach ($usrsComite as $usrComite) {
    if ($usrComite->usuarioId != $datos->idUsuario) {
      //Enviamos los datos de cada usuario para enviar notificacion
      $tituloNoti = "Alarma encendida!";
      $mensajeNoti = "Hola " . $usrComite->nombre . " tu vecino " . $usr->nombre . " ha activado la alarma";
      enviarPushACliente($usrComite->usuarioId, $tituloNoti, $mensajeNoti, 1, $datos->idUsuario, 0);
    }
  }
}


function enviarPushAClienteMonitor($idUsuario, $titulo, $mensajeCompleto, $tipo, $creador, $idRpt = 0, $tipodeMendaje)
{

  $msgObj = new mensajesObj();
  $regDispObj = new registroDispositivo();
  $resPush = "";
  if ($idUsuario > 0) {
    //>>>Logica para mandar un push al cliente<<<
    //obtener el id del dispositivo
    $regDispObj->usuarioId = $idUsuario;
    $colRegDisp = $regDispObj->obtTodosRegDispositivoPorIdUsr();
    //Si existe registro de dispositivo enviar push
    if (count($colRegDisp) > 0) {
      //Salvar el mensaje
      $msjTitulo = $titulo;
      $msjCompleto = $mensajeCompleto;
      $msgObj->usuarioId = $idUsuario;
      $msgObj->leido = 0;
      $msgObj->mostrar = 1;
      $msgObj->titulo = $msjTitulo;
      $msgObj->contenido = $msjCompleto;
      $msgObj->idConcepto = $tipo;
      $msgObj->idReporte = $idRpt;
      $msgObj->idUserEnviado = $creador;
      $msgObj->idTipoMensaje = $tipodeMendaje;
      $msgObj->GuardarMensajesObj();

      if ($tipodeMendaje == 5) {
        $imagen = 'https://dev.saitehuacan.com/images/720x480px.png';
      } elseif ($tipodeMendaje == 6) {
        $imagen = 'https://dev.saitehuacan.com/images/720x480px.png';
      }

      //Recorrer cada registro de dispositivo
      foreach ($colRegDisp as $elemReg) {
        //Checar la plataforma
        //Envio a web
        if ($elemReg->plataforma == 2) {
          $resPush = $regDispObj->gcmSend($elemReg->idRegDispositivo, $mensajeCompleto, $msjTitulo, 'web', $imagen);
        }

        return $resPush;
      }
    }
  }
}


// metodo para insertar y enviar push ala monitolista 
function enviarPushMonitor($callback, $idUser, $permisosApp)
{
  $permisosUsuarioPatrulleroOBJ = new permisosUsuarioPatrulleroOBJ();
  $usuariosObj = new usuariosObj();
  $idRol = '19,20';

  // datos user 
  $datosUser = $usuariosObj->UserByID($idUser);

  $permisosUsuarioPatrulleroOBJ->usuarioid = $idUser;
  $permisosUsuarioPatrulleroOBJ->datosPermiso = $permisosApp;
  $permisosUsuarioPatrulleroOBJ->InserData();
  

  if ($permisosUsuarioPatrulleroOBJ->idPemisoUP > 0) {
    $usuariosID = $usuariosObj->TraerUsuariosPorIdRol($idRol);
    foreach( $usuariosID as $user )
    {
      $tituloNoti = "Aviso importante";
      $mensajeNoti ="El patrullero  ".$datosUser->nombre."  ha desactivado su GPS. Confirma su estado actual.";
      enviarPushAClienteMonitor($user->idUsuario, $tituloNoti, $mensajeNoti, 1, $idUser, 0, 5);
    }
  }
}
// FUNNCION PARA ENVIAR PUSH AL MONITOR REUTILIZABLE
function gestionarPushMonitor($idUser,$tipo){
  // instancias 
  $usuariosObj = new usuariosObj();
  $catConfiguracionesObj  = new catConfiguracionesObj();
  // datos user 
  $datosUser = $usuariosObj->UserByID($idUser);
  // switch para poder taer los roles y los usuarios que se le va enviar notificacion push
  switch ($tipo) {
    case '1':// Fuera de linea push
      // obtener roles
      $datos = $catConfiguracionesObj->ObtConfiguracionByID(10);
      $idRol = $datos-> valor;
      // obtener todos los usuarios
      $usuariosID = $usuariosObj->TraerUsuariosPorIdRol($idRol);
      // mensaje para la push que se va haber en el monitor
      $tituloNoti = "Aviso importante";
      $mensajeNoti = "El patrullero " . $datosUser->nombre . " se ha quedado sin señal. Confirma su estado actual.";
      $tipodeMendaje = 6;
      break;
    default:
      # code...
      break;
  }
  foreach( $usuariosID as $user )
  {
    enviarPushAClienteMonitor($user->idUsuario, $tituloNoti, $mensajeNoti, 1, $idUser, 0, $tipodeMendaje);
  }
}