<?php
/*
 *  © 2012 Framelova. All rights reserved. Privacy Policy
 *  Creado: 27/10/2015
 *  Por: Jonathan Guerrero Pérez - JGP
 *  Descripción: Companies Object
 */
$pathDB = 'database/';
$pathComm = 'brules/';

if(file_exists('../database/CompanyDB.php')){
    $pathDB = '../database/';
    $pathComm = '../brules/';
}

// require_once $pathComm."KoolControls/KoolGrid/koolgrid.php";
// require_once $pathComm."KoolControls/KoolAjax/koolajax.php";
// require_once $pathComm."KoolControls/KoolUploader/kooluploader.php";
// include_once $pathComm.'KoolControls/KoolGrid/ext/datasources/MySQLiDataSource.php';
include_once $pathDB.'CompanyDB.php';

class Company{
    
    //Private Fields
    private $_idCompany = 0; 
    private $_name = '';
    private $_logo = '';    
    
    //Get set Methods
    // <editor-fold desc="getters and setters">
    public function setIDCompany($value)
    {$this->_idCompany = $value;}
    public function getIDCompany()
    {return $this->_idCompany;}
    
    public function setName($value)
    {$this->_name = $value;}
    public function getName()
    {return $this->_name;}   

    public function setLogo($value)
    {$this->_logo = $value;}
    public function getLogo()
    {return $this->_logo;}      
        
    // </editor-fold>
        
    //Get the Operator grid
    public function GetCompaniesGrid(){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection(); 
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new CompanyDB();
        $ds = $uDB->CompanyDataSet($ds);
        $grid = new KoolGrid("companiesGrid");
        
        $this->defineGrid($grid, $ds);
        
        $this->defineColumn($grid, "idCompany", "Id Empresa", false, true);
        $this->defineColumn($grid, "name", "Nombre", true, false, 1);        
        $this->defineColumn($grid, "logo", "Logo", true, false, 0);        
        $this->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();
        
        return $grid;
    }
    
    //Private Functions
    private function defineGrid($grid, $ds)
    {
        //create and define grid		
        $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
        $grid->styleFolder="default";
        $grid->Width = "760px";
        
        $grid->RowAlternative = true;
        $grid->AjaxEnabled = true;		
        $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
        $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");	

        $grid->AllowInserting = true;		
        $grid->AllowEditing = true;
        $grid->AllowDeleting = true;		
        $grid->AllowSorting = true;
        $grid->ColumnWrap = true;

        $grid->MasterTable->DataSource = $ds;		
        $grid->MasterTable->AutoGenerateColumns = false;			
        $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();
        
        //Show Function Panel
	    $grid->MasterTable->ShowFunctionPanel = true;
    	//Insert Settings
    	$grid->MasterTable->InsertSettings->Mode = "Form";
        $grid->MasterTable->EditSettings->Mode = "form";
        //$grid->MasterTable->EditSettings->InputFocus = "HideGrid";
        $grid->MasterTable->EditSettings->Mode = "Form";
	    $grid->MasterTable->InsertSettings->ColumnNumber = 1;        
    }
    
     //define the grid columns    
    private function defineColumn($grid, $name_field, $name_header, $visible=true, $read_only, $validator=0)
    {        
        if ($name_field == 'logo') {
            $kul = new KoolUploader('');
            $kul->width = "50px";
            $kul->height = "50px";
            echo $kul->RegisterScript(false);
            $column = new GridFileColumn();                                    
            $column->AllowedExtension = "jpg,png";
            $column->BaseDirectory = '../uploads/imgLogoCustomer';
            $column->IdColumn = 'idCompany';
//            $column->MultipleUpload = false;
            $column->AllowDelete = true;            
            $kulhandle = new KoolUploadHandler();
            $kulhandle->allowedExtension = "jpg,png";
            $kulhandle->allowDelete = true;
            echo $kulhandle->handleUpload();
        }
        else{        
            $column = new gridboundcolumn();    
        }         
                
        if($validator > 0)
            $column->addvalidator($this->GetValidator ($validator));

        
        $column->DataField = $name_field;
        $column->HeaderText = $name_header;
        $column->ReadOnly = $read_only;
        $column->Visible = $visible;
        $grid->MasterTable->AddColumn($column);
    }
    
    private function GetValidator($type){
        
        switch ($type) {
            case 1: //required
                $validator = new RequiredFieldValidator();
                $validator->ErrorMessage = "Campo requerido";
                return $validator;
                break;
        }
    }
    
    private function defineColumnEdit($grid)
    {
        $column = new grideditdeletecolumn();
        $column->Align = "center";
        $column->HeaderText = "Acciones";
        $grid->MasterTable->AddColumn($column);	        
    }
    
    
    /**
    * GetAllCompanies
    * Get all the companies into the Database
    * 
    * @return An array with period objects
    */
    public function GetAllCompanies(){
        $arrRes = array();
        $objDS = new CompanyDB();
        
        $result = $objDS->GetAllCompanies();
        
                
        if ($result)
        {
            while($myRows = mysqli_fetch_array($result)) 
            {
                $tmp = new Company();
                $tmp->setIDCompany($myRows['idCompany']);
                $tmp->setName($myRows['name']);
                                
                $arrRes[$tmp->getIDCompany()] = $tmp;
                
            }
        }
        
        return $arrRes;
    }
         

    //obtener datos del cliente por su id (company = cliente)
    public function CompanyById($idCustomer){
        $objDS = new CompanyDB();
        
        $result = $objDS->CompanyById($idCustomer);
        
                
        if ($result)
        {           
            $myRows = mysqli_fetch_array($result);
            if($myRows == false) return;

            $this->_idCompany = $myRows['idCompany'];                                                
            $this->_name = $myRows['name'];
            $this->_logo = $myRows['logo'];            
        }               
    }


}
?>
