<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/catComiteDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class catComiteObj extends configuracionesGridObj {
    private $_idComite = 0;
    private $_nombre = '';

    private $_mostrar = 0;

    //get y set
    public function __get($name) {             
        return $this->{"_".$name};
    }
    public function __set($name, $value) {        
        $this->{"_".$name} = $value;
    }

    public function ComitePorId($id){
        $ds = new catComiteBD();
        $obj = new catComiteObj();
        $datosBD = new datosBD();
        $result = $ds->ComitePorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de roles
    public function GetAllComites($mostrar = ""){
        $array = array();
        $ds = new catComiteBD();
        $datosBD = new datosBD();
        $result = $ds->GetAllComites($mostrar);
        $array = $datosBD->arrDatosObj($result);     
        return $array;            
    }

    public function GetComitesGrid($mostrar = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new catComiteBD();
        $ds = $uDB->ComitesDataSet($ds, $mostrar);
        $grid = new KoolGrid("comites");
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idComite", "ID", true, true);
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1, "");
        $configGrid->defineColumn($grid, "mostrar", "Mostrar en app", true, false, 0, "");
        

        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    /* mtodo para obtener solo los comites que tienen una alarma asociada */
    public function getComitesConAlarma() {
        $catComiteDB = new catComiteBD();
        $dtsDB = new datosBD();

        $result = $catComiteDB->getComitesConAlarmaDB();
        $data = $dtsDB->arrDatosObj($result);   

        return $data;
    }

}
