<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/catTelefonosEmergenciaDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class catTelefonosEmergenciaObj extends configuracionesGridObj {
    private $_idEmergencia = 0;
    private $_nombre = '';
    private $_telefono = '';
    private $_urlImg = '';
    private $_activo =  0;
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_idUsuarioCmb = 0;
    private $_fechaUltCambio = '0000-00-00 00:00:00';
    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de CatTelefonosEmergencias
    public function GetAllCatTelefonosEmergencia($activo=-1){
        $array = array();
        $ds = new catTelefonosEmergenciaDB();
        $datosBD = new datosBD();

        $result = $ds->GetallCatTelefonosEmergencia($activo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener CatTelefonosEmergencias por su id
    public function obtenerCatTelefonosEmergenciaById($id){
        $ds = new catTelefonosEmergenciaDB();
        $datosBD = new datosBD();
        $obj = new catTelefonosEmergenciaObj();
        $result = $ds->obtenerCatTelefonosEmergenciaById($id);

        return $datosBD->setDatos($result,$obj);
    }
    // guardar CatTelefonosEmergencias
    public function GuardarCatTelefonosEmergencia(){
        $objDB = new catTelefonosEmergenciaDB();
        return $this->_idDatoUsuario = $objDB->insertCatTelefonosEmergenciaDB($this->getParams());
    }
    //Eliminar CatTelefonosEmergencias
    public function EliminarCatTelefonosEmergencia($idDatoUsuario)
    {
        $objDB = new catTelefonosEmergenciaDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deleteCatTelefonosEmergenciaDB($param);
    }
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new catTelefonosEmergenciaDB();
        $resAct = $objDB->updateTelefonosEmergenciaCampoDB($param);
        return $resAct;
    }

    private function getParams($ctr=false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;
        $this->_fechaUltCambio = $dateTime;

        $param[0] = $this->_nombre;
        $param[1] = $this->_telefono;
        $param[2] = $this->_urlImg;
        $param[3] = $this->_activo;
        $param[4] = $this->_idUsuarioCmb;
        return $param;
    }

    public function GetTelefonosEmergneciaGrid(){
       $DataServices = new DataServices();
       $dbConn = $DataServices->getConnection();
       $ds = new MySQLiDataSource($dbConn);
       $uDB = new catTelefonosEmergenciaDB();
       $ds = $uDB->telefonoEmergenciaDataSet($ds);
       $grid = new KoolGrid("telefonosEmergenciaGrid");
       $configGrid = new configuracionesGridObj();

       $configGrid->defineGrid($grid, $ds);
       $configGrid->defineColumn($grid, "idEmergencia", "ID", false, true);
       $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1, "");
       $configGrid->defineColumn($grid, "telefono", "Telefono", true, false, 1, "TEL");
       $configGrid->defineColumn($grid, "tipoTel", "Tipo de telefono", true, true, 1, "");
       $configGrid->defineColumn($grid, "tipoTelefono", "Tipo de telefono", false, false, 1, "");
       $configGrid->defineColumn($grid, "activo", "Activo", false, true, 1, "");
       $configGrid->defineColumnEdit($grid);

       //pocess grid
       $grid->Process();

       return $grid;
    }
}
