<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/coordenadasVehiculoDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class coordenadasVehiculoObj  extends configuracionesGridObj{
    private $_idCoordenadas = 0;
    private $_vehiculoId = 0;
    private $_registroId = 0;
    private $_latitud = '';
    private $_longitud = '';    


    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function CoordenadasVehiculoPorId($id){
        $ds = new coordenadasVehiculoDB();
        $obj = new coordenadasVehiculoObj();
        $datosBD = new datosBD();
        $result = $ds->CoordenadasVehiculoPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtCoordenadasVehiculo($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new coordenadasVehiculoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtCoordenadasVehiculoDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosCoordenadasVehiculo($empresaId = ""){
        $array = array();
        $ds = new coordenadasVehiculoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosCoordenadasVehiculoDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCampoPeticionCoordendas($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new coordenadasVehiculoDB();
        $resAct = $objDB->updateCampoCoordenadasVehiculoBD($param);
        return $resAct;
    }

    public function GuardarCoordenadasVehiculo(){
        $objDB = new coordenadasVehiculoDB();
        $this->_idCoordenadas = $objDB->insertCoordenadasVehiculoBD($this->getParams());
    }

    public function ActualizarCoordenadasVehiculo(){
        $objDB = new coordenadasVehiculoBD();
        $this->_idVenta = $objDB->updateCoordenadasVehiculoBD($this->getParams(true));
    }

    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_latitud;
        $param[1] = $this->_longitud;

        if($update){//UPDATE
            $param[2] = $this->_idCoordendas;
        }else{//INSERT
            $param[2] = $this->_vehiculoId;
            $param[3] = $this->_registroId;
        }

        return $param;
    }

    //Grid personal
     public function ObtCoordenadasVehiculoGrid($usuarioId = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new coordenadasVehiculoDB();
        $ds = $uDB->CoordenadasVehiculoDataSet($ds, $usuarioId);
        $grid = new KoolGrid("CoordenadasVehiculoGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idPeticion", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    //Private Functions
    public function CoordenadasVehiculoPorIdVehiculo($id){                        
        $ds = new coordenadasVehiculoDB();        
        $obj = new coordenadasVehiculoObj();        
        $datosBD = new datosBD();
        $result = $ds->CoordenadasVehiculoPorIdVehiculoDB($id);
                
        return $datosBD->setDatos($result, $obj);
    }


    public function GuardarCoordenadasAlarma($vehiculoId, $registroId, $latitud, $longitud){
        $objDB = new coordenadasVehiculoDB();

        $param[0] = $vehiculoId;
        $param[1] = $registroId;
        $param[2] = $latitud;
        $param[3] = $longitud;


        $this->_idCoordenadas = $objDB->insertCoordenadasVehiculoBD($param);
    }
}
