<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/datosUsuarioDB.php';
include_once  $dirname.'/database/datosBD.php';

class datosUsuarioObj {
    private $_idDatoUsuario = 0;
    private $_usuarioId = 0;
    private $_clave = '';
    private $_nombre = '';
    private $_aPaterno = '';
    private $_aMaterno = '';
    private $_telefono = '';
    private $_calle = '';
    private $_numero = '';
    private $_colonia = '';
    private $_cp = '';
    private $_numComite = '';
    private $_fechaCreacion = '';
    private $_fechaAct = '';
    private $_urlFoto = '';
    private $_idComite = '';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de datosUsuarios
    public function GetAllDatosUsuario(){
        $array = array();
        $ds = new datosUsuarioDB();
        $datosBD = new datosBD();
        $result = $ds->GetallDatosUsuario();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener datosUsuarios por su id
    public function obtenerDatosUsuarioById($id){
        $ds = new datosUsuarioDB();
        $obj = new datosUsuarioObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerDatosUsuarioById($id);

        return $datosBD->setDatos($result,$obj);
    }

    //Obtener datos del usuario por su usuario id
    public function obtDatosUsuarioPorUsuarioId($id){
        $ds = new datosUsuarioDB();
        $obj = new datosUsuarioObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosUsuarioPorUsuarioIdDB($id);

        return $datosBD->setDatos($result,$obj);
    }
    

    // guardar datosUsuarios
    public function GuardarDatosUsuario(){
        $objDB = new datosUsuarioDB();
        return $this->_idDatoUsuario = $objDB->insertdatosUsuarioDB($this->getParams());
    }

    // guardar datosUsuarios
    public function GuardarDatosUsuarioCidadanoPie($params){
        $objDB = new datosUsuarioDB();
        return $this->_idDatoUsuario = $objDB->insertdatosUsuarioCiudadanoPieDB($params);
    }
    
    //Eliminar datosUsuarios
    public function EliminarDatosUsuario($idDatoUsuario)
    {
        $objDB = new datosUsuarioDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deletedatosUsuarioDB($param);
    }
    public function actDatoUsuarioPorCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new datosUsuarioDB();
        $resAct = $objDB->actDatoUsuarioPorCampoDB($param);
        return $resAct;
    }
    public function actDatoUsuarioCampoPorUsuarioId($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new datosUsuarioDB();
        $resAct = $objDB->actDatoUsuarioCampoPorUsuarioIdDB($param);
        return $resAct;
    }

    private function getParams($ctr=false){   
        $dateByZone = obtDateTimeZone();        
        $this->_fechaCreacion = $dateByZone->fechaHora;        

        $param[0] = $this->_usuarioId;
        $param[1] = $this->_clave;
        $param[2] = $this->_nombre;
        $param[3] = $this->_aPaterno;
        $param[4] = $this->_aMaterno;
        $param[5] = $this->_telefono;    
        $param[6] = $this->_calle;
        $param[7] = $this->_numero;
        $param[8] = $this->_colonia;
        $param[9] = $this->_cp;
        $param[10] = $this->_numComite;
        $param[11] = ($this->_idComite > 0 && is_numeric($this->_idComite))?$this->_idComite:13;
        $param[12] = $this->_fechaCreacion;

        return $param;
    }

    public function getMiembrosComite($idComite){
        $ds = new datosUsuarioDB();
        $obj = new datosUsuarioObj();
        $datosBD = new datosBD();
        $result = $ds->getMiembrosComiteDB($idComite);
        $array = $datosBD->arrDatosObj($result);
        return $array;
        //return $datosBD->setDatos($result,$obj);
    }
}
