<?php
$dirname = dirname(__DIR__);
include_once  $dirname . '/database/datosBD.php';
include_once  $dirname . '/database/histoUbicacionDB.php';
include_once  $dirname . '/brules/configuracionesGridObj.php';

class histoUbicacionObj  extends configuracionesGridObj
{
    private $_idUbi = 0;
    private $_peticionId = 0;
    private $_usuarioId = 0;
    private $_longitud = 0;
    private $_latitud = 0;
    private $_fechaHCreacion = '0000-00-00 00:00:00';



    public function __get($name)
    {

        return $this->{"_" . $name};
    }

    public function __set($name, $value)
    {

        $this->{"_" . $name} = $value;
    }

    public function GuardarUbicacion()
    {
        $objDB = new histoUbicacionDB();
        $this->_idUbi = $objDB->insertHistoubi($this->getParams());
    }
   
    private function getParams($update = false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaHCreacion = $dateTime;



        $param[0] = $this->_peticionId;
        $param[1] = $this->_usuarioId;
        $param[2] = $this->_latitud;;
        $param[3] = $this->_longitud;
        $param[4] = $this->_fechaHCreacion;


        return $param;
    }


    public function obtenerHistoricoUbicacion($idpeti){
        
        $array = array();
        $ds = new histoUbicacionDB();
        $datosBD = new datosBD();
       
        $result = $ds->historicoubicacion($idpeti);
        $array = $datosBD->arrDatosObj($result);
        return $array;

        
    }
}
