<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/historialDesconexionInternetDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class historialDesconexionInternetObj {
    private $_idDesconexion = 0;
    private $_fechaHoraDesconexion = "";
    private $_fechaHoraNuevaConexion = "";
    private $_tiempoDesconexion = "";
    private $_idUsuarioTurno = "";
    private $_idPeticion = "";
    private $_idAsignado = "";
    private $_idInicioSesion = "";

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function historialDesconexionesPorIdPeticion($idPeticion){
        $ds = new historialDesconexionInternetDB();
        $obj = new historialDesconexionInternetObj();
        $datosBD = new datosBD();
        $result = $ds->historialDesconexionesPorIdPeticionDB($idPeticion);

        return $datosBD->setDatos($result, $obj);
    }

    public function ActualizarCampoHistorialDesconexiones($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new historialDesconexionInternetDB();
        $resAct = $objDB->updateCampoHistorialDesconexionesBD($param);
        return $resAct;
    }

    public function arregloDesconexionesPorIdPeticion($idPeticion){
        $array = array();
        $ds = new historialDesconexionInternetDB();
        $obj = new historialDesconexionInternetObj();
        $datosBD = new datosBD();

        $result = $ds->arregloDesconexiones($idPeticion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function GuardarHistorialDesconexiones(){
        $objDB = new historialDesconexionInternetDB();
        $this->_idDesconexion = $objDB->insertHistorialDesconexionesBD($this->getParams());
    }

    private function getParams($update = false){
        $param[0] = $this->_fechaHoraDesconexion;
        $param[1] = $this->_fechaHoraNuevaConexion;
        $param[2] = $this->_tiempoDesconexion;
        $param[3] = $this->_idUsuarioTurno;
        $param[4] = $this->_idPeticion;
        $param[5] = $this->_idAsignado;
        $param[6] = $this->_idInicioSesion;
        return $param;
    }

    public function obtTodosDesconexionesSesion($idInicioSesion){
        $array = array();
        $ds = new historialDesconexionInternetDB();
        $datosBD = new datosBD();
        $result = $ds->obtTodosDesconexionesSesionDB($idInicioSesion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function obtTodosDesconexionesAsignacion($idAsignado){
        $array = array();
        $ds = new historialDesconexionInternetDB();
        $datosBD = new datosBD();
        $result = $ds->obtTodosDesconexionesAsignacionDB($idAsignado);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
}
