<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/historialPrimerSegundoPlanoDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class historialPrimerSegundoPlanoObj {
    private $_idhistorialplanos = 0;
    private $_fechaHora1plano = "";
    private $_fechaHora2plano = "";
    private $_tiempoActivo = "";
    private $_idUsuarioTurno = "";
    private $_idPeticion = "";
    private $_idAsignado = "";
    private $_idInicioSesion = "";
    private $_peticionesObtenidas = "";
    private $_asignacionesObtenidas = "";

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function ActualizarCampoHistorialPrimerSegundoPlano($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new historialPrimerSegundoPlanoDB();
        $resAct = $objDB->updateCampoHistorialPrimerSegundoPlanoBD($param);
        return $resAct;
    }

    public function GuardarHistorialPrimerSegundoPlano(){
        $objDB = new historialPrimerSegundoPlanoDB();
        $this->_idhistorialplanos = $objDB->insertHistorialPrimerSegundoPlanoBD($this->getParams());
    }

    private function getParams($update = false){
        $param[0] = $this->_fechaHora1plano;
        $param[1] = $this->_fechaHora2plano;
        $param[2] = $this->_tiempoActivo;
        $param[3] = $this->_idUsuarioTurno;
        $param[4] = $this->_idPeticion;
        $param[5] = $this->_idAsignado;
        $param[6] = $this->_idInicioSesion;
        $param[7] = $this->_peticionesObtenidas;
        $param[8] = $this->_asignacionesObtenidas;
        return $param;
    }


    public function obtHistorialPlanosByIdAsignacion($idAsignacion){
        $ds = new historialPrimerSegundoPlanoDB();
        $obj = new historialPrimerSegundoPlanoObj ();
        $datosBD = new datosBD();
        $result = $ds->obtHistorialPlanosByIdAsignacionBD($idAsignacion);

        return $datosBD->setDatos($result, $obj);
    }

    public function obtTodosPlanosPorAsignacion($idAsignacion){
        $array = array();
        $ds = new historialPrimerSegundoPlanoDB();
        $datosBD = new datosBD();
        $result = $ds->obtTodosPlanosPorAsignacionDB($idAsignacion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function obtRegistros1PlanoPorSesion($idInicioSesion){
        $array = array();
        $ds = new historialPrimerSegundoPlanoDB();
        $datosBD = new datosBD();
        $result = $ds->obtRegistros1PlanoPorSesionDB($idInicioSesion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    
}
