<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/historicoAsignadosBD.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';


class historicoAsignadosObj extends configuracionesGridObj {
    private $_idAsignacion = 0;
    private $_idUsuarioTurno = '';
    private $_fechaHoraCreacionAsignacion = "";
    private $_fechaHoraNotificacion = "";
    private $_tipoAsignacion = "";
    private $_asignacionAceptada = "";
    private $_fechaHoraAceptacionNegacion = "";
    private $_idPeticion = "";


    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function historicoAsignacionesPorIdPeticion($idPeticion){
        $ds = new historicoAsignadosDB();
        $obj = new historicoAsignadosObj();
        $datosBD = new datosBD();
        $result = $ds->historicoAsignacionesPorIdPeticionDB($idPeticion);

        return $datosBD->setDatos($result, $obj);
    }

    public function obtReportesSinFinalizar($idUserTurno){
        $array = array();
        $ds = new historicoAsignadosDB();
        $obj = new historicoAsignadosObj();
        $datosBD = new datosBD();
        $result = $ds->obtReportesSinFinalizarBD($idUserTurno);
        $array = $datosBD->arrDatosObj($result);

        return $array;
    }

    public function obtDatosAsignadoById($idAsignacion){
        $ds = new historicoAsignadosDB();
        $obj = new historicoAsignadosObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosAsignadoByIdBD($idAsignacion);

        return $datosBD->setDatos($result, $obj);
    }

    public function ActualizarCampohistoricoAsignaciones($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new historicoAsignadosDB();
        $resAct = $objDB->updateCampohistoricoAsignacionesBD($param);
        return $resAct;
    }

    public function ActualizarHoraRespuestaAsignaciones($campo, $id){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual

        $param[0] = $campo;
        $param[1] = $dateTime;
        $param[2] = $id;

        $objDB = new historicoAsignadosDB();
        $resAct = $objDB->updateCampohistoricoAsignacionesBD($param);
        return $resAct;
    }

    public function peticionesRechazadas($idPeticion){
        $array = array();
        $ds = new historicoAsignadosDB();
        $obj = new historicoAsignadosObj();
        $datosBD = new datosBD();

        $result = $ds->rechazosPatrullaBD($idPeticion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function GetAllAsignadosByDateGrid($date='', $dateFin=''){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        if($date == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $date=$today['year']."-".$mon."-".$today['mday'];
        }

        if($dateFin == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $dateFin=$today['year']."-".$mon."-".$today['mday'];
        }

        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new historicoAsignadosDB();
        $ds = $uDB->AsignadosByDateDataSet($ds, $date, $dateFin, 1);
        $grid = new KoolGrid("peticiones_patrulleros");
        $configGrid = new configuracionesGridObj();
        
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idAsignacion", "ID Asignaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "idPeticion", "Id Petici&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "tipoAsignacion", "Tipo de asignaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "descripcionDesasignacion", "Motivo de desasignaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "estatusAsignacionAceptada", "Estatus de asignaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "nombre", "Nombre del Patrullero", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "unidad", "Unidad", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "matricula", "Matricula", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraCreacionAsignacion", "Fecha de asignaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraNotificacion", "Fecha de lectura notificaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraAceptacionNegacion", "Fecha de respuesta a notificaci&oacute;n", true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "fechaHoraDesasignacion", "Fecha de desasignacion", true, true, 0, "", "auto");
        $configGrid->defineColumnReporteAsignacionPatrullero($grid);
        $configGrid->defineColumnChatPatrullero($grid);
        //pocess grid
        $grid->Process();

        return $grid;
    }

    public function GuardarAsignacionesPatrulla(){
        $objDB = new historicoAsignadosDB();
        $this->_idAsignacion = $objDB->insertAsignacionesPatrullaBD($this->getParams());
    }

    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaHoraCreacionAsignacion = $dateTime;

        $param[0] = $this->_idUsuarioTurno;
        $param[1] = $this->_fechaHoraCreacionAsignacion;
        $param[2] = $this->_tipoAsignacion;
        $param[3] = $this->_idPeticion;
        return $param;
    }

    public function obtTodosAsignacionesSesion($idInicioSesion){
        $array = array();
        $ds = new historicoAsignadosDB();
        $datosBD = new datosBD();
        $result = $ds->obtTodosAsignacionesSesionDB($idInicioSesion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    
    public function obtenerAsignacionPeticion($user,$fechaP,$fechaS,$idAsignacion = ""){
        $array = array();
        $ds = new historicoAsignadosDB();
        $datosBD = new datosBD();
        $result = $ds->obtenerAsignacionPeticionBD($user,$fechaP,$fechaS,$idAsignacion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function obtenerAsignacionPoridPeticion($id){
        $array = array();
        $ds = new historicoAsignadosDB();
        $datosBD = new datosBD();
        $result = $ds->obtenerAsignacionPoridPeticionBD($id);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
     
    //  validar 
    public function obtenerAsignacionPoridPeticionvalidar($id,$idVehiculo){
        $ds = new historicoAsignadosDB();
        $obj = new historicoAsignadosObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerAsignacionPoridPeticionvalidarBD($id,$idVehiculo);
        return $datosBD->setDatos($result, $obj);
    
    }

    public function obtenerAsignacionPoridPeticionSincontestar ($id){
        $ds = new historicoAsignadosDB();
        $obj = new historicoAsignadosObj();
        $datosBD = new datosBD();
        $result = $ds->obtenerAsignacionPoridPeticionSincontestarBD($id);
        return $datosBD->setDatos($result, $obj);
    }

}
