<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/historicosDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class historicosObj  extends configuracionesGridObj{
    private $_idHistoricoUT = 0;
    private $_jsonUserTurn = '';
    private $_tipoHist = 0;
    private $_fechaCreacion = '';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function HistoricosPorId($id){
        $ds = new historicosDB();
        $obj = new historicosObj();
        $datosBD = new datosBD();
        $result = $ds->HistoricosPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    public function HistoricosPorComite($id){
        $ds = new historicosDB();
        $obj = new historicosObj();
        $datosBD = new datosBD();
        $result = $ds->HistoricosPorComiteDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtHistoricos($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new historicosDB();
        $datosBD = new datosBD();
        $result = $ds->ObtHistoricosDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosHistoricos($tipoHist = "", $returnArray = false, $date='', $dateFin=''){
        $array = array();
        $ds = new historicosDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosHistoricosDB($tipoHist, $date, $dateFin);
        $array = ($returnArray)?$datosBD->arrDatos($result, "idHistoricoUT"):$datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCampoHistoricos($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new historicosDB();
        $resAct = $objDB->updateCampoHistoricoBD($param);
        return $resAct;
    }

    public function GuardarHistoricos(){
        $objDB = new historicosDB();
        $this->_idHistoricoUT = $objDB->insertHistoricoBD($this->getParams());
    }
    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_jsonUserTurn;
        $param[1] = $this->_tipoHist;
        $param[2] = $this->_fechaCreacion;

        return $param;
    }

    //Grid personal
     public function ObtHistoricosGrid($tipoHist = "", $date='', $dateFin =''){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        // $ds = new MySQLiDataSource($dbConn);
        $uDB = new historicosDB();
        // $ds = $uDB->HistoricosDataSet($ds, $tipoHist);
        $arr = $this->ObtTodosHistoricos($tipoHist, false, $date, $dateFin);
        //echo "<pre>";print_r($arr);echo "<pre>";
        $arrDs = array();
        
        if($tipoHist == 3){
            foreach ($arr as $item) {
                $arrJson = json_decode($item->jsonUserTurn);
                $arrDs[] = array("texto"=>$arrJson->texto, "fechaCreacion"=>convertirFechaVistaConHora($item->fechaCreacion));
            }
            $ds = new AdvancedArrayDataSource($arrDs);
            $grid = new KoolGrid("HistoricosGrid");
    
            $configGrid = new configuracionesGridObj();
    
            $configGrid->defineGrid($grid, $ds);
            $configGrid->defineColumn($grid, "texto", "Texto", true, false, 1, "800px");
            $configGrid->defineColumn($grid, "fechaCreacion", "fechaCreacion", true, false, 0, "100px");
        }
        elseif($tipoHist == 4){
            foreach ($arr as $item) {
                $arrJson = json_decode($item->jsonUserTurn);
                $arrDs[] = array("cuenta"=>$arrJson->cuenta, "tokenAnt"=>$arrJson->tokenAnt, "tokenNuevo"=>$arrJson->tokenNuevo, "fechaCreacion"=>convertirFechaVistaConHora($item->fechaCreacion));
            }
            $ds = new AdvancedArrayDataSource($arrDs);
            $grid = new KoolGrid("HistoricosGrid");
    
            $configGrid = new configuracionesGridObj();
    
            $configGrid->defineGrid($grid, $ds);
            $configGrid->defineColumn($grid, "cuenta", "Cuenta", true, false, 1);
            $configGrid->defineColumn($grid, "tokenAnt", "TokenAnt", true, false, 1);
            $configGrid->defineColumn($grid, "tokenNuevo", "TokenNuevo", true, false, 1);
            $configGrid->defineColumn($grid, "fechaCreacion", "fechaCreacion", true, false, 0, "100px");
        }
        // $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }

    public function ObtHistoricoEncendidoAlarmasGrid($fechaInicio = "", $fechaFin = "") {
        $arrDs = array();

        $arr = $this->ObtHistoricoEncendidoAlarmas($fechaInicio, $fechaFin);
        foreach ($arr as $item) {
            if($item->IdAlarmaJS != null && $item->IdAlarmaJS != "" && $item->IdAlarmaJS != 0){
                $arrDs[] = array(
                    "usuario" => $item->nombre, 
                    "alarma" => $item->matricula, 
                    "accion" => $item->accionJS, 
                    "idHistorico" => $item->idHistoricoUT, 
                    "fechaCreacion" => convertirFechaVistaConHora($item->fechaCreacion)
                );
            }
        }

        $ds = new AdvancedArrayDataSource($arrDs);
        $grid = new KoolGrid("HistoricosGrid");
        $configGrid = new configuracionesGridObj();
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idHistorico", "ID", false, true);
        $configGrid->defineColumn($grid, "usuario", "Usuario", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "alarma", "Alarma", true, false, 1);
        $configGrid->defineColumn($grid, "accion", "Accion", true, false, 1);
        $configGrid->defineColumn($grid, "fechaCreacion", "Fecha Creacion", true, false, 0);
        $grid->Process();
        
        return $grid;
    }

    public function ObtHistoricoEncendidoAlarmas($fechaInicio = "", $fechaFin = ""){
        $array = array();
        $ds = new historicosDB();
        $datosBD = new datosBD();

        $result = $ds->ObtHistoricoEncendidoAlarmasDB($fechaInicio, $fechaFin);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    
    //>>>>RHS>>>>
    public function ObtAlarmasGrid(){
        

        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new historicosDB();
        $ds = $uDB->HistoricosDataSet($ds);
        $grid = new KoolGrid("Alarmas");
        $configGrid = new configuracionesGridObj();
        
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idHistorico", "ID", true, true);
        $configGrid->defineColumn($grid, "matricula", "Nombre", true, false, 1, "");
        $configGrid->defineColumn($grid, "alarmaId", "Identificador", true, false, 1, "");
        $configGrid->defineColumn($grid, "latitud", "Latitud", true, false, 1, "");
        $configGrid->defineColumn($grid, "longitud", "Longitud", true, false, 1, "");                            
        $configGrid->defineColumn($grid, "idComite", "Comite", true, false, 1, "");   
        $configGrid->defineColumn($grid, "cuenta", "Cuenta", true, false, 1, "");                           
        

        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }

	//<<<<RHS<<<<
    

}
