<?php
$dirname = dirname(__DIR__);
include_once  $dirname . '/database/historicosPeticionesBD.php';
include_once  $dirname . '/database/datosBD.php';
include_once  $dirname . '/brules/configuracionesGridObj.php';


class  historicosPeticionesObj  extends configuracionesGridObj
{
    // Variable privadas
    private $_idhistorico  = 0;
    private $_idPeticion = 0;
    private $_idUserAtendido = 0;
    private $_fechaCreacion =  '0000-00-00 00:00:00';

    //get y set
    public function __get($name)
    {
        return $this->{"_" . $name};
    }
    public function __set($name, $value)
    {
        $this->{"_" . $name} = $value;
    }
    // funcion para ordenar y pasar datos 
    private function getParams()
    {

        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_idPeticion;
        $param[1] = $this->_idUserAtendido;
        $param[2] = $this->_fechaCreacion;

        return $param;
    }

    // insert a bd 
    public function insertBdHistoricoPeticiones()
    {
        $objDB = new historicosPeticionesBD();
        $this->_idhistorico = $objDB->insertBdHistoricoPeticionesBD($this->getParams());
    }

    public function obtenerPorIdPeticion($idPeticion) {
        $array = array();
        $ds = new historicosPeticionesBD();
        $datosBD = new datosBD();
        $result = $ds->obtenerPorIdPeticionBD($idPeticion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
}
