<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/peticionesDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';
include_once  $dirname.'/brules/catStatusComunicacionObj.php';

class peticionesObj  extends configuracionesGridObj{
    private $_idPeticion = 0; 
    private $_tipoPeticionId = '';
    private $_usuarioId = 0;
    private $_registroId = 0;
    private $_usuarioTurnoId = 0;
    private $_fechaCreacion = '';
    private $_usuarioOperadorId = 0;
    private $_fechaAsignacion = '';
    private $_fechaFinalizacion = '';
    private $_coordenadasInicio = '';
    private $_coordenadasFin = '';
    private $_estatusId = 0;
    private $_activo = 0;
    private $_tiempoAtendio = 0;
    private $_comiteUsuario = 0;
    
    private $_nombreUsuario="";
    private $_latitud="";
    private $_longitud="";
    private $_comentarios="";
    private $_nombreConductor; 
    private $_telefono="";
    private $_calle="";
    private $_numero="";
    private $_colonia="";
    private $_cp="";
    private $_numComite=0;
    private $_idComiteUsuario=0;
    private $_nombreComite=""; 

    private $_opcComite = 0;
    private $_cerradoEnApp = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function PeticionesPorId($id){
        $ds = new peticionesDB();
        $obj = new peticionesObj();
        $datosBD = new datosBD();
        $result = $ds->PeticionesPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    public function promedioAtencionPeticiones($fecha = ""){
        $ds = new peticionesDB();
        $obj = new peticionesObj();
        $datosBD = new datosBD();
        $result = $ds->promedioAtencionPeticionesDB($fecha);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtPeticiones($estatusId = "", $tipoPeticionId = "", $fecha = "", $hora = ""){
        $array = array();
        $ds = new peticionesDB();
        $datosBD = new datosBD();
        $result = $ds->ObtPeticionesDB($estatusId, $tipoPeticionId, $fecha, $hora);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosPeticiones($empresaId = ""){
        $array = array();
        $ds = new peticionesDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosPeticionesDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCampoPeticion($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = ($id > 0) ? $id : 0;

        $objDB = new peticionesDB();
        $resAct = $objDB->updateCampoPeticionBD($param);
        return $resAct;
    }

    public function ActualizarCampoPeticionEntero($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = ($id > 0)?$id:0;

        $objDB = new peticionesDB();
        $resAct = $objDB->updateCampoPeticionEnteroBD($param);
        return $resAct;
    }

    public function GuardarPeticion(){
        $objDB = new peticionesDB();
        $this->_idPeticion = $objDB->insertPeticionBD($this->getParams());
    }
    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_tipoPeticionId;
        $param[1] = $this->_usuarioId;
        $param[2] = $this->_registroId;
        $param[3] = $this->_coordenadasInicio;
        $param[4] = $this->_fechaCreacion;
        $param[5] = $this->_usuarioOperadorId;
        $param[6] = $this->_estatusId;
        $param[7] = $this->_activo;
        $param[8] = $this->_opcComite;
        $param[9] = $this->_comiteUsuario;

        return $param;
    }

    //Grid personal
     public function ObtPeticionesGrid($usuarioId = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new peticionesDB();
        $ds = $uDB->PeticionesDataSet($ds, $usuarioId);
        $grid = new KoolGrid("PeticionesGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idPeticion", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        // $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }
    //Private Functions

    public function ObtPeticionesUserBYEstatus($idUsuario, $estatusId){
        $obj = new peticionesObj();
        $objDB = new peticionesDB();
        $datosBD = new datosBD();
        $result = $objDB->ObtPeticionesUserBYEstatusDB($idUsuario, $estatusId);

        return $datosBD->setDatos($result, $obj);
    }
    public function obtDatosPorPeticion($idPeticion){
        $ds = new peticionesDB();
        $obj = new peticionesObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosPorPeticionDB($idPeticion);

        return $datosBD->setDatos($result, $obj);
    }
    public function PeticionesPorIdUsuarioEst($idTurno,$idEstatus){
        $ds = new peticionesDB();
        $obj = new peticionesObj();
        $datosBD = new datosBD();
        $result = $ds->PeticionesPorIdUsuarioEstDB($idTurno,$idEstatus);

        return $datosBD->setDatos($result, $obj);
    }
    public function PeticionesPorIdUsuarioEst2($idTurno,$idEstatus){
        $ds = new peticionesDB();
        $obj = new peticionesObj();
        $datosBD = new datosBD();
        $result = $ds->PeticionesPorIdUsuarioEstDB2($idTurno,$idEstatus);

        return $datosBD->setDatos($result, $obj);
    }

    // 19/03/2020 JAIR Nuevo metodo
    public function ObtPeticionesUserBYEstatus2($idUsuario, $estatusId){
        $obj = new peticionesObj();
        $objDB = new peticionesDB();
        $datosBD = new datosBD(); 
        $result = $objDB->ObtPeticionesUserBYEstatus2DB($idUsuario, $estatusId);

        return $datosBD->setDatos($result, $obj);
    }

     // 27/03/2020 JAIR Nuevo metodo
    public function ObtPeticionesUserBYCerradoApp($idUsuario, $cerrado){
        $obj = new peticionesObj();
        $objDB = new peticionesDB();
        $datosBD = new datosBD();
        $result = $objDB->ObtPeticionesUserBYCerradoAppDB($idUsuario, $cerrado);

        return $datosBD->setDatos($result, $obj);
    }

    public function DeletePeticionesPorIdUser($id){
        $ds = new peticionesDB();
        return $ds->DeletePeticionesPorIdUserDB($id);
    }

    public function GetAllPeticionesByDateGrid($date='', $dateFin=''){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        if($date == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $date=$today['year']."-".$mon."-".$today['mday'];
        }

        if($dateFin == ''){
            $today = getdate();
            $mon="";
            $day="";
            $year="";

            if($today['mon']<10){
                $mon="0".($today['mon']);
            }else{
                $mon=$today['mon'];
            }
           
            $dateFin=$today['year']."-".$mon."-".$today['mday'];
        }
        

        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new peticionesDB();
        $ds = $uDB->PeticionesByDateDataSet($ds, $date, $dateFin);
        $grid = new KoolGrid("historialpeticiones");
        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idPeticion", "ID", true, true, 0 , "" , "50px");
        $configGrid->defineColumn($grid, "tipo_peticion", "Tipo Peticion", true, true);
        $configGrid->defineColumn($grid, "usuario_peticion", "Usuario Peticion", true, true);
        //$configGrid->defineColumn($grid, "registroId", "Registro ID", true, true);
        $configGrid->defineColumn($grid, "nombre_usuario_turno", "Alarma asignada", true, true);
        $configGrid->defineColumn($grid, "statusAsignacion", "Status Asignaci&oacute;n", true, true);
        $configGrid->defineColumnReporteStatus($grid);
        $configGrid->defineColumn($grid, "statusComunicacion", "Status Comunicaci&oacute;n", true, true, 0 , "" , "120px");
        $configGrid->defineColumn($grid, "fechaCreacion", "Fecha Peticion", true, true);
	    $configGrid->defineColumn($grid, "comite", "Comite Actual", true, true);
	    $configGrid->defineColumn($grid, "comiteUsuario", "id del comite asociado en peticion", false, true);
	    $configGrid->defineColumn($grid, "comiteEnPeticion", "Comite Asociado", true, true);
        // $configGrid->defineColumn($grid, "operador", "Operador", true, true);
        $configGrid->defineColumnReporteStatusAsignacion($grid);
        $configGrid->defineColumn($grid, "fechaAsignacion", "Fecha Asignacion", true, true);
        $configGrid->defineColumn($grid, "fechaFinalizacion", "Fecha Finalizacion", true, true, 0 , "" , "100px");
        $configGrid->defineColumn($grid, "coordenadasInicio", "Coordenadas Inicio", true, true, 0 , "" , "130px");
        $configGrid->defineColumn($grid, "coordenadasFin", "Coordenadas Fin", true, true, 0 , "" , "130px");
        $configGrid->defineColumn($grid, "estatus", "Estatus", true, false, 0);
        //$configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumn($grid, "tiempoAtendio", "Tiempo atendido", true, false, 0);
        $configGrid->defineColumnReportePatrullero($grid);
        $configGrid->defineColumnMensajePatrullero($grid);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;

    }

    //Obtener coleccion de personal
    public function ObtPeticionesActivasPorAlarma($alarmaId, $estatusId){
        $array = array();
        $ds = new peticionesDB();
        $datosBD = new datosBD();
        $result = $ds->ObtPeticionesActivasPorAlarmaDB($alarmaId, $estatusId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ObtPeticionesActivasPorIDAlarma($alarmaId, $estatusId){
        $array = array();
        $ds = new peticionesDB();
        $datosBD = new datosBD();
        $result = $ds->ObtPeticionesActivasPorIDAlarmaDB($alarmaId, $estatusId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtPeticionesPorDia($fecha = ""){
        $array = array();
        $ds = new peticionesDB();
        $datosBD = new datosBD();
        $result = $ds->ObtPeticionesPorDiaDB($fecha);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function actualizarStatusComunicacion($resErrorCode, $idPeticion) {
        $statusComunicacion = NULL;
        switch($resErrorCode) {
            case 0:
                $statusComunicacion = catStatusComunicacionObj::ENCENDIDO_CORECTO;
                break;

            case -20002:
                $statusComunicacion = catStatusComunicacionObj::ALM_NO_RESPONDIO;
                break;

            case -20104:
                $statusComunicacion = catStatusComunicacionObj::ALM_MAL_CONFIGURADA;
                break;
		
            case -20571:
                $statusComunicacion = catStatusComunicacionObj::ALM_FUERA_LINEA;
                break;

            case -20580:
                $statusComunicacion = catStatusComunicacionObj::ALM_MAL_CONFIGURADA;
                break;

            case -20651:
                $statusComunicacion = catStatusComunicacionObj::TOKEN_EXPIRADO;
                break;
        }
        $this->ActualizarCampoPeticion(
            "statusComunicacionId",
            $statusComunicacion,
            $idPeticion
        );
    }
     public function obtenerpeti($idpeti){
        
        $array = array();
        $ds = new peticionesDB();
        $datosBD = new datosBD();
        
        $result = $ds->peticionesporid($idpeti);
        $array = $datosBD->arrDatosObj($result);
        return $array;

        
    }

}
