<?php

/*
 *  © 2017 Framelova. All rights reserved. Privacy Policy
 *  Creado: 29/08/2018
 *  Por: JCarlos Ramírez García - JCRG
 *  Descripción: registroDispositivo Object
 */

$dirname = dirname(__DIR__);
include_once  $dirname . '/database/registroDispositivosDB.php';
include_once  $dirname . '/database/datosBD.php';
include_once  $dirname . '/brules/configuracionesGridObj.php';
include_once $dirname . '/brules/catConfiguracionesObj.php';


class registroDispositivo extends configuracionesGridObj
{

    //Private Fields
    private $_idReg = 0;
    private $_usuarioId = 0;
    private $_idRegDispositivo = "";
    private $_activo = 0;
    private $_plataforma = 0;
    private $_fechaCreacion = 0;

    //get y set
    public function __get($name)
    {
        return $this->{"_" . $name};
    }
    public function __set($name, $value)
    {
        $this->{"_" . $name} = $value;
    }


    //Invoca al metodo de registrar dispositivo
    public function Salvar()
    {
        $this->regDispositivo();
    }

    //registrar un nuevo dispositivo
    private function regDispositivo()
    {
        $obj = new registroDispositivosDB();
        $this->_idReg = $obj->insertarRegDispositivoDB($this->_usuarioId, $this->_idRegDispositivo, $this->_plataforma);
    }

    //Comprobar que ya existe el registro del dispositivo
    public function ObtRegDispositivoPorIdReg()
    {
        $objDS = new registroDispositivosDB();
        $datosBD = new datosBD();
        $obj = new registroDispositivo();

        $result = $objDS->ObtRegDispositivoPorIdRegDB($this->_idRegDispositivo, $this->_usuarioId);
        return $datosBD->setDatos($result, $obj);
    }

    //Obtener todos los registros dependiendo del id del usuario
    public function obtTodosRegDispositivoPorIdUsr()
    {
        $array = array();
        $objDS = new registroDispositivosDB();
        $datosBD = new datosBD();
        $result = $objDS->obtTodosRegDispositivoPorIdUsrDB($this->_usuarioId);
        $array = $datosBD->arrDatosObj($result);

        return $array;
    }

    //Actualizar el registro por el id del usuario 
    public function ActRegActivo()
    {
        $obj = new registroDispositivosDB();
        $obj->ActRegActivoDB($this->_idRegDispositivo, $this->_plataforma, $this->_idReg);
    }

    public function ObtUsuarioPorIdRegDispositivo()
    {
        $objDS = new registroDispositivosDB();
        $datosBD = new datosBD();
        $obj = new registroDispositivo();

        $result = $objDS->ObtUsuarioPorIdRegDispositivoDB($this->_idRegDispositivo);
        return $datosBD->setDatos($result, $obj);
    }

    //Metodo que envia notificaciones push a dispositivos "ios"
    public function apnsSend($regid, $message)
    {
        $dirname = dirname(__DIR__);
        $archivoPem = $dirname . '/common/sachCK.pem';
        // El password del fichero .pem
        $passphrase = 'cerpub123';

        //obtener apikey
        // $configObj = new catConfiguracionesObj();
        // $datosConfig = $configObj->ObtConfiguracionByID(4);
        // $apiKey = $datosConfig->valor; // $apiKey = 'AIzaSyBSh7RqTjkttVm_TPvPlY0XGC_fE9s9agY';  //ejemplo apikey

        //------------------
        $ctx = stream_context_create();
        //Especificamos la ruta al certificado .pem que hemos creado
        stream_context_set_option($ctx, 'ssl', 'local_cert', $archivoPem);
        stream_context_set_option($ctx, 'ssl', 'passphrase', $passphrase);

        // Abrimos conexión con APNS        
        //Para desarrollo 
        // @$fp = stream_socket_client('ssl://gateway.sandbox.push.apple.com:2195', $err, $errstr, 60, STREAM_CLIENT_CONNECT|STREAM_CLIENT_PERSISTENT, $ctx); //COMENTAR EN SERVIDOR
        //Para distribucion
        @$fp = stream_socket_client('ssl://gateway.push.apple.com:2195', $err, $errstr, 60, STREAM_CLIENT_CONNECT | STREAM_CLIENT_PERSISTENT, $ctx);

        if (!$fp) {
            // exit("Error de conexión: $err $errstr" . PHP_EOL);
        }
        // echo 'Conectado al APNS' . PHP_EOL;

        // Creamos el payload
        $body['aps'] = array(
            'alert' => $message,
            'sound' => 'bingbong.aiff',
            'badge' => 0
        );

        // Lo codificamos a json
        $payload = json_encode($body);

        // Construimos el mensaje binario
        @$msg = chr(0) . pack('n', 32) . pack('H*', $regid) . pack('n', strlen($payload)) . $payload;

        // Lo enviamos
        @$result = fwrite($fp, $msg, strlen($msg));
        // cerramos la conexión
        @fclose($fp);

        if (!$result) {
            // $msgResp = 'ios: El mensaje push no fue posible enviarlo.';// . PHP_EOL;
            $msgResp = 0;
        } else {
            // $msgResp = 'ios: El mensaje push se envio al dispositivo.';// . PHP_EOL;
            $msgResp = 1;
        }

        return $msgResp;
    }

    function getAccessToken()
    {
        $dir = dirname(__DIR__) . "/common/sai-tehuacan-firebase-adminsdk-mxmp6-87a0a8d062.json";

        // Verificar si el archivo de credenciales existe
        if (!file_exists($dir)) {
            throw new Exception('El archivo de credenciales no existe: ' . $dir);
        }

        // Decodificar el archivo JSON
        $jsonCredentials = json_decode(file_get_contents($dir), true);

        // Verificar si hubo un error al decodificar el JSON
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception('Error al decodificar JSON: ' . json_last_error_msg());
        }

        $privateKey = $jsonCredentials['private_key'];
        $clientEmail = $jsonCredentials['client_email'];

        // Crear la carga útil del JWT
        $iat = time();
        $exp = $iat + 3600; // El token expira en 1 hora

        $payload = [
            'iss' => $clientEmail,
            'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
            'aud' => 'https://oauth2.googleapis.com/token',
            'iat' => $iat,
            'exp' => $exp,
        ];

        // Codificar el header y el payload
        $header = json_encode(['alg' => 'RS256', 'typ' => 'JWT']);
        $headerEncoded = base64_encode($header);
        $payloadEncoded = base64_encode(json_encode($payload));

        // Crear la firma
        $signature = '';
        openssl_sign("$headerEncoded.$payloadEncoded", $signature, $privateKey, OPENSSL_ALGO_SHA256);
        $signatureEncoded = base64_encode($signature);

        // Construir el JWT
        $jwt = "$headerEncoded.$payloadEncoded.$signatureEncoded";

        // Usar cURL para obtener el token de acceso
        $url = 'https://oauth2.googleapis.com/token';
        $data = [
            'assertion' => $jwt,
            'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer'
        ];

        // Configurar cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        // Ejecutar la solicitud
        $result = curl_exec($ch);
        curl_close($ch);

        // Decodificar la respuesta
        $response = json_decode($result, true);

        // Manejo de errores
        if (isset($response['error'])) {
            throw new Exception('Error al obtener el token de acceso: ' . $response['error_description']);
        }
        return $response['access_token'];
    }

    function gcmSend($regid, $message, $title = '', $device_type = 'android', $imagen = '')
    {
        $catConfiguracionesObj = new catConfiguracionesObj();
        $dataConf = $catConfiguracionesObj->ObtConfiguracionByID(9);
        $apiKey = $this->getAccessToken(); // token para el HEADER
       

        if ($device_type == 'android') { // android
            //contenido android
            $menaje = '{
                "message": {
                  "token": "' . $regid . '",
                  "notification": {
                    "title": "' . $title . '",
                    "body": "' . $message . '"
                  }
                }
              }';

        } elseif ($device_type == 'web') { // ios 
            //contenido web
            $menaje = '{
                "message": {
                  "token": "' . $regid . '",
                  "notification": {
                    "title": "' . $title . '",
                    "body": "' . $message . '",
                    "image": "' . $imagen . '"
                  }
                }
              }';

        } else {
            //contenido ios
            $menaje = '{
                "message": {
                  "token": "' . $regid . '",
                  "notification": {
                    "title": "' . $title . '",
                    "body": "' . $message . '"
                  }
                }
              }';
        }


        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://fcm.googleapis.com/v1/projects/sai-tehuacan/messages:send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $menaje,
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $apiKey . ''
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        // Guardar la respuesta en un archivo
        $dateTime = date('Y-m-d H:i:s');
        $logFile = '../ajaxcall2/push_notification_log.txt'; // Ruta del archivo de log
        $logEntry = "[$dateTime] Response: $response\n";
        file_put_contents($logFile, $logEntry, FILE_APPEND);

        // Verificar si la notificación se envió correctamente
        $responseData = json_decode($response, true);

        if (isset($responseData['name'])) {
            return 1; // Notificación enviada con éxito
        } else {
            return 0; // Hubo un problema al enviar la notificación
        }
    }

    // obtner porm id de usuario
    public function getPorIdUser($id)
    {
        $objDS = new registroDispositivosDB();
        $datosBD = new datosBD();
        $obj = new registroDispositivo();

        $result = $objDS->getPorIdUserBD($id);
        return $datosBD->setDatos($result, $obj);
    }

    public function validacionUser($id)
    {
        $objDS = new registroDispositivosDB();
        $datosBD = new datosBD();
        $obj = new registroDispositivo();

        $result = $objDS->getPorIdUserBD($id);
        return $datosBD->setDatos($result, $obj);
    }
}
