<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/usuariosTurnoDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class usuariosTurnoObj  extends configuracionesGridObj{
    private $_idUserTurno = 0;
    private $_usuarioVehiculoId = 0;
    private $_turnoId = 0;
    private $_vehiculoId = 0;
    private $_horaInicio = '';
    private $_horaFin = '';
    private $_fechaInicio = '';
    private $_fechaFin = '';
    private $_activo = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //personal por id
    public function UsuariosTurnoPorId($id){
        $ds = new usuariosTurnoDB();
        $obj = new usuariosTurnoObj();
        $datosBD = new datosBD();
        $result = $ds->UsuariosTurnoPorIdDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    public function obtUsuarioPorIdUsuarioTurno($idUserTurno){
        $ds = new usuariosTurnoDB();
        $obj = new usuariosTurnoObj();
        $datosBD = new datosBD();
        $result = $ds->obtUsuarioPorIdUsuarioTurnoDB($idUserTurno);

        return $datosBD->setDatos($result, $obj);
    }

    //Obtener coleccion de personal
    public function ObtUsuariosTurno($campo = "", $textoBuscar = "", $empresaId = ""){
        $array = array();
        $ds = new usuariosTurnoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtUsuariosTurnoDB($campo, $textoBuscar, $empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener coleccion de personal
    public function ObtTodosUsuariosTurno($empresaId = ""){
        $array = array();
        $ds = new usuariosTurnoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosUsuariosTurnoDB($empresaId);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ObtTodosVehiculosDisponibles($idTipoVehiculo="",$idPeticion=0){
        $array = array();
        $ds = new usuariosTurnoDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosVehiculosDisponiblesDB($idTipoVehiculo,$idPeticion);
        $array = $datosBD->arrDatosObj($result);
       // print_r($array);exit;
        return $array;
    }

    public function ActualizarCampoUsuarioTurno($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new usuariosTurnoDB();
        $resAct = $objDB->updateCampoUsuarioTurnoBD($param);
        return $resAct;
    }

    public function ActualizarCampoUsuarioTurnoUVid($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new usuariosTurnoDB();
        $resAct = $objDB->updateCampoUsuarioTurnoPorusuarioVehiculoIdBD($param);
        return $resAct;
    }

    public function GuardarUsuarioTurno(){
        $objDB = new usuariosTurnoDB();
        $this->_idUserTurno = $objDB->insertUsuarioTurnoBD($this->getParams());
    }
    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;

        $param[0] = $this->_usuarioVehiculoId;
        $param[1] = $this->_turnoId;
        $param[2] = $this->_vehiculoId;
        $param[3] = $this->_horaInicio;
        $param[4] = $this->_horaFin;

        return $param;
    }

    //Grid personal
     public function ObtUsuariosTurnoGrid($usuarioId = ""){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new usuariosTurnoDB();
        $ds = $uDB->UsuariosTurnoDataSet($ds, $usuarioId);
        $grid = new KoolGrid("UsuariosTurnoGrid");

        $configGrid = new configuracionesGridObj();

        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idUsuarioTurno", "ID", false, true);
        // $configGrid->defineColumn($grid, "empresaId", "Empresa", true, false, 1, "90px");
        $configGrid->defineColumn($grid, "nombre", "Nombre", true, false, 1);
        $configGrid->defineColumn($grid, "activo", "Activo", true, false, 0);
        $configGrid->defineColumnEdit($grid);

        //pocess grid
        $grid->Process();

        return $grid;
    }
    //Private Functions

    public function ObtTodosVehiculosDisponiblesById($idTurno){
        $ds = new usuariosTurnoDB();
        $obj = new usuariosTurnoObj();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosVehiculosDisponiblesByIdDB($idTurno);
        return $datosBD->setDatos($result, $obj);
    }
    //personal por id
    public function UsuariosTurnoPorIdUser($id){
        $ds = new usuariosTurnoDB();
        $obj = new usuariosTurnoObj();
        $datosBD = new datosBD();
        $result = $ds->UsuariosTurnoPorIdUserDB($id);

        return $datosBD->setDatos($result, $obj);
    }

    public function GuardarUsuarioTurnoAlarma($usuarioVehiculoId, $turnoId, $vehiculoId){
        $objDB = new usuariosTurnoDB();

        $param[0] = $usuarioVehiculoId;
        $param[1] = $turnoId;
        $param[2] = $vehiculoId;

        $this->_idUserTurno = $objDB->insertUsuarioTurnoBD($param);
    }


    public function GetAllAlarmaswithCoords(){

        $array = array();
        $ds = new usuariosTurnoDB();
        $datosBD = new datosBD();
        $result = $ds->GetAllAlarmaswithCoordsDB();
        $array = $datosBD->arrDatosObj($result);
        
        return $array;
    }

    public function getVehiculoUsuarioTurnoById($idUserTurno) {
        $usuariosTurnoDB = new usuariosTurnoDB($idUserTurno);
        $datosBD = new datosBD();
        $result = $usuariosTurnoDB->getVehiculoUsuarioTurnoByIdDB($idUserTurno);
        $data = $datosBD->setDatos($result);
        return $data;
    }

    // metodo para saaber si esta otra patrulla con otro usuario.
    public function VerificarVehiculoAsociado($vehiculo){
        $array = array();
        $usuariosTurnoDB = new usuariosTurnoDB;
        $datosBD = new datosBD();
        $result = $usuariosTurnoDB->VerificarVehiculoAsociadoBD($vehiculo);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function metodoPorIDuserTurno($id){
        $ds = new usuariosTurnoDB();
        $obj = new usuariosTurnoObj();
        $datosBD = new datosBD();
        $result = $ds->metodoPorIDuserTurnoBD($id);
        return $datosBD->setDatos($result, $obj);
    }

    public function MetodoParaPatrulleros(){
        $array = array();
        $usuariosTurnoDB = new usuariosTurnoDB;
        $datosBD = new datosBD();
        $result = $usuariosTurnoDB->MetodoParaPatrullerosBD();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

}
