<?php

$dirname = dirname(__DIR__);

class globalFunctions {

  /* Medir la distancia entre 2 puntos usando sus coordenadas */ 
  public function getDistanceToCoords($lat1, $lon1, $lat2, $lon2) {
    $R = 6371; // Radius of the earth in km
  
    $dLat = $this->_deg2rad($lat2 - $lat1); // deg2rad below
    $dLon = $this->_deg2rad($lon2 - $lon1);
  
    $a = sin($dLat / 2) * sin($dLat / 2) + cos($this->_deg2rad($lat1)) * cos($this->_deg2rad($lat2)) * sin($dLon / 2) * sin($dLon / 2);
  
    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
  
    $d = $R * $c; // Distance in km
  
    return number_format($d, 2);
  }
  
  private function _deg2rad($deg) {
    return $deg * (M_PI / 180);
  }

  /* Obtener fecha con formato */
  public function getFormattedDate($time, $format) {
    $date = new DateTime($time, new DateTimeZone("America/Mexico_City"));
    $date = $date->format($format);
    return $date;
  }
}
