<?php

/*
 *  © 2012 Framelova. All rights reserved. Privacy Policy
 *  Creado: 25/11/2012
 *  Por: Jonathan Guerrero Pérez - JGP
 *  Descripción: User database object
 */

$pathComm = 'common/';
if(file_exists('../common/DataServices.php'))
    $pathComm = '../common/';

include_once $pathComm.'DataServices.php';

class LanguageDB 
{
    //properties declarations

    public function LanguageDataSet($ds)
    {		 
        $dsO = new DataServices();		
        $param = null;

        $ds->SelectCommand = $dsO->ExecuteDS("getLanguageForGrid", $param);
        $ds->UpdateCommand = $dsO->ExecuteDS("updateLanguage", $param);
        $ds->DeleteCommand = $dsO->ExecuteDS("deleteLanguage", $param);
        $ds->InsertCommand = $dsO->ExecuteDS("insertLanguage", $param);
        $dsO->CloseConnection();
        return $ds;			
    }
    
    public function GetAllLanguages($onlyActive)
    {        
        $dsO = new DataServices();        
        $params[0] = ($onlyActive==true) ? ' WHERE active=1 ' : '';
                
        $result = $dsO->Execute("getAllLanguages", $params, false);
        $dsO->CloseConnection();
        return $result;
    }  
    
    public function LanguageByID($idL)
    {        
        $dsO = new DataServices();        
        $params[0] = $idL;                
        $result = $dsO->Execute("LanguageByID", $params, false);
        $dsO->CloseConnection();
        return $result;
    }
    
    
    
}
?>