<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class eventosApDB {

  //Obtener coleccion de eventos
  public function ObtEventosApDB($activo, $categoria, $fromDate, $toDate){
    $ds = new DataServices();
    $query = array();
    $param[0] = "";

    if($activo!=-1){
      $query[] = " activo=$activo ";
    }
    if($categoria>0){
      $query[] = " catId=$categoria ";
    }
    if($fromDate!=""){
      $query[] = " ( (DATE(fechaInicio) BETWEEN '".$fromDate."' AND '".$toDate."') OR (DATE(fechaFin) BETWEEN '".$fromDate."' AND '".$toDate."') ) ";
    }

    //En caso de llevar filtro
    if(count($query) > 0){
      $wordWhere = " WHERE ";
      $setWhere = implode(" AND ", $query);
      // echo $setWhere;
      $param[0] = $wordWhere.$setWhere;
    }
    $param[1] = " ORDER BY fechaInicio ASC ";

    $result = $ds->Execute("ObtEventosApDB", $param);
    return $result;
  }

  //Obtener datos del evento por su id
  public function ObtEventoApPorIdDB($id)
  {
      $ds = new DataServices();
      $param[0]= $id;
      $result = $ds->Execute("ObtEventoApPorIdDB", $param);
      $ds->CloseConnection();
      return $result;
  }

}