<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class historicosDB {

    //Otener personal por id
    public function HistoricosPorIdDB($id){
        $ds = new DataServices();
        $param[0]= $id;
        $result = $ds->Execute("HistoricosPorIdDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    public function HistoricosPorComiteDB($id){
        $ds = new DataServices();
        $param[0]= ($id > 0)?$id:0;
        $result = $ds->Execute("HistoricosPorComiteDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    //Otener col de personal
    public function ObtTodosHistoricosDB($tipoHistoricoId = "", $date='', $dateFin=''){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if($tipoHistoricoId != ""){
            $query[] = " tipoHist IN($tipoHistoricoId) ";
        }

        if($date != '' && $dateFin != ''){
            $query[] = 'fechaCreacion >= \''.$date.' 00:00:00\' AND fechaCreacion <= \''.$dateFin.' 23:59:59\'';
        }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }
        $result = $ds->Execute("ObtTodosHistoricosDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function ObtHistoricoEncendidoAlarmasDB($fechaInicio = "", $fechaFin = "") {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();
        $c_tipoHistoricoAlarmas = 1; 

        $query[] = " A.tipoHist IN ($c_tipoHistoricoAlarmas) ";

        if($fechaInicio != "" && $fechaFin != ""){
            $query[] = " A.fechaCreacion >= '" . $fechaInicio . " 00:00:00 ' ";
            $query[] = " A.fechaCreacion <= '" . $fechaFin . " 23:59:59 ' ";
        }

        // Contruimos filtro
        if (count($query) > 0) {
          $whereConditions = implode(" AND ", $query);
          $param[0] = " WHERE $whereConditions ";
        }

        $result = $ds->Execute("ObtHistoricoEncendidoAlarmasDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    //Otener col de personal
    public function ObtHistoricosDB($campo, $textoBuscar, $empresaId){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if($campo == "nombre" && $textoBuscar != ""){
            $query[] = " nombre LIKE '%".$textoBuscar."%' ";
        }

        if($campo == "clave" && $textoBuscar != ""){
            $query[] = " claveMat LIKE '%".$textoBuscar."%' ";
        }

        if($empresaId != ""){
            $query[] = " empresaId=$empresaId ";
        }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }
        $result = $ds->Execute("ObtHistoricosDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function insertHistoricoBD($param){
        $ds = new DataServices();
        $result = $ds->Execute("insertHistoricoBD", $param, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoHistoricoBD($param){
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoHistoricoBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function HistoricosDataSet($ds, $tipoHist = ""){
        $dsO = new DataServices();
        $param[0] = "";
        $query = array();

        if($tipoHist != ""){
            $query[] = " tipoHist IN($tipoHist) ";
        }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }

        $ds->SelectCommand = $dsO->ExecuteDS("GetHistoricosGrid", $param);
        // $param[0] = $usuarioId;
        //$ds->InsertCommand = $dsO->ExecuteDS("insHistoricosGrid", $param);
        // $ds->UpdateCommand = $dsO->ExecuteDS("actAlarmaGrid", $param);
        $param = null;
        //$ds->DeleteCommand = $dsO->ExecuteDS("eliminarHistoricosGrid", $param);
        $dsO->CloseConnection();

        return $ds;
    }

}