<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class peticionesDB {

    //Otener personal por id
    public function PeticionesPorIdDB($id){
        $ds = new DataServices();
        $param[0]= ($id > 0)?$id:0;
        $result = $ds->Execute("PeticionesPorIdDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    public function promedioAtencionPeticionesDB($fecha = ""){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if($fecha != ""){
            $query[] = " A.fechaCreacion BETWEEN '$fecha 00:00:00' AND '$fecha 23:59:59'  ";
        }

        //En caso de llevar filtro
        if(count($query) > 0){
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere.$setWhere;
        }

        $result = $ds->Execute("promedioAtencionPeticionesDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    //Otener col de personal
    public function ObtTodosPeticionesDB($empresaId){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if($empresaId != ""){
            $query[] = " empresaId=$empresaId ";
        }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }
        $result = $ds->Execute("ObtTodosPeticionesDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    //Otener col de personal
    public function ObtPeticionesDB($estatusId, $tipoPeticionId, $fecha, $hora){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        // if($campo == "nombre" && $textoBuscar != ""){
        //     $query[] = " nombre LIKE '%".$textoBuscar."%' ";
        // }

        // if($campo == "clave" && $textoBuscar != ""){
        //     $query[] = " claveMat LIKE '%".$textoBuscar."%' ";
        // }

        if($estatusId != ""){
            $query[] = " estatusId IN($estatusId) ";
        }

        if($tipoPeticionId !== ""){
            $query[] = " A.tipoPeticionId IN($tipoPeticionId) ";
        }

        if($fecha != ""){
            $query[] = " A.fechaCreacion BETWEEN '$fecha 00:00:00' AND '$fecha 23:59:59'  ";
        }

        if($hora !== ""){
            $query[] = ' DATE_FORMAT(A.fechaCreacion, "%H")='.$hora.' ';
        }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }
        $result = $ds->Execute("ObtPeticionesDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function insertPeticionBD($param){
        $ds = new DataServices();
        $result = $ds->Execute("insertPeticionBD", $param, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoPeticionBD($param){
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoPeticionBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoPeticionEnteroBD($param){
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoPeticionEnteroBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function PeticionesDataSet($ds, $usuarioId = ""){
        $dsO = new DataServices();
        $param[0] = "";
        $query = array();

        // if($usuarioId != ""){
        //     $query[] = " usuarioId=$usuarioId ";
        // }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }

        $ds->SelectCommand = $dsO->ExecuteDS("ObtPeticionesDB", $param);
        $param[0] = $usuarioId;
        $ds->InsertCommand = $dsO->ExecuteDS("insPeticionesGrid", $param);
        $ds->UpdateCommand = $dsO->ExecuteDS("actPeticionesGrid", $param);
        $param = null;
        $ds->DeleteCommand = $dsO->ExecuteDS("eliminarPeticionesGrid", $param);
        $dsO->CloseConnection();

        return $ds;
    }
    public function ObtPeticionesUserBYEstatusDB($idUsuario, $estatusId){
        $ds = new DataServices();
        $param[0] = "WHERE usuarioId=".$idUsuario." AND estatusId=".$estatusId;
        // $param[0] = "WHERE usuarioId=".$idUsuario;
        //En caso de llevar filtro
        $result = $ds->Execute("ObtPeticionesUserBYEstatusDB", $param);
        $ds->CloseConnection();
        return $result;
    }
    public function obtDatosPorPeticionDB($id){
        $ds = new DataServices();
        $param[0]= $id;
        $result = $ds->Execute("obtDatosPorPeticionDB", $param);
        $ds->CloseConnection();

        return $result;
    }
    //Otener personal por id
    public function PeticionesPorIdUsuarioEstDB($id,$estatus){
        $ds = new DataServices();
        $param[0]= $id;
        $param[1]= $estatus;
        $result = $ds->Execute("PeticionesPorIdUsuarioEstDB", $param);
        $ds->CloseConnection();

        return $result;
    }
    public function PeticionesPorIdUsuarioEstDB2($id,$estatus){
        $ds = new DataServices();
        $param[0]= $id;
        $param[1]= $estatus;
        $result = $ds->Execute("PeticionesPorIdUsuarioEstDB2", $param);
        $ds->CloseConnection();

        return $result;
    }

    //19/03/2020 Jair Nuevo metodo
    public function ObtPeticionesUserBYEstatus2DB($idUsuario, $estatusId){
        $ds = new DataServices(); 
        $param[0] = "WHERE usuarioId=".$idUsuario." AND estatusId IN(".$estatusId.")";
        // $param[0] = "WHERE usuarioId=".$idUsuario;
        //En caso de llevar filtro
        $result = $ds->Execute("ObtPeticionesUserBYEstatus2DB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function ObtPeticionesUserBYCerradoAppDB($idUsuario, $cerrado){
        $ds = new DataServices();
        $param[0] = "WHERE usuarioId=".$idUsuario." AND cerradoEnApp IN(".$cerrado.")";
        // $param[0] = "WHERE usuarioId=".$idUsuario;
        //En caso de llevar filtro
        $result = $ds->Execute("ObtPeticionesUserBYCerradoAppDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function DeletePeticionesPorIdUserDB($id){
        $ds = new DataServices();
        $param[0]= $id;
        $result = $ds->Execute("DeletePeticionesPorIdUserDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    public function PeticionesByDateDataSet($ds, $date = "", $dateFin=""){
        $dsO = new DataServices();
        $param[0] = "";
        $query = array();

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }
        
        $param[0] = $date;
        $param[1] = $dateFin;
        $ds->SelectCommand = $dsO->ExecuteDS("GetAllPeticionesByDateGrid", $param);
        //$param[0] = $date;
        //$ds->InsertCommand = $dsO->ExecuteDS("insVehiculosGrid", $param);
        //$ds->UpdateCommand = $dsO->ExecuteDS("actAlarmaGrid", $param);
        $param = null;
        //$ds->DeleteCommand = $dsO->ExecuteDS("eliminarVehiculosGrid", $param);
        $dsO->CloseConnection();

        return $ds;
    }

    public function ObtPeticionesActivasPorAlarmaDB($alarmaId, $estatusId){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();


        $param[0] = "WHERE G.idVehiculo=$alarmaId AND A.estatusId IN($estatusId) ";
        

        $result = $ds->Execute("ObtPeticionActivaPorIdAlarmaDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function ObtPeticionesActivasPorIDAlarmaDB($alarmaId, $estatusId){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();


        $param[0] = "WHERE usuarioTurnoId=$alarmaId AND estatusId IN($estatusId) ";
        

        $result = $ds->Execute("ObtPeticionActivaPorIdAlarmaShellyDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    //Otener col de personal
    public function ObtPeticionesPorDiaDB($fecha){
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if($fecha != ""){
            $query[] = " fechaAsignacion >= '".$fecha." 00:00:00' AND fechaAsignacion <='".$fecha ." 23:00:00' AND atendidoOperador = 0 AND estatusId != 3";
        }

        //En caso de llevar filtro
        if(count($query) > 0){
          $wordWhere = " WHERE ";
          $setWhere = implode(" AND ", $query);
          // echo $setWhere;
          $param[0] = $wordWhere.$setWhere;
        }
        $result = $ds->Execute("ObtPeticionesPorDiaDB", $param);
        $ds->CloseConnection();
        return $result;
    }
    
     public function peticionesporid($idpeti){
  
 
        $ds = new DataServices();
      
        $query = "";
      
        $query="WHERE p.idPeticion=".$idpeti;
      
        $param[0] = $query;
       
        $result = $ds->Execute("getpeti", $param);
       
        return $result;
      }
}
