<?php
$dirname = dirname(__DIR__);
include_once  $dirname . '/common/DataServices.php';

class vehiculosDB
{

    //Otener personal por id
    public function VehiculosPorIdDB($id)
    {
        $ds = new DataServices();
        $param[0] = $id;
        $result = $ds->Execute("VehiculosPorIdDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    public function VehiculosPorComiteDB($id)
    {
        $ds = new DataServices();
        $param[0] = ($id > 0) ? $id : 0;
        $result = $ds->Execute("VehiculosPorComiteDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    //Otener col de personal
    public function ObtTodosVehiculosDB($tipoVehiculoId = "", $estatusId = "", $activo = "")
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        //$file = fopen("archivo.txt", "w");
        if ($tipoVehiculoId != "") {
            $query[] = " tipoVehiculoId=$tipoVehiculoId ";
        }

        if ($estatusId !== "") {
            $query[] = " estatusId=$estatusId ";
        }

        if ($activo !== "") {
            //fwrite($file,"activo=:  ". $activo . PHP_EOL);
            $query[] = " activo=$activo ";
        }

        /*fwrite($file,"VARIABLES:  ". $activo . PHP_EOL);
        fwrite($file,"if:  ". ($activo != "")?"diferente":"igual" . PHP_EOL);
        fwrite($file,"query count:  ". count($query) . PHP_EOL);
        for($i=0;$i<count($query);$i++){
            fwrite($file,"posicion:  ". $i ." value ". $query[$i] . PHP_EOL);
        }*/

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
            //fwrite($file,"QUERY:  ". $param[0] . PHP_EOL);
        }
        //fclose($file);
        $result = $ds->Execute("ObtTodosVehiculosDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function vehiculosInicioSesionDB()
    {
        $ds = new DataServices();
        $param = NULL;
        //$query = array();
        $result = $ds->Execute("vehiculosInicioSesionDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    //Otener col de personal
    public function ObtVehiculosDB($campo, $textoBuscar, $empresaId)
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if ($campo == "nombre" && $textoBuscar != "") {
            $query[] = " nombre LIKE '%" . $textoBuscar . "%' ";
        }

        if ($campo == "clave" && $textoBuscar != "") {
            $query[] = " claveMat LIKE '%" . $textoBuscar . "%' ";
        }

        if ($empresaId != "") {
            $query[] = " empresaId=$empresaId ";
        }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }
        $result = $ds->Execute("ObtVehiculosDB", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function insertVehiculoBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("insertVehiculoBD", $param, true);
        $ds->CloseConnection();
        return $result;
    }

    public function insertAlarma($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("insertAlarma", $param, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoVehiculoBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoVehiculoBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function updateCampoAlarmaByAlarmaIdBD($param)
    {
        $ds = new DataServices();
        $result = $ds->Execute("updateCampoAlarmaByAlarmaIdBD", $param, false, true);
        $ds->CloseConnection();
        return $result;
    }

    public function VehiculosDataSet($ds, $usuarioId = "", $idRol)
    {
        $dsO = new DataServices();
        $param[0] = "";
        $query = array();

        // if($usuarioId != ""){
        //     $query[] = " usuarioId=$usuarioId ";
        // }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }

        $ds->SelectCommand = $dsO->ExecuteDS("GetAlarmas", $param);
        $param[0] = $usuarioId;
        //$ds->InsertCommand = $dsO->ExecuteDS("insVehiculosGrid", $param);
        if ($idRol == '5' && $idRol != "" && $idRol != null) {
            $ds->UpdateCommand = $dsO->ExecuteDS("actAlarmaGridUserEmpadronamiento", $param);
        } else {
            $ds->UpdateCommand = $dsO->ExecuteDS("actAlarmaGrid", $param);
        }
        $param = null;
        //$ds->DeleteCommand = $dsO->ExecuteDS("eliminarVehiculosGrid", $param);
        $dsO->CloseConnection();

        return $ds;
    }

    //Otener personal por id
    public function VehiculosByNameDB($nombreAlarma)
    {
        $ds = new DataServices();
        $param[0] = $nombreAlarma;
        $result = $ds->Execute("TipoVehiculosByNameDB", $param);
        $ds->CloseConnection();

        return $result;
    }

    //Obtener coleccion de vehiculos
    public function GetallVehiculos($mostrar = "")
    {
        $ds = new DataServices();

        $param[0] = "";
        $query = array();

        if ($mostrar !== "") {
            $query[] = " mostrar=$mostrar ";
        }
        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }

        $result = $ds->Execute("GetAllVehiculos", $param);
        $ds->CloseConnection();
        return $result;
    }

    public function UnidadesDataSet($ds, $idRol = 0)
    {
        $dsO = new DataServices();
        //echo 'tengo:'.$idRol;

        if ($idRol == 9) {
            $param = "";
            $ds->SelectCommand = $dsO->ExecuteDS("getUnidadesForGridRolTi", $param);
        } else {
            $param = "";
            $ds->SelectCommand = $dsO->ExecuteDS("getUnidadesForGridRolTi", $param);
        }

        //$param = null;
        //$ds->UpdateCommand = $dsO->ExecuteDS("updatePatrullerosGrid", $param);
        //$ds->DeleteCommand = $dsO->ExecuteDS("deleteUserGrid", $param);
        // $ds->InsertCommand = $dsO->ExecuteDS("insertUserGrid", $param);
        $dsO->CloseConnection();

        return $ds;
    }

    public function obtDatosVehiculoPorIdDB($id)
    {
        $ds = new DataServices();
        $param[0] = $id;
        $result = $ds->Execute("obtDatosVehiculoPorIdDB", $param);
        $ds->CloseConnection();

        return $result;
    }


    // Metodo para taer todas Alarmas de que pertenece a la cuenta 

    public function GetAlarmasPorCuentaBD($nombreCuenta)
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        if ($nombreCuenta != "") {
            $query[] = " tipoVehiculoId = 4 ";
            $query[] = " cuenta ='$nombreCuenta'";
        }

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }

        $result = $ds->Execute("getAlarmasPorCuentaBD", $param);
        $ds->CloseConnection();

        return $result;
    }


    // nuevo metodo de alarma mas cercana 
    public function VerAlarma_masCercanaBD($id)
    {
        $ds = new DataServices();
        $param[0] = $id;

        $result = $ds->Execute("VerAlarma_masCercanaBD", $param);
        $ds->CloseConnection();

        return $result;
    }

    // METODO PARA TRAER LOS PATRULLEROS 

    public function GetPatrullerosBD()
    {
        $ds = new DataServices();
        $param[0] = "";

        $result = $ds->Execute("GetPatrullerosBD", $param);
        $ds->CloseConnection();

        return $result;
    }

    // METODO PARA TRAER LOS PATRULLEROS 

    public function GetPorIDPatrulleroBD($id)
    {
        $ds = new DataServices();
        $param[0] = $id;

        $result = $ds->Execute("GetDatosPoridPatrullero", $param);
        $ds->CloseConnection();

        return $result;
    }

    public function Get_Alarma_solo_comiteBD($id)
    {
        $ds = new DataServices();
        $param[0] = "";
        $query = array();

        $query[] = "A.idComite = '$id'";
        $query[] = "A.soloComite =1 ";
    

        //En caso de llevar filtro
        if (count($query) > 0) {
            $wordWhere = " WHERE ";
            $setWhere = implode(" AND ", $query);
            // echo $setWhere;
            $param[0] = $wordWhere . $setWhere;
        }

        $result = $ds->Execute("vehiculoPorcomiteSoloComite", $param);
        $ds->CloseConnection();

        return $result;
    }


    public function VehiculosByMatriculaDB($matricula)
    {
        $ds = new DataServices();
        $param[0] = $matricula;
        $result = $ds->Execute("traerpatrullaspormatricula", $param);
        $ds->CloseConnection();

        return $result;
    }


}
