<?php

// Verificar si se ha enviado el formulario

if ($_SERVER["REQUEST_METHOD"] == "POST") {

    if (!isset ($_POST ['usr_email'], $_POST ['usr_tel'], $_POST ['usr_motivo'])) {

        header ('HTTP/1.1 400 Bad Request');

        echo json_encode (array (

            'message' => 'Faltan datos en el formulario'

        ));

        exit ();

    }

    require_once 'brules/sendinblue.php';

    $mail = new sendinblue ();

    // Procesar los datos del formulario

    $mail -> __set ('replyTo', 'mauricio.sanchez@framelova.com');

    $mail -> __set ('to', $_POST ['usr_email']);

    $mail -> __set ('subject', 'Solicitud de eliminación de cuenta');

    $mail -> __set ('htmlContent', 'Se ha recibido una solicitud de eliminación de cuenta con los siguientes datos: <br> Correo: ' . $_POST ['usr_email'] . '<br> Teléfono: ' . $_POST ['usr_tel'] . '<br> Motivo: ' . $_POST ['usr_motivo']);

    if ($mail -> send () == 0) {

        header ('HTTP/1.1 500 Internal Server Error');

        echo json_encode (array (

            'message' => 'Error al enviar el correo'

        ));

        exit ();

    }

    header ('HTTP/1.1 200 OK');

    echo json_encode (array (

        'message' => 'Correo enviado correctamente'

    ));

    exit ();

}

?>



<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title> Soporte SAI Tehuac&aacute;n </title>

    <link href="css/bootstrap.min.css" rel="stylesheet" type="text/css" />

</head>



<body style="background: #e6e6e6;">

    <br>

    <div style="display: flex;justify-content: center;align-items: center;margin: 2% 0%;">

        <img style="height: 150px;" src="images/logo-extendido.png" />

        <div>

            <h1 style="color: #b22c52; text-align: center; font-family: Arial;">SAI Tehuac&aacute;n</h1>

            <h4 style="text-align: center;"> <b> Eliminaci&oacute;n de cuenta </b></h4>

        </div>

    </div>    

   

    <br>

    <div class="col-xs-1 col-md-1"></div>

    <div class="col-xs-10 col-md-10" style="background: #d5d5d5;padding: 3%;">

            <p style="text-align: justify;"> Si desea eliminar su cuenta de usuario en la aplicaci&oacute;n SAI Tehuac&aacute;n, favor de llenar el siguiente formulario, nos comunicaremos contigo para indicarte el estado de t&uacute; solicitud: </p>

            <br>

            <div> 

                <form method="post" action="javascript:void(0);">

                    <div class="form-group col-xs-12 col-md-12">

                        <label class="col-xs-12 col-md-3" for="email"> Correo electr&oacute;nico con el que te registraste</label>

                        <input class="col-xs-12 col-md-9" type="email" class="form-control input-lg" name="usr_email" id="usr_email"   required>

                    </div>

                    <br>

                    <div class="form-group col-xs-12 col-md-12">

                        <label class="col-xs-12 col-md-3" for="pwd">Número de tel&eacute;fono</label>

                        <input class="col-xs-12 col-md-9" type="tel" class="form-control input-lg" name="usr_tel" id="usr_tel"  required>

                    </div>

                    <br>

                    <div class="form-group col-xs-12 col-md-12">

                        <label class="col-xs-12 col-md-3" for="pwd"> Motivo de eliminación </label>

                        <textarea class="col-xs-12 col-md-9" type="text" class="form-control" name="usr_motivo" id="usr_motivo"  required> </textarea>

                    </div>

                    <br>

                    <div class="col-xs-3 col-md-4"></div>

                    <div class="col-xs-6 col-md-4">

                        <div style="padding-top: 5%;"></div>

                        <button type="submit" name="aceptar" class="btn btn-lg btn-primary btn-block">Enviar </button>

                    </div>

                    <div class="col-xs-3 col-md-4"></div>

                    <br>

                </form>

            </div>

            <p hidden

                id="mensaje"

                style='text-align: center;'></p>

        <?php

        ?>

    </div>

    <div class="col-xs-1 col-md-1"></div>

    <script src="js/jquery-1.10.2.min.js"></script>

    <script>

        'use strict'





        $(document).ready (() => {

            $("form").submit ((event) => {

                event.preventDefault ()

                $.ajax ({

                    type: 'POST',

                    url: 'soporte.php',

                    data: {

                        usr_email: event.target.usr_email.value,

                        usr_tel: event.target.usr_tel.value,

                        usr_motivo: event.target.usr_motivo.value

                    },

                    success: (response) => {

                        console.log (response)

                        alert ('Correo enviado correctamente')

                    },

                    error: (response) => {

                        console.log (response)

                        alert ('Error al enviar el correo')

                    }

                })

            })

        })

    </script>

</body>

</html>