<?php
include_once '../brules/usuariosObj.php';
include_once '../brules/registroDispositivosObj.php';
include_once '../brules/peticionesObj.php';
include_once '../brules/datosUsuarioObj.php';
include_once '../brules/peticionCoordenadasObj.php';
include_once '../common/globalFunctions.php';

include_once '../brules/utilsObj.php';
include_once '../brules/catConfiguracionesObj.php';
include_once '../brules/EmailFunctionsObj.php';
include_once '../brules/comunicadosObj.php';
include_once '../brules/catTiposLugarObj.php';
include_once '../brules/catLugaresObj.php';
include_once '../brules/catTipoContactosObj.php';
include_once '../brules/catTelefonosEmergenciaObj.php';
include_once '../brules/seguridadObj.php';
include_once '../brules/codigoValidacionObj.php';
include_once '../brules/mensajesObj.php';
include_once '../brules/catRptCiudadanosObj.php';
include_once '../brules/rptCiudadanoUsuarioObj.php';
include_once '../brules/documentosUsuarioObj.php';
include_once '../brules/catBolsatrabajoObj.php';
include_once '../brules/bolsatrabajoObj.php';
include_once '../brules/catTipojornadaObj.php';
include_once '../brules/infolegalCategoriasObj.php';
include_once '../brules/infolegalEnlacesObj.php';
include_once '../brules/catTipoMultaObj.php';
include_once '../brules/foliosMultasObj.php';
include_once '../brules/rptMascotasObj.php';
include_once '../brules/imagenesMascotaObj.php';
include_once '../brules/respMascotasObj.php';
include_once '../brules/respPersonasObj.php';
include_once '../brules/catAyudasObj.php';
include_once '../brules/rptPersonasObj.php';
include_once '../brules/imagenesPersonaObj.php';
include_once '../brules/catEstatusObj.php';
include_once '../brules/eventosApObj.php';
include_once '../brules/catCategoriaApObj.php';
include_once '../brules/usuariosTurnoObj.php';
include_once '../brules/vehiculosObj.php';
include_once '../brules/vehiculosEstacionadosObj.php';
include_once '../brules/coordenadasVehiculoObj.php';
include_once '../brules/rechazosPatrullaObj.php';
include_once '../brules/buzonCiudadanoObj.php';
include_once '../brules/catUnidadesRutasObj.php'; //Imp. 25/10/19
include_once '../brules/catComiteObj.php';
include_once '../brules/catCuentasObj.php';
include_once '../brules/historicosObj.php';
include_once '../brules/calificarAtencionObj.php';
include_once '../brules/catStatusAsignacionObj.php';
include_once '../brules/historicoAsignadosObj.php';
include_once '../brules/historialDesconexionInternetObj.php';
include_once '../brules/historialInicioSesionObj.php';
include_once '../brules/historialPrimerSegundoPlanoObj.php';
include_once '../brules/historialSegundoPrimerPlanoObj.php';
include_once '../brules/historicoConexionBotonLLaveroObj.php';
include_once '../brules/imagenesMascotasVistasObj.php';
include_once '../brules/imagenesPersonasVistasObj.php';


$function = $_GET['dom_funct'];
switch ($function) {
    case "solicitudPeticionBotonSilencioso":
        solicitudPeticionBotonSilencioso($_GET['idDispositivo']);
    break;
    case "obtEstadoSim":
        obtEstadoSim();
    break;
    case "obtEstadoSimAjax":
        obtEstadoSimAjax($_GET['callback']);
    break;
    case "cambiarEstadoSim":
        cambiarEstadoSim($_GET['callback'], $_GET['valor']);
    break;
    case "obtEstatusPeticion":
        obtEstatusPeticion($_GET['idPeticion']);
    break;
    case "funcionEjemplo":
        funcionEjemplo($_GET['idPeticion']);
    break;
}

function funcionEjemplo($idPeticion){
    $peticionesObj = new peticionesObj();

    $estatusPeticion = $peticionesObj->obtDatosPorPeticion($idPeticion);
    $enviados = array("idPeticion" => $idPeticion, "peticion" => $idPeticion, "estatusId" => $estatusPeticion->estatusId);
    
    echo json_encode($enviados);
    return json_encode($enviados);

}

function obtEstadoSim(){
    $file = fopen("estadoSim.txt", "r");
    //while(!feof($file)){
        $traer = fgets($file);
    //}
    fclose($file);

    $arr = array("Estado" => intval($traer));
    echo json_encode($arr);
    return json_encode($arr);
}

function obtEstadoSimAjax($callback){
    $file = fopen("estadoSim.txt", "r");
    //while(!feof($file)){
        $traer = fgets($file);
    //}
    fclose($file);

    $arr = array("success" => true, "valor" => intval($traer));
    echo $callback . '(' . json_encode($arr) . ');';
}

function cambiarEstadoSim($callback, $valor){
    $file = fopen("estadoSim.txt", "w");
    fwrite($file, $valor);
    fclose($file);

    $arr = array("success" => true, "valor" => $valor);
    echo $callback . '(' . json_encode($arr) . ');';
}

function solicitudPeticionBotonSilencioso($idDispositivo){
    $peticionesObj = new peticionesObj();
    $usuariosObj = new usuariosObj();
    $datosUsuarioObj = new datosUsuarioObj();
    $peticionCoordenadasObj = new peticionCoordenadasObj();
    $registroDispositivo = new registroDispositivo();
    $registroDispositivo->idRegDispositivo = $idDispositivo;
    $datosDispositivo = $registroDispositivo->ObtUsuarioPorIdRegDispositivo();
    $idUsuario = $datosDispositivo -> usuarioId;
    
    $dtsUsuario = $datosUsuarioObj->obtDatosUsuarioPorUsuarioId($idUsuario);
    $peticionActiva = $peticionesObj->ObtPeticionesUserBYEstatus2($idUsuario, "1,2,5");
    $peticionCerrada = $peticionesObj->ObtPeticionesUserBYCerradoApp($idUsuario, "0");

    if($peticionActiva-> idPeticion == 0 && $peticionCerrada->idPeticion == 0){
        $peticionesObj->tipoPeticionId = 4;
        $peticionesObj->usuarioId = $idUsuario;
        $peticionesObj->registroId = 0;
        $peticionesObj->coordenadasInicio = "19.01773" . ", " . "-98.22744";
        $peticionesObj->usuarioOperadorId = 1;
        $peticionesObj->estatusId = 1;
        $peticionesObj->activo = 1;
        $peticionesObj->opcComite = 0;
        $peticionesObj->comiteUsuario = (($dtsUsuario->idComite == NULL) ? 0 : $dtsUsuario->idComite);
        $peticionesObj->GuardarPeticion();

        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateTime = $dateByZone->format('Y-m-d H:i:s');

        if ($peticionesObj->idPeticion > 0) {
            $peticionCoordenadasObj->latitud = "19.01773";
            $peticionCoordenadasObj->longitud = "-98.22744";
            $peticionCoordenadasObj->peticionId = $peticionesObj->idPeticion;
            $peticionCoordenadasObj->registroId = 0;
            $peticionCoordenadasObj->usuarioId = $idUsuario;
            $peticionCoordenadasObj->GuardarPeticionCoordenadas();
            
            $peticionesObj->ActualizarCampoPeticion("permissionsApp", '{"so":"","version_so":"","uuid":"","cordova":"","name":"","geolocation_coarse":true,"geolocation_fine":true,"geolocation_background":false,"microphone":false,"camera":false,"storage":false,"contacts":false}', $peticionesObj->idPeticion);
            $peticionesObj->ActualizarCampoPeticion("tipoBoton", "Silencioso", $peticionesObj->idPeticion);
            // verPeticionApp($peticionesObj->idPeticion);
        } else {
            $recibidos = array("success" => false, "idUsuario" =>  intval($idUsuario), "idPeticion" =>  intval($peticionesObj->idPeticion), "msg"  => "Sin coordenadas");
        } 
        
        if ($peticionCoordenadasObj->idCoordenadasPet > 0){
            // verPeticionApp($peticionesObj->idPeticion);

            $recibidos = array("success" => true, "idUsuario" =>  intval($idUsuario), "idPeticion" =>  intval($peticionesObj->idPeticion));
        } else {
            $recibidos = array("success" => false, "msg" => "Peticion no creada");
        }
    } else if ($peticionCerrada->idPeticion > 0) {
        $peticionesObj->ActualizarCampoPeticion("cerradoEnApp", 1, $peticionCerrada->idPeticion);
    } else {
        $recibidos = array("success" => false, "idUsuario" =>  intval($idUsuario), "peticionActiva" =>  intval($peticionActiva->idPeticion));
    }

    echo json_encode($recibidos);
    return json_encode($recibidos);
}


function obtEstatusPeticion($idPeticion){
    $peticionesObj = new peticionesObj();
    
    $estatusPeticion = $peticionesObj->obtDatosPorPeticion($idPeticion);
    
    if($estatusPeticion -> estatusId == 1){
        $recibidos = array("success" => true, "idPeticion" => intval($estatusPeticion->idPeticion), "estatusId" => intval($estatusPeticion -> estatusId), "estado" => "Peticion enviada");    
    } else if ($estatusPeticion -> estatusId == 2){
        $recibidos = array("success" => true, "idPeticion" => intval($estatusPeticion->idPeticion), "estatusId" => intval($estatusPeticion -> estatusId), "estado" => "Peticion activa");    
    } else if($estatusPeticion -> estatusId == 3){
        $recibidos = array("success" => true, "idPeticion" => intval($estatusPeticion->idPeticion), "estatusId" => intval($estatusPeticion -> estatusId), "estado" => "Peticion cerrada");    
    } else if($estatusPeticion -> idPeticion == 0){
        $recibidos = array("success" => false, "idPeticion" => intval($estatusPeticion->idPeticion), "estado" => "Peticion no encontrada");    
    } else {
        $recibidos = array("success" => false, "idPeticion" => intval($estatusPeticion->idPeticion), "estado" => "Estatus no encontrado");    
    } 
     
    echo json_encode($recibidos);
    return json_encode($recibidos);
}

//https://csbemg.framelova.info/ajaxcall2/domfunct.php?&dom_funct=solicitudPeticionBotonSilencioso&idDispositivo=A1B2C3D4E5&
//https://csbemg.framelova.info/ajaxcall2/domfunct.php?&dom_funct=funcionEjemplo&idPeticion=2130&
//https://csbemg.framelova.info/ajaxcall2/domfunct.php?&dom_funct=obtEstatusPeticion&idPeticion=2132&


// >>>> RHS Logica para autoasignacion de peticion desde la app >>>>
function verPeticionApp($idPeticion)
{
  //$file = fopen("archivo.txt", "w");
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionesObj = new peticionesObj();
  $vehiculosObj = new vehiculosObj();
  $catConfiguracionesObj = new catConfiguracionesObj();

  $peticion = $peticionesObj->PeticionesPorId($idPeticion);
  switch ($peticion->tipoPeticionId) {
    case 0:
      $tipoVehiculoId = "3,4";
      break;
    case 1:
      $tipoVehiculoId = "2,4";
      break;
    case 2:
      $tipoVehiculoId = "1,4";
      break;
    case 4:
      $tipoVehiculoId = "1,4";
      break;
    default:
      $tipoVehiculoId = 0;
      break;
  }
  //fwrite($file, "tipoVehiculoId: " . $tipoVehiculoId . PHP_EOL);
  $vehiculosdisponiblesPeticion = [];
  $vehiculosdisponibles = $usuariosTurnoObj->ObtTodosVehiculosDisponibles($tipoVehiculoId); // aqui viene los veiculos  TODOS
  $alarmaComiteDisponible = false;
  $alarmaComite = $vehiculosObj->VehiculosPorComite($peticion->idComiteUsuario); // PIDE LA ALRMA DE MANDO 
  $datosCatConf = $catConfiguracionesObj->ObtConfiguracionByID(5); // TRAEL EN OTRA TABLA DE BASE DE DATOS A LA ALARMA  DE MANDO
  $alarmaCentroMando = $datosCatConf->valor; // HAY UNA CAMPO LLAMADA VALOR EN LA LINEA ANTERIOR 


  foreach ($vehiculosdisponibles as $vehiculosdisponible) {
    if ($vehiculosdisponible->idRechazoPatrulla == 0 || $vehiculosdisponible->idRechazoPatrulla == null || $vehiculosdisponible->idPeticion != $idPeticion || $vehiculosdisponible->idPeticion == $idPeticion) {
      if ($vehiculosdisponible->vehiculoId != $alarmaCentroMando) {
        $vehiculosdisponiblesPeticion[] = $vehiculosdisponible;  // tenemos tos los veiculos menos a control de mando
      }
    }
    //verificar que la alarma de su comite este en los vehiculos disponibles:
    if ($alarmaComite->idVehiculo == $vehiculosdisponible->vehiculoId) {
      $alarmaComiteDisponible = true;
    }
  }

  if ($alarmaComiteDisponible == false) {
    $peticionesObj->ActualizarCampoPeticion(
      "statusAsignacionId",
      catStatusAsignacionObj::ALM_COMITE_OCUPADA,
      $peticion->idPeticion
    );
  }
  //fwrite($file, "Vehiculos disponibles: " . count($vehiculosdisponiblesPeticion) . PHP_EOL);
  /*$usuarioTurnoId = ($peticion->usuarioTurnoId > 0) ? $peticion->usuarioTurnoId : 0;
  $asignado = $usuariosTurnoObj->UsuariosTurnoPorId($usuarioTurnoId);*/
  //fwrite($file, "usuarioTurnoId: " . $usuarioTurnoId . PHP_EOL);
  //fclose($file);
  

  obtUnidadesCercanasApp($peticion, $vehiculosdisponiblesPeticion);
}

function getDistanceToCoords($lat1, $lon1, $lat2, $lon2)
{
  $R = 6371; // Radius of the earth in km

  $dLat = _deg2rad($lat2 - $lat1); // deg2rad below
  $dLon = _deg2rad($lon2 - $lon1);

  $a = sin($dLat / 2) * sin($dLat / 2) + cos(_deg2rad($lat1)) * cos(_deg2rad($lat2)) * sin($dLon / 2) * sin($dLon / 2);

  $c = 2 * atan2(sqrt($a), sqrt(1 - $a));

  $d = $R * $c; // Distance in km

  return number_format($d, 2);
}

function _deg2rad($deg)
{
  return $deg * (M_PI / 180);
}

function obtUnidadesCercanasApp($peticion, $vehiculos)
{
  
  $vehiculosObj = new vehiculosObj();
  $peticionesObj = new peticionesObj();
  $vehCercanos = [];
  $lat1 = $peticion->latitud; // datos de la peticion 
  $lon1 = $peticion->longitud;
  foreach ($vehiculos as $key => $value) {
    $colIndex = $vehiculos[$key]; // CONTIENE TODO LOS VEHICULOS CONTOO SUS CAMPOS.
    if ($colIndex != null) { // entra por que si tiiene datos
      $lat2 = $colIndex->latitud; // datos de los veiculos 
      $lon2 = $colIndex->longitud;
      $km = getDistanceToCoords($lat1, $lon1, $lat2, $lon2);
      $dataSuc = array(
        'idUserTurno' => $colIndex->idUserTurno,
        'conductor' => $colIndex->conductor,
        'idUserTurno' => $colIndex->idUserTurno,
        'latitud' => $colIndex->latitud,
        'longitud' => $colIndex->longitud,
        'matricula' => $colIndex->matricula,
        'tipoVehiculoId' => $colIndex->tipoVehiculoId,
        'turnoId' => $colIndex->turnoId,
        'unidad' => $colIndex->unidad,
        'usuarioVehiculoId' => $colIndex->usuarioVehiculoId,
        'km' => (float) $km,
        'vehiculoId' => $colIndex->vehiculoId,
        'idRechazoPatrulla' => $colIndex->idRechazoPatrulla,
        'idPeticion' => $colIndex->idPeticion,
        'estatusAlarma' => $colIndex->estatusAlarma,
        'idComite' => $colIndex->idComite,
        'soloComite' => $colIndex->soloComite,
        'distanciaAlarma' => $colIndex->distanciaAlarma,
        'usuarioTurnoVehiculoId' => $colIndex->usuarioTurnoVehiculoId
        // rechazo:  rechazoRes
      );
      // el if es para las colonias si entra pero eso depende la alrma o veiculo :)
      if ($peticion->opcComite == 1 && $peticion->idComiteUsuario == $colIndex->idComite && (float) $km <= ($colIndex->distanciaAlarma / 100)) {
        //$vehCercanos.push($dataSuc);
        array_push($vehCercanos, $dataSuc);
        //fwrite($file, "Por comite" . PHP_EOL);
        //fwrite($file, "Unidad: " . $colIndex->unidad ." km: ". $km . PHP_EOL);
      }
      // Validamos si esta a menos de 100m de una alarma 28/03/2020 Rafa
      //Alarmas con distancia mayor a 100m se discriminan
      if ((float) $km < 0.5) {
        array_push($vehCercanos, $dataSuc);

        //$vehCercanos.push($dataSuc);
        //fwrite($file, "Sin comite" . PHP_EOL);
        //fwrite($file, "Unidad: " . $colIndex->unidad ." km: ". $km . PHP_EOL);
      }
    }

    // Verificar si la alarma de comité se encuentra dentro de los vehiculos cercanos:
    $alarmaComite = $vehiculosObj->VehiculosPorComite($peticion->idComiteUsuario);

    $almComEnVehCercanos = false;
    foreach ($vehCercanos as $vehCercano) {

      if ($alarmaComite->idVehiculo == $vehCercano->vehiculoId) {
        $almComEnVehCercanos = true;
      }
    }
    $petActualizada = $peticionesObj->PeticionesPorId($peticion->idPeticion);

    $statusAsignacionId = $petActualizada->statusAsignacionId;
    if ($almComEnVehCercanos == false && $statusAsignacionId == NULL) {
      $peticionesObj->ActualizarCampoPeticion(
        "statusAsignacionId",
        catStatusAsignacionObj::ALM_COMITE_FUERA_RANGO,
        $peticion->idPeticion
      );
    }
    
  } // todo bien

  //ejemplo real
  for ($r = 0; $r < (count($vehCercanos) - 1); $r++) { //2
    for ($s = 0; $s < (count($vehCercanos) - $r); $s++) { // 3 
      $kmTemp1 = $vehCercanos[$s]["km"]; //0.1
      if ($vehCercanos[$s + 1] != null) {
        $kmTemp2 = $vehCercanos[$s + 1]["km"]; //0.19
        //fwrite($file, "kmTemp1 " . $kmTemp1 ." mayor que kmTemp2: " . $kmTemp2 . PHP_EOL);
        if ($kmTemp1 > $kmTemp2) {
          $aux = $vehCercanos[$s]; //guardamos el numero mayor en el auxiliar
          $vehCercanos[$s] = $vehCercanos[$s + 1]; //guardamos el numero menor en el lugar correspondiente
          $vehCercanos[$s + 1] = $aux; //asignamos el auxiliar en el lugar correspondiente
        }
      }
    }
  }
  
  actualizaPeticionVecinalApp($peticion, $vehCercanos);
} // todo bien  en obtUnidadesCercanasApp

function actualizaPeticionVecinalApp($peticion, $vehCercanos)
{
  //print_r($vehCercanos);
  include_once "shelly.php";
  $shelly = new shellyB();
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $peticionesObj = new peticionesObj();
  ///actualizar peticion vecinal utiliza peticion y vehiculos cercanos
  $arrayVehiculosExcluidos = [];
  $arrayVehiculoUnicos = [];
  $arraAlarmasPrendidas = [];
  $arrapatrullaPrendidas = [];
  $arrayAlarmasExcluidos = [];
  //$file = fopen("archivo.txt", "w");
  if (count($vehCercanos) == 0) {
    //fwrite($file, "sin alarma " . PHP_EOL);
    asignarUsuarioTurnoApp(0, $peticion->idPeticion, $peticion->asignado);
  }
  if ($peticion->opcComite == 1) { //CAMBIAR A 1
    $bandLocalizarAlarma = 0;

    foreach ($vehCercanos as $vehiculo) {

      if ($vehiculo['tipoVehiculoId'] == 4 && $vehiculo['estatusAlarma'] == 2) {
        array_push($arraAlarmasPrendidas, $vehiculo['idUserTurno']);
      }
      if ($vehiculo['idPeticion'] == $peticion->idPeticion) {
        array_push($arrayVehiculosExcluidos, $vehiculo['idUserTurno']);
      }
      //Excluir alarmar si es solo comite
      if ($vehiculo['soloComite'] == 1) {
        array_push($arrayAlarmasExcluidos, $vehiculo['idUserTurno']);
      }
    }

    if ($peticion->estatusId == 1 || $peticion->estatusId == 5) {
      $rechazo = 0;
      $rechazoRes = 0;
      foreach ($vehCercanos as $vehiculo) {
        $noPrint = 0;
        $bandLocalizar = 0;
        if ($vehiculo['idPeticion'] > 0) {

          if ($vehiculo['idPeticion'] == $peticion->idPeticion) {
            $rechazoRes = 1;
            $noPrint = 1;
          } else {
            if (in_array($vehiculo['idUserTurno'], $arrayVehiculosExcluidos)) {
              $rechazoRes = 1;
            } else {
              if (in_array($vehiculo['idUserTurno'], $arrayVehiculoUnicos)) {
                $noPrint = 1;
              } else {
                $noPrint = 0;
                array_push($arrayVehiculoUnicos, $vehiculo['idUserTurno']);
              }
              $rechazoRes = 0;
            }
          }
        } else {
          if (in_array($vehiculo['idUserTurno'], $arrayVehiculoUnicos)) {
            $noPrint = 1;
          } else {
            $noPrint = 0;
            array_push($arrayVehiculoUnicos, $vehiculo['idUserTurno']);
          }
          if (in_array($vehiculo['idUserTurno'], $arrayAlarmasExcluidos)) {
            $rechazoRes = 1;
          } else {
            $rechazoRes = 0;
          }
        }
        //todo bien 
        if ($noPrint == 0) {
          if ($rechazoRes == 0) {
            if ($rechazo == 0) {
              $rechazo = 1;
              $bandLocalizar = 1;
            }
          }

          if ($vehiculo['tipoVehiculoId'] == 4) {
            if ($vehiculo['activoV'] == 0) {
              if ($vehiculo['estatusAlarma'] == 1) {
                if ($vehiculo['soloComite'] == 1) {
                  if ($bandLocalizarAlarma == 0) {
                    print_r($vehiculo);
                    if (count($arraAlarmasPrendidas) >= 0) { /// si la alarma ya esta prendida  se ignora
                      $bandLocalizarAlarma = 1;
                      /// se enciende la alarma
                      //RHS validar que no prenda otras alarmas cuando ya se hizo la solicitud
                      //if ($peticion->asignado == 0) {
                      //fwrite($file, "desde opcion comite alarma encendida sin asignar usuario turno: ". $vehiculo['idUserTurno'] . PHP_EOL);
                      $peticionesObj->ActualizarCampoPeticion(
                        "statusAsignacionId",
                        catStatusAsignacionObj::ALM_COMITE_ASIGNADA,
                        $peticion->idPeticion
                      );
                      $idVehiculo = $vehiculo['vehiculoId'];
                      $idvehiculoTipo = $vehiculosObj->VehiculosPorId($idVehiculo);
                      $cuenta = $catCuentasObj->CuentaPorNombre($idvehiculoTipo->cuenta);
                      if ($cuenta->tipo == "tplink") {
                        verifyTokenAndServer($vehiculo['vehiculoId']);
                        $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                        if (is_array($resEncenderAlmApp)) {
                          $resErrorCode = $resEncenderAlmApp["error_code"];
                          $peticionesObj->ActualizarCampoPeticion("encendidoAlm", $resErrorCode, $peticion->idPeticion);
                          $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                        }
                        switch ($resErrorCode) {
                          case -20651:
                            verifyTokenAndServer($vehiculo['vehiculoId']);
                            // Volvemos a encender alarma y guardamos el codigo de error del segundo encendido en bd:
                            $resSegundoEncedido = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                            if (is_array($resSegundoEncedido)) {
                              $resErrorCode = $resSegundoEncedido["error_code"];
                              $peticionesObj->ActualizarCampoPeticion("segundoEncendidoAlm", $resErrorCode, $peticion->idPeticion);
                              $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                            }
                            break;
                        }
                      } elseif ($cuenta->tipo == "shelly") {

                        verifyTokenAndServer($vehiculo['vehiculoId']);
                        $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                        $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                        $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                      }
                      asignarUsuarioTurnoApp($vehiculo['idUserTurno'], $peticion->idPeticion, $peticion->asignado);
                      $peticionesObj->ActualizarCampoPeticion(
                        "statusAsignacionId",
                        catStatusAsignacionObj::ALM_PMI_ASIGNADA,
                        $peticion->idPeticion
                      );
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  } elseif ($peticion->opcComite == 0) {
    $bandLocalizarAlarma = 0;
    $bandLocalizarPatrullas = 0;
    

    foreach ($vehCercanos as $vehiculo) {

      if ($vehiculo['tipoVehiculoId'] == 4 && $vehiculo['estatusAlarma'] == 2) {
        array_push($arraAlarmasPrendidas, $vehiculo['idUserTurno']);
      }
      if ($vehiculo['tipoVehiculoId'] == 1 && $vehiculo['estatusAlarma'] == 2) {
        array_push($arrapatrullaPrendidas, $vehiculo['idUserTurno']);
      }
      if ($vehiculo['idPeticion'] == $peticion->idPeticion) {
        array_push($arrayVehiculosExcluidos, $vehiculo['idUserTurno']);
      }
      //Excluir alarmar si es solo comite
      if ($vehiculo['soloComite'] == 1) {
        array_push($arrayAlarmasExcluidos, $vehiculo['idUserTurno']);
      }
    }

    if ($peticion->estatusId == 1 || $peticion->estatusId == 5) {
      $rechazo = 0;
      $rechazoRes = 0;

      foreach ($vehCercanos as $vehiculo) {
        $noPrint = 0;
        $bandLocalizar = 0;
        if ($vehiculo['idPeticion'] > 0) {

          if ($vehiculo['idPeticion'] == $peticion->idPeticion) {
            $rechazoRes = 1;
            $noPrint = 1;
          } else {
            if (in_array($vehiculo['idUserTurno'], $arrayVehiculosExcluidos)) {
              $rechazoRes = 1;
            } else {
              if (in_array($vehiculo['idUserTurno'], $arrayVehiculoUnicos)) {
                $noPrint = 1;
              } else {
                $noPrint = 0;
                array_push($arrayVehiculoUnicos, $vehiculo['idUserTurno']);
              }
              $rechazoRes = 0;
            }
          }
        } else {
          if (in_array($vehiculo['idUserTurno'], $arrayVehiculoUnicos)) {
            $noPrint = 1;
          } else {
            $noPrint = 0;
            array_push($arrayVehiculoUnicos, $vehiculo['idUserTurno']);
          }
          if (in_array($vehiculo['idUserTurno'], $arrayAlarmasExcluidos)) {
            $rechazoRes = 1;
          } else {
            $rechazoRes = 0;
          }
        }
        //todo bien 
        if ($noPrint == 0) {
          if ($rechazoRes == 0) {
            if ($rechazo == 0) {
              $rechazo = 1;
              $bandLocalizar = 1;
            }
          }
       
          if($vehiculo['tipoVehiculoId'] == 1){
            // if ($vehiculo['activoV'] == 0) {
              if ($vehiculo['soloComite'] == 0 && $vehiculo['estatusAlarma'] == 1) {
                if ($bandLocalizarPatrullas == 0) {
                  if (count($arrapatrullaPrendidas) >= 0) {
                    $idPatrulla =$vehiculo['idUserTurno'];
                    
                    $historicoAsignadosObj = new historicoAsignadosObj();
                    $historicoAsignadosObj->idUsuarioTurno = $idPatrulla;
                    $historicoAsignadosObj->tipoAsignacion = "App";
                    $historicoAsignadosObj->idPeticion = $peticion->idPeticion;
                    $historicoAsignadosObj->GuardarAsignacionesPatrulla();
                    
                    //$peticionesObj->ActualizarCampoPeticion("usuarioTurnoVehiculoId", $idPatrulla, $peticion->idPeticion);
                  }
                  
                }
              }
            // }
          }
         
          
          if ($vehiculo['tipoVehiculoId'] == 4) {
            if ($vehiculo['activoV'] == 0) {
              if ($vehiculo['soloComite'] == 0 && $vehiculo['estatusAlarma'] == 1) {
                if ($bandLocalizarAlarma == 0) {
                  if (count($arraAlarmasPrendidas) >= 0) { /// si la alarma ya esta prendida  se ignora
                    $bandLocalizarAlarma = 1;
                    $idVehiculo = $vehiculo['vehiculoId'];
                    $idvehiculoTipo = $vehiculosObj->VehiculosPorId($idVehiculo);
                    $cuenta = $catCuentasObj->CuentaPorNombre($idvehiculoTipo->cuenta);
                    $alarmaId = $idvehiculoTipo->alarmaId;
                    $estadoapi = $shelly->respuesta_de_api($cuenta->token, $alarmaId, $cuenta->servidor);
                    $estadoshelly = $shelly->LineaShelly($cuenta->token, $alarmaId, $cuenta->servidor);
                    if ($cuenta->tipo == "tplink") {
                      verifyTokenAndServer($vehiculo['vehiculoId']);
                      $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                      if (is_array($resEncenderAlmApp)) {
                        $resErrorCode = $resEncenderAlmApp["error_code"];
                        $peticionesObj->ActualizarCampoPeticion("encendidoAlm", $resErrorCode, $peticion->idPeticion);
                        $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                      }
                      switch ($resErrorCode) {
                        case -20651:
                          verifyTokenAndServer($vehiculo['vehiculoId']);
                          // Volvemos a encender alarma y guardamos el codigo de error del segundo encendido en bd:
                          $resSegundoEncedido = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                          if (is_array($resSegundoEncedido)) {
                            $resErrorCode = $resSegundoEncedido["error_code"];
                            $peticionesObj->ActualizarCampoPeticion("segundoEncendidoAlm", $resErrorCode, $peticion->idPeticion);
                            $peticionesObj->actualizarStatusComunicacion($resErrorCode, $peticion->idPeticion);
                          }
                          break;
                      }
                    } elseif ($cuenta->tipo == "shelly") {
                      if ($estadoapi[0] == 200) {
                        if ($estadoshelly[0] == true) {
                          verifyTokenAndServer($vehiculo['vehiculoId']);
                          $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                          $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                          $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                        } elseif ($estadoshelly[0] == false) {
                          verifyTokenAndServer($vehiculo['vehiculoId']);
                          $resEncenderAlmApp = encenderAlarmaApp($vehiculo['vehiculoId'], 1, "", 0, $peticion->idPeticion);
                          $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                          //$peticionesObj->actualizarStatusComunicacion(-20571, $peticion->idPeticion);
                        $peticionesObj->actualizarStatusComunicacion(0, $peticion->idPeticion);
                        
                        }
                      } elseif ($estadoapi[0] == 400) {
                        verifyTokenAndServer($vehiculo['vehiculoId']);
                        $peticionesObj->ActualizarCampoPeticion("encendidoAlm", 0, $peticion->idPeticion);
                        $peticionesObj->actualizarStatusComunicacion(-20580, $peticion->idPeticion);
                      }
                    }
                    
                    asignarUsuarioTurnoApp($vehiculo['idUserTurno'], $peticion->idPeticion, $peticion->asignado);
                    $peticionesObj->ActualizarCampoPeticion(
                      "statusAsignacionId",
                      catStatusAsignacionObj::ALM_PMI_ASIGNADA,
                      $peticion->idPeticion
                    );
                  }
                }
              }
            }
          }
        }
      }
    }
    //fclose($file);
  }
}
// aqui arriba ya prende la alarma.

function asignarUsuarioTurnoApp($idUserTurno, $idPeticion, $peticionAsignada)
{
  $usuariosTurnoObj = new usuariosTurnoObj();
  $peticionesObj = new peticionesObj();
  $vehiculosObj = new vehiculosObj();
  $historicoAsignadosObj = new historicoAsignadosObj();
  $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
  $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
  $peticion = $peticionesObj->PeticionesPorId($idPeticion);
  $user = $usuariosTurnoObj->obtUsuarioPorIdUsuarioTurno($idUserTurno);
  
  if ($idUserTurno == 0 || $idUserTurno == '0') {
    $update = 0;
  } else {
    $update = $peticionesObj->ActualizarCampoPeticion("usuarioTurnoId", $idUserTurno, $idPeticion);
    // usuarioTurnoVehiculoId
  }

  $updateEst = $peticionesObj->ActualizarCampoPeticion("estatusId", 2, $idPeticion); // se actualiza el estatus en 2 para que se sepa que la patrulla esta asignada
  //$update = $peticionesObj->ActualizarCampoPeticion("usuarioTurnoId", $idUserTurno, $idPeticion);
  $peticionesObj->ActualizarCampoPeticion("asignado", 1, $_GET['idPeticion']);
  $peticionesObj->ActualizarCampoPeticion("fechaAsignacion", $dateTime, $idPeticion);
  $dataTurno = $usuariosTurnoObj->UsuariosTurnoPorId($idUserTurno);
  //$dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 2, $dataTurno->vehiculoId);
  $dataVehic = $vehiculosObj->ActualizarCampoVehiculos("estatusId", 1, $dataTurno->vehiculoId);

  //}

  $resPush = array();
  if ($update > 0) {
    //Mandar notificacion y guardar mensaje a la unidad asignada
    $regDispObj = new registroDispositivo();
    $peticion = $peticionesObj->PeticionesPorId($idPeticion);
    $turno = $usuariosTurnoObj->UsuariosTurnoPorId($idUserTurno);
    $regDispObj->usuarioId = $turno->usuarioVehiculoId;
    $colRegDisp = $regDispObj->obtTodosRegDispositivoPorIdUsr();

    //Diferencia
    $diferencia = obtenerDiferenciaPorFechaHoy($peticion->fechaCreacion, $dateTime, "%H:%i:%s");
    $peticionesObj->ActualizarCampoPeticion("tiempoAtendio", $diferencia, $idPeticion);

    //$return_arr = array("success" => true, "resPush" => $resPush, "dateTime" => $dateTime, "fechaCreacion" => $peticion->fechaCreacion);
  } else {
    //$return_arr = array("success" => false);
  }
  //$callback = $_GET['callback'];
  //echo $callback . '(' . json_encode($return_arr) . ');';
}

/* Realizar un segundo encendido para la alarma de la calle */
function verifyTokenAndServer($idVehiculo)
{
  $tplink = new TpLinkFramelova();
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $historicosObj = new historicosObj();
  $peticionesObj = new peticionesObj();

  // Realizamos el proceso de revision de token y actualizacion
  $almCalle = $vehiculosObj->VehiculosPorId($idVehiculo);
  $cuentaAlmCalle = $catCuentasObj->CuentaPorNombre($almCalle->cuenta);
  if ($cuentaAlmCalle->tipo == "tplink") {
    $responseToken = $tplink->returnToken($cuentaAlmCalle->usario, $cuentaAlmCalle->password);
    if ($cuentaAlmCalle->token != $responseToken["result"]['token']) { // el token retornado es diferente al que esta en db:

      $resActualizarCuenta = $catCuentasObj->ActualizarCampoCuenta("token", $responseToken["result"]['token'], $cuentaAlmCalle->idCuenta);

      if ($resActualizarCuenta > 0) { // se actualizo correctamente en bd:

        $fechaActual = (new DateTime("now", new DateTimeZone('America/Mexico_City')))->format('Y-m-d H:i:s');
        $histToken = array(
          "cuenta" => $cuentaAlmCalle->nombre,
          "tokenAnt" => $cuentaAlmCalle->token,
          "tokenNuevo" => $responseToken["result"]['token'],
          "fecha" => $fechaActual
        );

        $historicosObj->jsonUserTurn = json_encode($histToken);
        $historicosObj->tipoHist = 4;
        $historicosObj->GuardarHistoricos();
      }
    }

    // Validamos el servidor
    $responseServer = $tplink->verifyServer($responseToken["result"]['token'], $almCalle->alarmaId, $almCalle->server);
    if ($responseServer['equals'] == false) { // el servidor obtenido no coincide con el de base de datos y lo actualizamos:
      $resActualizarVehiculo = $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("server", $responseServer["serverFound"], $almCalle->alarmaId);
      if ($resActualizarVehiculo > 0) { // se actualizo correctamente en bd:

        $fechaActual = (new DateTime("now", new DateTimeZone('America/Mexico_City')))->format('Y-m-d H:i:s');
        $vehiculosObj->ActualizarCampoAlarmaByAlarmaId("fechaActualizacion", $fechaActual, $almCalle->alarmaId);
      }
    }
  }
}

function encenderAlarmaApp($idVehiculo, $accionAlm, $historico = "", $usuarioId = 0, $idPeticion)
{
  $vehiculosObj = new vehiculosObj();
  $catCuentasObj = new catCuentasObj();
  $peticionesObj = new peticionesObj();
  $vehiculo = $vehiculosObj->VehiculosPorId($idVehiculo);
  //$toggle = ($vehiculo->estatusAlarma == 1)?true:false;
  $accion = ($accionAlm != null && $accionAlm != "") ? $accionAlm : "";
  //$estatusUpd = ($vehiculo->estatusAlarma == 1) ? 2 : 1;
  $estatusUpd = ($accion == 0 || $accion == "0") ? 1 : 2;
  /*$estatusUpd=1;
  if($accion == 0 || $accion == "0"){
    $estatusUpd=1;
  }else{
    $estatusUpd=2;
  }*/
  $accionFinal = ($accion == 1) ? true : false;

  $vehiculosObj->ActualizarCampoVehiculos("estatusAlarma", $estatusUpd, $idVehiculo);

  // 30/03/2020 JAIR Guardar en historico la accion si asi se requiere
  if ($historico != "") {
    if ($historico == 1) {
      $historicosObj = new historicosObj();
      $accionH = ($accion == 1) ? "encendido_manual" : "apagado_manual";

      $arrJson = array("accion" => $accionH, "tabla" => "alarmas", "idUsuario" => $usuarioId, "idAlarma" => $idVehiculo);
      $historicosObj->jsonUserTurn = json_encode($arrJson);
      $historicosObj->tipoHist = 1;
      $historicosObj->GuardarHistoricos();
    }
  }

  $cuenta = $catCuentasObj->CuentaPorNombre($vehiculo->cuenta);

  if ($cuenta->tipo == "tplink") {
    $alarmaId = $vehiculo->alarmaId;
    $useUrl = $vehiculo->server;
    $token = $cuenta->token;
    include_once "tplink-framelova.php";
    $tplink = new TpLinkFramelova();
    $res = $tplink->plugSwitch($useUrl, $token, array(    // bool, default false
      "deviceId" => $alarmaId, // deviceId, default none
      "useUrl" => $useUrl      // optional specify appServerUrl (Previously provided)
    ), $accionFinal);
  } elseif ($cuenta->tipo == "shelly") {

    $alarmaId = $vehiculo->alarmaId;
    $token = $cuenta->token;
    $shellyserver = $cuenta->servidor;

    include_once "shelly.php";

    $shelly = new shellyB();
    $res = $shelly->SwithPlug($token, $alarmaId, $accionFinal, $shellyserver);
  }
  return $res;
  //$return_arr = array("res" => $res);

  //echo $callback . '(' . json_encode($return_arr) . ');';
}
?>
