<?php
$dirname = dirname(__DIR__);
include_once $dirname.'/brules/PHPExcel/PHPExcel.php';
include_once $dirname.'/brules/datosUsuarioObj.php';
include_once $dirname.'/brules/vehiculosObj.php';
include_once $dirname.'/brules/historicoAsignadosObj.php';
include_once $dirname.'/brules/catStatusAsignacionObj.php';
include_once $dirname.'/brules/historialInicioSesionObj.php';
include_once $dirname.'/common/config.php';
include_once $dirname.'/common/globalFunctions.php';

$fechaAcceso = $_GET['fechaAcceso'];
$fechaAccesoFin = $_GET['fechaAccesoFin'];

$connectionStatus = mysqli_connect($cfg_server,$cfg_user, $cfg_pw, $cfg_db);

// Las columnas deben de estar en el orden en que son expuestas en el reporte:
$query = '
    SELECT 
    his.idInicioSesion,
    uv.nombre,
    his.fechaHoraInicioSesion,
    his.fechaHoraCierreSesion,
    v.unidad,
    v.matricula,
    his.tiempoLoggeado,
    his.usuarioCerrarSesion,
    (SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(tiempoEstacionado))),"00:00:00") FROM vehiculosEstacionados WHERE idInicioSesion = his.idInicioSesion) AS totalEstacionado,
    (SELECT IFNULL(SEC_TO_TIME(SUM(TIME_TO_SEC(tiempoDesconexion))),"00:00:00") FROM historialDesconexionInternet WHERE idInicioSesion = his.idInicioSesion) AS totalDesconexion,
    (SELECT COUNT(idAsignacion) FROM historico_asignados ha WHERE ha.idInicioSesion = his.idInicioSesion ) AS totalAsignaciones
    FROM historialInicioSesion his 
    LEFT JOIN usuarios_turno ut on ut.idUserTurno = his.idUsuarioTurno
    LEFT JOIN vehiculos v on v.idVehiculo = ut.vehiculoId
    LEFT JOIN usuario_vehiculo uv on idUsuarioVehiculo = ut.usuarioVehiculoId
    WHERE his.fechaHoraInicioSesion >= \''.$fechaAcceso.' 00:00:00\' AND his.fechaHoraInicioSesion <= \''.$fechaAccesoFin.' 23:59:59\' 
    ORDER BY his.idInicioSesion DESC;
';

$titulosColumnas = array(
  "ID Inicio Sesion",
  "Nombre",
  "Fecha Inicio Sesion",
  "Fecha Cierre Sesion", 
  "Unidad",
  "Matricula",
  "Tiempo Loggeado",
  "Usuario en Cerrar Sesion",
  "Tiempo estacionado",
  "Tiempo desconectado de internet", 
  "Total de asignaciones"
);

$columnas = array(
  'idInicioSesion',
  'nombre',
  'fechaHoraInicioSesion',
  'fechaHoraCierreSesion',
  'unidad', 
  'matricula',
  'tiempoLoggeado',
  'usuarioCerrarSesion',
  'totalEstacionado',
  'totalDesconexion',
  'totalAsignaciones'
);
  
//ejecutamos query
$result =  mysqli_query($connectionStatus, $query);
$info_campos = $result->fetch_fields();
    
if (PHP_SAPI == 'cli') die('Este archivo solo se puede ver desde un navegador web');

// Se crea el objeto PHPExcel
$objPHPExcel = new PHPExcel();

// Se asignan las propiedades del libro
$objPHPExcel->getProperties()->setCreator("Framelova")
->setLastModifiedBy("Framelova")
->setTitle("Reporte de accesos de patrulleros")
->setSubject("AccesosPatrulleros")
->setDescription("Reporte de accesos de patrulleros por fecha asignada")
->setKeywords("Reporte Accesos Patrulleros")
->setCategory("AccesosPatrulleros");
            
//inyectamos titulos de columnas
$totalTituloCol = count($titulosColumnas);
$colB = 'A';
$FilaTitulo = 1;

for($i=1; $i <= $totalTituloCol; $i++){
    $objPHPExcel->getActiveSheet()->setCellValue($colB.$FilaTitulo, $titulosColumnas[$i-1]);
    $colB++;
}

//inyectamos filas
$contLetra = "$colB"."1";
$iIns=2;
$colA = 'A';
$filaActual = 2;
$lastCol = 'A';

// Agregamos la columna de los datos del reporte:
for($i=0; $i<(count($columnas)+1); $i++){
    $lastCol++;
}

$datosUsuarioObj = new datosUsuarioObj();
$vehiculosObj = new vehiculosObj();
$functions = new globalFunctions();
while ($row=mysqli_fetch_array($result)) {
    for($i=1; $i<=(count($columnas)); $i++){   
        //obtenemos el tipo para saber si tiene otro tratamiento
        $type = $info_campos[$i-1]->type;

        if($type == 12){//fecha
            $dateForm=explode(" ",$row[$i-1]);
            $dateForm1=explode("-",$dateForm[0]);
            // $fecha = (isset($dateForm1[2])) ? ($dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1]) : "";
            // $dateForm1F= $dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1];
            $dateForm1F = (isset($dateForm1[2])) ? ($dateForm1[2]."/".$dateForm1[1]."/".$dateForm1[0]." ".$dateForm[1]) : "--";

            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, $dateForm1F);
            $colA++;
        }else{
            //$objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, utf8_encode($row[$i-1]));
            //$objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, $row[$i-1]);
            $objPHPExcel->setActiveSheetIndex(0)->setCellValue($colA.$filaActual, (($row[$i-1] == NULL) ? "--" : utf8_encode($row[$i-1])));
            $colA++;
        } 
    }
  $colA = 'A';
  $filaActual++;
}
 
$estiloTituloColumnas = array('font' => array('name'=> 'Arial','bold'=> true,'size'=>10,'color'=> array('rgb' => '000000')),'alignment' => array('horizontal'=>PHPExcel_Style_Alignment::HORIZONTAL_CENTER,'vertical'=>PHPExcel_Style_Alignment::VERTICAL_CENTER,'wrap'=>TRUE));

$estiloInformacion = new PHPExcel_Style();
$estiloInformacion->applyFromArray(array('font' => array('name'=>'Arial', 'size'=>8, 'color'=> array('rgb' => '000000'))));

    $objPHPExcel->getActiveSheet()->getStyle('A1:'.$lastCol.'1')->applyFromArray($estiloTituloColumnas);

for($j = 'A'; $j < $lastCol; $j++){
    $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);
}
// Se asigna el nombre a la hoja
$objPHPExcel->getActiveSheet()->setTitle('AccesosPatrulleros');

// Se activa la hoja para que sea la que se muestre cuando el archivo se abre
$objPHPExcel->setActiveSheetIndex(0);

// Inmovilizar paneles
$objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,2);

$titletmp = "AccesosPatrulleros-".$fechaAcceso;
$titleFile = "Reporte-".$titletmp.".xls";
header('Content-Type: application/vnd.ms-excel');
header("Content-Disposition: attachment;filename=$titleFile");
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

$objWriter->save('php://output');

exit;
ob_flush();

?>