<?php
$dirname = dirname(__DIR__);
include_once $dirname.'/common/config.php';
include_once $dirname.'/brules/PHPExcel/PHPExcel.php';
include_once $dirname."/database/calificarAtencionDB.php";

if (PHP_SAPI == 'cli') die('Este archivo solo se puede ver desde un navegador web');

$calificarAtencionDB = new calificarAtencionDB();
$startDate = $_GET["fechaInicio"];
$endDate = $_GET["fechaFin"];

$result = $calificarAtencionDB->getOpinionsByDateDB($startDate, $endDate);

// Se asignan las propiedades del libro
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator("Framelova") //Author
  ->setLastModifiedBy("Framelova") //Ultimo usuario que lo modifico
  ->setTitle("Reporte de Calificaciones")
  ->setSubject("Calificar la atencion")
  ->setDescription("Reporte de calificaciones hechas por los usarios a traves de su app movil, ordenados por fecha de creacion")
  ->setKeywords("Reporte Calificar la atencion")
  ->setCategory("Calificar la atencion");
    

$titulosColumnas = array(
  "ID",
  "Comite",
  "Usario", 
  "Rol",
  "Comentario", 
  "Fecha Comentado",
);
$columnas = array(
  "idOpinion", 
  "nombreComite",
  'nombreUsuario',
  "rol", 
  'comentario', 
  'fechaCreacion',
);
// Inyectamos titulos de columnas
$totalTituloCol = count($titulosColumnas);
$colB = 'A';
$FilaTitulo = 1;
for($i=1; $i<=$totalTituloCol; $i++){
  $objPHPExcel->getActiveSheet()->setCellValue($colB.$FilaTitulo, $titulosColumnas[$i-1]);
  $colB++;
}
// Inyectamos filas
$contLetra = "$colB"."1";
$iIns=2;
$colA = 'A';
$filaActual = 2;
$lastCol = 'A';
for($i=0; $i<count($columnas); $i++){
  $lastCol++;
}

// Inyectamos los datos
$info_campos = $result->fetch_fields();
while ($row = mysqli_fetch_array($result)) {
  for ($i = 1; $i <= count($columnas); $i++){
    // Obtenemos el tipo para saber si tiene otro tratamiento
    $type = $info_campos[$i-1]->type;

    if ($type == 12) { //fecha
      
      $date = explode(" ", $row["fechaCreacion"]);
      $onlyDate = explode("-", $date[0]);
      $hour = $date[1];
      $dateWithFormat = (isset($onlyDate[2]) ? $onlyDate[2] : "") . "/" . 
        (isset($onlyDate[1]) ? $onlyDate[1] : "") . "/" . 
        (isset($onlyDate[0]) ? $onlyDate[0] : "") . " $hour";

      $objPHPExcel->setActiveSheetIndex(0)->setCellValue("F".$filaActual, $dateWithFormat);
      $colA++;
    } else {
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue("A".$filaActual, $row["idOpinion"]);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue("B".$filaActual, $row["nombreComite"]);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue("C".$filaActual, $row["nombreUsuario"]);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue("D".$filaActual, $row["rol"]);
      $objPHPExcel->setActiveSheetIndex(0)->setCellValue("E".$filaActual, $row["comentario"]);

      $colA++;
    }
  }
  $colA = 'A';
  $filaActual++;
}
    
// Ponemos estilo a las columnas y filass
$estiloTituloColumnas = array('font' => array('name'=> 'Arial','bold'=> true,'size'=>10,'color'=> array(
    'rgb' => '000000')),'alignment' => array('horizontal'=>PHPExcel_Style_Alignment::HORIZONTAL_CENTER,'vertical'=>PHPExcel_Style_Alignment::VERTICAL_CENTER,'wrap'=>TRUE));

$estiloInformacion = new PHPExcel_Style();
$estiloInformacion->applyFromArray(array('font' => array('name'=>'Arial', 'size'=>8, 'color'=> array('rgb' => '000000'))));

$objPHPExcel->getActiveSheet()->getStyle('A1:'.$lastCol.'1')->applyFromArray($estiloTituloColumnas);

for($j = 'A'; $j < $lastCol; $j++){
  $objPHPExcel->getActiveSheet()->getColumnDimension($j)->setAutoSize(true);
}
// Se asigna el nombre a la hoja
$objPHPExcel->getActiveSheet()->setTitle('FormularioWeb');

// Se activa la hoja para que sea la que se muestre cuando el archivo se abre
$objPHPExcel->setActiveSheetIndex(0);

// Inmovilizar paneles
$objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,2);

$titleDate = ($startDate != "" && $endDate != "") ? 
  ($startDate . "__" . $endDate) 
  : "Todo";
$titleFile = "Reporte_Calificaciones_$titleDate.xls";
header('Content-Type: application/vnd.ms-excel');
header("Content-Disposition: attachment;filename=$titleFile");
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');

$objWriter->save('php://output');

exit;
ob_flush();
?>