<?php
$dirname = dirname(__DIR__);

include_once  $dirname . '/database/FormularioRespuestaBD.php';
include_once  $dirname . '/database/datosBD.php';
include_once  $dirname . '/brules/configuracionesGridObj.php';

class FormularioRespuestaObj  extends configuracionesGridObj
{
    private $_idRespuestaPregunta = 0;
    private $_idPreguntaFormulario  = 0;
    private $_idUsuario  = 0;
    private $_idOpcionPregunta   = '';
    private $_respuesta   = 0;
    private $_fechaHoraRespuesta   = '0000-00-00 00:00:00';
    private $_finalizado = '';
    private $_folio = '';
    

    //get y set

    public function __get($name)
    {
        return $this->{"_" . $name};
    }

    public function __set($name, $value)
    {
        $this->{"_" . $name} = $value;
    }

    
    public function GuardarRespuestaFormulario(){
        $objDB = new FormularioRespuestaBD();
        $this->_idRespuestaPregunta = $objDB->GuardarRespuestaFormularioBD($this->getParams(true));
    }

    public function verificarOBJ($id,$folio){
        $objDB = new FormularioRespuestaBD();
        $datosBD = new datosBD();
        $obj = new FormularioRespuestaObj();
        $result = $objDB->verificarBD($id,$folio);
        return $datosBD->setDatos($result, $obj);   
    
    }

    public function UpdateRespuesta(){
        $objDB = new FormularioRespuestaBD();
        return $objDB->UpdateRespuesta($this->getParams(false));
    }



    private function getParams($Update = false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City'));
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaHoraRespuesta = $dateTime;

        $params[0] = $this->_idPreguntaFormulario;
        $params[1] = $this->_idUsuario;
        $params[2]=  $this->_idOpcionPregunta;
        $params[3] = $this->_respuesta;
        $params[4] = $this->_fechaHoraRespuesta;
        $params[5] = $this->_finalizado;
        $params[6] = $this->_folio;

        if($Update == false){
            $params[7] = $this->_idRespuestaPregunta;
        }
    
        return $params;
    }

    public function eliminmarRespuestaObj($ID){
        $objDB = new FormularioRespuestaBD();
        $datosBD = new datosBD();
        $obj = new FormularioRespuestaObj();
        $result = $objDB->eliminmarRespuestaBD($ID);
        return $result;  
    }

}
