<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/botonesPeticionDB.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class botonesPeticionObj extends configuracionesGridObj{
    private $_idBoton = 0;
    private $_tipoBoton = 0;
    private $_identificador = "";
    private $_activo = 0;
    private $_idUsuario = 0;

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function obtDatosPorIdentificadorBoton($idBoton){
        $ds = new botonesPeticionDB();
        $obj = new botonesPeticionObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosPorIdentificadorBotonBD($idBoton);

        return $datosBD->setDatos($result, $obj);
    }

    public function obtDatosPorIdBoton($idBoton){
        $ds = new botonesPeticionDB();
        $obj = new botonesPeticionObj();
        $datosBD = new datosBD();
        $result = $ds->obtDatosPorIdBotonBD($idBoton);

        return $datosBD->setDatos($result, $obj);
    }

    public function ObtTodosBotonesRegistrados($idUsuario){
        $array = array();
        $ds = new botonesPeticionDB();
        $datosBD = new datosBD();
        $result = $ds->ObtTodosBotonesRegistradosDB($idUsuario);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    public function ActualizarCampoBotonesPeticion($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new botonesPeticionDB();
        $resAct = $objDB->updateCampoBotonesPeticionBD($param);
        return $resAct;
    }

    public function GuardarBotonesPeticion(){
        $objDB = new botonesPeticionDB();
        $this->_idBoton = $objDB->insertBotonesPeticionBD($this->getParams());
    }

    private function getParams($update = false){
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s');

        $param[0] = $this->_tipoBoton;
        $param[1] = $this->_identificador;
        $param[2] = $this->_activo;
        $param[3] = $this->_idUsuario;
        $param[4] = $this->$dateTime;
        return $param;
    }

    public function GetInfoBotonSilenciosoGrid($idRol = 0){
        $DataServices = new DataServices();
        $dbConn = $DataServices->getConnection();
        $ds = new MySQLiDataSource($dbConn);
        $uDB = new botonesPeticionDB();
        $ds = $uDB->BotonesPeticionDataSet($ds, $idRol);
        $grid = new KoolGrid("botonSilencioso");
        $grid->ClientSettings->ClientEvents["OnRowStartEdit"] = "Handle_OnRowStartEdit";
        $configGrid = new configuracionesGridObj();
        $configGrid->defineGrid($grid, $ds);
        $configGrid->defineColumn($grid, "idBoton", "ID Boton",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "identificador", "Identificador",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "activo", "Activo",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "idUsuario", "Usuario",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "calle", "Calle",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "numero", "Numero",  true, true, 0, "", "auto");
        $configGrid->defineColumn($grid, "colonia", "Colonia",  true, true, 0, "", "auto");
        $configGrid->defineColumnCoordenadasBotonSilencioso($grid);
        $grid->Process();
        return $grid;
    }
}
