<?php

$dirname = dirname(__DIR__);

include_once  $dirname . '/database/catBotonesLlaveroDB.php';

include_once  $dirname . '/database/datosBD.php';

include_once  $dirname . '/brules/configuracionesGridObj.php';



class catBotonesLlaveroObj extends configuracionesGridObj {

    private $_idBoton = 0;

    private $_identificador = '';

    private $_color = '';

    private $_fechaRegistro = '0000-00-00 00:00:00';

    private $_comentarios= '';



    //get y set

    public function __get($name) {

        return $this->{"_".$name};

    }

    public function __set($name, $value) {

        $this->{"_".$name} = $value;

    }



    public function getCatBotonesLlaveros()

    {

        $array = array();

        $ds = new catBotonesLlaveroDB();

        $datosBD = new datosBD();

        $result = $ds->getCatBotonesLlaverosDB();

        $array = $datosBD->arrDatosObj($result);

        return $array;

    }

   

    //create Grid

    public function GetBotonesLlaverosGrid()

    {

        $DataServices = new DataServices();

        $dbConn = $DataServices->getConnection();

        $ds = new MySQLiDataSource($dbConn);

        $uDB = new catBotonesLlaveroDB();

        $ds = $uDB->botonesLlaverosDataSet($ds);

        $grid = new KoolGrid("botonesllaveros");

        $configGrid = new configuracionesGridObj();



        $configGrid->defineGrid($grid,$ds);

        $configGrid->defineColumn($grid,"idBoton","ID Boton", true, true);

        $configGrid->defineColumn($grid,"identificador","Identificador", true, false, 1, "");

        $configGrid->defineColumn($grid, "color", "Color", true, false, 1, "");

        $configGrid->defineColumn($grid,"comentarios","Comentarios", true, false, 1, "");

        $configGrid->defineColumn($grid,"fechaRegistro","Fecha de registro", true, true, 1, "");

        $configGrid->defineColumnEdit($grid);



        $grid->Process();

        return $grid;

    }



}