<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/rptCiudadanoUsuarioDB.php';
include_once  $dirname.'/database/datosBD.php';

class rptCiudadanoUsuarioObj{
    private $_idRptCUsuario = 0;
    private $_rptCId = 0;
    private $_usuarioId = 0;
    private $_folio = '';
    private $_estatus = 0;
    private $_urlImg = '';
    private $_ubicacion = '';
    private $_comentario = '';
    private $_fechaCreacion = '0000-00-00 00:00:00';
    private $_fechaCreacion2 = '0000-00-00 00:00:00';
    private $_datosJson = '';

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    //Obtener coleccion de RptCiudadanoUsuarioObjs
    public function GetAllRptCiudadanoUsuario(){
        $array = array();
        $ds = new rptCiudadanoUsuarioDB();
        $datosBD = new datosBD();
        $result = $ds->GetAllRptCiudadanoUsuarioDB();
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }

    //Obtener RptCiudadanoUsuarioObjs por su id
    public function obtRptCiudadanoUsuarioPorIdUsr($id){
        $array = array();        
        $ds = new rptCiudadanoUsuarioDB();
        $datosBD = new datosBD();

        $result = $ds->obtRptCiudadanoUsuarioPorIdUsrDB($id);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
    //Obtener RptCiudadanoUsuarioObjs por su id
    public function obtRptCiudadanoUsuarioPorId($id){
        $array = array();
        $ds = new rptCiudadanoUsuarioDB();
        $datosBD = new datosBD();
        $obj = new rptCiudadanoUsuarioObj();
        $result = $ds->obtRptCiudadanoUsuarioPorIdDB($id);
        return $datosBD->setDatos($result, $obj);
    }
    // guardar RptCiudadanoUsuarioObjs
    public function GuardarRptCiudadanoUsuario(){
        $objDB = new rptCiudadanoUsuarioDB();
        $this->_idRptCUsuario = $objDB->insertRptCiudadanoUsuarioDB($this->getParams());
    }
    //Eliminar RptCiudadanoUsuarioObjs
    public function EliminarRptCiudadanoUsuarioObj($idDatoUsuario)
    {
        $objDB = new rptCiudadanoUsuarioDB();
        $param[0] = $idDatoUsuario;
        return $objDB->deleteRptCiudadanoUsuarioDB($param);
    }
    public function ActualizarCampo($campo, $valor, $id){
        $param[0] = $campo;
        $param[1] = $valor;
        $param[2] = $id;

        $objDB = new rptCiudadanoUsuarioDB();
        $resAct = $objDB->updateCampoDB($param);
        return $resAct;
    }
    public function GetAllRptCiudadanoUsuarioByFecha($fInicio,$fFin){
      $array = array();
      $ds = new rptCiudadanoUsuarioDB();
      $datosBD = new datosBD();
      $result = $ds->GetAllRptCiudadanoUsuarioByFechaDB($fInicio,$fFin);
      $array = $datosBD->arrDatosObj($result);
      return $array;
    }
    public function GetAllRptCiudadanoUsuarioByFechaCategria($fInicio,$fFin,$categoria){
      $array = array();
      $ds = new rptCiudadanoUsuarioDB();
      $datosBD = new datosBD();
      $result = $ds->GetAllRptCiudadanoUsuarioByFechaCategoriaDB($fInicio,$fFin,$categoria);
      $array = $datosBD->arrDatosObj($result);
      return $array;
    }
    private function getParams($ctr=false)
    {
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha Actual
        $this->_fechaCreacion = $dateTime;        

        $param[0] = $this->_rptCId;
        $param[1] = $this->_usuarioId;
        $param[2] = $this->_folio;
        $param[3] = $this->_estatus;
        $param[4] = $this->_urlImg;
        $param[5] = $this->_ubicacion;
        $param[6] = $this->_comentario;
        $param[7] = $this->_datosJson;
        $param[8] = $this->_fechaCreacion;

        return $param;
    }

    public function GetRptCiudadanosGrid(){
       $DataServices = new DataServices();
       $dbConn = $DataServices->getConnection();
       $ds = new MySQLiDataSource($dbConn);
       $uDB = new rptCiudadanoUsuarioDB();
       $ds = $uDB->RptCiudadanosDataSet($ds);
       $grid = new KoolGrid("ReporteCiudadanosGrid");
       $this->defineGridReporteCiudadanos($grid, $ds);
       $this->defineColumnRpt($grid, "idRptCUsuario", "ID", false, true);
       $this->defineColumnRpt($grid, "rptCId", "Tipo", true, false, 1,"100px");
       $this->defineColumnRpt($grid, "usuarioId", "Usuario", true, false, 1,"100px");
       $this->defineColumnRpt($grid, "comentario", "Comentario", true, false, 1,"200px");
       $this->defineColumnEditUser($grid);

       //pocess grid
       $grid->Process();

       return $grid;
   }

   //Private Functions
   private function defineGridReporteCiudadanos($grid, $ds)
   {
       //create and define grid
       $grid->scriptFolder = "../brules/KoolControls/KoolGrid";
       $grid->styleFolder="office2010blue";
       $grid->Width = "860px";

       $grid->RowAlternative = true;
       $grid->AjaxEnabled = true;
       $grid->AjaxLoadingImage =  "../brules/KoolControls/KoolAjax/loading/5.gif";
       $grid->Localization->Load("../brules/KoolControls/KoolGrid/localization/es.xml");

       $grid->AllowInserting = true;
       $grid->AllowEditing = true;
       $grid->AllowDeleting = true;
       $grid->AllowSorting = true;
       $grid->ColumnWrap = true;
       $grid->AllowScrolling = true;
       //$grid->MasterTable->Height = "540px";
       $grid->MasterTable->ColumnWidth = "90px";
       $grid->AllowResizing = true;

       $grid->MasterTable->DataSource = $ds;
       $grid->MasterTable->AutoGenerateColumns = false;
       $grid->MasterTable->Pager = new GridPrevNextAndNumericPager();
       $grid->MasterTable->Pager->ShowPageSize = true;
       $grid->MasterTable->Pager->PageSizeOptions = "10,25,50,100,150";
       //Show Function Panel
       $grid->MasterTable->ShowFunctionPanel = true;
       //Insert Settings
       $grid->MasterTable->InsertSettings->Mode = "Form";
       $grid->MasterTable->EditSettings->Mode = "Form";
       $grid->MasterTable->InsertSettings->ColumnNumber = 1;
       $grid->ClientSettings->ClientEvents["OnRowConfirmEdit"] = "Handle_OnRowConfirmEdit";
       $grid->ClientSettings->ClientEvents["OnConfirmInsert"] = "Handle_OnConfirmInsert";
   }
   //define the grid columns
   private function defineColumnRpt($grid,$name_field, $name_header, $visible=true, $read_only=false, $validator=0, $width = "90px")
   {

        if($name_field == 'rptCId'){
          $column = new GridDropDownColumn();
          $rptCiudadanoObj = new catRptCiudadanosObj();
          $rptCiudadanoArr = $rptCiudadanoObj->GetAllCatRptCiudadanos(1);
          $column->AddItem('-- Seleccionar --',NULL);
          foreach($rptCiudadanoArr as $ciudadanoTmp)
          {
              $column->AddItem($ciudadanoTmp->nombre,$ciudadanoTmp->idRptC);
          }
        }elseif ($name_field == 'usuarioId') {
          $column = new GridDropDownColumn();
          $usuarioObj = new usuariosObj();
          $usuarioArr = $usuarioObj->obtTodosUsuarios();
          $column->AddItem('-- Seleccionar --',NULL);
          foreach($usuarioArr as $usuarioTmp)
          {
              $column->AddItem($usuarioTmp->nombre,$usuarioTmp->idUsuario);
          }
        }else {
          $column = new gridboundcolumn();
        }



       if($validator > 0)
           $column->addvalidator($this->GetValidatorUser ($validator));

       $column->Visible = $visible;
       $column->DataField = $name_field;
       $column->HeaderText = $name_header;
       $column->ReadOnly = $read_only;
       $column->Width = $width;
       $grid->MasterTable->AddColumn($column);
   }
   //validar campo
   private function GetValidatorUser($type){
       switch ($type) {
           case 1: //required
               $validator = new RequiredFieldValidator();
               $validator->ErrorMessage = "Campo requerido";
               return $validator;
               break;
           case 2:
               $validator = new RegularExpressionValidator();
               $validator->ValidationExpression = "/^([0-9])+$/"; // Only accept integer.
               $validator->ErrorMessage = "Escriba un valor numerico";
               return $validator;
               break;
       }
   }
   //define la columna de acciones
   private function defineColumnEditUser($grid){
       $column = new GridCustomColumn();
       $column->ItemTemplate = '
           <a class="kgrLinkEdit" onclick="grid_edit(this)" href="javascript:void 0" title="Editar"></a>'
           . '<a class="kgrLinkDelete" onclick="grid_delete(this)" href="javascript:void 0" title="Eliminar"></a>';
       $column->Align = "center";
       $column->HeaderText = "Acciones";
       $column->Width = "120px";
       $grid->MasterTable->AddColumn($column);
   }

  public function reportesCiudadano(){

          $result = $this->GetAllRptCiudadanoUsuario();
        //  var_dump($result);
        //  die();
          // $result = $this->ObtTareas($idUsuario, $tipo, true);
          $idTable = "rptCiudadanoGrid";
          $tituloColNombre = '';
          $contenColNombre = '';

          $html = '
          <div class="datable_bootstrap">
              <table id="'.$idTable.'" class="table table-striped table-bordered table-condensed dataTable no-footer dt-responsive" role="grid" cellspacing="0" width="100%" >
                  <thead>
                      <tr>
                          <th>Id<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Comentario<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Autor<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Tipo<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Folio<i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Fecha Creacion <i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Imagen <i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                          <th>Ver detalles <i class="fa fa-fw fa-sort " aria-hidden="true"></i></th>
                      </tr>
                  </thead>
                  <tbody>
                  ';
                  if(count($result)>0){
                      foreach($result as $item){
                                  $usuariosObj = new usuariosObj();
                                  $imagen = base64_encode(file_get_contents(dirname(__DIR__).'/upload/rpt_ciudadano/'.$item->urlImg));
                                  $usuario = $usuariosObj->UserByID($item->usuarioId);
                                    $html .= '
                                    <tr>
                                        <td>'.$item->idRptCUsuario.'</td>
                                        <td>'.$item->comentario.'</td>
                                        <td>'.$usuario->nombre.'</td>
                                        <td>'.$item->rptCId.'</td>
                                        <td>'.$item->folio.'</td>
                                        <td>'.convertirFechaVista($item->fechaCreacion).'</td>
                                        <td><img src="data:image/jpeg;base64,'.$imagen.'" class="framelova-zoomOnImage" id="RPTC-'.$item->urlImg.'"></td>
                                        <td>
                                        <a class="kgrLinkDelete" onclick="detallesReporte('.$item->idRptCUsuario.')" href="javascript:void 0" title="Detalles"><img src="../images/eye.png" class="iconoDesactivar" ></a></td>';
                                  $html .= '  </tr> ';
                          }
                      }

              $html .= '
                  </tbody>
              </table>
              </div>
          ';
          return $html;
  }

  public function reporteCiudadanoById($id){
    $item = $this->obtRptCiudadanoUsuarioPorId($id);
    
    $usuariosObj = new usuariosObj();
    $imagen = base64_encode(file_get_contents(dirname(__DIR__).'/upload/rpt_ciudadano/'.$item->urlImg));
    $usuario = $usuariosObj->UserByID($item->usuarioId);
    return '<div style="background-color: white; width: 100%; padding: 20px; margin-bottom: 20px">
              <div class="row">
                <div class="col-xs-12" style="justify-content: center; align-items: center; display: flex; flex-direction: column;">
                  <input type="hidden" value="'.$item->ubicacion.'" id="coordenadas">
                  <div class="framelova-spacedBetweenRow">
                    <div>N&uacute;mero de reporte:</div>
                    <div><strong>'.$item->idRptCUsuario.'</strong></div>
                  </div>
                  <hr>
                  <div class="framelova-spacedBetweenRow">
                    <div>Folio:</div>
                    <div><strong>'.$item->folio.'</strong></div>
                  </div>
                  <hr>
                  <div class="framelova-spacedBetweenRow">
                    <div>Fecha:</div>
                    <div><strong>'.convertirFechaVistaConHora($item->fechaCreacion).'</strong></div>
                  </div>
                  <hr>
                  <div class="framelova-spacedBetweenRow">
                    <div>Usuario:</div>
                    <div><strong>'.$usuario->nombre.'</strong></div>
                  </div>
                  <hr>
                  <div style="width: 100%; height: auto; display: flex; justify-content: space-between; flex-direction: row;">
                    <div>Comentario:</div>
                    <div style="display: flex; max-width: 60%;"><strong>'.$item->comentario.'</strong></div>
                  </div>
                  <hr>
                  <div class="framelova-spacedBetweenRow">
                    <div>Evidencia:</div>
                    <div><img src="data:image/jpeg;base64,'.$imagen.'" class="framelova-zoomOnImage" id="RPTC-'.$item->urlImg.'"></div>
                  </div>
                </div>
              </div>
            </div>';
  }
}
