<?php

$pathDB = 'database/';
$pathBrules = '../brules/';

if (file_exists('../database/saveDataDB.php')) {
    $pathDB = '../database/';
    $pathComm = 'brules/';
}
include_once $pathDB . 'saveDataDB.php';

class saveData {
    
    //Private Fields
    private $_idQuestion = 0;
    private $_idQuestionary = 0;
    private $_idLanguage = 0;
    private $_dataJson = '';
    private $_orderQuestion = '';
    
     //Get Set Methods
    public function setIdQuestion($value)
    {$this->_idQuestion = $value;}
    public function getIdQuestion()
    {return $this->_idQuestion;}
    
    public function setIdQuestionary($value)
    {$this->_idQuestionary = $value;}
    public function getIdQuestionary()
    {return $this->_idQuestionary;}
    
    public function setIdLanguage($value)
    {$this->_idLanguage = $value;}
    public function getIdLanguage()
    {return $this->_idLanguage;}
    
    public function setDataJson($value)
    {$this->_dataJson = $value;}
    public function getDataJson()
    {return $this->_dataJson;}
    
    public function setOrderQuestion($value)
    {$this->_orderQuestion = $value;}
    public function getOrderQuestion()
    {return $this->_orderQuestion;}
    
    
    public function CheckExistQuestionsByQuestionnaires(){
        $ds = new saveDataDB();
        $result = $ds->CheckExistQuestionsByQuestionnaires($this->_idQuestionary);
                        
        if($result){      
            $myRows = mysqli_fetch_array($result);
            
            if($myRows['idQuestion'] == false){
                return 0;
            }else{
                return 1;
            }                
        }                
    }
    
    public function createIDQuestions(){
        $ds = new saveDataDB();
        $id = $ds->createIDQuestionsDB($this->_idQuestionary);
        
        return $id;
    }
    
    //salvar los datos del formulario
    public function SaveDataForm($idQ, $idL, $data){
        $ds = new saveDataDB();
        $this->_idQuestion = $ds->SaveDataFormDB($idQ, $idL, $data);
    }        
    
    //obtener la coleccion de preguntas        
    public function GetAllQuestions($idQuestionary, $idL){
        $resArr = array();
        $objDS = new saveDataDB();
        $result = $objDS->GetAllQuestions($idQuestionary, $idL);
        
        if ($result)
        {
            while($myRows = mysqli_fetch_array($result)) 
            {
                $objTmp = new saveData();
                $objTmp->setIdQuestion($myRows['idQuestion']);
                $objTmp->setIdQuestionary($myRows['idQuestionary']);
                $objTmp->setIdLanguage($myRows['idLanguage']);
                $objTmp->setDataJson(json_decode($myRows['dataJson']));
                $objTmp->setOrderQuestion($myRows['orderQuestion']);
                                
                $resArr[$objTmp->getIdQuestion()] = $objTmp;
            }
        }
        
        return $resArr;
    }
    
    //obtener arreglo de idiomas por id cuestionario
    public function GetAllLanguageByIDQuestionnary($idQuestionary){
        $resArr = array();
        $objDS = new saveDataDB();
        $result = $objDS->GetAllLanguageByIDQuestionnary($idQuestionary);
        
        if ($result)
        {
            while($myRows = mysqli_fetch_array($result)) 
            {
                $objTmp = new saveData();
                $objTmp->setIdLanguage($myRows['idLanguage']);                                
                                
                $resArr[$objTmp->getIdLanguage()] = $objTmp;
            }
        }
        
        return $resArr;
    }
    
    //salvar el orden de las preguntas
    public function SaveOrderQuestions($data){
        $ds = new saveDataDB();
        $col=$ds->SaveOrderQuestionsDB($data);
        return $col;
    }       
    
    //obtener pregunta por id    
    public function GetQuestionByID($id){
        $objDS = new saveDataDB();
        $result = $objDS->GetQuestionByID($id);
        
        if ($result)
        {
            
            $myRows = mysqli_fetch_array($result);
            if($myRows == false) return;
            $this->_idQuestion = $myRows['idQuestion'];                                                
            $this->_idQuestionary = $myRows['idQuestionary'];
            $this->_idLanguage = $myRows['idLanguage'];
            $this->_dataJson = json_decode($myRows['dataJson']);
            $this->_orderQuestion = $myRows['orderQuestion'];
        }
    }
    
    //Actualizar datos de la pregunta
    public function UpdateDataQuestion($idPreg, $data){
        $ds = new saveDataDB();
        $result = $ds->UpdateDataQuestionDB($idPreg, $data);
        return $result;
    }  
    
    //elimina la pregunta
    public function DeleteQuestionById($idPreg){
        $ds = new saveDataDB();
        $result = $ds->DeleteQuestionById($idPreg);
        return $result;
    }  
    
    //Contruir tipo 1 = textoSimple
    public function GetResultByType($data, $ctr, $idQuestion, $langID){  
        
        //Solo vamos armar estos arreglos si son tipo  u 8
        $arrTextoCaritas = array();
        
        if($data->tipo == 5 || $data->tipo == 8){
            $langObj = new Language();
            $langObj->LanguageByID($langID);
            $langCaritasArr = $langObj->getLagCaritsArr();
            $arrTextoCaritas[2] = array(
                                        (object)array("imgCarita"=>"excelente.png",
                                            "txtCarita"=>"$langCaritasArr[1]", "idCarita"=>"1"),
                                        (object)array("imgCarita"=>"pesimo.png",
                                            "txtCarita"=>"$langCaritasArr[5]", "idCarita"=>"5")
                                        );
            $arrTextoCaritas[3] = array(
                                        (object)array("imgCarita"=>"excelente.png",
                                            "txtCarita"=>"$langCaritasArr[1]", "idCarita"=>"1"),
                                        (object)array("imgCarita"=>"regular.png",
                                            "txtCarita"=>"$langCaritasArr[3]", "idCarita"=>"3"),
                                        (object)array("imgCarita"=>"pesimo.png",
                                            "txtCarita"=>"$langCaritasArr[5]", "idCarita"=>"5")
                                        );
            $arrTextoCaritas[4] = array(
                                        (object)array("imgCarita"=>"excelente.png",
                                            "txtCarita"=>"$langCaritasArr[1]", "idCarita"=>"1"),
                                        (object)array("imgCarita"=>"bien.png",
                                            "txtCarita"=>"$langCaritasArr[2]", "idCarita"=>"2"),    
                                        (object)array("imgCarita"=>"mal.png",
                                            "txtCarita"=>"$langCaritasArr[4]", "idCarita"=>"4"),
                                        (object)array("imgCarita"=>"pesimo.png",
                                            "txtCarita"=>"$langCaritasArr[5]", "idCarita"=>"5")
                                        );  
            $arrTextoCaritas[5] = array(
                                        (object)array("imgCarita"=>"excelente.png",
                                            "txtCarita"=>"$langCaritasArr[1]", "idCarita"=>"1"),
                                        (object)array("imgCarita"=>"bien.png",
                                            "txtCarita"=>"$langCaritasArr[2]", "idCarita"=>"2"),
                                        (object)array("imgCarita"=>"regular.png",
                                            "txtCarita"=>"$langCaritasArr[3]", "idCarita"=>"3"),    
                                        (object)array("imgCarita"=>"mal.png",
                                            "txtCarita"=>"$langCaritasArr[4]", "idCarita"=>"4"),
                                        (object)array("imgCarita"=>"pesimo.png",
                                            "txtCarita"=>"$langCaritasArr[5]", "idCarita"=>"5")
                                        );          
        }
        
                
//        echo '<pre>';
//            print_r($data);
//        echo '</pre>';
        
        switch ($data->tipo) {
            //opcion de texto simple
            case 1: ?>                
                    <div class="pregunta">
                        <?php echo $data->pregunta;?>
                    </div>
                    <div class="respuestas text">                        
                        <div class="respuesta" id="respuesta1">
                             <input type="text" name="idPreg_<?php echo $idQuestion;?>" id="texto_<?php echo $idQuestion;?>" />                             
                        </div>                        
                    </div>                                    
                    <?php
                break;
            //Texto varias lineas
            case 2: ?>
                    <div class="pregunta">
                        <?php echo $data->pregunta;?>
                    </div>
                    <div class="respuestas text">                        
                        <div class="respuesta">
                            <textarea name="idPreg_<?php echo $idQuestion;?>" id="texto_<?php echo $idQuestion;?>"></textarea>                             
                        </div>                        
                    </div>
                    <?php
                break;
            //opcion de radio
            case 3:
            case 6:
                ?>
                    <div class="pregunta"><?php echo $data->pregunta;?></div>                    
                    <div class="respuestas radio">                        
                        <?php                            
                            for($i=1; $i<=$data->ctrMax; $i++){
                                $dataOpc = $data->{"opcResp_".$i};
                                $img = isset($data->{"imagen_".$i}) ? $data->{"imagen_".$i} : '';
                                $classOthr = isset($data->{"opcRespCheckOth_".$i}) ? "radioOther" : 'noOther';
                        ?>
                                <div class="respuesta">                                                                        
                                    <input type="radio" name="idPreg_<?php echo $idQuestion;?>" id="radio_<?php echo $idQuestion.'_'.$i;?>" value="<?php echo $i;?>" class="<?php echo $classOthr; ?>" tipoOptExtra="radio">                                                                                                            
                                    <label for="radio_<?php echo $idQuestion.'_'.$i;?>" >
                                        <?php if($img!=''){ ?>
                                                <img src="<?php echo $img;?>" >
                                        <?php } ?>
                                        <?php echo $dataOpc;?>
                                    </label>
                                    <div id="forOther_radio_<?php echo $idQuestion.'_'.$i;?>" class="clearOptExtra"></div>
                                </div>
                        <?php } ?>                        
                    </div>                                                                
                <?php
                break;
            //opcion de checkboxes       
            case 4:
            case 7:
                 ?>
                 <div class="pregunta"><?php echo $data->pregunta;?></div>
                 <div class="respuestas checkbox">                      
                        <?php                            
                            for($i=1; $i<=$data->ctrMax; $i++){
                                $dataOpc = $data->{"opcResp_".$i};
                                $img = isset($data->{"imagen_".$i}) ? $data->{"imagen_".$i} : '';
								$classOthr = isset($data->{"opcRespCheckOth_".$i}) ? "radioOther" : 'noOther';
                        ?>          
                                <div class="respuesta">                                                                        
                                    <input type="checkbox" name="idPreg_<?php echo $idQuestion;?>" id="check_<?php echo $idQuestion.'_'.$i;?>" value="<?php echo $i;?>" class="<?php echo $classOthr; ?>" tipoOptExtra="check">                                                                                                    
                                    <label for="check_<?php echo $idQuestion.'_'.$i;?>" >
                                        <?php if($img!=''){ ?>
                                            <img src="<?php echo $img;?>">
                                        <?php } ?>
                                        <?php echo $dataOpc;?>
                                    </label> 
									<div id="forOther_check_<?php echo $idQuestion.'_'.$i;?>" class="clearOptExtra"></div>
                                </div>
                        <?php } ?>                     
                </div>
                                                                                                                     
                <?php
                break;
            //opcion de caritas    
            case 5:
                 ?>
                  <div class="pregunta"><?php echo $data->pregunta;?></div>
                  
                  <div class="respuestas radio imagen">                       
                        <?php
                            $opcioncaritas = (int)$data->opcioncaritas;
                            $colTextoCaritas = $arrTextoCaritas[$opcioncaritas];
                            $cout = 1;
                                                        
                            foreach($colTextoCaritas as $elemCarita){                                
                            ?>   
                                <div class="respuesta">
                                    <input type="radio" name="idPreg_<?php echo $idQuestion;?>" id="radiocarita_<?php echo $idQuestion.'_'.$cout;?>" value="<?php echo $elemCarita->idCarita;?>">                                    
                                    <label for="radiocarita_<?php echo $idQuestion.'_'.$cout;?>" ><img src="<?php echo 'images/'.$elemCarita->imgCarita;?>"><?php echo $elemCarita->txtCarita;?></label>                                                                        
                                </div>    
                        <?php 
                         $cout++;
                         } ?>                       
                  </div>                                                                               
                <?php
                break;
              //Caritas con compartir
                case 8:
                    //para asegurarnos siempre sea un array
                    if(!is_array($data->showShare)){
                        $shareOpts[] = $data->showShare;
                    }
                    else{
                        $shareOpts = $data->showShare;
                    }
                 ?>
                  <div class="pregunta"><?php echo $data->pregunta;?></div>
                  
                  <div class="respuestas radio imagen">                       
                        <?php
                            $opcioncaritas = (int)$data->opcioncaritas;
                            $colTextoCaritas = $arrTextoCaritas[$opcioncaritas];
                            $cout = 1;
                                                        
                            foreach($colTextoCaritas as $elemCarita){                                
                                $spClass = (array_search($cout, $shareOpts) === FALSE) ? 'noShare':'showShare';
                            ?>   
                                <div class="respuesta">
                                    <input type="radio" name="idPreg_<?php echo $idQuestion;?>" id="radiocarita_<?php echo $idQuestion.'_'.$cout;?>" value="<?php echo $elemCarita->idCarita;?>" class="<?php echo $spClass; ?>">                                    
                                    <label for="radiocarita_<?php echo $idQuestion.'_'.$cout;?>" ><img src="<?php echo 'images/'.$elemCarita->imgCarita;?>"><?php echo $elemCarita->txtCarita;?></label>                                                                        
                                </div>    
                        <?php 
                         $cout++;
                         } ?>
                         
                  </div>                                                                               
                <?php
                break;
                
                case 9:
                ?>
                    <div class="pregunta"><?php echo $data->pregunta;?></div>                                                                                    
                        <?php                            
                            for($i=1; $i<=$data->ctrMax; $i++){
                                $img = isset($data->{"imagen_".$i}) ? $data->{"imagen_".$i} : '';
                        ?>
                                <div class="respuesta">
                                <?php if($img!=''){ ?>
                                    <img src="<?php echo $img;?>" >
                                <?php } ?>
                                </div>
                        <?php } ?>
                <?php
                break;
        }                
    }
    
}

?>