<?php
$dirname = dirname(__DIR__);
include_once  $dirname.'/database/vehiculosEstacionadosBD.php';
include_once  $dirname.'/database/datosBD.php';
include_once  $dirname.'/brules/configuracionesGridObj.php';

class vehiculosEstacionadosObj {
    private $_idVehiculoEstacionado = 0;
    private $_fechaHoraInicioEstacionamiento = '';
    private $_fechaHoraFinEstacionamiento = "";
    private $_coordenadasEstacionamiento = "";
    private $_idUsuarioTurno = "";
    private $_idUsuario = "";
    private $_tiempoEstacionado = "";
    private $_idInicioSesion = "";

    //get y set
    public function __get($name) {
        return $this->{"_".$name};
    }
    public function __set($name, $value) {
        $this->{"_".$name} = $value;
    }

    public function GuardarVehiculoEstacionado(){
        $objDB = new vehiculosEstacionadosDB();
        $this->_idVehiculoEstacionado = $objDB->insertVehiculosEstacionadoBD($this->getParams());
    }

    private function getParams($update = false){
        $param[0] = $this->_fechaHoraInicioEstacionamiento;
        $param[1] = $this->_fechaHoraFinEstacionamiento;
        $param[2] = $this->_coordenadasEstacionamiento;
        $param[3] = $this->_idUsuarioTurno;
        $param[4] = $this->_idUsuario;
        $param[5] = $this->_tiempoEstacionado;
        $param[6] = $this->_idInicioSesion;
        return $param;
    }

    public function obtTodosEstacionamientosSesion($idInicioSesion){
        $array = array();
        $ds = new vehiculosEstacionadosDB();
        $datosBD = new datosBD();
        $result = $ds->obtTodosEstacionamientosSesionDB($idInicioSesion);
        $array = $datosBD->arrDatosObj($result);
        return $array;
    }
}
