<?php

/*
 *  © 2017 Framelova. All rights reserved. Privacy Policy
 *  Creado: 11/07/2017
 *  Por: JCarlos Ramírez García - JCRG
 *  Descripción: registro dispositivo database object
 */
$dirname = dirname(__DIR__);
include_once  $dirname.'/common/DataServices.php';

class registroDispositivosDB 
{        
        
    public function insertarRegDispositivoDB($usuarioId, $idRegDispositivo, $plataforma){
        $ds = new DataServices();
        
        $dateByZone = new DateTime("now", new DateTimeZone('America/Mexico_City') );
        $dateTime = $dateByZone->format('Y-m-d H:i:s'); //fecha y hora

        $param[0]= $usuarioId;
        $param[1]= $idRegDispositivo;
        $param[2]= 1;
        $param[3]= $plataforma;
        $param[4]= $dateTime;
    
        $result = $ds->Execute("insertarRegDispositivoDB", $param, true);	
        $ds->CloseConnection();

        return $result;
    }
    
    //Comprobar que ya existe el registro del dispositivo
    public function ObtRegDispositivoPorIdRegDB($idReg, $idUsuario){
        $ds = new DataServices();
        $param[0]= $idReg;
        $param[1]= $idUsuario;
        $result = $ds->Execute("ObtRegDispositivoPorIdRegDB", $param); 
        $ds->CloseConnection();
        return $result;
    }


    public function obtTodosRegDispositivoPorIdUsrDB($usuarioId){
        $ds = new DataServices();
        $param[0]= $usuarioId;        
        $result = $ds->Execute("obtTodosRegDispositivoPorIdUsrDB", $param); 
        $ds->CloseConnection();

        return $result;
    }

    public function ObtUsuarioPorIdRegDispositivoDB($idDispositivo){
        $ds = new DataServices();
        $param[0]= $idDispositivo;        
        $result = $ds->Execute("ObtUsuarioPorIdRegDispositivoDB", $param); 
        $ds->CloseConnection();

        return $result;
    }

    //Actualizar el registro por el id del usuario 
    public function ActRegActivoDB($regDispositivo, $plataforma, $idReg){
        $ds = new DataServices();
        $param[0]= $regDispositivo;
        $param[1]= '1';
        $param[2]= $plataforma;
        $param[3]= $idReg;
        $result = $ds->Execute("ActRegActivoDB", $param);   
        $ds->CloseConnection();
        return $result;
    }    

    public function getPorIdUserBD($id){
        $ds = new DataServices();
        $param[0]= $id;        
        $result = $ds->Execute("GetRegistridispositipoPorIdUser", $param); 
        $ds->CloseConnection();

        return $result;
    }    
}
?>