/*
 * Date: 5/05/2017
 * Actualizado: 11/01/2018
 * Funciones generales y especificas de javascript
 */

var encenderAlarmaCentral = 0;
var desplegarInfoPeticion = false;

/**
 * Para cambios_usuarios
 */
var arrayResultPreEdit = [];
var validoValor = "";

$(document).ready(function () {
  $('input[name="activo"]').click(function () {
    var v = $(this).val();
    var value = v == 1 ? "0" : "1";
    $("#activo").val(value);
  });

  if (typeof tieneAlertify !== "undefined") {
    defineAlertify();
  }
  if ($(".duallb").length) {
    $(".duallb").bootstrapDualListbox({
      nonSelectedListLabel: 'Non-selected',
      selectedListLabel: 'Selected',
      preserveSelectionOnMove: 'moved',
      moveOnSelect: false
    });
  }
  //Validar formulario registro gama de modelo
  if ($("#formRegGamaModelo").length) {
    $("#formRegGamaModelo").validate({
      submitHandler: function (form) {
        // setLoading($(form).attr('id'));
        form.submit();
      },
    });
  }

  //Para todas las vistas que tengan fechas con kool agregar atributo readonly
  $("#fechaDel").attr("readonly", "readonly");
  $("#fechaAl").attr("readonly", "readonly");

  /* INICIO FANCYBOX */
  if ($("#btnAgregarPlan").length) {
    $("#btnAgregarPlan").fancybox({
      autoDimensions: false,
      padding: 30,
      width: 900,
      height: 900,
      autoScale: true,
      closeBtn: true,
      closeClick: false,
      helpers: {
        overlay: {
          closeClick: true
        },
      },
      beforeLoad: function () { },
    });
  }

  // if($("#btnAyudaweb").length){
  //   $("#btnAyudaweb").fancybox({
  //     autoDimensions: false,
  //     padding : 30,
  //     width : 900,
  //     height : 900,
  //     autoScale : true,
  //     closeBtn : true,
  //     closeClick  : false,
  //     helpers : {
  //      overlay : {closeClick: true}
  //    },
  //    beforeLoad: function() {
  //    }
  //  });
  // }

  /* FIN FANCYBOX */

  //
  $(document).on("click", ".hostpot", function () {
    gralClic = false;
  });

  //Mostrar campo para la nueva galeria
  $("#btn_agregargaleria").click(function () {
    $("#cont_nueva_galeria").show();
  });
  $("#btn_aceptaragregargaleria").click(function () {
    if ($("#nueva_galeria").val() != "") {
      $("#cont_nueva_galeria").hide();
      loadingAjax("cont_selgaleria");
      var params = {
        funct: "agregarGaleria",
        galeria: $("#nueva_galeria").val(),
      };
      ajaxData(params, function (data) {
        // console.log(data);
        if (data.success == true) {
          idG = 0;
          var res = koolajax.callback(dropDownGaleria(idG));
          // console.log(res);
          setTimeout(function () {
            $("#cont_selgaleria").html(res);
          }, 1500);
        }
      });
    }
  });

  //Recargar el grid de zonas
  /*$(".btnMenu6").click(function(){
    versionZonaGrid.refresh();
    versionZonaGrid.commit();
  });*/

  // Abrir chat de operador por default 
  if ($("#btn_chat_operador").length) {
    $("#btn_chat_operador").trigger("click");
  }

  if ($("#btn_chat_operador2").length) {
    $("#btn_chat_operador2").trigger("click");
  }

  //Mostrar por default las peticiones sin asignar 
  if ($("#mpm_3").length) {
    $("#mpm_3").trigger("click");

  }
  //NUEVO TEMPLATE
  /*$('.modal-sizes').magnificPopup({
   type: 'inline',
   preloader: false,
   modal: true
   }); */

  //intervalo para mantenerse escuchando peticiones recibidas
  seleccionaOpcion(2);

  /**
   * Toggle para ajax
   * 23/06/21
   * JARED GILBON
   */
  $('input[name=toggleBtnCerco]').change((event) => {
    //dis = alusivo a 'this'
    event.preventDefault;
    var dis = event.currentTarget;
    $(dis).data('valor') === 'activo' ? $(dis).prop('checked', true) : $(dis).prop('checked', false);
    const isActivo = $(dis).is(":checked");

    if (isActivo === true) {
      alertify.confirm('Advertencia',
        `¿Est&aacute; seguro de desactivar el cerco geogr&aacute;fico?`, () => {

          const params = {
            funct: "actualizarConfiguracion",
            idConfiguracion: 6,
            nombre: 'Estado de cerco geografico',
            valor: 'inactivo'
          };

          ajaxData(params, function (data) {
            if (data.success) {
              $(dis).prop('checked', false);
              alertify.success('Cerco geogr&aacute;fico desactivado');
              $(dis).data('valor', 'inactivo');
              $('#estadoCerco').html('inactivo');
            }
          });


        }, () => {
          alertify.closeAll()
        });
    } else {
      const params = {
        funct: "actualizarConfiguracion",
        idConfiguracion: 6,
        nombre: 'Estado de cerco geografico',
        valor: 'activo'
      };

      ajaxData(params, function (data) {
        if (data.success) {
          $(dis).prop('checked', true);
          alertify.success('Cerco geogr&aacute;fico activado');
          $(dis).data('valor', 'activo');
          $('#estadoCerco').html('activo');
        }
      });
    }

  })
});

var arrPeticionesPorAsignar = [];
var arrPeticionesAsignadas = [];
var selected = 0;
var vehiculosEncontrados = [];
var rechazo = 0;

function guardarFrmUsuario() {
  $.validator.setDefaults({
    success: "valid",
  });
  //Agregar metodo de validacion
  $.validator.addMethod("emailRepetido", function (value, element, param) {

    var result; //Variable para el resultado
    var idUsuarioAct = $("#idUsuario").val(); //Id usuario actual
    var data = {
      funct: "verificaExisteEmail",
      email: value,
    }; //Parametros ajax

    $.ajax({
      async: false,
      type: "GET",
      dataType: "jsonp",
      data: data,
      jsonp: "callback",
      url: "../ajaxcall2/ajaxFunctions.php",
      success: function (data) {
        //console.log(data);
        if (data.success) {
          //console.log(data)

          //si el usuario encontrado es mayor a 0 y es diferente al usuario actual
          if (data.idUsuario > 0 && data.idUsuario != idUsuarioAct) {
            result = false;
          } else {
            result = true;
          }
        }
      },
      error: function (jqXHR, exception) {
        var msg = "";
        if (jqXHR.status === 0) {
          msg = "Not connect.\n Verify Network.";
        } else if (jqXHR.status == 404) {
          msg = "Requested page not found. [404]";
        } else if (jqXHR.status == 500) {
          msg = "Internal Server Error [500].";
        } else if (exception === "parsererror") {
          msg = "Requested JSON parse failed.";
        } else if (exception === "timeout") {
          msg = "Time out error.";
        } else if (exception === "abort") {
          msg = "Ajax request aborted.";
        } else {
          msg = "Uncaught Error.\n" + jqXHR.responseText;
        }
        alertify.error(msg);
      },
    });

    return result;
  },
    "Este correo ya se ha registrado en el sistema, por favor escriba otro."
  );

  //Agregar al formulario la validacion por el metodo personalizado
  $("#formUsuario").validate({
    rules: {
      emailU: {
        emailRepetido: true,
        email: true,
        required: true,
      },
    },
  });

  //     $("#formUsuario").validate({
  //   debug: true
  // });

  htmlOriginal = showLoading("btnGuardarUsuario");
  //Si el formulario es valido realizar post
  if ($("#formUsuario").valid()) {
    //Submit form
    $("#formUsuario").submit();
  } else {
    //Ocultar loading
    hideLoading("btnGuardarUsuario", htmlOriginal);
    // console.log("invalido");
  }
}

function guardarFrmPatrullero() {
  $.validator.setDefaults({
    success: "valid",
  });

  $.validator.addMethod("emailRepetido", function (value, element, param) {
    var result;
    var idUsuarioAct = $("#idUsuario").val();
    var data = {
      funct: "verificaExisteEmail",
      email: value,
    };

    $.ajax({
      async: false,
      type: "GET",
      dataType: "jsonp",
      data: data,
      jsonp: "callback",
      url: "../ajaxcall2/ajaxFunctions.php",
      success: function (data) {
        if (data.success) {
          if (data.idUsuario > 0 && data.idUsuario != idUsuarioAct) {
            result = false;
          } else {
            result = true;
          }
        }
      },
      error: function (jqXHR, exception) {
        var msg = "";
        if (jqXHR.status === 0) {
          msg = "Not connect.\n Verify Network.";
        } else if (jqXHR.status == 404) {
          msg = "Requested page not found. [404]";
        } else if (jqXHR.status == 500) {
          msg = "Internal Server Error [500].";
        } else if (exception === "parsererror") {
          msg = "Requested JSON parse failed.";
        } else if (exception === "timeout") {
          msg = "Time out error.";
        } else if (exception === "abort") {
          msg = "Ajax request aborted.";
        } else {
          msg = "Uncaught Error.\n" + jqXHR.responseText;
        }
        alertify.error(msg);
      },
    });
    return result;
  },
    "Este correo ya se ha registrado en el sistema, por favor escriba otro."
  );

  $("#formPatrullero").validate({
    rules: {
      emailU: {
        emailRepetido: true,
        email: true,
        required: true,
      },
    },
  });


  htmlOriginal = showLoading("btnGuardarPatrullero");
  if ($("#formPatrullero").valid()) {
    $("#formPatrullero").submit();
  } else {
    hideLoading("btnGuardarPatrullero", htmlOriginal);
  }
}

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>METODOS ESPECIFICOS FUERA DEl $(document).ready<<<<<<
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

//desactivar un registro del grid seleccionado
function grid_activardesactivar(id, grid, valor) {
  switch (grid) {
    case "gamamodelo":
      // console.log(id);
      // console.log(grid);
      // console.log(valor);
      params = {
        funct: "ActivaDesactivaGModelo",
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        // console.log("hola");
        if (data.success) {
          // console.log("success");
          gamaModelosGrid.refresh();
          gamaModelosGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;

    case "versiongral":
      params = {
        funct: 'ActivaDesactivaVersionGral',
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        // console.log("hola");
        if (data.success) {
          // console.log("success");
          versionGeneralGrid.refresh();
          versionGeneralGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;
    case 'versionprecio':
      params = {
        funct: 'ActivaDesactivaVersionPrecio',
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        // console.log("hola");
        if (data.success) {
          // console.log("success");
          versionPrecioGrid.refresh();
          versionPrecioGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;
    case 'versionplan':
      params = {
        funct: 'ActivaDesactivaVersionPlan',
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        if (data.success) {
          // console.log("success");
          versionPlanGrid.refresh();
          versionPlanGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;
    case 'versionrequisito':
      params = {
        funct: 'ActivaDesactivaVersionReq',
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        if (data.success) {
          // console.log("success");
          versionRequisitoGrid.refresh();
          versionRequisitoGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;
    case 'versioncolor':
      params = {
        funct: 'ActivaDesactivaVersionColor',
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        if (data.success) {
          // console.log("success");
          versionColorGrid.refresh();
          versionColorGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;
    case 'versionzona':
      params = {
        funct: 'ActivaDesactivaVersionZona',
        id: id,
        valor: valor
      };
      ajaxData(params, function (data) {
        if (data.success) {
          // console.log("success");
          versionZonaGrid.refresh();
          versionZonaGrid.commit();
          alertify.success("Actualizado correctamente");
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
      break;
  }
}

function mostrarAlertify() {
  var opc = parseInt($("#tipoAviso").val());
  // console.log(typeof(opc));
  // console.log(opc);
  switch (opc) {
    case 0:
      alertify.error("No se ha podido guardar el registro");
      // console.log(opc);
      break;
    case 1:
      alertify.success("Cambios guardados correctamente");
      // console.log(opc);
      break;
    case 2:
      // alertify.notify('custom message.', 'custom', 2, function(){console.log('dismissed');});
      alertify.success("No hay cambios que guardar");
      // console.log(opc);
      break;
    case 3:
      alertify.error("Error al subir la imagen");
      break;
    default:
      // console.log("default");
      break;
  }
}

//Mostrar alerta de mensajes personalizados
function verificaFormVG() {
  // console.log($("#vgcaracteristicas").val());
  $.validator.setDefaults({
    success: "valid",
  });
  $("#formVersionGral").validate({
    rules: {
      vgcaracteristicas: {
        required: true,
      },
    },
  });
  tinymce.triggerSave();
  // console.log($("#vgcaracteristicas").val());
  $("#vgcarachidden").val($("#vgcaracteristicas").val());
  if ($("#formVersionGral").valid()) {
    if ($("#vgcaracteristicas").val() == "") {
      alertify.error("Por favor llene las caracteristicas");
    } else {
      $("#formVersionGral").submit();
    }
  } else {
    alertify.error("Por favor rellene todos los campos para continuar");
  }
}

function mostrarFancyAgregarPlan(verPlanId, idTipoPlan) {
  if (verPlanId == 0) {
    $("#idVersionPlan").val(0);
    $("#vp_idtipoplan").val("");
    var htmlOriginal = showLoading('btnGuardarPlan');
    setTimeout(function () {
      $("#div_vp_carac").html(
        '<textarea class="form-control required" name="vp_carac" id="vp_carac" rows="4"></textarea>'
      );
      // hideLoading('contenidoRec',html);
      var params = {
        selector: "#vp_carac",
        height: "230",
        btnImg: true
      };
      opcionesTinymce(params);
      // tinymce.init({
      //   selector: "#vp_carac",
      //   theme: "modern",
      //   plugins: [
      //   ["advlist autolink link image lists preview hr pagebreak"],
      //   ["searchreplace wordcount visualblocks visualchars code media"],
      //   ["save contextmenu directionality emoticons paste"]
      //   ],
      //   height : "230"
      // });
      hideLoading("btnGuardarPlan", htmlOriginal);
      // hideLoading('btnGuardarReco',htmlOriginal2);
    }, 1000);
  } else {
    params = {
      funct: "obtVersionPlan",
      idVersionPlan: verPlanId
    };
    ajaxData(params, function (data) {
      if (data.success) {
        $("#idVersionPlan").val(verPlanId);
        $("#vp_idtipoplan").val(idTipoPlan);
        var htmlOriginal = showLoading("btnGuardarPlan");
        setTimeout(function () {
          $("#div_vp_carac").html(
            '<textarea class="form-control required" name="vp_carac" id="vp_carac" rows="4">' +
            data.caracteristicas +
            '</textarea>'
          );
          // hideLoading('contenidoRec',html);
          var params = {
            selector: "#vp_carac",
            height: "230",
            btnImg: true
          };
          opcionesTinymce(params);
          // tinymce.init({
          //   selector: "#vp_carac",
          //   theme: "modern",
          //   plugins: [
          //   ["advlist autolink link image lists preview hr pagebreak"],
          //   ["searchreplace wordcount visualblocks visualchars code media"],
          //   ["save contextmenu directionality emoticons paste"]
          //   ],
          //   height : "230"
          // });
          hideLoading("btnGuardarPlan", htmlOriginal);
          // hideLoading('btnGuardarReco',htmlOriginal2);
        }, 1000);
      }
    });
  }
}

function guardarVersionPlan() {
  tinymce.triggerSave();
  if ($("#formVersionPlan").valid()) {
    if ($("#vp_carac").val() == "") {
      alertify.error("Por favor llene las caracteristicas");
    } else {
      var htmlOriginal = showLoading("btnGuardarPlan");
      params = {
        funct: "guardarVersionPlan",
        idVersionGral: $("#idVersionGral").val(),
        idVersionPlan: $("#idVersionPlan").val(),
        idTipoPlan: $("#vp_idtipoplan").val(),
        caracteristicas: $("#vp_carac").val(),
      };
      ajaxData(params, function (data) {
        if (data.success) {
          // console.log("success");
          parent.$.fancybox.close();
          versionPlanGrid.refresh();
          versionPlanGrid.commit();
          hideLoading("btnGuardarPlan", htmlOriginal);
          if (data.res == 1) {
            alertify.success("Proceso finalizado correctamente");
          }
          if (data.res == 0) {
            alertify.error("Error al guardar registro");
          }
          if (data.res == 2) {
            alertify.success("Cambios guardados correctamente");
          }
          if (data.res == 3) {
            alertify.success("No hay cambios que guardar");
          }
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
    }
  } else {
    alertify.error("invalido");
  }
}

function mostrarFancyAgregarRequisito(verReqId, concepto) {
  if (verReqId == 0) {
    $("#idVersionReq").val(0);
    $("#vr_concepto").val("");
    var htmlOriginal = showLoading("btnGuardarReq");
    setTimeout(function () {
      $("#div_vr_carac").html(
        '<textarea class="form-control required" name="vr_carac" id="vr_carac" rows="4"></textarea>'
      );
      // hideLoading('contenidoRec',html);
      var params = {
        selector: "#vr_carac",
        height: "230",
        btnImg: true
      };
      opcionesTinymce(params);
      // tinymce.init({
      //   selector: "#vr_carac",
      //   theme: "modern",
      //   plugins: [
      //   ["advlist autolink link image lists preview hr pagebreak"],
      //   ["searchreplace wordcount visualblocks visualchars code media"],
      //   ["save contextmenu directionality emoticons paste"]
      //   ],
      //   height : "230"
      // });
      hideLoading("btnGuardarReq", htmlOriginal);
      // hideLoading('btnGuardarReco',htmlOriginal2);
    }, 1000);
  } else {
    params = {
      funct: 'obtVersionReq',
      idVersionReq: verReqId
    };
    ajaxData(params, function (data) {
      if (data.success) {
        $("#idVersionReq").val(verReqId);
        $("#vr_concepto").val(concepto);
        var htmlOriginal = showLoading("btnGuardarReq");
        setTimeout(function () {
          $("#div_vr_carac").html(
            '<textarea class="form-control required" name="vr_carac" id="vr_carac" rows="4">' +
            data.caracteristicas +
            '</textarea>'
          );
          var params = {
            selector: "#vr_carac",
            height: "230",
            btnImg: true
          };
          opcionesTinymce(params);
          // hideLoading('contenidoRec',html);
          // tinymce.init({
          //   selector: "#vr_carac",
          //   theme: "modern",
          //   plugins: [
          //   ["advlist autolink link image lists preview hr pagebreak"],
          //   ["searchreplace wordcount visualblocks visualchars code media"],
          //   ["save contextmenu directionality emoticons paste"]
          //   ],
          //   height : "230"
          // });
          hideLoading('btnGuardarReq', htmlOriginal);
          // hideLoading('btnGuardarReco',htmlOriginal2);
        }, 1000);
      }
    });
  }
}

function guardarVersionReq() {
  tinymce.triggerSave();
  if ($("#formVersionReq").valid()) {
    if ($("#vr_carac").val() == "") {
      alertify.error("Por favor llene las caracteristicas");
    } else {
      var htmlOriginal = showLoading("btnGuardarReq");
      params = {
        funct: "guardarVersionReq",
        idVersionGral: $("#vr_idVersionGral").val(),
        idVersionReq: $("#idVersionReq").val(),
        concepto: $("#vr_concepto").val(),
        caracteristicas: $("#vr_carac").val(),
      };
      ajaxData(params, function (data) {
        if (data.success) {
          // console.log("success");
          parent.$.fancybox.close();
          versionRequisitoGrid.refresh();
          versionRequisitoGrid.commit();
          hideLoading("btnGuardarReq", htmlOriginal);
          if (data.res == 1) {
            alertify.success("Proceso finalizado correctamente");
          }
          if (data.res == 0) {
            alertify.error("Error al guardar registro");
          }
          if (data.res == 2) {
            alertify.success("Cambios guardados correctamente");
          }
          if (data.res == 3) {
            alertify.success("No hay cambios que guardar");
          }
        } else {
          // console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
    }
  } else {
    alertify.error("invalido");
  }
}

function mostrarFancyAgregarColor(verColorId, color, imagenAuto, imagenColor) {
  $("#formVersionColor")[0].reset();
  if (verColorId == 0) {
    $("#idVersionColor").val(0);
    $("#vc_color").val("");
    $("#vc_imagena").removeClass("required");
    $("#vc_imagenc").removeClass("required");
    $("#vc_imagena").addClass("required");
    $("#vc_imagenc").addClass("required");
    $("#divMostrarImgAuto").html("");
    $("#divMostrarImgColor").html("");
  } else {
    $("#idVersionColor").val(verColorId);
    $("#vc_color").val(color);
    $("#vc_imagena").removeClass("required");
    $("#vc_imagenc").removeClass("required");
    $("#divMostrarImgAuto").html(
      '<img src="' +
      imagenAuto +
      '" height="68"><br/>' +
      '<input type="hidden" name="hid_imagen" id="hid_imagen" value="' +
      imagenAuto +
      '">'
    );
    $("#divMostrarImgColor").html(
      '<img src="' +
      imagenColor +
      '" height="68"><br/>' +
      '<input type="hidden" name="hid_imagenc" id="hid_imagenc" value="' +
      imagenColor +
      '">'
    );
  }
}

function guardarVersionColor() {
  if ($("#formVersionColor").valid()) {
    $("#formVersionColor").submit();
  }
}

function eliminarColorVersion(coloresVersId) {
  alertify.confirm(
    "<strong>&#191Est&aacute; seguro que desea eliminar este color?</strong>",
    function () {
      confirmElimColorVersion(coloresVersId);
    },
    function () { }).set({
      labels: {
        ok: 'Aceptar',
        cancel: 'Cancelar'
      },
      padding: false
    });
}

function confirmElimColorVersion(coloresVersId) {
  params = {
    funct: "eliminarColorVersion",
    coloresVersId: coloresVersId,
  };
  ajaxData(params, function (data) {
    console.log(data);
    if (data.success) {
      versionColorGrid.refresh();
      versionColorGrid.commit();
      if (data.res == 1) {
        alertify.success("Proceso finalizado correctamente");
      }
      if (data.bloquearTab) {
        if (!$("#btnMenu2").hasClass("tabdisabled")) {
          $("#btnMenu2").addClass("tabdisabled");
        }
        if (!$("#btnMenu6").hasClass("tabdisabled")) {
          $("#btnMenu6").addClass("tabdisabled");
        }
      }
    } else {
      console.log("Else");
      alertify.error("Error, intente mas tarde");
    }
  });
}

function cambiarColorImgPrincipal(idColorImgPrincipal) {
  var url = new URL(window.location.href);
  var verId = url.searchParams.get("verId");
  location.href = 'version.php?verId=' + verId + "&idColorImgPrincipal=" + idColorImgPrincipal;
  // location.href=window.location+"&idColorImgPrincipal="+idColorImgPrincipal;
}

function mostrarFancyEditarImgGaleria(zonaVersId, idImagen, titulo, descripcion, imagen) {
  $('#formImagenGal')[0].reset();
  descripcion = $("#descripcion_img_" + idImagen).val();
  titulo = $("#titulo_img_" + idImagen).val();
  $("#imagen_imggal").attr("src", imagen);
  $("#idimagen_imggal").val(idImagen);
  $("#zonaVersId_imggal").val(zonaVersId);
  $("#titulo_imggal").val(titulo);
  var htmlOriginal = showLoading('btnGuardarImgGal');
  setTimeout(function () {
    $("#div_desc_imggal").html(
      '<textarea class="form-control" rows="4" name="descripcion_imggal" id="descripcion_imggal">' +
      descripcion +
      '</textarea>'
    );
    // hideLoading('contenidoRec',html);
    var params = {
      selector: "#descripcion_imggal",
      height: "230",
      btnImg: false,
    };
    opcionesTinymce(params);
    // tinymce.init({
    //   selector: "#descripcion_imggal",
    //   theme: "modern",
    //   plugins: [
    //   ["advlist autolink link image lists preview hr pagebreak"],
    //   ["searchreplace wordcount visualblocks visualchars code media"],
    //   ["save contextmenu directionality emoticons paste"]
    //   ],
    //   height : "170"
    // });
    hideLoading("btnGuardarImgGal", htmlOriginal);
    // hideLoading('btnGuardarReco',htmlOriginal2);
  }, 1000);
  // $("#descripcion_imggal").val(descripcion);
}

function guardarImgGal() {
  tinymce.triggerSave();
  var file = $("input#imgGalSubir")[0].files[0];



  if ($("#formImagenGal").valid()) {
    var htmlOriginal = showLoading('btnGuardarImgGal');
    if (typeof file !== 'undefined') {
      console.log("con archivo");
      console.log(file);
      var data = new FormData();
      data.append('file', file);
      data.append('zonaVersId', $("#zonaVersId_imggal").val());
      data.append('idImagen', $("#idimagen_imggal").val());
      data.append('titulo', $("#titulo_imggal").val());
      data.append('descripcion', $("#descripcion_imggal").val());

      $.ajax({
        type: "POST",
        url: '../uploadfiles.php?funct=uploadImageIndGM',
        data: data,
        cache: false,
        contentType: false,
        processData: false,
        success: function (rponse) {
          console.log(rponse);
          hideLoading('btnGuardarImgGal', htmlOriginal);
          parent.$.fancybox.close();
          if (rponse != '') {

            versionZonaActivaGrid.refresh();
            versionZonaActivaGrid.commit();
            if (rponse > 0) {
              alertify.success("Proceso finalizado correctamente");
            }

          } else {
            alertify.error("Error al subir imagen");
          }

        },
      });
    } else {
      console.log("sin archivo");
      params = {
        funct: "guardarImagenGaleria",
        zonaVersId: $("#zonaVersId_imggal").val(),
        idImagen: $("#idimagen_imggal").val(),
        titulo: $("#titulo_imggal").val(),
        descripcion: $("#descripcion_imggal").val(),
      };
      ajaxData(params, function (data) {
        hideLoading("btnGuardarImgGal", htmlOriginal);
        if (data.success) {
          parent.$.fancybox.close();
          versionZonaActivaGrid.refresh();
          versionZonaActivaGrid.commit();
          if (data.res > 0) {
            alertify.success("Proceso finalizado correctamente");
          }
        } else {
          console.log("Else");
          alertify.error("Error, intente mas tarde");
        }
      });
    }
  } else {
    console.log("Invalido");
  }
}

function eliminarZonaVersion(zonaVersId) {
  alertify.confirm(
    "<strong>&#191Esta seguro que desea eliminar la zona seleccionada?</strong><br>Tambi&eacute;n se eliminar&aacute; la galeria de imagenes si la tiene",
    function () {
      confirmEliminarZona(zonaVersId);
    }, function () {
      $("#idDocumentoEliminar").val("");
      $("#nombreDocumentoEliminar").val("");
      // alertify.error('Cancelar');
    }).set({
      labels: {
        ok: 'Aceptar',
        cancel: 'Cancelar'
      },
      padding: false
    });
}

function confirmEliminarZona(zonaVersId) {
  params = {
    funct: "EliminarZona",
    zonaVersId: zonaVersId,
  };
  ajaxData(params, function (data) {
    if (data.success) {
      parent.$.fancybox.close();
      versionZonaGrid.refresh();
      versionZonaGrid.commit();
      if (data.res > 0) {
        $(".hostpot").each(function () {
          if ($(this).attr("data-activazonaid") == data.activaZonaId) {
            $(this).remove();
          }
        });
        alertify.success("Proceso finalizado correctamente");
      }
    } else {
      console.log("Else");
      alertify.error("Error, intente mas tarde");
    }
  });
}

function agregarImgGal() {
  if ($("#formAgregarImgGal").valid()) {
    $("#formAgregarImgGal").submit();
  }
}

function eliminarImgGaleria(activazonaid, idImagen) {
  alertify.confirm(
    "<strong>&#191Esta seguro que desea eliminar la imagen seleccionada?</strong>",
    function () {
      confirmEliminarImgGal(activazonaid, idImagen);
    },
    function () { }).set({
      labels: {
        ok: 'Aceptar',
        cancel: 'Cancelar'
      },
      padding: false
    });
}

function confirmEliminarImgGal(activazonaid, idImagen) {
  params = {
    funct: 'EliminarImgGal',
    activazonaid: activazonaid,
    idImagen: idImagen,
  };
  ajaxData(params, function (data) {
    if (data.success) {
      if (data.res > 0) {
        alertify.success("Proceso realizado correctamente.");
        versionZonaActivaGrid.refresh();
        versionZonaActivaGrid.commit();
      } else {
        alertify.error("No se pudo completar");
      }
    } else {
      alertify.error("Error inesperado, intenta mas tarde");
    }
  });
}

function Handle_OnRowStartEdit(sender, args) {
  let _row = args["Row"];

  /**
   * Para empatar el tr que contiene el mismo nombre
   * que _row y posteriormente obtener el innerHTML
   * de cada div de cada td
   * JARED 25/06/21
   */
  let editedRow = null;
  const HTMLRow = document.getElementsByClassName('kgrRow');
  const arrayRow = Array.from(HTMLRow);

  arrayRow.map((row) => {
    if (row.id === _row.id) {
      editedRow = row;
    }
  });

  const childNodes = Array.from(editedRow.childNodes);
  arrayResultPreEdit = childNodes.map((td) => { return td.childNodes[0].innerHTML });
}

function Handle_OnRowConfirmEdit(sender, args) {
  let _row = args["Row"];

  /**
   * Si existe otro input text dentro del campo de edici�n, se debe agregar aqu�.
   * La posici�n de dicho campo se encontrar� mostrando en pantalla (console.log()) 
   * alguno de los array (arrayResultPreEdit o arrayResultPostEdit)
   */
  const camposRaw = {
    3: 'nombre',
    4: 'nombre',

    5: 'aPaterno',
    6: 'aMaterno',
    7: 'telefono',
    8: 'calle',
    9: 'numero',
    10: 'colonia',
    11: 'cp',
    12: 'email'
  };

  const camposVista = {
    3: 'Nombre',
    4: 'Nombre',

    5: 'Apellido paterno',
    6: 'Apellido materno',
    7: 'Tel&eacute;fono',
    8: 'Calle',
    9: 'N&uacute;mero',
    10: 'Colonia',
    11: 'C&oacute;digo postal',
    12: 'Correo electr&oacute;nico'
  };

  /**
   * Para empatar el tr que contiene el mismo nombre
   * que _row y posteriormente obtener el innerHTML
   * de cada div de cada td
   * y posteriormente comparar diferencias y 
   * almacenarlas para ser enviadas
   * JARED 25/06/21
   */
  let editedRow = null;
  const HTMLRow = document.getElementsByClassName('kgrRow');
  const idUsuario = document.getElementsByName('idUsuario')[0].id;
  const arrayRow = Array.from(HTMLRow);

  arrayRow.map((row) => {
    if (row.id === _row.id) {
      editedRow = row;
    }
  });

  const childNodes = Array.from(editedRow.childNodes);
  const arrayResultPostEdit = childNodes.map((td) => { return td.childNodes[0].innerHTML });
  let differences = [];

  arrayResultPostEdit.map((column, index) => {
    if (arrayResultPreEdit[index] !== column) {
      differences.push({
        'usuarioMonitor': idUsuario,
        'idUsuario': arrayResultPostEdit[0],
        'campo': camposVista[index] || 'Otro',
        'valorAnterior': arrayResultPreEdit[index],
        'valorNuevo': column
      });
    }
  })

  if (sender.id === 'usuarios') {
    let campos = "";
    let valoresAnteriores = "";
    let valoresNuevos = "";

    differences.map((cambio, index) => {

      if (index === differences.length - 1) {
        campos += `${cambio.campo}`;
        valoresAnteriores += `${cambio.valorAnterior}`;
        valoresNuevos += `${cambio.valorNuevo}`;
      } else {
        campos += `${cambio.campo}, `;
        valoresAnteriores += `${cambio.valorAnterior}, `;
        valoresNuevos += `${cambio.valorNuevo}, `;
      }

      params = {
        funct: 'crearCambioUsuario',
        usuarioMonitor: cambio.usuarioMonitor,
        idUsuario: cambio.idUsuario,
        campo: campos,
        valorAnterior: valoresAnteriores,
        valorNuevo: valoresNuevos
      };

    });
    console.log(params);

    ajaxData(params, function (data) {
      if (data.success) {
        // console.log("actualizado");
      }
    });
  }

  var tabla = "";
  if (sender.id == "versionPrecioGrid") {
    tabla = "version_precios";
  }
  if (sender.id == "usuariosGrid") {
    tabla = "usuarios";
  }
  if (tabla != "") {
    // console.log("hola2");
    params = {
      funct: 'updActualizacion',
      tabla: tabla
    };
    ajaxData(params, function (data) {
      if (data.success) {
        console.log("actualizado");
      }
    });
  }
}

function Handle_OnConfirmInsert(sender, args) {
  console.log(sender.id);
  var tabla = "";
  if (sender.id == "versionPrecioGrid") {
    tabla = "version_precios";
  }
  if (sender.id == "usuariosGrid") {
    tabla = "usuarios";
  }
  if (tabla != "") {
    params = {
      funct: 'updActualizacion',
      tabla: tabla
    };
    ajaxData(params, function (data) {
      if (data.success) {
        console.log("actualizado");
      }
    });
  }
}

//Acciones necesarias para cuando se muestra el fancy desactivar usuarios en catalogos
function muestraDesactivarUsuario(idUsuario, grid, catalogo, activo) {
  $("#idUsuarioDesactivar").val(idUsuario);
  var opcion = "Desactivar";
  var opc = 0;
  console.log(idUsuario);
  console.log(grid);
  console.log(activo);

  var params = {
    funct: 'activar',
    id: idUsuario,
    valor: activo,
    cat: catalogo,
  };
  ajaxData(params, function (data) {
    if (data.res == 1) {
      alertify.success("Se activo correctamente");
    } else {
      alertify.error("Se desactivo correctamente");
    }
    if (catalogo == "bolsa") {
      bolsaTrabajoGrid.refresh();
      bolsaTrabajoGrid.commit();
    } else if (catalogo == "usuarios") {
      usuariosGrid.refresh();
      usuariosGrid.commit();
    } else if (catalogo == "rpt") {
      RptCiudadanosGrid.refresh();
      RptCiudadanosGrid.commit();
    } else if (catalogo == "comunicados") {
      comunicadosGrid.refresh();
      comunicadosGrid.commit();
    } else if (catalogo == "catLugares") {
      catLugaresGrid.refresh();
      catLugaresGrid.commit();
    } else if (catalogo == "emergecia") {
      telefonosEmergenciaGrid.refresh();
      telefonosEmergenciaGrid.commit();
    } else if (catalogo == "tipoMulta") {
      tipoMultaGrid.refresh();
      tipoMultaGrid.commit();
    } else if (catalogo == "infoLegalCat") {
      infoLegalGrid.refresh();
      infoLegalGrid.commit();
    } else if (catalogo == "infoLegalEnlaces") {
      infoLegalEnlacesGrid.refresh();
      infoLegalEnlacesGrid.commit();
    }

  });
}

//Metodo para seleccionar por defecto el auto que se mostrara primeo en la mesa de control en la app
function selPorDefecto(idColor) {
  // console.log(idColor);
  var urlPage = new URL(window.location.href);
  var verId = urlPage.searchParams.get("verId");

  var params = {
    funct: "actColorPordefecto",
    idColor: idColor,
    gralVersId: verId,
  };
  ajaxData(params, function (data) {
    versionColorGrid.refresh();
    versionColorGrid.commit();

    if (data.success == true) {
      var url = "version.php?verId=" + verId; //+"#menu2";
      var arrParams = [];
      arrParams[0] = {
        name: "idVersionColorPordefecto",
        val: verId
      };
      postDinamico(url, arrParams);
    } else {
      alertify.success("Error, intente mas tarde");
      return false;
    }
  });
}

//Metodo que elimina el registro desde un grid
function eliminar_reg(id, opc) {
  console.log(id);
  console.log(opc);
  var msg = "&#191Est&aacute; seguro de eliminar esta fila";
  switch (opc) {
    case "gama_modelo":
      msg += ", si es asi se borraran las versiones que lo contengan";
      alertify.confirm("<strong>" + msg + "?</strong>",
        function () {
          var url = 'gamamodelos.php';
          var arrParams = [];
          arrParams[0] = {
            name: "gModeloId",
            val: id
          };
          arrParams[1] = {
            name: "eliminarModelo",
            val: "ok"
          };
          postDinamico(url, arrParams);
        }, function () { }).set({
          labels: {
            ok: 'Aceptar',
            cancel: 'Cancelar'
          },
          padding: false
        });
      break;
    case "version_modelo":
      msg += ", si es asi se borraran todo su contenido interior";
      alertify.confirm("<strong>" + msg + "?</strong>",
        function () {
          var url = 'versiones.php';
          var arrParams = [];
          arrParams[0] = {
            name: "gralVersId",
            val: id
          };
          arrParams[1] = {
            name: "eliminarVersion",
            val: "ok"
          };
          postDinamico(url, arrParams);
        }, function () { }).set({
          labels: {
            ok: 'Aceptar',
            cancel: 'Cancelar'
          },
          padding: false
        });
      break;
  }
}

//Opciones del editor tinymce
function opcionesTinymce(params) {
  // console.log(params.btnImg);
  if (params.btnImg == true) {
    tinymce.init({
      selector: params.selector,
      height: params.height,
      // theme: "modern",
      menu: {
        file: {
          title: 'File'
        },
        edit: {
          title: "Edit",
          items: "undo redo | cut copy paste pastetext | selectall",
        },
        insert: {
          title: 'Insert',
          items: 'link media | image '
        },
        view: {
          title: 'View',
          items: 'preview'
        },
        format: {
          title: 'Format',
          items: 'bold italic underline strikethrough superscript subscript | formats | removeformat'
        },
        table: {
          title: "Table",
          items: "inserttable tableprops deletetable | cell row column",
        },
        tools: {
          title: 'Tools',
          items: 'spellchecker code'
        }
      },
      plugins: [
        ["advlist autolink link image lists preview"],
        ["code "],
        ["save contextmenu directionality emoticons paste"],
      ],
      file_picker_types: "image",
      image_title: true,
      automatic_uploads: true,
      file_browser_callback_types: "image",
      file_browser_callback: function (field_name, url, type, win) {
        win.document.getElementById(field_name).value = "my browser value";
      },
      file_picker_callback: function (callback, value, meta) {
        var input = document.createElement("input");
        input.setAttribute("type", "file");
        input.setAttribute("accept", "image/*");
        input.onchange = function () {
          var file = this.files[0];
          var reader = new FileReader();
          reader.onload = function () {
            // console.log(file);
            var data = new FormData();
            data.append("file", file);
            $.ajax({
              type: "POST",
              url: "../uploadfiles.php?funct=uploadImagesTinymce",
              data: data,
              cache: false,
              contentType: false,
              processData: false,
              success: function (rponse) {
                // console.log(rponse);
                objJson = JSON.parse(rponse);
                if (objJson.resp == true) {
                  console.log(objJson);
                  callback(objJson.ruta, {
                    alt: ""
                  });
                }
              },
            });
          };
          reader.readAsDataURL(file);
        };
        input.click();
      },
    });
  } else {
    tinymce.init({
      selector: params.selector,
      height: params.height,
      // theme: "modern",
      menu: {
        file: {
          title: "File"
        },
        edit: {
          title: "Edit",
          items: "undo redo | cut copy paste pastetext | selectall",
        },
        insert: {
          title: "Insert",
          items: "link media "
        },
        view: {
          title: "View",
          items: "preview"
        },
        format: {
          title: "Format",
          items: "bold italic underline strikethrough superscript subscript | formats | removeformat",
        },
        table: {
          title: "Table",
          items: "inserttable tableprops deletetable | cell row column",
        },
        tools: {
          title: "Tools",
          items: "spellchecker code"
        },
      },
      plugins: [
        ["advlist autolink link lists preview"],
        ["code "],
        ["save contextmenu directionality emoticons paste"],
      ],
      onchange_callback: function (editor) {
        tinyMCE.triggerSave();
        $("#" + editor.id).valid();
      },
    });
  }
}

// INICIO FUNCIONES CSB
var interval;
var intervalChat;
var tiempoInterval = 5000;

function obtenerVehiculosMapa() {
  var params = {
    funct: "obtenerVehiculosMapa",
  };


  ajaxData(params, function (data) {
    if (data.success) {
      //console.log(data.vehiculosdisponibles);
      actualizaVehiculosMapa(data.vehiculosdisponibles);
    }
  });
}

var arrIdsPetNot = [];

function preparaVerNot() {
  setInterval(function () {
    mostrarNotificacionesEscritorio();
  }, tiempoInterval);

  //SetTomeout para preguntar si shelly esta encendido o no
  // -------------- Creacion de alarma al encender shelly de camioneta -------------
  // setInterval(function(){
  //   demoChecarShelly();
  // },10000)
}

function mostrarNotificacionesEscritorio() {
  var params = {
    funct: "obtenerPeticionesMapa",
    estatusId: 1,
  };

  ajaxData(params, function (data) {
    if (data.success) {
      data.peticiones.forEach(function (peticion) {
        if (arrIdsPetNot.indexOf(peticion.idPeticion) == -1) {
          arrIdsPetNot.push(peticion.idPeticion);
          notifyMe(
            "Peticion sin atender",
            "Ver peticion en el mapa",
            function () {
              preparaVerPeticion(peticion.idPeticion);
            }
          );
        }
      });
    }
  });
}

function obtenerPeticionesMapa(estatusId) {
  var params = {
    funct: "obtenerPeticionesMapa",
    estatusId: estatusId,
  };
  ajaxData(params, function (data) {
    if (data.success) {
      actualizaPeticionesMapa(data.peticiones);
    }
  });
}




function verificaOpcionMostrar() {
  initializeMapPanico();
  mostrarOpcionMapa();
}

function seleccionaOpcion(opcion) {
  $("#selecMap").val(opcion);
  $("#selecMap").trigger("change");
}

var chatOculto = false;

function mostrarOpcionMapa(idPeticion) {
  //Limpia datos de peticion
  $("#infoPeticionSeleccionada").html("");
  $("#infoBotones").html("");
  $("#infoUnidadSeleccionada").html("");
  $("#infoPatrullaSeleccionada").html("");
  $("#infoAsignadoSeleccionada").html("");
  $("#infoDispositivoSeleccionado").html("");

  // if(chatOculto ===  false){
  //   $("#divChat").css("display", "none");
  //   chatOculto = true;
  // }

  // $("#btn-chat").attr("disabled", true);

  if (typeof idPeticion === "undefined") {
    //console.log("undefined");
    clearInterval(intervalChat);
    // $("#spanDownChat").click();
  } else {
    //console.log("!= undefined");
    $(".btn_opcion_mapa").removeClass("btn_opcionmapa_sel");
    $("#mpm_" + idPeticion).addClass("btn_opcionmapa_sel");
    //console.log("#mpm_"+idPeticion);
  }

  clearMarkers();
  //console.log("clearMarkers");
  //console.log($("#selecMap").val());
  switch (parseInt($("#selecMap").val())) {
    //switch(parseInt(idPeticion)){  
    case 1:
      desplegarInfoPeticion = false
      obtenerVehiculosMapa();
      clearInterval(interval);
      clearMarkers2();
      if (markerCiudadano) {
        markerCiudadano.setMap(null);
        console.log("Marcador eliminado del mapa");
      } else {
        console.log("El marcador no está definido");
      }

      interval = setInterval(function () {
        obtenerVehiculosMapa();
        obtenerPeticionesMapa("1,2");
      }, tiempoInterval);
      alertify.success("Mostrar Alarmas");
      $("#ulChat").html("");
      //aquitar para ver patrullero
      //$("#ulChat2").html("");
      break;
    case 2:
      desplegarInfoPeticion = false
      obtenerPeticionesMapa("1,2");
      clearInterval(interval);
      clearMarkers2();
      interval = setInterval(function () {
        obtenerPeticionesMapa("1,2");

      }, tiempoInterval);
      alertify.success("Mostrar todas las peticiones");
      $("#ulChat").html("");
      //aquitar para ver patrullero
      //$("#ulChat2").html("");
      break;
    case 3:
      obtenerPeticionesMapa(1);
      clearInterval(interval);
      interval = setInterval(function () {
        obtenerPeticionesMapa(1);
      }, tiempoInterval);
      alertify.success("Mostrar peticiones sin asignar");
      $("#ulChat").html("");
      //aquitar para ver patrullero
      //$("#ulChat2").html("");
      break;
    case 4:
      obtenerPeticionesMapa(2);
      clearInterval(interval);
      clearMarkers2();
      interval = setInterval(function () {
        obtenerPeticionesMapa(2);

      }, tiempoInterval);
      alertify.success("Mostrar peticiones asignadas");
      $("#ulChat").html("");
      //aquitar para ver patrullero
      //$("#ulChat2").html("");
      break;
    case 5:
      if (typeof idPeticion !== "undefined") {
        verPeticion(idPeticion);
        clearInterval(interval);
        clearMarkers2();
        interval = setInterval(function () {
          //console.log("opcion 5 ver peticion");
          obtenerPeticionesMapa("1,2");
          verPeticion(idPeticion);

        }, tiempoInterval);
        alertify.success("Mostrar peticion y alarmas");
      } else {
        alertify.warning("No ha seleccionado una petici&oacute;n");
        $("#selecMap").val(2);
        $("#selecMap").trigger("change");
      }
      break;
    case 6:
      desplegarInfoPeticion = false
      if (markerCiudadano) {
        markerCiudadano.setMap(null);
        console.log("Marcador eliminado del mapa");
      } else {
        console.log("El marcador no está definido");
      }

      GetPatrulleros2();
      clearInterval(interval);
      clearMarkers2();
      interval = setInterval(function () {
        GetPatrulleros2();

      }, tiempoInterval);
      alertify.success("Mostrar Patrullas");
      $("#ulChat").html("");
      //aquitar para ver patrullero
      //$("#ulChat2").html("");

      break;
  }

}

function preparaVerPeticion(idPeticion) {
  $("#selecMap").val(5);
  $("#peticionIdSelected").val(idPeticion);
  //console.log("preparaVerPeticion");
  //console.log(idPeticion);
  // $("#btn-chat").attr("disabled", false);
  // $("#divChat").css("display", "inline");
  chatOculto = false;
  desplegarInfoPeticion = true;

  mostrarMensajesPeticion();
  //aquitar para ver patrullero
  //mostrarMensajesPeticion2();

  intervalChat = setInterval(function () {
    mostrarMensajesPeticion();
    //mostrarMensajesPeticion2();
  }, tiempoInterval);

  mostrarOpcionMapa(idPeticion);
}

function mostrarMensajesPeticion() {
  var params = {
    funct: "mostrarMensajesPeticion",
    idPeticion: $("#peticionIdSelected").val(),
  };

  ajaxData(params, function (data) {
    //console.log("data");
    //console.log(data);
    if (data.success) {
      var html = "";
      data.mensajes.forEach(function (mensaje) {
        var imagen = "";
        //console.log(mensaje.imagen);
        if (mensaje.imagen != "") {
          //console.log("if");
          imagen =
            '<p><img width="30%" src="../upload/mensajes/' +
            mensaje.imagen +
            '"></p>';
        } else {
          //console.log("else");
        }
        //console.log(imagen);
        if (mensaje.usuarioId == $("#usuarioSesionId").val() && mensaje.idTipoMensaje == 1) {
          html +=
            '<li class="right clearfix"><span class="chat-img pull-right">' +
            //'<img src="http://placehold.it/50/FA6F57/fff&text=ME" alt="User Avatar" class="img-circle" />' +
            '<img src="../images/iconos/fff&text=ME.png" alt="User Avatar" class="img-circle" />' +
            "</span>" +
            '<div class="chat-body clearfix">' +
            '<div class="header">' +
            '<small class=" text-muted"><span class="glyphicon glyphicon-time"></span>Recien</small>' +
            '<strong class="pull-right primary-font">Operador</strong>' +
            "</div>" +
            "<p>" +
            mensaje.contenido +
            "</p>" +
            imagen +
            "</div>" +
            "</li>";
        } else if ((mensaje.idRol == 3 || mensaje.idRol == 10) && mensaje.idTipoMensaje == 3) {
          html += '<li class="left clearfix"><span class="chat-img pull-left">' +
            '<img src="../images/iconos/fff&text=U.png" alt="User Avatar" class="img-circle" />' +
            "</span>" +
            '<div class="chat-body clearfix">' +
            '<div class="header">' +
            '<strong class="primary-font">Usuario</strong> <small class="pull-right text-muted">' +
            '<span class="glyphicon glyphicon-time"></span>12 mins ago</small>' +
            "</div>" +
            "<p>" +
            mensaje.contenido +
            "</p>" +
            imagen +
            "</div>" +
            "</li>";
        }
      });

      $("#ulChat").html(html);
      var elmnt = document.getElementById("contend_MSG");
      elmnt.scrollBy(0, 100000);

      //mostrarOpcionMapa(idPeticion)
    }
  });
}

function mostrarMensajesPeticion2() {
  var params = {
    funct: "mostrarMensajesPeticion",
    idPeticion: $("#peticionIdSelected").val(),
  };

  ajaxData(params, function (data) {
    //console.log("data");
    //console.log(data);
    if (data.success) {
      var html = "";
      data.mensajes.forEach(function (mensaje) {
        var imagen = "";
        //console.log(mensaje.imagen);
        if (mensaje.imagen != "") {
          //console.log("if");
          imagen =
            '<p><img width="100%" src="../upload/mensajes/' +
            mensaje.imagen +
            '"></p>';
        } else {
          //console.log("else");
        }
        //console.log(imagen);
        if (mensaje.usuarioId == $("#usuarioSesionId").val() && mensaje.idTipoMensaje == 2) {
          html +=
            '<li class="right clearfix"><span class="chat-img pull-right">' +
            //'<img src="http://placehold.it/50/FA6F57/fff&text=ME" alt="User Avatar" class="img-circle" />' +
            '<img src="../images/iconos/fff&text=ME2.png" alt="User Avatar" class="img-circle" />' +
            "</span>" +
            '<div class="chat-body clearfix">' +
            '<div class="header">' +
            '<small class=" text-muted"><span class="glyphicon glyphicon-time"></span>Recien</small>' +
            '<strong class="pull-right primary-font">Operador</strong>' +
            "</div>" +
            "<p>" +
            mensaje.contenido +
            "</p>" +
            imagen +
            "</div>" +
            "</li>";
        } else if (mensaje.idRol == 4 && mensaje.idTipoMensaje == 4) {
          html +=
            '<li class="left clearfix"><span class="chat-img pull-left">' +
            //'<img src="http://placehold.it/50/55C1E7/fff&text=U" alt="User Avatar" class="img-circle" />' +
            '<img src="../images/iconos/fff&text=P.png" alt="User Avatar" class="img-circle" />' +
            "</span>" +
            '<div class="chat-body clearfix">' +
            '<div class="header">' +
            '<strong class="primary-font">Patrulla</strong> <small class="pull-right text-muted">' +
            '<span class="glyphicon glyphicon-time"></span>13 mins ago</small>' +
            "</div>" +
            "<p>" +
            mensaje.contenido +
            "</p>" +
            imagen +
            "</div>" +
            "</li>";
        }
      });

      $("#ulChat2").html(html);
      var elmnt2 = document.getElementById("contend_MSG2");
      elmnt2.scrollBy(0, 100000);

      //mostrarOpcionMapa(idPeticion)
    }
  });
}

function verPeticion(idPeticion) {
  var params = {
    funct: "verPeticion",
    idPeticion: idPeticion,
  };

  ajaxData(params, function (data) {
    //console.log("VerPeticion con data 1511");
    //console.log(data);
    if (data.success) {
      if (data.peticion.estatusId < 3 || data.peticion.estatusId == 5) {
        if (data.peticion.tipoPeticionId == 4) {
          //console.log("Panico Vecinal");
         // console.log(data)
          panicoVecinal(data.peticion, data.unidades, data.asignado, data.almComite, data.distPetiAlarm, data.dataAsignado, data.dataAlarma, data.nombreOpe, data.notificarPatrulla);
        } else {
          actualizaPeticionMapa(data.peticion, data.unidades, data.asignado);
        }
      } else {
        alertify.success("La petici&oacute;n ha finalizado");
        $("#ulChat").html("");
        //aquitar para ver patrullero
        //$("#ulChat2").html("");
        $("#selecMap").val(3);
        $("#selecMap").trigger("change");
      }
    }
  });
}

function asignarUnidad(idUserTurno) {

  var params = {
    funct: "asignaPatrullaTurno",
    idTurno: idUserTurno,
    idPeticion: $("#peticionIdSelected").val(),
    tipoAsignacion: "Server",
  };
  ajaxData(params, function (data) {
    if (data.success) {
      alertify.success("Petici&oacute;n asignada correctamente a la unidad seleccionada");
      if (markersCercanos.length > 0) {
        markersCercanos.forEach(function (markerObj) {
          markerObj.marker.setMap(null);
        });
      }
      markersCercanos = [];
    } else {
      //alertify.warning("No se ha podido asignar a la unidad seleccionada");
      alertify.warning("Notificaci&oacute;n enviada a la unidad seleccionada");
    }
  });

}

function desasignarUnidad(idAsignacion, latitud, longitud) {
  console.log(latitud, longitud);
  valorentrada = 0
  var terminocoordenadas;
  if (latitud != undefined || longitud != undefined) {
    terminocoordenadas = parseFloat(latitud) + "," + parseFloat(longitud);
  } else {
    terminocoordenadas = "Sin coordenadas";
  }

  var params = {
    funct: "desasignaPatrullaTurno",
    idAsignacion: idAsignacion,
    idPeticion: $("#peticionIdSelected").val(),
    coordenadasfinal: terminocoordenadas,
    motivo: 2,
  };
  ajaxData(params, function (data) {
    if (data.success) {
      alertify.success("Vehiculo desasignado correctamente");
      clearMarkers2();
      //markerPatrulla.setMap(null);
      //markerCiudadano.setMap(null);
    } else {
      alertify.warning("No se ha podido desasignar a la unidad seleccionada");
    }
  });
}

function cancelarUnidad(idUserTurno) {
  alertify.confirm(
    "Cancelar unidad",
    "&#191;Esta seguro de cancelar esta unidad?",
    function () {
      var params = {
        funct: "cancelarUnidad",
        idTurno: idUserTurno,
        idPeticion: $("#peticionIdSelected").val(),

      };
      ajaxData(params, function (data) {
        if (data.success) {
          $("#infoUnidadSeleccionada").html("");
          alertify.success("Se cancelo la unidad para esta petici&oacute;n");
          if (typeof markerUNIDAD1 !== "undefined") {
            markerUNIDAD1.setMap(null);
          }
          if (typeof directionsDisplayPeticion !== "undefined") {
            directionsDisplayPeticion.setMap(null);
          }
        } else {
          alertify.warning("No se ha podido cancelar a la unidad");
        }
      });
    }, function () { });

}

var recargarPagina = false;

function cancelarPeticion(idUserTurnoAlarma, idUserTurnoVehiculo, idAsignacion, latitud, longitud, idVehiculoAlarma) {
  console.log(idVehiculoAlarma)
  alertify.confirm(
    "Cerrar petici&oacute;n",
    "&#191;Esta seguro de cerrar esta petici&oacute;n?",
    function () {
      encenderAlarma(idVehiculoAlarma, 0, 1);
      seleccionaOpcion(2);
      var terminocoordenadas;
      if (latitud != undefined || longitud != undefined) {
        terminocoordenadas = parseFloat(latitud) + "," + parseFloat(longitud);
      } else {
        terminocoordenadas = "Sin coordenadas";
      }

      var idUserTurnoVehiculo2 = idUserTurnoVehiculo != undefined ? idUserTurnoVehiculo : "0";
      var idUserTurnoAlarma2 = idUserTurnoAlarma != undefined ? idUserTurnoAlarma : "0";
      var idAsignacion2 = idAsignacion != undefined ? idAsignacion : "0";

      var params = {
        funct: "cancelarPeticion",
        idTurnoVehiculo: idUserTurnoVehiculo2,
        idTurnoAlarma: idUserTurnoAlarma2,
        idAsignacion: idAsignacion2,
        idPeticion: $("#peticionIdSelected").val(),
        coordenadasfinal: terminocoordenadas,
      };
      ajaxData(params, function (data) {
        $("#cont_peticiones_mapa").html("");
        $("#mpm_3").trigger("click");

        recargarPagina = true;
        //SE QUEDA ASI PARA DEMO  
        if (data.idVehiculo != 0 && data.idVehiculo != null && data.idVehiculo != undefined && data.idVehiculo != "0" && data.idVehiculo != "") {
          encenderAlarma(data.idVehiculo, 0);//JGP HACMEOS POR EMERGENCIA ASUMISMOS QUE LOS UNICOS VEHIULOS ASIGNADOS SON ALARMAS
        }
        recargarPagina = false;
        setTimeout(location.reload(), 3000);
      });
    },
    function () { }
  ).set({
    labels: {
      ok: "Aceptar",
      cancel: "Cancelar"
    }
  });
}


function enviarMensaje() {
  if ($("#peticionIdSelected").val() > 0) {
    var mensaje = $("#inputmensaje").val();
    var params = {
      funct: "enviarMensaje",
      mensaje: $("#inputmensaje").val(),
      idPeticion: $("#peticionIdSelected").val(),
      usuarioSesionId: $("#usuarioSesionId").val(),
      titulo: "",
      idTipoMensaje: 1
    };
    var urlDel = "../ajaxcall2/ajaxFunctions.php?funct=enviarMensaje";
    //var formElement = document.getElementById("formPorCotizar");
    var data = new FormData();
    data.append("mensaje", $("#inputmensaje").val());
    data.append("idPeticion", $("#peticionIdSelected").val());
    data.append("usuarioSesionId", $("#usuarioSesionId").val());
    data.append("titulo", "");
    data.append("idTipoMensaje", 1);
    //var htmlOriginal = showLoading('btnGuardarAyuda');
    data.append("saveFolder", "../upload/mensajes/");

    var file1 = $("input#file_chat")[0].files[0];
    if (typeof file1 !== "undefined") {
      data.append("file", file1);
    }

    ajaxDataImg(urlDel, data, function (data) {
      if (data.res > 0) {

        //let estadoAppPeticion = document.getElementById('estadoApp').getAttribute('data-estado');

        // if(estadoAppPeticion === '0'){ //1: indica que la app esta abierta y no es necesario enviar push, 0: indica que la app esta en pausa
        let operadorId = document.getElementById('usuarioSesionId').value;
        let usuarioId = String(document.getElementById('usuarioId').value);

        const params = {
          funct: "enviarMesanjeClientesMultiple",
          idUsuarios: usuarioId,
          tipo: 1,
          creador: operadorId,
          titulo: 'Abre tu app, has recibido nuevo(s) mensaje(s)',
          contenido: 'Abre tu app, has recibido nuevo(s) mensaje(s)',
        };

        ajaxData(params, function (data) {
          console.log(data)
          if (data.success) {
            if (data.res > 0) {
              alertify.success("Se envi&oacute; notificaci&oacute;n para que el usuario abra su app y pueda ver el mensaje");
            } else {
              alertify.error("No se pudo enviar la notificaci&oacute;n");
            }
          } else {
            alertify.error("No se pudo realizar esta acci&oacute;n, intente m&aacute;s tarde");
          }
        });

        //}

        var html = "";

        html +=
          '<li class="right clearfix"><span class="chat-img pull-right">' +
          // '<img src="http://placehold.it/50/FA6F57/fff&text=ME" alt="User Avatar" class="img-circle" />' +
          '<img src="../images/iconos/fff&text=ME.png" alt="User Avatar" class="img-circle" />' +
          "</span>" +
          '<div class="chat-body clearfix">' +
          '<div class="header">' +
          '<small class=" text-muted"><span class="glyphicon glyphicon-time"></span>Recien</small>' +
          '<strong class="pull-right primary-font">Operador</strong>' +
          "</div>" +
          "<p>" +
          mensaje +
          "</p>" +
          "</div>" +
          "</li>";
        $("#inputmensaje").val("");
        $("#ulChat").append(html);
        $("#file_chat").val("");
        var elmnt = document.getElementById("contend_MSG");
        // console.log(elmnt);
        // elmnt.scrollIntoView(false);
        elmnt.scrollBy(0, 100000);
        // $("#ulChat").scrollBy(0, 50);
      }
    });
  } else {
    $("#inputmensaje").val("");
  }
}

function enviarMensaje2() {
  if ($("#peticionIdSelected").val() > 0) {
    var mensaje = $("#inputmensaje2").val();
    var params = {
      funct: "enviarMensaje",
      mensaje: $("#inputmensaje2").val(),
      idPeticion: $("#peticionIdSelected").val(),
      usuarioSesionId: $("#usuarioSesionId").val(),
      titulo: "",
      idTipoMensaje: 2
    };
    var urlDel = "../ajaxcall2/ajaxFunctions.php?funct=enviarMensaje";
    //var formElement = document.getElementById("formPorCotizar");
    var data = new FormData();
    data.append("mensaje", $("#inputmensaje2").val());
    data.append("idPeticion", $("#peticionIdSelected").val());
    data.append("usuarioSesionId", $("#usuarioSesionId").val());
    data.append("titulo", "");
    data.append("idTipoMensaje", 2);
    //var htmlOriginal = showLoading('btnGuardarAyuda');
    data.append("saveFolder", "../upload/mensajes/");

    var file1 = $("input#file_chat2")[0].files[0];
    if (typeof file1 !== "undefined") {
      data.append("file", file1);
    }

    ajaxDataImg(urlDel, data, function (data) {
      if (data.res > 0) {
        var html = "";

        html +=
          '<li class="right clearfix"><span class="chat-img pull-right">' +
          // '<img src="http://placehold.it/50/FA6F57/fff&text=ME" alt="User Avatar" class="img-circle" />' +
          '<img src="../images/iconos/fff&text=ME2.png" alt="User Avatar" class="img-circle" />' +
          "</span>" +
          '<div class="chat-body clearfix">' +
          '<div class="header">' +
          '<small class=" text-muted"><span class="glyphicon glyphicon-time"></span>Recien</small>' +
          '<strong class="pull-right primary-font">Operador</strong>' +
          "</div>" +
          "<p>" +
          mensaje +
          "</p>" +
          "</div>" +
          "</li>";
        $("#inputmensaje2").val("");
        $("#ulChat2").append(html);
        $("#file_chat2").val("");
        var elmnt2 = document.getElementById("contend_MSG2");
        // console.log(elmnt);
        // elmnt.scrollIntoView(false);
        elmnt2.scrollBy(0, 100000);
        // $("#ulChat").scrollBy(0, 50);
      }
    });
  } else {
    $("#inputmensaje2").val("");
  }
}

/*
nuevo parametro jair 18/03/2020
accion
  0 =  apagar
  1 =  encenders
*/
function encenderAlarma(idVehiculo, accion, historico) {
  if (idVehiculo == 4) {
    //console.log("PIKAPI");
  }
  // console.log(idVehiculo);
  historico = typeof historico === "undefined" ? 0 : 1;

  if (idVehiculo == null || idVehiculo == undefined || idVehiculo == 0) {

  } else {
    var params = {
      funct: "encenderAlarma",
      idVehiculo: idVehiculo,
      accion: accion,
      historico: historico,
      idUsuario: $("#usuarioSesionId").val(),
    };
    var nombreBtn = accion == 1 ? "btnAlarmaEncender_" : "btnAlarmaApagar_";
    var htmlOriginal = showLoading(nombreBtn + idVehiculo);
    ajaxData(params, function (data) {
      // console.log(data);
      hideLoading(nombreBtn + idVehiculo, htmlOriginal);
      alertify.success("Acci&oacute;n realizada correctamente");

      if (recargarPagina) {
        recargarPagina = false;
        location.reload();
      }
    });
  }


}

function muestraReporteStatus(idPeticion, comiteUsuario = 0) {
  $("#distPetiAlarm").html('');
  $("#dispSO").html('');
  $("#versSO").html('');
  $("#permGeoloc").html('');

  var params = {
    funct: "obtDatosPeticionPorIdModal",
    idPeticion: idPeticion,
    idComite: comiteUsuario
  };


  ajaxData(params, function (res) {
    console.log(res);

    if (res.success) {
      $("#rep-detalles__idPeticion").html(res.peticion.idPeticion);
      $("#rep-detalles__fechaPeticion").html(res.peticion.fechaCreacion);
      $("#rep-detalles__coordPeticion").html(res.peticion.coordenadasInicio + '<a target="_blank" class="btn btn-dark" href="https://maps.google.com/?q=' + res.peticion.coordenadasInicio + '" style="margin-left: 15px;">Ver en Google Maps</a>');

      $("#rep-detalles__stsAsignacion").html(res.statusAsignacion);

      if (res.alarmaComite != undefined) {
        $("#rep-detalles__almComiteMsg").hide();

        $("#rep-detalles__mtrAlarma").html(res.alarmaComite.matricula);
        $("#distPetiAlarm").html((res.distPetiAlarm * 1000) + ' mts');
        $("#rep-detalles__coordAlarma").html(res.alarmaComite.latitud + ', ' + res.alarmaComite.longitud);

        $(".rep-detalles__mtrAlarma-lbl").show();
        $(".distPetiAlarm-lbl").show();
        $(".rep-detalles__coordAlarma-lbl").show();
      } else {
        $(".rep-detalles__mtrAlarma-lbl").hide();
        $(".distPetiAlarm-lbl").hide();
        $(".rep-detalles__coordAlarma-lbl").hide();

        $("#rep-detalles__almComiteMsg").html("Comit&eacute; no asociado.");

        $("#rep-detalles__almComiteMsg").show();
      }

      $("#dispSO").html(res.dispSO);
      $("#versSO").html(res.versSO);
      if (res.permGeoloc == true) {
        $("#permGeoloc").html("activado");
      } else {
        $("#permGeoloc").html("desactivado");
      }
      let ALM_COMITE_ASIGNADA = '1';
      let ALM_PMI_ASIGNADA = '2';
      let ALM_COMITE_FUERA_RANGO = '3';
      let ALM_COMITE_OCUPADA = '4';

      console.log(res.peticion);
      console.log(res.peticion.statusAsignacionId);
      switch (res.peticion.statusAsignacionId) {
        case ALM_COMITE_ASIGNADA:
          break;

        case ALM_PMI_ASIGNADA:
          $("#rep-detalles__mtrAlarmaPmi").html(res.pmiAsignada.matricula);
          $("#distPetiAlarmPmi").html((res.distPetAlmPmi * 1000) + ' mts');
          $("#rep-detalles__coordAlarmaPmi").html(res.pmiAsignada.latitud + ', ' + res.pmiAsignada.longitud);
          $("#rep-detalles__almPmi").show();
          break;

        case ALM_COMITE_FUERA_RANGO:

          break;

        case ALM_COMITE_OCUPADA:
          break;
      }

      $("#histPeticiones__rep-detalles").show();
    } else {
      $("#histPeticiones__msg").html('Petici&oacute;n con informaci&oacute;n insuficiente para generar el reporte.');
      $("#histPeticiones__msg").show();
    }
  });
}

$("#popup_repStatus").on("hidden.bs.modal", function () {
  $("#rep-detalles__almPmi").hide();
  $("#histPeticiones__rep-detalles").hide();
  $("#histPeticiones__msg").hide();
});

//Reporte de patrullero

function muestraReportePatrullero(idPeticion, idVehiculo, rechazados) {

  $('#rechazos-patrullero').html('');
  $('#desconexiones').html('');

  var params = {
    funct: "obtDatosPeticionPorIdModal",
    idPeticion: idPeticion,
    idComite: 0,
    idUsuarioTurno: 0,
    idVehiculo: idVehiculo,
    rechazados: rechazados,

  };



  ajaxData(params, function (data) {
    /*console.log(data);
    console.log(data.peticion);
    console.log(data.datosAsignado);
    console.log(data.rechazados);
    console.log(data.desconexiones);*/

    if (data.success) {
      $('#rep-pat__idPeticion').html(data.peticion.idPeticion);
      $('#rep-pat__fechaPeticion').html(data.peticion.fechaCreacion);
      $('#rep-pat__coordPeticion').html(data.peticion.coordenadasInicio);

      $('#rep-pat__nombre').html(data.peticion.nombreConductor);
      $('#rep-pat__unidad').html(data.pmiAsignada.unidad);
      $('#rep-pat__matricula').html(data.pmiAsignada.matricula);

      $('#rep-pat__horaNotificacion').html(data.datosAsignado.fechaHoraNotificacion);
      $('#rep-pat__acptPeticion').html(data.datosAsignado.fechaHoraAceptacionNegacion);

      $('#rep-pat__tmpRecorrido').html(data.datosAsignado.tiempoRecorrido);
      $('#rep-pat__arribo').html(data.peticion.fechaFinalizacion);
      $('#rep-pat__comentario').html(data.datosAsignado.comentarioVehiculo);

      $('#rep-pat__tipoAsignacion').html(data.datosAsignado.tipoAsignacion);

      $('#rep-pat__horaAsignacion').html(data.datosAsignado.fechaHoraCreacionAsignacion);
      $('#rep-pat__horaDesasignacion').html(data.datosAsignado.fechaHoraDesasignacion);
      $('#rep-pat__motivoDesasignacion').html(data.datosAsignado.descripcionDesasignacion);

      let tablaDesconexiones = document.getElementById('desconexiones');
      let tablehead = document.createElement('thead');
      let tableBody = document.createElement('tbody');

      let filaCabecera = document.createElement('tr');

      let h1 = document.createElement('th');
      h1.innerHTML = "Hora de desconexi&oacute;n";

      let h2 = document.createElement('th');
      h2.innerHTML = "Tiempo de desconexi&oacute;n";

      filaCabecera.appendChild(h1);
      filaCabecera.appendChild(h2);
      tablehead.appendChild(filaCabecera);

      data.desconexiones.forEach(item => {
        let fila = document.createElement('tr');

        let td = document.createElement('td');
        td.innerText = item.fechaHoraDesconexion;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = item.tiempoDesconexion + ' min';
        fila.appendChild(td);

        tableBody.appendChild(fila);
      });

      tablaDesconexiones.appendChild(tablehead);
      tablaDesconexiones.appendChild(tableBody);


      //if(data.datosAsignado.asignacionAceptada = 0){


      let tablaRechazos = document.getElementById('rechazos-patrullero');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');

      let head1 = document.createElement('th');
      head1.innerHTML = "Nombre";

      let head2 = document.createElement('th');
      head2.innerHTML = "Unidad";

      let head3 = document.createElement('th');
      head3.innerHTML = "Matr&iacute;cula";

      let head4 = document.createElement('th');
      head4.innerHTML = "Fecha/Hora";

      let head5 = document.createElement('th');
      head5.innerHTML = "Motivo";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      tablaHead.appendChild(rowHead);

      data.rechazados.forEach(llenarTabla => {


        let fila = document.createElement('tr');

        let td = document.createElement('td');
        td.innerText = llenarTabla.nombre;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTabla.unidad;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTabla.matricula;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTabla.fechaHoraAceptacionNegacion;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTabla.motivoDesasignacion;
        fila.appendChild(td);

        cuerpoTabla.appendChild(fila);
      });

      tablaRechazos.appendChild(tablaHead);
      tablaRechazos.appendChild(cuerpoTabla);
      //}

      $('#histPeticiones__rep-patrulla').show();
      $('#rechazos-patrullero').show();
      $('#desconexiones').show();
    }
  });
}

$("#popup_rep_patrullero").on("hidden.bs.modal", function () {
  $("#rechazos-patrullero").hide();
  $("#desconexiones").hide();
});

// Abir reporte de asignacion patrullero //
function muestraReporteAsignacionPatrullero(idAsignado) {
  var params = {
    funct: "obtDatosReporteAsignacionPatrulla",
    idAsignado: idAsignado,
  };

  ajaxData(params, function (data) {
    //console.log(data);
    if (data.success) {
      $('#rep-asig-pat__idPeticion').html(data.asignado.idPeticion);
      $('#rep-asig-pat__fechaPeticion').html(data.peticion.fechaCreacion);

      $('#rep-asig-pat__primerPlano').html('<a class="btn" data-toggle="modal" data-target="#popup_1planoPatrulla" style="background: #0466cd; margin-left: 5px; color: white;" onclick="verHistorial1PlanoPatrulla(' + data.asignado.idAsignacion + ',' + data.planos.numPlanos + ')">' + data.planos.primerPlano + '</a>');
      $('#rep-asig-pat__segundoPlano').html('<a class="btn" data-toggle="modal" data-target="#popup_2planoPatrulla" style="background: #0466cd; margin-left: 5px; color: white;" onclick="verHistorial2PlanoPatrulla(' + data.asignado.idAsignacion + ',' + data.planos.numPlanos2 + ')">' + data.planos.segundoPlano + '</a>');
      $('#rep-asig-pat__desconexionesRed').html('<a class="btn" data-toggle="modal" data-target="#popup_desconexionesPatrullero" style="background: #0466cd; margin-left: 5px; color: white;" onclick="verDesconexionesPatrulla2(' + data.asignado.idAsignacion + ',' + data.planos.numDesconexiones + ')">' + data.planos.totalDesconexion + '</a>');

      $('#rep-asig-pat__tmpRespuestaNotificacionAsignacion').html(data.asignado.tiempoRespuestaNotificacion);
      $('#rep-asig-pat__tmpRecorrido').html(data.asignado.tiempoRecorrido);
      $('#rep-asig-pat__distanciaRecorrida').html(data.asignado.distanciaRecorrida);

      $('#rep-asig-pat__horaAutomatico50m').html(data.asignado.fechaHoraAutomaticoVehiculo50m);

      $('#rep-asig-pat__horaManual50m').html(data.asignado.fechaHoraRespuestaVehiculo50m);

      if (data.asignado.estatusVehiculo50m == 'Sin estatus') {
        $('#rep-asig-pat__estatus50m').html(data.asignado.estatusVehiculo50m).css("color", "red");
      } else {
        $('#rep-asig-pat__estatus50m').html(data.asignado.estatusVehiculo50m).css("color", "none");
      }

      if (data.asignado.coordenadasDesasignacion == 'Sin coordenadas') {
        $('#rep-asig-pat__coordenadasDesasignacion').html(data.asignado.coordenadasDesasignacion);
      } else {
        $('#rep-asig-pat__coordenadasDesasignacion').html(data.asignado.coordenadasDesasignacion + '<a target="_blank" class="btn btn-dark" href="https://maps.google.com/?q=' + data.asignado.coordenadasDesasignacion + '" style="margin-left: 15px;">Ver en Google Maps</a>');
      }

      if (data.asignado.comentarioVehiculo == null) {
        $('#rep-asig-pat__reporteFinal').html("<br>A&uacute;n no llenado.").css("color", "red");
      } else {
        $('#rep-asig-pat__reporteFinal').html(data.asignado.comentarioVehiculo).css("color", "none");
      }

      if (data.asignado.fechaHoraReporteFinal == null) {
        $('#rep-asig-pat__fechareporteFinal').html("");
      } else {
        $('#rep-asig-pat__fechareporteFinal').html(data.asignado.fechaHoraReporteFinal);
      }

      if (data.asignado.motivoDesasignacion == data.asignado.motivoCancelacionAsignacion) {
        $('#rep-asig-pat__cancelacionAsignacionPatrullero').hide();
        $('#lb_motivoCancelacionPatrulla').hide();
      } else {
        $('#rep-asig-pat__cancelacionAsignacionPatrullero').html(data.asignado.motivoCancelacionAsignacion);
      }
    }
  });
}


//mostrar si hay mensajes en las peticiones

function verMensajes(idPeticion, numMensajes) {
  $('#tabla-mensajes').html('');

  if (numMensajes === 0) {
    $("#no-mensaje").show();
    return true;
  } else {
    var params = {
      funct: "mostrarMensajesPeticion",
      idPeticion: idPeticion,
      numMensajes: numMensajes
    };

    ajaxData(params, function (data) {
      let tablaMensajes = document.getElementById('tabla-mensajes');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');

      let head1 = document.createElement('th');
      head1.innerHTML = "ID Peticion";

      let head2 = document.createElement('th');
      head2.innerHTML = "Usuario";

      let head3 = document.createElement('th');
      head3.innerHTML = "Tipo Mensaje";

      let head4 = document.createElement('th');
      head4.innerHTML = "T&iacute;tulo";

      let head5 = document.createElement('th');
      head5.innerHTML = "Contenido mensaje";

      let head6 = document.createElement('th');
      head6.innerHTML = "Fecha";

      let head7 = document.createElement('th');
      head7.innerHTML = "Imagen";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      rowHead.appendChild(head7);
      tablaHead.appendChild(rowHead);

      data.mensajes.forEach(llenarTablaMensajes => {
        let fila = document.createElement('tr');

        let td = document.createElement('td');
        td.innerText = llenarTablaMensajes.idReporte;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.nombre;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.idConcepto;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.titulo;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.contenido;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.fechaCreacion;
        fila.appendChild(td);
        if (llenarTablaMensajes.imagen != "") {
          td = document.createElement('td');
          td.innerHTML = '<a href="../upload/mensajes/' + llenarTablaMensajes.imagen + '" target="_blank"><img class="imagen-celda" src="../upload/mensajes/' + llenarTablaMensajes.imagen + '"></a>'
          fila.appendChild(td);//aqui va imagen

        } else {
          td = document.createElement('td');
          td.innerText = '';
          fila.appendChild(td);
        }
        cuerpoTabla.appendChild(fila);
      });
      tablaMensajes.appendChild(cuerpoTabla);
      tablaMensajes.appendChild(tablaHead);
    });

    $("#tabla-div").show();
    $("#body-mensajes").show();

  }//fin de else
}

function verMensajes2(idPeticion, numMensajes) {
  $('#tabla-mensajes').html('');

  if (numMensajes === 0) {
    $("#no-mensaje").show();
    return true;
  } else {
    var params = {
      funct: "mostrarMensajesPeticion2",
      idPeticion: idPeticion,
      numMensajes: numMensajes
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablaMensajes = document.getElementById('tabla-mensajes');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID Peticion";
      let head2 = document.createElement('th');
      head2.innerHTML = "Usuario";
      let head3 = document.createElement('th');
      head3.innerHTML = "Tipo Mensaje";
      let head4 = document.createElement('th');
      head4.innerHTML = "T&iacute;tulo";
      let head5 = document.createElement('th');
      head5.innerHTML = "Contenido mensaje";
      let head6 = document.createElement('th');
      head6.innerHTML = "Fecha";
      let head7 = document.createElement('th');
      head7.innerHTML = "Imagen";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      rowHead.appendChild(head7);
      tablaHead.appendChild(rowHead);

      data.mensajes.forEach(llenarTablaMensajes => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenarTablaMensajes.idReporte;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.nombre;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.idConcepto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.titulo;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.contenido;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.fechaCreacion;
        fila.appendChild(td);

        if (llenarTablaMensajes.imagen != "") {
          td = document.createElement('td');
          td.innerHTML = '<a href="../upload/mensajes/' + llenarTablaMensajes.imagen + '" target="_blank"><img class="imagen-celda" src="../upload/mensajes/' + llenarTablaMensajes.imagen + '"></a>'
          fila.appendChild(td);//aqui va imagen

        } else {
          td = document.createElement('td');
          td.innerText = '';
          fila.appendChild(td);
        }
        cuerpoTabla.appendChild(fila);
      });
      tablaMensajes.appendChild(cuerpoTabla);
      tablaMensajes.appendChild(tablaHead);
    });

    $("#tabla-div").show();
    $("#body-mensajes").show();
  }
}

$("#popup_verMensajes").on("hidden.bs.modal", function () {
  $("#body-mensajes").hide();
  $("#tabla-div").hide();
  $("#no-mensaje").hide();
});

$("#popup_chatMensajesPatrullero").on("hidden.bs.modal", function () {
  $("#body-mensajes").hide();
  $("#tabla-div").hide();
  $("#no-mensaje").hide();
});

// ------------------------------- Pop estacionamientos reporte accesos patrulleros -------------------------------
function verEstacionamientosPatrulla(idInicioSesion, estacionamientos) {
  $('#tabla-estacionamientos').html('');

  if (estacionamientos === 0) {
    $("#no-estacionamiento").show();
    return true;
  } else {
    var params = {
      funct: "mostrarEstacionamientosPorSesion",
      idInicioSesion: idInicioSesion,
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablaEstacionamientos = document.getElementById('tabla-estacionamientos');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha inicio estacionamiento";
      let head3 = document.createElement('th');
      head3.innerHTML = "Fecha fin estacionamiento";
      let head4 = document.createElement('th');
      head4.innerHTML = "Coordenadas";
      let head5 = document.createElement('th');
      head5.innerHTML = "Tiempo estacionado";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      tablaHead.appendChild(rowHead);

      data.estacionados.forEach(llenartablaEstacionamientos => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablaEstacionamientos.idVehiculoEstacionado;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaEstacionamientos.fechaHoraInicioEstacionamiento;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaEstacionamientos.fechaHoraFinEstacionamiento;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerHTML = llenartablaEstacionamientos.coordenadasEstacionamiento + '<a target="_blank" class="btn btn-dark" href="https://maps.google.com/?q=' + llenartablaEstacionamientos.coordenadasEstacionamiento + '" style="margin-left: 15px;">Ver en Google Maps</a>';
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaEstacionamientos.tiempoEstacionado;
        fila.appendChild(td);

        cuerpoTabla.appendChild(fila);
      });
      tablaEstacionamientos.appendChild(cuerpoTabla);
      tablaEstacionamientos.appendChild(tablaHead);
    });

    $("#tabla-div").show();
    $("#body-estacionamiento").show();
  }
}

// ------------------------------- Pop desconexiones reporte accesos patrulleros -------------------------------
function verDesconexionesPatrulla(idInicioSesion, desconexionesRed) {
  $('#tabla-desconexiones').html('');

  if (desconexionesRed === 0) {
    $("#no-desconexion").show();
    return true;
  } else {
    var params = {
      funct: "mostrarDesconexionesPorSesion",
      idInicioSesion: idInicioSesion,
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablaDesconexiones = document.getElementById('tabla-desconexiones');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha inicio desconexi&oacute;n";
      let head3 = document.createElement('th');
      head3.innerHTML = "Fecha fin desconexi&oacute;n";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tiempo sin conexi&oacute;n";
      let head5 = document.createElement('th');
      head5.innerHTML = "Petici&oacute;n activa";
      let head6 = document.createElement('th');
      head6.innerHTML = "Asignaci&oacute;n activa";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      tablaHead.appendChild(rowHead);

      data.desconexiones.forEach(llenartablaDesconexiones => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.idDesconexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.fechaHoraDesconexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.fechaHoraNuevaConexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.tiempoDesconexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.idPeticion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.idAsignado;
        fila.appendChild(td);

        cuerpoTabla.appendChild(fila);
      });
      tablaDesconexiones.appendChild(cuerpoTabla);
      tablaDesconexiones.appendChild(tablaHead);
    });

    $("#tabla-div2").show();
    $("#body-desconexiones").show();
    $("#no-desconexion").hide();
  }
}

// ------------------------------- Pop desconexiones reporte accesos patrulleros -------------------------------
function verDesconexionesPatrulla2(idAsignado, desconexionesRed) {
  $('#tabla-desconexiones').html('');

  if (desconexionesRed === 0) {
    $("#no-desconexion").show();
    return true;
  } else {
    var params = {
      funct: "mostrarDesconexionesPorAsignacion",
      idAsignado: idAsignado,
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablaDesconexiones = document.getElementById('tabla-desconexiones');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha inicio desconexi&oacute;n";
      let head3 = document.createElement('th');
      head3.innerHTML = "Fecha fin desconexi&oacute;n";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tiempo sin conexi&oacute;n";
      let head5 = document.createElement('th');
      head5.innerHTML = "Petici&oacute;n activa";
      let head6 = document.createElement('th');
      head6.innerHTML = "Asignaci&oacute;n activa";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      tablaHead.appendChild(rowHead);

      data.desconexiones.forEach(llenartablaDesconexiones => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.idDesconexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.fechaHoraDesconexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.fechaHoraNuevaConexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.tiempoDesconexion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.idPeticion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaDesconexiones.idAsignado;
        fila.appendChild(td);

        cuerpoTabla.appendChild(fila);
      });
      tablaDesconexiones.appendChild(cuerpoTabla);
      tablaDesconexiones.appendChild(tablaHead);
    });

    $("#tabla-div3").show();
    $("#body-desconexiones").show();
    $("#no-desconexion").hide();
  }
}

// ------------------------------- Pop asignaciones reporte accesos patrulleros -------------------------------
function verAsignacionesPatrulla(idInicioSesion, totalAsignaciones) {
  $('#tabla-asignaciones').html('');

  if (totalAsignaciones === 0) {
    $("#no-asignacion").show();
    return true;
  } else {
    var params = {
      funct: "mostrarAsignacionesPorSesion",
      idInicioSesion: idInicioSesion,
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablaAsignaciones = document.getElementById('tabla-asignaciones');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID Asignaci&oacute;n";
      let head2 = document.createElement('th');
      head2.innerHTML = "ID Petici&oacute;n";
      let head3 = document.createElement('th');
      head3.innerHTML = "Fecha asignaci&oacute;n";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tipo de asignaci&oacute;n";
      let head5 = document.createElement('th');
      head5.innerHTML = "Estatus de asignaci&oacute;n";
      let head6 = document.createElement('th');
      head6.innerHTML = "Fecha de desasignaci&oacute;n";
      let head7 = document.createElement('th');
      head7.innerHTML = "Motivo de desasignaci&oacute;n";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      rowHead.appendChild(head7);
      tablaHead.appendChild(rowHead);

      data.asignaciones.forEach(llenartablaAsignaciones => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.idAsignacion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.idPeticion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.fechaHoraCreacionAsignacion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.tipoAsignacion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.estatusAsignacionAceptada;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.fechaHoraDesasignacion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaAsignaciones.descripcionDesasignacion;
        fila.appendChild(td);


        cuerpoTabla.appendChild(fila);
      });
      tablaAsignaciones.appendChild(cuerpoTabla);
      tablaAsignaciones.appendChild(tablaHead);
    });

    $("#tabla-div3").show();
    $("#body-asignacion").show();
    $("#no-asignacion").hide();
  }
}

// ------------------------------- Pop historial 1 plano accesos patrulleros -------------------------------
function verHistorial1PlanoPatrulla(idAsignado, numPlanos) {
  $('#tabla-historicoPlanos').html('');

  if (numPlanos === 0) {
    $("#no-planos").show();
    return true;
  } else {
    var params = {
      funct: "mostrarHistorialPrimerPlanoAsignacion",
      idAsignado: idAsignado,
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablahistoricoPlanos = document.getElementById('tabla-historicoPlanos');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "Fecha inicio 1° plano";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha fin 1° plano";
      let head3 = document.createElement('th');
      head3.innerHTML = "Tiempo activo";
      let head4 = document.createElement('th');
      head4.innerHTML = "ID Petici&oacute;n";
      let head5 = document.createElement('th');
      head5.innerHTML = "ID Asignado";
      let head6 = document.createElement('th');
      head6.innerHTML = "ID Inicio Sesi&oacute;n";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      tablaHead.appendChild(rowHead);

      data.planos.forEach(llenartablahistoricoPlanos => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora1plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora2plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.tiempoActivo;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.peticionesObtenidas.substr(0, llenartablahistoricoPlanos.peticionesObtenidas.length - 1);;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.asignacionesObtenidas.substr(0, llenartablahistoricoPlanos.asignacionesObtenidas.length - 1);;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.idInicioSesion;
        fila.appendChild(td);


        cuerpoTabla.appendChild(fila);
      });
      tablahistoricoPlanos.appendChild(cuerpoTabla);
      tablahistoricoPlanos.appendChild(tablaHead);
    });

    $("#tabla-div2").show();
    $("#body-historicoPlanos").show();
    $("#no-planos").hide();
  }
}

// ------------------------------- Pop historial 2 plano accesos patrulleros -------------------------------
function verHistorial2PlanoPatrulla(idAsignado, numPlanos2) {
  $('#tabla-historicoPlanos2').html('');

  if (numPlanos2 === 0) {
    $("#no-planos2").show();
    return true;
  } else {
    var params = {
      funct: "mostrarHistorialSegundoPlanoAsignacion",
      idAsignado: idAsignado,
    };

    ajaxData(params, function (data) {
      //console.log(data);
      let tablahistoricoPlanos = document.getElementById('tabla-historicoPlanos2');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "Fecha inicio 2° plano";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha fin 2° plano";
      let head3 = document.createElement('th');
      head3.innerHTML = "Tiempo inactivo";
      let head4 = document.createElement('th');
      head4.innerHTML = "ID Petici&oacute;n";
      let head5 = document.createElement('th');
      head5.innerHTML = "ID Asignado";
      let head6 = document.createElement('th');
      head6.innerHTML = "ID Inicio Sesi&oacute;n";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      tablaHead.appendChild(rowHead);

      data.planos.forEach(llenartablahistoricoPlanos => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora2plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora1plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.tiempoInactivo;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.peticionesObtenidas.substr(0, llenartablahistoricoPlanos.peticionesObtenidas.length - 1);
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.asignacionesObtenidas.substr(0, llenartablahistoricoPlanos.asignacionesObtenidas.length - 1);
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.idInicioSesion;
        fila.appendChild(td);


        cuerpoTabla.appendChild(fila);
      });
      tablahistoricoPlanos.appendChild(cuerpoTabla);
      tablahistoricoPlanos.appendChild(tablaHead);
    });

    $("#tabla-div4").show();
    $("#body-historicoPlanos2").show();
    $("#no-planos2").hide();
  }
}

// ------------------------------- Pop historial planos accesos patrulleros -------------------------------
function verPlanosEnTiempoLogueadoSesionPatrulla(idInicioSesion) {
  //console.log(idAsignado, numPlanos);
  var params = {
    funct: "mostrarHistorialPlanosPorSesion",
    idInicioSesion: idInicioSesion,
  };

  ajaxData(params, function (data) {
    $('#tabla-historico1Plano').html('');
    $('#tabla-historico2Plano').html('');

    if (data.primerplano.length > 0) {
      let historico1Plano = document.getElementById('tabla-historico1Plano');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha inicio 1° plano";
      let head3 = document.createElement('th');
      head3.innerHTML = "Fecha fin 1° plano";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tiempo activo";
      let head5 = document.createElement('th');
      head5.innerHTML = "ID Petici&oacute;n";
      let head6 = document.createElement('th');
      head6.innerHTML = "ID Asignado";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      tablaHead.appendChild(rowHead);

      data.primerplano.forEach(llenartablahistoricoPlanos => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.idhistorialplanos;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora1plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora2plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.tiempoActivo;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.peticionesObtenidas.substr(0, llenartablahistoricoPlanos.peticionesObtenidas.length - 1);
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.asignacionesObtenidas.substr(0, llenartablahistoricoPlanos.asignacionesObtenidas.length - 1);
        fila.appendChild(td);
        cuerpoTabla.appendChild(fila);
      });
      historico1Plano.appendChild(cuerpoTabla);
      historico1Plano.appendChild(tablaHead);

      $("#tabla-div2a").show();
      $("#body-historico1Planos").show();
      $("#no-1plano").hide();
    } else {
      $("#no-1plano").show();
    }

    if (data.segundoplano.length > 0) {
      let historico2Plano = document.getElementById('tabla-historico2Plano');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID";
      let head2 = document.createElement('th');
      head2.innerHTML = "Fecha inicio 2° plano";
      let head3 = document.createElement('th');
      head3.innerHTML = "Fecha fin 2° plano";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tiempo inactivo";
      let head5 = document.createElement('th');
      head5.innerHTML = "ID Petici&oacute;n";
      let head6 = document.createElement('th');
      head6.innerHTML = "ID Asignado";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      tablaHead.appendChild(rowHead);

      data.segundoplano.forEach(llenartablahistoricoPlanos => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.idHistorial2Plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora2plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.fechaHora1plano;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.tiempoInactivo;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.peticionesObtenidas.substr(0, llenartablahistoricoPlanos.peticionesObtenidas.length - 1);
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablahistoricoPlanos.asignacionesObtenidas.substr(0, llenartablahistoricoPlanos.asignacionesObtenidas.length - 1);;
        fila.appendChild(td);
        cuerpoTabla.appendChild(fila);
      });
      historico2Plano.appendChild(cuerpoTabla);
      historico2Plano.appendChild(tablaHead);

      $("#tabla-div3a").show();
      $("#body-historico2Planos").show();
      $("#no-2plano").hide();
    } else {
      $("#no-2plano").show();
    }
  });
}

function liberarUnidadFromGrid(idVehiculo, estatusPat, idInicioSesion) {
  if (estatusPat == 2) {
    alertify.error("La unidad seleccionada se encuentra disponible, no es necesaria su liberaci&oacute;n. ");
  } else if (estatusPat == 1 && idVehiculo > 0) {
    alertify.confirm(
      "Liberar unidad",
      "¿Esta seguro de liberar esta unidad?",
      function () {
        var params = {
          funct: "liberarUnidadPorOperador",
          idVehiculo: idVehiculo,
          idInicioSesion: idInicioSesion
        };

        ajaxData(params, function (data) {
          if (data.success) {
            alertify.success("Unidad liberada con &eacute;xito.")
          }
        });
      }, function () { });
  }
}

function verRechazadosDia(idPeticion) {
  console.log(idPeticion);

  $('#tabla-rechazados-dia').html('');

  var params = {
    funct: "rechazosReportePatrullero",
    idPeticion: idPeticion
  }

  ajaxData(params, function (data) {
    console.log(data);


    let tabRechazo = document.getElementById('tabla-rechazados-dia');
    let tabHead = document.createElement('thead');
    let tabCuerpo = document.createElement('tbody');

    let rHead = document.createElement('tr');

    let head1 = document.createElement('th');
    head1.innerHTML = "ID Peticion";

    let head2 = document.createElement('th');
    head2.innerHTML = "Fecha/Hora Rechazo";

    rHead.appendChild(head1);
    rHead.appendChild(head2);
    tabHead.appendChild(rHead);

    data.rechazados.forEach(item => {
      let fila = document.createElement('tr');

      let celda = document.createElement('td');
      celda.innerText = item.idPeticion;
      fila.appendChild(celda);

      celda = document.createElement('td');
      celda.innerText = item.fechaHoraAceptacionNegacion;
      fila.appendChild(celda);

      tabCuerpo.appendChild(fila);
    });

    tabRechazo.appendChild(tabHead);
    tabRechazo.appendChild(tabCuerpo);


  });
  $('#rechazados-dia').show();
  $('#tabla-rechazados-dia').show();
}

function activaInactivaPatrullero(idUserPat, activo) {
  if (activo == 1) {
    alertify.confirm(
      "Deshabilitar patrullero",
      "¿Esta seguro de deshabilitar a este patrullero?",
      function () {
        var params = {
          funct: "deshabilitarPatrullero",
          idUsuario: idUserPat,
        };

        ajaxData(params, function (data) {
          if (data.success) {
            usuarios.refresh();
            usuarios.commit();
            alertify.success("Acci&oacute;n realizada correctamente");
          } else {
            alertify.error("Acci&oacute;n no realizada, int&eacute;ntelo de nuevo.");
          }
        });
      }, function () { });
  } else if (activo == 0) {
    alertify.confirm(
      "Activar patrullero",
      "¿Esta seguro de activar a este patrullero?",
      function () {
        var params = {
          funct: "activarPatrullero",
          idUsuario: idUserPat,
        };

        ajaxData(params, function (data) {
          if (data.success) {
            usuarios.refresh();
            usuarios.commit();
            alertify.success("Acci&oacute;n realizada correctamente");
          } else {
            alertify.error("Acci&oacute;n no realizada, int&eacute;ntelo de nuevo.");
          }
        });
      }, function () { });
  } else {
    alertify.error("Algo sali&oacute; mal, int&eacute;ntelo de nuevo.");
  }
}

//Ciudadano
function muestraCiudadano(idUsuario) {
  //console.log(idUsuario);
  var params = {
    funct: "obtDatosUsrPorIdUsrModal",
    idUsuario: idUsuario,
  };
  var htmlOriginal = showLoading("btnModal_" + idUsuario);

  //Limpiamos modal
  //limpiarModalUsuario();

  ajaxData(params, function (data) {
    obtValidacionUsr(data.res.usuarioId);
    $("#claveUsrMdl").html(data.res.clave);
    $("#nombreUsrMdl").html(data.res["nombre"]);
    $("#apellidoPUsrMdl").html(data.res["aPaterno"]);
    $("#apellidoMUsrMdl").html(data.res["aMaterno"]);
    $("#telefonoUsrMdl").html(data.res["telefono"]);
    $("#calleUsrMdl").html(data.res["calle"]);
    $("#numeroUsrMdl").html(data.res["numero"]);
    $("#coloniaUsrMdl").html(data.res["colonia"]);
    $("#cpUsrMdl").html(data.res["cp"]);
    $("#emailUsrMdl").html(data.res["email"]);
    $("#fotoUsrMdl").show();
    $("#fotoUsrMdl").error(function () {
      $(this).hide();
    }).attr('src', '../upload/ciudadano_pie/' + data.res['urlFoto']);
    // $("#numComiteUsrMdl").html(data.res['numComite']);
    $("#fechaCreacionUsrMdl").html(data.res["fechaCreacion"]);
    $("#fechaActUsrMdl").html(data.res["fechaAct"]);
    $("#divSelectorComite").html(data.selector);

    hideLoading("btnModal_" + idUsuario, htmlOriginal);
    //alertify.success("Accion realizada correctamente");
  });
}

// acciones cuando se cierra el modal:
$("#popup_usr_datos").on("hidden.bs.modal", function () {
  $("#fotoUsrMdl").attr('src', '');
  $("#fotoUsrMdl").hide();
});

//Mostrar el modal con el mensaje pricipal de cada buzon ciudadano
function muestraMensajePrincipal(idBuzonCiudadano) {
  var params = {
    funct: "obtDatosBuzonCiudadanoPorIdBuzon",
    idBuzonCiudadano: idBuzonCiudadano,
  };
  var htmlOriginal = showLoading("btnModal_" + idBuzonCiudadano);

  ajaxData(params, function (data) {
    //alert(data);
    //console.log("data");
    //console.log(data);
    $("#ciudadanoBuzonMdl").html(data["nombreCiudadano"]);
    $("#mensajeBuzonMdl").html(data["mensaje"]);

    hideLoading("btnModal_" + idBuzonCiudadano, htmlOriginal);
    //alertify.success("Accion realizada correctamente");
  });
}

function obtValidacionUsr(idUsuario) {
  //console.log(idUsuario);
  var params = {
    funct: "obtValidacionUsrPorIdUsrModal",
    idUsuario: idUsuario,
  };
  //var htmlOriginal = showLoading('btnModal_'+idUsuario);

  ajaxData(params, function (data) {
    //console.log(data);

    var valido = document.getElementById("validoUsrMdl");
    var comentarios = document.getElementById('comentariosUsrMdl');
    var btnGuardarComentario = document.getElementById('btnGuardarComentarioUsuario');

    valido.setAttribute(
      "onchange",
      "actualizarUsrvalido('" + data["idUsuario"] + "', '" + data["email"] + "')"
    );

    if (data["valido"] == 0 || data["valido"] == null) {
      valido.checked = false;
      validoValor = 'No';
    } else if (data["valido"] == 1) {
      valido.checked = true;
      validoValor = 'S&iacute;';
    }

    //Pasamos datos a los comentarios
    comentarios.value = data['comentarios'];

    //Agregamos el evento de guardar comentario al boton
    btnGuardarComentario.setAttribute(
      "onClick",
      "guardarComentarioUsuario('" + data["idUsuario"] + "')"
    );

    //hideLoading('btnModal_'+idUsuario, htmlOriginal);
    //alertify.success("Accion realizada correctamente");
  });
}

function actualizarUsrvalido(idUsuario, email) {
  //console.log(idUsuario);
  var valido = document.getElementById("validoUsrMdl").checked;
  var valValido = 0;
  const idUsuarioMonitor = document.getElementsByName('idUsuario')[0].id;

  if (valido) {
    valValido = 1;
    valor = 'S&iacute;';
  } else {
    valValido = 0;
    valor = 'No';
  }

  var params = {
    funct: "actUsrValidado",
    idUsuario: idUsuario,
    valido: valValido,
    campo: "valido",
    email: email,
  };
  //var htmlOriginal = showLoading('validoUsrMdl');

  ajaxData(params, function (data) {
    //console.log(data);
    //hideLoading('validoUsrMdl', htmlOriginal);
    usuarios.refresh();
    usuarios.commit();
    alertify.success("Acci&oacute;n realizada correctamente");

    params = {
      funct: 'crearCambioUsuario',
      usuarioMonitor: idUsuarioMonitor,
      idUsuario: idUsuario,
      campo: 'V&aacute;lido',
      valorAnterior: validoValor,
      valorNuevo: valor
    };

    console.log(params);

    ajaxData(params, function (data) {
      if (data.success) {
        // console.log("actualizado");
      }
    });
  });
}

function guardarComentarioUsuario(idUsuario) {
  var comentarios = document.getElementById('comentariosUsrMdl').value;

  var params = {
    funct: "actUsrComentarios",
    idUsuario: idUsuario,
    comentarios: comentarios,
    campo: "comentarios",
  };
  //var htmlOriginal = showLoading('validoUsrMdl');

  ajaxData(params, function (data) {
    //console.log(data);
    //hideLoading('validoUsrMdl', htmlOriginal);
    usuarios.refresh();
    usuarios.commit();
    alertify.success("Acci&ocute;n realizada correctamente");
  });
}

function Handle_OnLoad(sender, args) {
  //alert("KoolGrid is loaded.");
}

function cargaComite() {
  var texto = $('select[name="comiteId"] option:selected').text();
  switch (texto) {
    case 'Todos':
      $(".filter-right").val("");
      break;

    default:
      $(".filter-right").val(texto);
      break;

  }
  $(".filter-right").trigger("change");
}

function cambiarVista(control) {
  var value = control.value;
  if (value != "") location.href = value + ".php";
}

function actualizaCampoDato(campo, valor, idDato) {
  var params = {
    funct: "actualizaCampoDato",
    campo: campo,
    valor: valor,
    idDato: idDato,
  };
  //var htmlOriginal = showLoading('validoUsrMdl');

  ajaxData(params, function (data) {
    //console.log(data);
    if (data.success) {
      if (data.upd > 0) {
        usuarios.refresh();
        usuarios.commit();
        alertify.success("Se han guardado los cambios.");
      } else {
        alertify.warning("No hay cambios que guardar");
      }
    }
  });
}

function verAlarmasInactivas() {
  var params = {
    funct: "verAlarmasInactivas",
  };
  //var htmlOriginal = showLoading('validoUsrMdl');

  ajaxData(params, function (data) {
    if (data.success) {
      $("#divAlarmas").html(data.html);
      // alarmasInactivasGrid = initGridBTById("alarmasInactivasGrid");
    }
  });
}

function revisionAlarmas() {
  alertify.confirm('Revision de todas las alarma', 'Estas seguro que quieres realizar esta accion esto puede demolar unos minutos', function () {
    var htmlOriginal = showLoading("btnRevision");
    alertify.set('notifier', 'position', 'top-right');
    alertify.success("Por favor espere, esto podr&iacute;a tardar unos minutos.");
    var params = {
      funct: "cronAlarmas",
    };
    ajaxData(params, function (data) {
      hideLoading("btnRevision", htmlOriginal);
      if (data.success) {

        console.table(data);
        var htmlCheckupTable = "";
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += data.contActualizacion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += data.contActualizacionS;
        htmlCheckupTable += "</td>";
        $("#tplinkdis").html(htmlCheckupTable);
        var htmlshelly = "";
        htmlshelly += "<tr>";
        htmlshelly += "<td>";
        htmlshelly += data.dispositivoShelly;
        htmlshelly += "</td>";

        htmlshelly += "<td>";
        htmlshelly += data.dispositivoShellyenMALestado;
        htmlshelly += "</td>";

        htmlshelly += "<td>";
        htmlshelly += data.deviceIdmal;
        htmlshelly += "</td>";

        htmlshelly += "<td>";
        htmlshelly += data.tokenInvalido;
        htmlshelly += "</td>";
        $('#cronAlarmas').modal('show');
        $("#shellydis").html(htmlshelly);
      }
    });
  }, function () {
    alertify.set('notifier', 'position', 'top-center');
    alertify.warning('Cancelado')
  });
}





function showListParaEditarAlarmaCentroMando() {
  if ($("#divEditACM").css("display") == "block") {
    $("#divEditACM").hide();
  } else {
    $("#divEditACM").show();
  }
}

function editarAlarmaCentroMando() {
  var idACM = $("#selectAlarmaCentroMando").val();

  if (idACM > 0) {
    alertify.confirm('Advertencia',
      '¿Est&aacute; seguro de moficar la alarma de centro de mando?', () => {
        const params = {
          funct: "actualizarConfiguracion",
          idConfiguracion: 5,
          nombre: 'Alarma_CentroMandoId',
          valor: idACM
        };

        ajaxData(params, function (data) {
          if (data.success) {
            alertify.success('Alarma de centro de mando modificada correctamente.');
            setTimeout(function () { location.reload(); }, 2000);
          }
        });
      }, () => {
        alertify.closeAll()
      }
    );
  }
}

// FIN FUNCIONES CSB

//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>METODOS GENERALES>>>>>>>>>>>>>>>>>>>>
//>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

//metodo para abre llamadas ajax
function ajaxData(data, response) {
  $.ajax({
    type: "GET",
    dataType: "jsonp",
    data: data,
    jsonp: "callback",
    url: "../ajaxcall2/ajaxFunctions.php",
    beforeSend: function () {
      //$("#imgLoadSave").show();
    },
    complete: function () { },
    success: function (data) {
      //console.log(data);
      response(data);
    },
    error: function () { },
  });
}

//metodo para subir imagenes y esperar el collback
function ajaxDataImg(url, data, response) {
  $.ajax({
    type: "POST",
    url: url,
    data: data,
    cache: false,
    contentType: false,
    processData: false,
    success: function (rponse) {
      response(JSON.parse(rponse));
    },
    error: function () {
      // console.log("Error");
    },
  });
}
//sirve para redirecionar y tomar el filtro correspondiente
function obtenervalorfiltro(control) {
  var value = control.value;
  if (value != "") location.href = "catalogos.php?catalog=" + value + "";
}

//mostrar loading
function loadingAjax(target) {
  html =
    '<div class="loadImg"><img src="../images/loading.gif" height="16" /></div>';
  $("#" + target).html(html);
}

//Formatea el campo
function muestraValorMoneda(idInput, valor) {
  $("#" + idInput).val(accounting.formatColumn([valor], "$"));
}

//metodo para agregar un post dinamico
function postDinamico(url, arrParams) {
  var form = $("<form/></form>");
  form.attr("action", url);
  form.attr("method", "POST");
  form.attr("style", "display:none;");

  if (arrParams.length > 0) {
    $.each(arrParams, function (i, v) {
      // console.log(v);
      input = $("<input></input>")
        .attr("type", "hidden")
        .attr("name", v.name)
        .val(v.val);
      form.append(input);
    });
    $("body").append(form);
    // submit form
    form.submit();
    form.remove();
  }
}

//Metodo para agregar campos hidden al post
function agregarInput(target, params) {
  $.each(params, function (i, param) {
    var input = $("<input>")
      .attr("type", "hidden")
      .attr("name", param.name)
      .val(param.value);
    $(target).append($(input));
  });
}
//mostrar loading
function loadingAjax(target) {
  html =
    '<div class="loadImg"><img src="../images/loading.gif" height="16" /></div>';
  $("#" + target).html(html);
}
function stopLoading(target) {
  $("#" + target).html("");
}
//Metodo para poner loading cuando se presionan los botones que hacen accion sobre la DB
function showLoading(target) {
  htmlOriginal = $("#" + target)
    .parent()
    .html();
  html =
    '<div class="loadImg"><img src="../images/loading.gif" height="16" /></div>';
  $("#" + target).hide();
  $("#" + target)
    .parent()
    .append(html);
  //Se retorna el html original para poder ocultar el loading mas tarde
  return htmlOriginal;
}

//Funcion para ocultar loading. Parametros target=id del elemento con loading, htmlOriginal=html obtenido de showLoading
function hideLoading(target, htmlOriginal) {
  //Se agrega el html al padre del elemento target
  $("#" + target)
    .parent()
    .html(htmlOriginal);
}

function verPasswordFromGridPatrullas(idElementoPassword) {
  //console.log(idElementoPassword);
  var x = $("#" + idElementoPassword).attr('type');
  //var x = document.getElementById("'"+idElementoPassword+"'");
  if (x === "password") {
    $("#" + idElementoPassword).attr("type", "text");
  } else {
    $("#" + idElementoPassword).attr("type", "password");
  }
}

function mostrarOjo(id) {
  if ($("#" + id).val()) $("#eye-" + id).show();
  else $("#eye-" + id).hide();
}

function mostrarPassword(id) {
  $("#" + id).attr("type", "text");
}

function ocultarPassword(id) {
  $("#" + id).attr("type", "password");
}

//Obtener extension de un archivo
function getFileExtension(filename) {
  return /[.]/.exec(filename) ? /[^.]+$/.exec(filename)[0] : undefined;
}

//Obtener parametro dada una url
function getParameterByName(name, url) {
  if (!url) url = window.location.href;
  name = name.replace(/[\[\]]/g, "\\$&");
  var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
    results = regex.exec(url);
  if (!results) return null;
  if (!results[2]) return "";
  return decodeURIComponent(results[2].replace(/\+/g, " "));
}
//Configuracion especial de alertify
function defineAlertify() {
  alertify.defaults = {
    // dialogs defaults
    autoReset: true,
    basic: false,
    closable: true,
    closableByDimmer: true,
    frameless: false,
    maintainFocus: true, // <== global default not per instance, applies to all dialogs
    maximizable: true,
    modal: true,
    movable: true,
    moveBounded: false,
    overflow: true,
    padding: true,
    pinnable: true,
    pinned: true,
    preventBodyShift: false, // <== global default not per instance, applies to all dialogs
    resizable: true,
    startMaximized: false,
    transition: "zoom",
    // notifier defaults
    notifier: {
      // auto-dismiss wait time (in seconds)
      delay: 4,
      // default position
      position: "top-center",
      // adds a close button to notifier messages
      closeButton: false,
    },
    // language resources
    glossary: {
      // dialogs default title
      title: "",
      // ok button text
      ok: "OK",
      // cancel button text
      cancel: "Cancelar",
    },
    // theme settings
    theme: {
      // class name attached to prompt dialog input textbox.
      input: "ajs-input",
      // class name attached to ok button
      ok: "ajs-ok",
      // class name attached to cancel button
      cancel: "ajs-cancel",
    },
  };
}
//Mostrar alerta de mensajes personalizados
function msgAlertify(msj, msjPer, tipo) {
  if (msj != "") {
    msj = msj;
  } else {
    msj = msjPer;
  }
  switch (tipo) {
    case 1:
      alertify.success(msj);
      break;
    case 2:
      alertify.error(msj);
      break;
  }
}
function reseteaFormulario(idForm) {
  $("label.error").hide();
  $("label.valid").hide();

  $("input").removeClass("error");
  $("select").removeClass("error");
  $("textarea").removeClass("error");
  $("#" + idForm)[0].reset();
}
//obtener la fecha actual con formato (d/m/Y)
function getCurrentDate(ctr) {
  var d = new Date();

  var month = d.getMonth() + 1;
  var day = d.getDate();

  var horas = d.getHours() >= 10 ? d.getHours() : "0" + d.getHours();
  var minutos = d.getMinutes() >= 10 ? d.getMinutes() : "0" + d.getMinutes();
  var segundos = d.getSeconds();

  var dateCurrent =
    (("" + day).length < 2 ? "0" : "") +
    day +
    "/" +
    (("" + month).length < 2 ? "0" : "") +
    month +
    "/" +
    d.getFullYear();
  var tiempo = horas + ":" + minutos; // + ":" + segundos;

  if (ctr == 1) {
    return dateCurrent;
  }
  if (ctr == 2) {
    return dateCurrent + " " + tiempo;
  }
}

//function para descargar el archivo
function descargarArchivo(rutaArchivo, nivel) {
  if (nivel == 1) {
    filephp = "../download_file.php?pathfile=" + rutaArchivo;
  }
  window.open(filephp, "_blank");
  // location.href=filephp;
}

function limpiaUrl(url) {
  var res = url.replace("https://", "");
  res = res.replace("http://", "");
  res = res.replace("'", "");
  res = res.replace('"', "");

  return res;
}

function agregarClaseActive() {
  var menuObt = getParameterByName("menu");
  if (menuObt != null && menuObt != "") {
    localStorage.setItem("menu", menuObt);
    $("li").removeClass("activemenu");
    $("#btnmenu_" + menuObt).addClass("activemenu");
  } else {
    if (
      localStorage.getItem("menu") != "" &&
      localStorage.getItem("menu") != null
    ) {
      $("li").removeClass("activemenu");
      $("#btnmenu_" + localStorage.getItem("menu")).addClass("activemenu");
    } else {
      $("li").removeClass("activemenu");
      $("#btnmenu_index").addClass("activemenu");
    }
  }
}

function cerrarSesion() {
  localStorage.setItem("menu", "");
  location.href = "../admin/logout.php";
}

//funcion para inicializar el grid bootstrap correctamente
function initGridBT() {
  $("#grid_bootstrap").DataTable({
    searching: false,
    dom: "Bfrtip",
    bInfo: true,
    responsive: true,
    language: {
      url: "../js/Spanish.json",
    },
    aaSorting: [],
  });
}

function editarAyuda(vista) {
  if (vista != "") {
    var params = {
      funct: "mostrarAyuda",
      alias: vista,
    };

    var htmlOriginal = showLoading("btnGuardarAyuda");
    ajaxData(params, function (data) {
      // console.log(data);
      if (data.success) {
        var htmltextarea =
          '<textarea name="contenidoAyuda" id="contenidoAyuda" rows="6" class="form-control contenidoAyuda" required="">' +
          data.descripcion +
          "</textarea>";

        $("#divContenidoAyuda").html(htmltextarea);
        $("#contenidoAyuda").val(data.descripcion);
        // console.log(data.descripcion);
        tinymce.init({
          selector: ".contenidoAyuda",
          theme: "modern",
          plugins: [
            ["advlist autolink link image lists preview hr pagebreak"],
            ["searchreplace wordcount visualblocks visualchars code media"],
            ["save contextmenu directionality emoticons paste"],
          ],
          setup: function (editor) {
            editor.on("change", function () {
              editor.save();
            });
          },
        });
      }
      hideLoading("btnGuardarAyuda", htmlOriginal);
    });
  } else {
    // var htmltextarea = '<textarea class="form-control" id="contenidoAyuda"></textarea>';

    // $("#divContenidoAyuda").html(htmltextarea);
    alertify.error("Por favor seleccione una ayuda.");
  }
}

function guardarAyuda() {
  tinymce.triggerSave();
  $("#question_html").val(tinyMCE.get("contenidoAyuda").getContent());

  if (
    $("#ayudas").val() != "" &&
    tinyMCE.get("contenidoAyuda").getContent() != ""
  ) {
    // var params = {
    //   funct: 'guardarAyuda',
    //   alias:  $("#ayudas").val(),
    //   contenido: tinyMCE.get('contenidoAyuda').getContent()
    // };
    var urlDel = "../ajaxcall2/ajaxFunctions.php?funct=guardarAyuda";
    var formElement = document.getElementById("formPorCotizar");
    var data = new FormData();
    data.append("alias", $("#ayudas").val());
    data.append("contenido", tinyMCE.get("contenidoAyuda").getContent());
    var htmlOriginal = showLoading("btnGuardarAyuda");

    ajaxDataImg(urlDel, data, function (data) {
      hideLoading("btnGuardarAyuda", htmlOriginal);
      if (data.success) {
        alertify.success("Cambios guardados correctamente");
      } else {
        alertify.success("No hay cambios que guardar");
      }
    });

    // ajaxData(params, function(data){
    //   hideLoading('btnGuardarAyuda', htmlOriginal);
    //   if(data.success)
    //   {
    //     alertify.success("Cambios guardados correctamente");
    //   }
    //   else
    //   {
    //     alertify.success("No hay cambios que guardar");
    //   }
    // });
  } else {
    alertify.error("Por favor seleccione una ayuda y escriba su contenido.");
  }
}

function mostrarAyuda(vista) {
  //Obtener ayuda
  //PENDIENTE

  var params = {
    funct: "mostrarAyuda",
    alias: vista,
  };

  ajaxData(params, function (data) {
    // console.log(data);
    if (data.success) {
      var tituloAyuda = data.titulo;
      var contenidoAyuda = data.descripcion;
      // console.log(tituloAyuda);
      // console.log(contenidoAyuda);
      //Mostrar ayuda
      $("#tituloAyuda").html(
        "<img src='../images/icon_ayuda.png' width='25px'>Ayuda " + tituloAyuda
      );
      $("#contenidoAyudaM").html(data.descripcion);
    } else {
      $("#tituloAyuda").html("Error");
      $("#contenidoAyudaM").html(
        "No es posible cargar la ayuda en este momento"
      );
    }
  });
}

function sumarDiasFechaTexto(dateText, numDias) {
  // console.log(dateText);
  arrFecha = dateText.split(" ");
  arrFecha2 = arrFecha[0].split("/");
  var fecha =
    arrFecha2[2] + "-" + arrFecha2[1] + "-" + arrFecha2[0] + " " + arrFecha[1];
  // console.log(fechaPet);
  var fechaObj = new Date(fecha);
  fechaObj.setDate(fechaObj.getDate() + (numDias + 1));
  // console.log(frevision);

  return fechaObj;
}

function enviarMesanjeClientesMultiple() {
  $.validator.setDefaults({
    success: "valid",
  });

  if ($("#listaUsuarios").val() !== null) {
    if ($("#formEnviarMensaje").valid()) {
      var htmlOriginal = showLoading("sendMes");
      // var params = {
      //   funct: "enviarMesanjeClientesMultiple",
      //   idUsuarios: $("#listaUsuarios").val().toString(),
      //   tipo: $("#tipoMensaje").val(),
      //   creador: $("#idUsuarioCbm").val(),
      //   titulo: $("#tituloMensaje").val(),
      //   contenido: $("#contenidoMensaje").val(),
      // };

      // ajaxData(params, function (data) {
      //   hideLoading("sendMes", htmlOriginal);
      //   if (data.success) {
      //     if (data.res > 0) {
      //       alertify.success("Se envio mensaje a " + data.res + " usuarios");
      //     } else {
      //       alertify.error("No se envio el mensaje a ningun usuario");
      //     }
      //   } else {
      //     alertify.error("No se pudo realizar esta accion, intente mas tarde");
      //   }
      // });
      var urlDel = "../ajaxcall2/ajaxFunctions.php?funct=enviarMesanjeClientesMultiple";
      var data = new FormData();
      data.append("idUsuarios", $("#listaUsuarios").val().toString());
      data.append("titulo", $("#tituloMensaje").val());
      data.append("contenido", $("#contenidoMensaje").val());
      data.append("tipo", $("#tipoMensaje").val());
      data.append("creador", $("#idUsuarioCbm").val());
      data.append("saveFolder", "../upload/mensajes/");

      var file1 = $("input#imagenMensaje")[0].files[0];
      if (typeof file1 !== "undefined") {
        data.append("file", file1);
      }

      ajaxDataImg(urlDel, data, function (data) {
        hideLoading("sendMes", htmlOriginal);
        if (data.success) {
          if (data.enviados > 0) {
            alertify.success("Se envi&oacute; el mensaje a " + data.enviados + " usuarios");
          } else {
            alertify.error("No se envi&oacute; el mensaje a ningun usuario");
          }
        } else {
          alertify.error("No se pudo realizar esta acci&oacute;n, intente m&aacute;s tarde.");
        }
      });
    }
  } else {
    alertify.error("Debe seleccionar almenos un usuario");
  }
}

function enviarMesanjeClientesMultipleCiudadanos() {
  if ($("#listaUsuarios").val() !== null) {
    if ($("#formEnviarMensaje").valid()) {
      // var htmlOriginal = showLoading("sendMes");

      var params = {
        funct: "enviarPushMultimedia",
        idUsuarios: $("#listaUsuarios").val().toString(),
        titulo: $("#tituloMensaje").val(),
        contenido: $("#contenidoMensaje").val(),
        tipo: $("#tipoMensaje").val(),
        creador: $("#idUsuarioCbm").val(),
        multimedia: tinymce.get("enviarPushTiny").getContent().replace(/</g, "^^").replace(/>/g, "**")
      }

      ajaxData(params, function (data) {
        // hideLoading("sendMes", htmlOriginal);
        if (data.success) {
          if (data.enviados > 0) {
            alertify.success("Se envio mensaje a " + data.enviados + " usuarios");
          } else {
            alertify.error("No se envio el mensaje a ningun usuario");
          }
        } else {
          alertify.error("No se pudo realizar esta accion, intente mas tarde");
        }
      });
    }
  } else {
    alertify.error("Debe seleccionar almenos un usuario");
  }
}

function enviarMesanjeClientesMultiplePatrulleros() {
  if ($("#listaUsuariosPat").val() !== null) {
    if ($("#formEnviarMensajePat").valid()) {
      // var htmlOriginal = showLoading("sendMes");

      var params = {
        funct: "enviarPushMultimedia",
        idUsuarios: $("#listaUsuariosPat").val().toString(),
        titulo: $("#tituloMensajePat").val(),
        contenido: $("#contenidoMensajePat").val(),
        tipo: $("#tipoMensaje").val(),
        creador: $("#idUsuarioCbm").val(),
        multimedia: tinymce.get("enviarPushTinyPatrulleros").getContent().replace(/</g, "^^").replace(/>/g, "**")
      }

      ajaxData(params, function (data) {
        // hideLoading("sendMes", htmlOriginal);
        if (data.success) {
          if (data.enviados > 0) {
            alertify.success("Se envio mensaje a " + data.enviados + " usuarios");
          } else {
            alertify.error("No se envio el mensaje a ning&uacute;nn usuario");
          }
        } else {
          alertify.error("No se pudo realizar esta acci&oacute;n, intente m&aacute;s tarde");
        }
      });
    }
  } else {
    alertify.error("Debe seleccionar almenos un usuario");
  }
}

function initGridBTById(idTabla) {
  var parametros = obtenerParametrosDataTable(idTabla);

  var gridBT = $("#" + idTabla).DataTable({
    scrollY: true,
    scrollX: true,
    scrollCollapse: true,
    searching: true,
    dom: "Bfrtip",
    bInfo: true,
    responsive: true,
    paging: true,
    columnDefs: parametros["columnDefs"],
    fixedColumns: parametros["fixedCol"],
    processing: parametros["processing"],
    serverSide: parametros["serverSide"],
    ajax: parametros["ajax"],
    pageLength: 10,
    lengthChange: parametros["lengthChange"],
    lengthMenu: [
      [5, 10, 25, 50, 100, -1],
      [5, 10, 25, 50, 100, "Todos"],
    ],
    language: {
      url: "../js/Spanish.json?upd=2",
    },
    aaSorting: [],
    rowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
      //console.log(aData[0]);
      // if ( aData[0].indexOf(' (Baja)') != -1 )
      // {
      //     // $('td', nRow).css('background-color', 'Red');
      //     // $('td', nRow).css('color', 'white');
      //     $('td', nRow).addClass("row-baja");
      // }
      // else
      // {
      //     $('td', nRow).removeClass("row-baja");
      // }
    }, //,
    // "mouseenter": function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
    //     //console.log(aData[0]);
    //     var colIdx = gridBT.cell(this).index().column;

    //         $( gridBT.cells().nodes() ).removeClass( 'highlight' );
    //         $( gridBT.column( colIdx ).nodes() ).addClass( 'highlight' );

    // }
  });

  // gridBT.on( 'select', function ( e, dt, type, indexes ) {
  //   if ( type === 'row' ) {
  //     console.log(e);
  //     console.log(dt);
  //     console.log(type);
  //     console.log(indexes);

  //     // do something with the ID of the selected items
  //     }
  // } );

  // gridBT.addEventListener("click", function(){
  //   myFunction(p1, p2);
  // });

  // $('#'+idTabla+' tbody')
  //   .on( 'mouseenter', 'td', function () {
  //     var colIdx = gridBT.cell(this).index().column;

  //     $( gridBT.cells().nodes() ).removeClass( 'highlight' );
  //     $( gridBT.column( colIdx ).nodes() ).addClass( 'highlight' );
  // } );

  // gridBT.columns.adjust().draw();
  // $('#'+idTabla).css( 'display', 'block' );
  // gridBT.columns.adjust().draw();

  return gridBT;
}
function obtenerParametrosDataTable(idTabla) {
  var fixedCol = false;
  var ajax = false;
  var processing = false;
  var serverSide = false;
  var columnDefs = [{
    width: "20%",
    targets: 0
  }];
  var lengthChange = false;

  if (idTabla == "rptbuzonCiudadanoGrid") {
    columnDefs = [
      {
        width: "6%",
        targets: 0,
      },
      {
        width: "10%",
        targets: 3,
      },
    ];
  }

  var obj = {
    fixedCol: fixedCol,
    ajax: ajax,
    processing: processing,
    serverSide: serverSide,
    columnDefs: columnDefs,
    lengthChange: lengthChange,
  };

  obj["fixedCol"] = fixedCol;
  obj["ajax"] = ajax;
  obj["processing"] = processing;
  obj["serverSide"] = serverSide;
  obj["columnDefs"] = columnDefs;
  obj["lengthChange"] = lengthChange;

  return obj;
}
function detallesReporte(idRpt) {
  location.href = "detallesRptCiudadano.php?idRpt=" + idRpt;
}
function detallesReporteM(idRpt) {
  location.href = "detallesRptMascotas.php?idRpt=" + idRpt;
}
//>>>>>>>>>>Mapa estatico para los eventos
function onMapGoogleEvento(latitude, longitude) {
  // console.log(accounting.unformat(latitude));
  // console.log(accounting.unformat(longitude));

  // app.preloader.show();
  var options = {
    zoom: 15,
    center: {
      lat: accounting.unformat(latitude),
      lng: accounting.unformat(longitude),
    },
    //mapTypeId: "satellite",
    mapTypeControl: false,
    disableDefaultUI: true,
    // zoomControl: true,
    // zoomControlOptions: {
    //     style: google.maps.ZoomControlStyle.LARGE,
    //     position: google.maps.ControlPosition.LEFT_CENTER
    // },
    // scaleControl: true,
  };
  var map = new google.maps.Map(
    document.getElementById("map_ubicacion"),
    options
  );
  var marker = new google.maps.Marker({
    map: map,
    draggable: false,
    // animation: google.maps.Animation.DROP,
    position: {
      lat: accounting.unformat(latitude),
      lng: accounting.unformat(longitude),
    },
  });
  // app.preloader.hide();
}

function enviarMesanjeIndividual() {
  $.validator.setDefaults({
    success: "valid",
  });
  if ($("#sendMsgNot").valid()) {
    var htmlOriginal = showLoading("sendMes");

    var params = {
      funct: "enviarMesanjeIndividual",
      idUsuario: $("#idUsuario").val(),
      idUsuarioEnv: $("#idUsuarioEnv").val(),
      idMensaje: $("#idMensaje").val(),
      contenido: $("#contenidoMensaje").val(),
    };

    ajaxData(params, function (data) {
      hideLoading("sendMes", htmlOriginal);
      if (data.success) {
        if (data.res > 0) {
          alertify.success("Se envio mensaje a " + data.res + " usuario");
          setTimeout(function () {
            if ($("#tipoConcepto").val() == 2) {
              location.href = "detallesRptCiudadano.php?idRpt=" + $("#idReporte").val();
            } else if ($("#tipoConcepto").val() == 3) {
              location.href = "detallesRptMascotas.php?idRpt=" + $("#idReporte").val();
            }
          }, 1000);
        } else {
          alertify.error("No se envio el mensaje a ningun usuario");
        }
      } else {
        alertify.error("No se pudo realizar esta accion, intente mas tarde");
      }
    });
  }
}

function detallesMensaje(idRpt, idConcepto) {
  if (idConcepto == 2) {
    location.href = "detallesRptCiudadano.php?idRpt=" + idRpt + "&page=1";
  } else if (idConcepto == 3) {
    location.href = "detallesRptMascotas.php?idRpt=" + idRpt + "&page=1";
  }
}
function returnPage(idConcepto) {
  if (idConcepto == 2) {
    location.href = "rptCiudadano.php";
  } else if (idConcepto == 3) {
    location.href = "rptMascotas.php";
  } else {
    location.href = "rptMensajes.php";
  }
}
function solicitudPeticion() {
  var data = {
    funct: "solicitudPeticion",
    idUsuario: 5,
    latitud: "19.02770211",
    longitud: "-98.2211977,161",
    idTipoPeticion: 1,
  }; //Parametros ajax

  $.ajax({
    async: false,
    type: "GET",
    dataType: "jsonp",
    data: data,
    jsonp: "callback",
    url: "../ajaxcall2/jsonfunct.php",
    success: function (data) {
      //console.log(data);
      // console.log(data.success);
    },
  });
}
function patrullasDisp() {
  var params = {
    funct: "patrullasDisp",
    idEstatus: 1,
    idActivo: 1,
  };
  ajaxData(params, function (data) {
    // console.log(data);
  });
}
function patrullasDataTurno() {
  var params = {
    funct: "patrullasDataTurno",
    idTurno: 3,
  };
  ajaxData(params, function (data) {
    // console.log(data);
  });
}
function asignaPatrullaTurno(idTurno, idPeticion) {
  var params = {
    funct: "asignaPatrullaTurno",
    idTurno: idTurno,
    idPeticion: idPeticion,
    tipoAsignacion: "Server",
  };
  ajaxData(params, function (data) {
    // console.log(data);
  });
}

function notifyMe(mensaje, body, funcion) {
  if (!("Notification" in window)) {
    alert("Este navegador no soporta notificaciones de escritorio");
  } else if (Notification.permission === "granted") {
    var options = {
      body: body,
      icon: "../images/logo.png",
      dir: "ltr",
    };
    var notification = new Notification(mensaje, options);
    notification.onclick = funcion;
  } else if (Notification.permission !== "denied") {
    Notification.requestPermission(function (permission) {
      if (!("permission" in Notification)) {
        Notification.permission = permission;
      }
      if (permission === "granted") {
        var options = {
          body: body,
          icon: "../images/logo.png",
          dir: "ltr",
        };
        var notification = new Notification(mensaje, options);
        notification.onclick = funcion;
      }
    });
  }
}

function presionarEnter(event, vista) {
  if (event.which == 13 || event.keyCode == 13) {
    //code to execute here
    event.preventDefault();
    switch (vista) {
      case "chat":
        enviarMensaje();
        break;

      default:
      // console.log("Presionar enter"+true);break;
    }
  } else {
    //console.log("Presionar enter"+false);
  }

}

function presionarEnter2(event, vista) {
  if (event.which == 13 || event.keyCode == 13) {
    //code to execute here
    event.preventDefault();
    switch (vista) {
      case "chat2":
        enviarMensaje2();
        break;

      default:
      // console.log("Presionar enter"+true);break;
    }
  } else {
    //console.log("Presionar enter"+false);
  }

}

//Centrar marcador en el mapa 
function verMarcadorMapa(lat, long) {
  var lat = accounting.unformat(lat);
  var long = accounting.unformat(long);
  // console.log(lat);
  // console.log(long);

  map.setCenter(new google.maps.LatLng(lat, long));
  map.setZoom(16);
  var elmnt = document.getElementById("contend_MSG");
  elmnt.scrollBy(0, 100000);
  // var elmnt = document.getElementById("contend_MSG2");
  // elmnt.scrollBy(0, 100000);
}


//Variable para guardar el id de la peticion que ya fue seleccionada con anterioridad
var itemsSelected = "";

function seleccionarList(idPeticion, idOperadorAtendio, estatusId) {
  desplegarInfoPeticion = true;
  //corremos un proceso en paralelo para marcar la peticion como atendida por un operador
  marcarAtendidaOperador(idPeticion, idOperadorAtendio);

  selected = idPeticion;
  itemsSelected = localStorage.getItem('idsSelected');
  //Validamos que tenga informacion guardada de peticiones recibidas
  if (itemsSelected != "" && itemsSelected != null) {
    var items = itemsSelected.split(",");
    //console.log("ITEMS");
    //console.log(items);
    //console.log("include? "+items.includes(idPeticion+""));
    if (!items.includes(idPeticion + "")) {
      console.log("added: " + idPeticion);
      items.push(idPeticion);
    }
    //console.log(items.join().toString());
    clearMarkers2()
    localStorage.setItem("idsSelected", items.join().toString());

  } else {
    localStorage.setItem("idsSelected", idPeticion);
  }
  // console.log("cont_list_"+idPeticion);
  //$(".cont_peticion").removeClass("green_selected");
  //$("#cont_list_" + idPeticion).addClass("green_selected");

  //Obtenemos sus clases 

  var pet = $("#painting_areaPeticion_" + idPeticion);

  for (var i = 0; i < pet[0].classList.length; i++) {
    var clase = pet[0].classList[i];
    if (clase == "orange" || clase == "red") {
      pet.removeClass("orange");
      pet.removeClass("red");
      pet.addClass("green");
    }
  }

  //$("#painting_areaPeticion_"+idPeticion).css("background","green");
  $("#selecMap").val(5);
  // var params = {
  //         funct: 'seleccionarList',
  //         idPeticion:idPeticion
  //     };
  //     ajaxData(params, function(data){
  preparaVerPeticion(idPeticion);
  // }); 
}

function marcarAtendidaOperador(idPeticion, idOperadorAtendio) {

  if (idPeticion !== undefined && idPeticion != "" && idPeticion > 0 && idPeticion != null) {
    //enviamos peticion para cambiar atendidoOperador a positivo
    var params = {
      funct: "cambiarAtendidoOperador",
      idPeticion: idPeticion,
      atendidoOperador: idOperadorAtendio
    };
    ajaxData(params, function (data) {
      console.log("cambiarAtendidoOperador");
      //console.log(data);

      if (data.success) {
        //console.log("Peticion marcada como atendida por el operador");
        alertify.alert("El usuario operador que está atendiendo la petición con ID: " + idPeticion + " es: " + data.userdata.nombre + ".", function () {
          alertify.message('OK');
        });
      } else {
        console.log("Hay una peticion que no se ha podido marcar como atendida");
      }
    });
  }
}

function eliminarUsuario(idUsuario) {
  alertify.confirm(
    "Eliminar usuario",
    "¿Esta seguro de eliminar este usuario?",
    function () {
      var params = {
        funct: "eliminarUsuario",
        idUsuario: idUsuario,
      };

      ajaxData(params, function (data) { });

      setTimeout(function () { location.reload(); }, 2000);
    }, function () { });
}

/**
 * Miscelaneous FRAMELOVA
 * 30/06/21
 * JARED
 */
document.addEventListener('click', (e) => {
  /**
   * Captura clic en elementos con la clase zoomOnImage
   */
  const dis = e.target;
  let hasImage = false;

  if (dis.src !== 'data:image/jpeg;base64,') {
    hasImage = true;
  } else {
    hasImage = false
  }

  if (dis && dis.className === 'framelova-zoomOnImage') {
    const sourceOfImage = dis.src;
    const zoomedImage = document.getElementsByClassName('framelova-zoomedImage');
    zoomedImage[0].innerHTML = hasImage === true ?
      /*html*/
      `<img src=${sourceOfImage} class="framelova-zoomedImageImg">` :
      /*html*/
      `<div class="framelova-noImageResult">
      <h4>No hay imagen disponible</h4>
    </div>` ;
    $("#modalImage").modal();
  }
});

// BEAR 01-12-2022

function botonregristro(datetime, usuarioAlarma) {
  var matriculaAlarma = "";
  var identificadorAlarma = "";
  var latitudAlarma = "";
  var longitudAlarma = "";
  var comiteAlarma = "";
  var cuentaAlarma = "";
  matriculaAlarma = document.getElementById('txtMatrculaAlarma').value;
  identificadorAlarma = document.getElementById('txtIdentificadorAlarma').value;
  identificadorAlarma = (identificadorAlarma == '') ? 'x' : identificadorAlarma;
  latitudAlarma = document.getElementById('txtLatitudAlarma').value;
  longitudAlarma = document.getElementById('txtLongitudAlarma').value;
  comiteAlarma = document.getElementById('selectComiteAlarma').value;
  cuentaAlarma = document.getElementById('txtCuentaAlarma').value;
  console.log(matriculaAlarma, identificadorAlarma, latitudAlarma, longitudAlarma, comiteAlarma, cuentaAlarma, usuarioAlarma, datetime);

  if (matriculaAlarma != "" &&
    identificadorAlarma != "" &&
    latitudAlarma != "" &&
    longitudAlarma != "" &&
    comiteAlarma != "" &&
    cuentaAlarma != "" &&
    usuarioAlarma != "") {
    var params = {
      funct: 'altaAlarmaNueva',
      matrculaAlarma: matriculaAlarma,
      identificadorAlarma: identificadorAlarma,
      latitudAlarma: latitudAlarma,
      longitudAlarma: longitudAlarma,
      comiteAlarma: comiteAlarma,
      cuentaAlarma: cuentaAlarma,
      usuarioAlarma: usuarioAlarma,
      fechaCreacion: datetime
    };
    //bear corrigio la carga de datos :)
    //console.log(params);
    var htmlOriginal = showLoading("btnSubmitAlarma");
    //console.log(htmlOriginal);
    ajaxData(params, function (data) {
      //console.log(data.success);
      hideLoading("btnSubmitAlarma", htmlOriginal);
      //console.log(hideLoading);
      if (data.success) {
        console.log("hola qui");
        alertify.success("El registro de la alarma se realizo correctamente");
        let idAlarma = data.idAlarma;
        // console.log(`la alarma con id ${idAlarma} se ha dado de alta con exito`);
        var params = {
          funct: "verifyDevice",
          idAlarma: idAlarma
        };
        ajaxData(params, function (data) {
          if (data.success) {
            console.log(`check-up de alarma con id ${idAlarma} realizado`);
          }
        });
        //limpiar();
        setTimeout(function () {
          location.reload();
        }, 1500);
      } else {
        alertify.warning("No se pudo registrar la alarma, intentelo mas tarde");
      }
    });
  } else {
    alertify.warning("Llena todos los campos solicitados");
  }
  function limpiar() {
    document.getElementById('txtMatrculaAlarma').value = "";
    document.getElementById('txtIdentificadorAlarma').value = "";
    document.getElementById('txtLatitudAlarma').value = "";
    document.getElementById('txtLongitudAlarma').value = "";
    //document.getElementById('selectComiteAlarma').value="";
    //document.getElementById('txtCuentaAlarma').value = "";
    //document.getElementById('selectUsuarioAlarma').value="";
  }
}
function prueba() {
  let datos = $("#Alarma").val();
  console.log(datos);

}




//  mover del alamas
function encenderAlarmaButton(idVehiculo, accion, historico) {
  alertify.confirm('Encender Alarma', 'Estas seguro que quieres encender la alarma?', function () {
    encenderAlarma(idVehiculo, 1, 1);
    alertify.success('Alarma encendida');
  }, function () {
    alertify.warning('Cancelado');
  });
}

function apagarAlarmaButton(idVehiculo, accion, historico) {
  alertify.confirm('Apagar Alarma', 'Estas seguro que quieres apagar la alarma?', function () {
    encenderAlarma(idVehiculo, 0, 1);
    alertify.success('Alarma apagada');
  }, function () {
    alertify.warning('Cancelado');
  });
}
//shelly
//Realizamos check-up de alarma
function checkupAlarma(idAlarma, matriculaAlarma) {

  $("#alarmaCheckupClss").html(matriculaAlarma);

  //Mostramos loadings
  var htmlContentCheckup = showLoading("contentCheckup");

  //Enviamos datos para realizar check
  var params = {
    funct: "verifyDevice",
    idAlarma: idAlarma
  };
  console.log(params);
  ajaxData(params, function (data) {
    console.log("verifyDevice");
    console.log(data);

    var desbloqueoObj = {};
    var estadoObj = {};
    var tokenObj = {};
    var servidorObj = {};
    var enLineaObj = {};
    var mensajeObj = {};
    var deviceIdObj = {};
    var mensajebajoObj = {};


    if (data.success) {

      var htmlCheckupTable = "";

      if (data.tipo == "tplink") {
        //Bloque de BLOQUEADA
        //hideLoading("checkBloqueoAlarma", htmlCheckBloqueoAlarma);
        if (data.bloqueada == "updated") {
          //La alarma estaba como ocupada sin peticion asignada y se actualizo como disponible
          desbloqueoObj.estado = "Bloqueada";
          desbloqueoObj.accion = "Desbloquear";
          desbloqueoObj.nuevoEstado = "Desbloqueada";
          desbloqueoObj.notas = "*";
          //$("#checkBloqueoAlarma").html("CORRECTAMENTE DESBLOQUEADA <span class='fa fa-check-circle'></span>");
        } else if (data.bloqueada == "no updated") {
          //La alarma esta como ocupada sin peticion activa pero no se pudo actualizar por algun error
          desbloqueoObj.estado = "Bloqueada";
          desbloqueoObj.accion = "Desbloquear";
          desbloqueoObj.nuevoEstado = "Bloqueada";
          desbloqueoObj.notas = "No se pudo desbloquear alarma, verifique la configuración manualmente e inténtelo más tarde";
          //$("#checkBloqueoAlarma").html("NO DESBLOQUEADA <span class='fa fa-exclamation-triangle'></span>");
        } else if (data.bloqueada == "ok") {
          //La alarma no esta en estado de ocupada y no se realio ninguna accion
          desbloqueoObj.estado = "Desbloqueada";
          desbloqueoObj.accion = "Ninguna";
          desbloqueoObj.nuevoEstado = "*";
          desbloqueoObj.notas = "*";
          //$("#checkBloqueoAlarma").html("DESBLOQUEADA <span class='fa fa-check-circle'></span>");
        } else {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          desbloqueoObj.estado = "No definido";
          desbloqueoObj.accion = "No definido";
          desbloqueoObj.nuevoEstado = "No definido";
          desbloqueoObj.notas = "Verifique su conexión o revise la configuración e inténtelo más tarde";
        }

        //Bloque de ESTADO 
        //hideLoading("checkEstadoAlarma", htmlCheckEstadoAlarma);
        if (data.estado == "on") {
          //La alarma esta disponible
          estadoObj.estado = "Encendida";
          estadoObj.accion = "Apagar";
          estadoObj.nuevoEstado = "Apagada";
          estadoObj.notas = "*";
          //$("#checkEstadoAlarma").html("ALARMA FUE APAGADA<span class='fa fa-check-circle'></span>");
        } else if (data.estado == "off") {
          //El token no se pudo actualizar por algun error
          estadoObj.estado = "Apagada";
          estadoObj.accion = "Ninguna";
          estadoObj.nuevoEstado = "*";
          estadoObj.notas = "*";
          //$("#checkEstadoAlarma").html("ALARMA APAGADA<span class='fa fa-check-circle'></span>");
        } else {
          //Intentelo mas tarde
          estadoObj.estado = "No definido";
          estadoObj.accion = "No definido";
          estadoObj.nuevoEstado = "No definido";
          estadoObj.notas = "Verifique su conexión o revise la configuración e inténtelo más tarde";
        }

        //Bloque de TOKEN
        //hideLoading("checkTokenAlarma", htmlCheckTokenAlarma);
        if (data.token == "updated") {
          //El token fue actualizado
          tokenObj.estado = "Expirado";
          tokenObj.accion = "Actualizar";
          tokenObj.nuevoEstado = "Actualizado";
          tokenObj.notas = "*";
          //$("#checkTokenAlarma").html("ACTUALIZADO <span class='fa fa-check-circle'></span>");
        } else if (data.token == "no updated") {
          //El token no se pudo actualizar por algun error
          tokenObj.estado = "Expirado";
          tokenObj.accion = "Actualizar";
          tokenObj.nuevoEstado = "Expirado";
          tokenObj.notas = "No se pudo actualizar el token, verifique su conexión";
          //$("#checkTokenAlarma").html("NO ACTUALIZADO <span class='fa fa-exclamation-triangle'></span>");
        } else if (data.token == 'no data account') {
          tokenObj.estado = "Desconocido";
          tokenObj.accion = "Ninguna";
          tokenObj.nuevoEstado = "*";
          tokenObj.notas = "Verificar los datos de la cuenta";
        } else if (data.token == "ok") {
          //El token sigue siendo el correcto
          tokenObj.estado = "Correcto";
          tokenObj.accion = "Ninguna";
          tokenObj.nuevoEstado = "*";
          tokenObj.notas = "*";
          //$("#checkTokenAlarma").html("CORRECTO <span class='fa fa-check-circle'></span>");
        } else {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          tokenObj.estado = "No definido";
          tokenObj.accion = "No definido";
          tokenObj.nuevoEstado = "No definido";
          tokenObj.notas = "Verifique su conexión o revise la configuración e inténtelo más tarde";
        }

        //Bloque de SERVIDOR
        //hideLoading("checkServidorAlarma", htmlCheckServidorAlarma);
        if (data.servidor == "updated") {
          //El servidor fue actualizado
          servidorObj.estado = "Incorrecto";
          servidorObj.accion = "Actualizar";
          servidorObj.nuevoEstado = "Actualizado";
          servidorObj.notas = "*";
          //$("#checkServidorAlarma").html("ACTUALIZADO <span class='fa fa-check-circle'></span>");
        } else if (data.servidor == "no updated") {
          //El servidor no se pudo actualizar por algun error
          servidorObj.estado = "Incorrecto";
          servidorObj.accion = "Actualizar";
          servidorObj.nuevoEstado = "Incorrecto";
          servidorObj.notas = "No se pudo actualizar el servidor, inténtelo más tarde";
          //$("#checkServidorAlarma").html("NO ACTUALIZADO <span class='fa fa-exclamation-triangle'></span>");
        } else if (data.servidor == "ok") {
          //El servidor sigue siendo el correcto
          servidorObj.estado = "Correcto";
          servidorObj.accion = "Ninguna";
          servidorObj.nuevoEstado = "*";
          servidorObj.notas = "*";
          //$("#checkServidorAlarma").html("CORRECTO <span class='fa fa-check-circle'></span>");
        } else {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          servidorObj.estado = "No definido";
          servidorObj.accion = "No definido";
          servidorObj.nuevoEstado = "No definido";
          servidorObj.notas = "Verifique su conexión o revise la configuración e inténtelo más tarde";
        }

        //Bloque de EN LINEA
        //hideLoading("checkEnLineaAlarma", htmlContentCheckup);
        if (data.enLinea) {
          enLineaObj.estado = "En línea";
          enLineaObj.accion = "Ninguna";
          enLineaObj.nuevoEstado = "*";
          enLineaObj.notas = "*";
          //$("#checkEnLineaAlarma").html("EN LINEA <span class='fa fa-check-circle'></span>");
        } else if (data.enLinea == "unknow") {
          enLineaObj.estado = "No definido";
          enLineaObj.accion = "No definido";
          enLineaObj.nuevoEstado = "No definido";
          enLineaObj.notas = "Verifique su conexión o revise la configuración e inténtelo más tarde";
        } else {
          //Alarma no disponible
          enLineaObj.estado = "Fuera de línea";
          enLineaObj.accion = "Ninguna";
          enLineaObj.nuevoEstado = "*";
          enLineaObj.notas = "*";
          //$("#checkEnLineaAlarma").html("FUERA DE LINEA <span class='fa fa-exclamation-triangle'></span>");
        }

        //ERROR DE SERVER
        if (data.mensaje == "unknow") {
          mensajeObj.notas = "Ocurrio un error desconocido, inténtelo más tarde. Mensaje de error: " + data.responseEstatus.msg;
        } else if (data.mensaje == "server") {
          mensajeObj.notas = "El servidor registrado no coincide con los servidores almacenados en la base de datos.";
        } else if (data.mensaje == "timeout") {
          mensajeObj.notas = "Error de conexión, dispositivo fuera de línea o sin corriente, verificar dispositivo físicamente.";
        } else if (data.mensaje == "empty account") {
          mensajeObj.notas = "Favor de revisar el usuario y contraseña de la cuenta.";
        } else if (data.mensaje == "token updated") {
          mensajeObj.notas = "El token de la cuenta se actualizó correctamente.";
        } else {
          mensajeObj.notas = "*";
        }

        //ERROR DEVICEID
        if (data.deviceId == "unknow") {
          deviceIdObj.notas = "Se encontró un error en el identificador de la alarma, favor de corregir para realizar el análisis.";
        } else {
          deviceIdObj.notas = "**";
        }

        //HTML BLOQUEO
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Bloqueo";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML ESTADO
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Encendido logico";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML TOKEN
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Token";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML SERVIDOR
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Servidor";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML EN LINEA
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "En línea";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML FOOTER NOTES
        var htmlCheckupTableFooter = "";
        htmlCheckupTableFooter += "<tr>";
        htmlCheckupTableFooter += "<td class='footerContent'>";
        htmlCheckupTableFooter += "<div class='titleNotasFooter'>";
        htmlCheckupTableFooter += "Mensajes generales";
        htmlCheckupTableFooter += "</div>";
        htmlCheckupTableFooter += "<div class='contentNotasFooter'>";
        htmlCheckupTableFooter += deviceIdObj.notas;
        htmlCheckupTableFooter += "</div>";
        htmlCheckupTableFooter += "<div class='contentNotasFooter'>";
        htmlCheckupTableFooter += mensajeObj.notas;
        htmlCheckupTableFooter += "</div>";
        htmlCheckupTableFooter += "</td>";
        htmlCheckupTableFooter += "</tr>";

        hideLoading("contentCheckup", htmlContentCheckup);

        $("#footerCheckup").html("");
        $("#footerCheckup").html(htmlCheckupTableFooter);
        $("#contentCheckup").html("");
        $("#contentCheckup").html(htmlCheckupTable);

      } else if (data.tipo.includes("shelly")) {
        console.log("aqui en shelly")
        //Bloque de BLOQUEADA
        //hideLoading("checkBloqueoAlarma", htmlCheckBloqueoAlarma);
        if (data.bloqueada == "updated") {

          //La alarma estaba como ocupada sin peticion asignada y se actualizo como disponible
          desbloqueoObj.estado = "Bloqueada";
          desbloqueoObj.accion = "Desbloquear";
          desbloqueoObj.nuevoEstado = "Desbloqueada";
          desbloqueoObj.notas = "*";
          //$("#checkBloqueoAlarma").html("CORRECTAMENTE DESBLOQUEADA <span class='fa fa-check-circle'></span>");

        } else if (data.bloqueada == "no updated") {

          //La alarma esta como ocupada sin peticion activa pero no se pudo actualizar por algun error
          desbloqueoObj.estado = "Bloqueada";
          desbloqueoObj.accion = "Desbloquear";
          desbloqueoObj.nuevoEstado = "Bloqueada";
          desbloqueoObj.notas = "No se pudo desbloquear alarma, verifique configuracion manual e intentelo mas tarde";

          //$("#checkBloqueoAlarma").html("NO DESBLOQUEADA <span class='fa fa-exclamation-triangle'></span>");
        } else if (data.bloqueada == "ok") {

          //La alarma no esta en estado de ocupada y no se realio ninguna accion
          desbloqueoObj.estado = "Desbloqueada";
          desbloqueoObj.accion = "Ninguna";
          desbloqueoObj.nuevoEstado = "*";
          desbloqueoObj.notas = "*";

          //$("#checkBloqueoAlarma").html("DESBLOQUEADA <span class='fa fa-check-circle'></span>");
        } else if (data.bloqueada == "servidor") {
          desbloqueoObj.estado = "No definido";
          desbloqueoObj.accion = "No definido";
          desbloqueoObj.nuevoEstado = "No definido";
          desbloqueoObj.notas = "Verfique el servidor del dispositivo";
        } else if (data.bloqueada == "401") {
          desbloqueoObj.estado = "No definido";
          desbloqueoObj.accion = "No definido";
          desbloqueoObj.nuevoEstado = "No definido";
          desbloqueoObj.notas = "token no válido";
        } else {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          desbloqueoObj.estado = "No definido";
          desbloqueoObj.accion = "No definido";
          desbloqueoObj.nuevoEstado = "No definido";
          desbloqueoObj.notas = "Verifique su conexion o revise la configuracion e intentelo mas tarde";

        }

        //Bloque de ESTADO 
        //hideLoading("checkEstadoAlarma", htmlCheckEstadoAlarma);
        if (data.estado == "on") {
          //La alarma esta disponible
          estadoObj.estado = "Encendida";
          estadoObj.accion = "Apagar";
          estadoObj.nuevoEstado = "Apagar";
          estadoObj.notas = "*";

          //$("#checkEstadoAlarma").html("ALARMA FUE APAGADA<span class='fa fa-check-circle'></span>");

        } else if (data.estado == "off") {
          //El token no se pudo actualizar por algun error
          estadoObj.estado = "Apagada";
          estadoObj.accion = "Ninguna";
          estadoObj.nuevoEstado = "*";
          estadoObj.notas = "*";

          //$("#checkEstadoAlarma").html("ALARMA APAGADA<span class='fa fa-check-circle'></span>");
        } else if (data.estado == "id") {
          //Intentelo mas tarde
          estadoObj.estado = "No definido";
          estadoObj.accion = "No definido";
          estadoObj.nuevoEstado = "No definido";
          estadoObj.notas = "indentificador del dispositivo esta mal";
        } else if (data.estado == "servidor") {
          //Intentelo mas tarde
          estadoObj.estado = "No definido";
          estadoObj.accion = "No definido";
          estadoObj.nuevoEstado = "No definido";
          estadoObj.notas = "Verfique el servidor del dispositivo";
        } else if (data.estado == "401") {
          //Intentelo mas tarde
          estadoObj.estado = "No definido";
          estadoObj.accion = "No definido";
          estadoObj.nuevoEstado = "No definido";
          estadoObj.notas = "token no válido";
        } else {
          //Intentelo mas tarde
          estadoObj.estado = "No definido";
          estadoObj.accion = "No definido";
          estadoObj.nuevoEstado = "No definido";
          estadoObj.notas = "Verifique su conexion o revise la configuracion e intentelo mas tarde";
        }


        //Bloque de TOKEN
        //hideLoading("checkTokenAlarma", htmlCheckTokenAlarma);
        if (data.token == "updated") {
          //El token fue actualizado
          tokenObj.estado = "Expirado";
          tokenObj.accion = "Actualizar";
          tokenObj.nuevoEstado = "Actualizado";
          tokenObj.notas = "*";

          //$("#checkTokenAlarma").html("ACTUALIZADO <span class='fa fa-check-circle'></span>");
        } else if (data.token == "no updated") {
          //El token no se pudo actualizar por algun error
          tokenObj.estado = "Expirado";
          tokenObj.accion = "Actualizar";
          tokenObj.nuevoEstado = "Expirado";
          tokenObj.notas = "No se pudo actualizar el token verifique su conexion o los datos de cuenta";

          //$("#checkTokenAlarma").html("NO ACTUALIZADO <span class='fa fa-exclamation-triangle'></span>");
        } else if (data.token == "ok") {
          //El token sigue siendo el correcto
          tokenObj.estado = "Correcto";
          tokenObj.accion = "Ninguna";
          tokenObj.nuevoEstado = "*";
          tokenObj.notas = "*";

          //$("#checkTokenAlarma").html("CORRECTO <span class='fa fa-check-circle'></span>");
        } else if (data.token == "token invalido") {
          tokenObj.estado = "No definido";
          tokenObj.accion = "No definido";
          tokenObj.nuevoEstado = "No definido";
          tokenObj.notas = "Error Verifique el token e intente mas tarde";
        } else if (data.token == "servidor") {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          tokenObj.estado = "No definido";
          tokenObj.accion = "No definido";
          tokenObj.nuevoEstado = "No definido";
          tokenObj.notas = "Verfique el servidor del dispositivo";
        } else if (data.token == "401") {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          tokenObj.estado = "No definido";
          tokenObj.accion = "No definido";
          tokenObj.nuevoEstado = "No definido";
          tokenObj.notas = "token no válido";
        } else {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          tokenObj.estado = "No definido";
          tokenObj.accion = "No definido";
          tokenObj.nuevoEstado = "No definido";
          tokenObj.notas = "Verifique su conexion o revise la configuracion e intentelo mas tarde";
        }

        //Bloque de SERVIDOR
        //hideLoading("checkServidorAlarma", htmlCheckServidorAlarma);
        if (data.servidor == "updated") {
          //El servidor fue actualizado
          servidorObj.estado = "Incorrecto";
          servidorObj.accion = "Actualizar";
          servidorObj.nuevoEstado = "Actualizado";
          servidorObj.notas = "*";

          //$("#checkServidorAlarma").html("ACTUALIZADO <span class='fa fa-check-circle'></span>");
        } else if (data.servidor == "no updated") {
          //El servidor no se pudo actualizar por algun error
          servidorObj.estado = "Incorrecto";
          servidorObj.accion = "Actualizar";
          servidorObj.nuevoEstado = "Incorrecto";
          servidorObj.notas = "No se pudo actualizar el servidor, intentelo mas tarde";

          //$("#checkServidorAlarma").html("NO ACTUALIZADO <span class='fa fa-exclamation-triangle'></span>");
        } else if (data.servidor == "ok") {
          //El servidor sigue siendo el correcto
          servidorObj.estado = "Correcto";
          servidorObj.accion = "Ninguna";
          servidorObj.nuevoEstado = "*";
          servidorObj.notas = "*";

          //$("#checkServidorAlarma").html("CORRECTO <span class='fa fa-check-circle'></span>");
        } else if (data.servidor == "servidor") {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          servidorObj.estado = "No definido";
          servidorObj.accion = "No definido";
          servidorObj.nuevoEstado = "No definido";
          servidorObj.notas = "Verfique el servidor del dispositivo";
        } else if (data.servidor == "401") {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          servidorObj.estado = "No definido";
          servidorObj.accion = "No definido";
          servidorObj.nuevoEstado = "No definido";
          servidorObj.notas = "token no válido, pero el seridor esta bien.";
        } else {
          //Intentelo mas tarde
          alertify.warning("Intentalo mas tarde");
          servidorObj.estado = "No definido";
          servidorObj.accion = "No definido";
          servidorObj.nuevoEstado = "No definido";
          servidorObj.notas = "Verifique su conexion o revise la configuracion e intentelo mas tarde";
        }


        //Bloque de EN LINEA
        //hideLoading("checkEnLineaAlarma", htmlContentCheckup);
        if (data.enLinea == true) {
          enLineaObj.estado = "En linea";
          enLineaObj.accion = "Ninguna";
          enLineaObj.nuevoEstado = "*";
          enLineaObj.notas = "*";

          //$("#checkEnLineaAlarma").html("EN LINEA <span class='fa fa-check-circle'></span>");
        } else if (data.enLinea == false) {
          enLineaObj.estado = "No definido";
          enLineaObj.accion = "No definido";
          enLineaObj.nuevoEstado = "No definido";
          enLineaObj.notas = "Indentificador del dispositivo esta mal";
        } else if (data.enLinea == "servidor") {
          enLineaObj.estado = "No definido";
          enLineaObj.accion = "No definido";
          enLineaObj.nuevoEstado = "No definido";
          enLineaObj.notas = "Verfique el servidor del dispositivo";
        } else if (data.enLinea == "401") {
          enLineaObj.estado = "No definido";
          enLineaObj.accion = "No definido";
          enLineaObj.nuevoEstado = "No definido";
          enLineaObj.notas = "token no válido, no podemos controlar el dispositivo";
        } else if (data.enLinea == "no") {
          enLineaObj.estado = "No definido";
          enLineaObj.accion = "No definido";
          enLineaObj.nuevoEstado = "No definido";
          enLineaObj.notas = "Dispositivo no tiene internet";
        } else {
          //Alarma no disponible
          enLineaObj.estado = "Fuera de linea";
          enLineaObj.accion = "Ninguna";
          enLineaObj.nuevoEstado = "*";
          enLineaObj.notas = "*";

          //$("#checkEnLineaAlarma").html("FUERA DE LINEA <span class='fa fa-exclamation-triangle'></span>");
        }

        //ERROR DE SERVER
        if (data.mensaje == "unknow") {
          mensajeObj.notas = "Ocurrio un error desconocido, intentelo mas tarde";
        } else if (data.mensaje == "Esta todo bien.") {
          mensajeObj.notas = "*";
        } else if (data.mensaje == "servidor") {
          mensajeObj.notas = "*";
        } else if (data.mensaje == "401") {
          mensajeObj.notas = "*";
        }


        //ERROR DEVICEID
        if (data.mensajebajo == "NO INTERNET") {
          mensajebajoObj.notas = "Por favor de verificar dispositivo de manera presencial";
        } else if (data.mensajebajo == "id") {
          mensajebajoObj.notas = "No tienes permisos para controlar el dispositivo, coloque bien el indentificador";
        } else if (data.mensajebajo == "servidor") {
          mensajebajoObj.notas = "verifique el servidor del dispositivo.";
        } else if (data.mensajebajo == "401") {
          mensajebajoObj.notas = "Verifique el token del dispositivo para que pueda ser controlado.";
        }



        //HTML BLOQUEO
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Bloqueo";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += desbloqueoObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML ESTADO
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Encendido logico";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += estadoObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML TOKEN
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Token";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += tokenObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML SERVIDOR
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "Servidor";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += servidorObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML EN LINEA
        htmlCheckupTable += "<tr>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += "En linea";
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.estado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.accion;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.nuevoEstado;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "<td>";
        htmlCheckupTable += enLineaObj.notas;
        htmlCheckupTable += "</td>";
        htmlCheckupTable += "</tr>";

        //HTML FOOTER NOTES
        var htmlCheckupTableFooter = "";
        htmlCheckupTableFooter += "<tr>";
        htmlCheckupTableFooter += "<td class='footerContent'>";
        htmlCheckupTableFooter += "<div class='titleNotasFooter'>";
        htmlCheckupTableFooter += "Mensajes generales";
        htmlCheckupTableFooter += "</div>";
        htmlCheckupTableFooter += "<div class='contentNotasFooter'>";
        htmlCheckupTableFooter += mensajebajoObj.notas;
        htmlCheckupTableFooter += "</div>";
        htmlCheckupTableFooter += "<div class='contentNotasFooter'>";
        htmlCheckupTableFooter += mensajeObj.notas;
        htmlCheckupTableFooter += "</div>";
        htmlCheckupTableFooter += "</td>";
        htmlCheckupTableFooter += "</tr>";

        hideLoading("contentCheckup", htmlContentCheckup);


        $("#footerCheckup").html("");
        $("#footerCheckup").html(htmlCheckupTableFooter);
        $("#contentCheckup").html("");
        $("#contentCheckup").html(htmlCheckupTable);

      }



    } else {
      alertify.warning("No se pudo realizar el check-up intentelo mas tarde");
    }

  });
}

//shelly
function pruebaaaas(Id) {
  console.log(Id);
}
function encendershelly(idVehiculo) {
  var params = {
    funct: 'encendershelly',
    idVehiculo: idVehiculo
  };

  ajaxData(params, function (data) {

  });
}

function seedata() {
  var tipo = "";
  tipo = document.getElementById('Alarma').value;
  console.log(tipo);
  var params = {
    funct: 'seedata',
    tipod: tipo
  };
  ajaxData(params, function (data) {
    if (data.success) {
      //let imprimir = "";
      //let valor = "'<label>Cuenta: </label>";


      let html = ' <label>Cuenta: </label> <select class="form-control" name="txtCuentaAlarma" id="txtCuentaAlarma"> <option value="">Seleccione...</option>';
      $.each(data.shelly, function (key, value) {
        //valor += '<br> <option value="'+value.nombre+'">'+value.nombre+'</option> </br>';
        /*const vaalor = value.nombre;
        let text = "";
        for (let i = 0; i < vaalor.length; i++) {
          text += vaalor[i] + "<br>";
        }
        document.getElementById('demo').innerHTML= text;*/

        html += '	 <option value="' + value.nombre + '">' + value.nombre + '</option>';
        //imprimir += '<option value="'+value.nombre+'">'+value.nombre+'</option>';
      });
      //document.getElementById('LIST').innerHTML=valor;
      //html += '</option>';
      document.getElementById('prueba').innerHTML = html;
      //document.getElementById('LIST').innerHTML= imprimir, '<br>';
    }

  });
}

function encenderAlarmaPeticion(idVehiculo, accion, historico) {
  if (idVehiculo == 4) {
    //console.log("PIKAPI");
  }
  // console.log(idVehiculo);
  historico = typeof historico === "undefined" ? 0 : 1;

  if (idVehiculo == null || idVehiculo == undefined || idVehiculo == 0) {

  } else {
    var params = {
      funct: "encenderAlarmaPeticion",
      idVehiculo: idVehiculo,
      accion: accion,
      idUsuario: $("#usuarioSesionId").val(),
    };
    var nombreBtn = accion == 1 ? "btnAlarmaEncender_" : "btnAlarmaApagar_";
    var htmlOriginal = showLoading(nombreBtn + idVehiculo);
    ajaxData(params, function (data) {
      // console.log(data);
      hideLoading(nombreBtn + idVehiculo, htmlOriginal);
      alertify.success("Acci&oacute;n realizada correctamente");

      if (recargarPagina) {
        recargarPagina = false;
        location.reload();
      }
    });
  }
}

// ------------------------------- Pop reportes mascota vista -------------------------------
function verReportesMascotaVista(idRptMascota, totalReportes) {
  $('#tabla-reportesmascotas').html('');
  if (totalReportes === 0) {
    $("#sin-reportes").show();
    return true;
  } else {
    var params = {
      funct: "mostrarReportesMascotaVista",
      idRptMascota: idRptMascota,
    };

    ajaxData(params, function (data) {
      let tablaReportesMascotas = document.getElementById('tabla-reportesmascotas');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID Reporte";
      let head2 = document.createElement('th');
      head2.innerHTML = "Persona que hizo el reporte";
      let head3 = document.createElement('th');
      head3.innerHTML = "Correo";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tel&eacute;fono";
      let head5 = document.createElement('th');
      head5.innerHTML = "Descripci&oacute;n";
      let head6 = document.createElement('th');
      head6.innerHTML = "Fecha en que vio a la mascota";
      let head7 = document.createElement('th');
      head7.innerHTML = "Creaci&oacute;n del reporte";
      let head8 = document.createElement('th');
      head8.innerHTML = "Zona donde se vio a la mascota";
      let head9 = document.createElement('th');
      head9.innerHTML = "Evidencias";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      rowHead.appendChild(head7);
      rowHead.appendChild(head8);
      rowHead.appendChild(head9);
      tablaHead.appendChild(rowHead);

      data.reportes.forEach(llenartablaReportes => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablaReportes.idRespMascota;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.nombreContacto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.emailContacto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.telContacto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.descripcion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.fechaVisto.substr(0, 10);
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerHTML = llenartablaReportes.fechaCreacion;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerHTML = `<a class="cta" data-toggle="modal" data-target="#popup_mapaZonaMascota" onclick="verZonaMascotaReportada(` + llenartablaReportes.ubicacion + `)"> Ver zona </a>`;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerHTML = `<a class="cta" data-toggle="modal" data-target="#popup_imagenesMascotaVista" onclick="verImgsMascotaVista(` + llenartablaReportes.idRespMascota + `)"> Ver </a>`;
        fila.appendChild(td);

        cuerpoTabla.appendChild(fila);
      });
      tablaReportesMascotas.appendChild(cuerpoTabla);
      tablaReportesMascotas.appendChild(tablaHead);
    });

    $("#tabla-divRepoMascotas").show();
    $("#body-asignacion").show();
    $("#sin-reportes").hide();
  }
}

function verImagenesMascota(idRptMascota) {
  var params = {
    funct: "verImagenesMascota",
    idRptMascota: idRptMascota,
  };

  ajaxData(params, function (data) {
    var html = '';
    if (data.imagenesMascota.length === 0) {
      html += '<div style="color: ghostwhite;padding: 10px;font-size: 14px;"> Sin im&aacute;genes disponibles. </div>'
    } else {
      html += '<ul>';
      $.each(data.imagenesMascota, function (i, v) {
        html += '<li class="sinVineta">';
        html += '<img src="' + '../upload/mascotas_perdidas' + '/' + v.urlImg + '" onclick="window.open(this.src)">';
        html += '</li>';
      });
      html += '</ul>';
    }

    $("#mostrarFotosMascota").html(html);
  });

}

function verZonaMascotaReportada(lat, long) {
  var html = '';
  if (lat === null || lat === undefined) {
    html += "No existe ninguna zona reportada."
    $("#mapaZonaMascota").html(html);
  } else {
    var center = {
      lat: lat,
      lng: long
    }

    const map = new google.maps.Map(document.getElementById("mapaZonaMascota"), {
      zoom: 16,
      // maxZoom: 16,
      center: center,
      draggable: true,
      styles: [
        { elementType: "geometry", stylers: [{ color: "#242f3e" }] },
        { elementType: "labels.text.stroke", stylers: [{ color: "#242f3e" }] },
        { elementType: "labels.text.fill", stylers: [{ color: "#746855" }] },
        {
          featureType: "administrative.locality",
          elementType: "labels.text.fill",
          stylers: [{ color: "#d59563" }],
        },
        {
          featureType: "poi",
          elementType: "labels.text.fill",
          stylers: [{ color: "#d59563" }],
        },
        {
          featureType: "poi.park",
          elementType: "geometry",
          stylers: [{ color: "#263c3f" }],
        },
        {
          featureType: "poi.park",
          elementType: "labels.text.fill",
          stylers: [{ color: "#6b9a76" }],
        },
        {
          featureType: "road",
          elementType: "geometry",
          stylers: [{ color: "#38414e" }],
        },
        {
          featureType: "road",
          elementType: "geometry.stroke",
          stylers: [{ color: "#212a37" }],
        },
        {
          featureType: "road",
          elementType: "labels.text.fill",
          stylers: [{ color: "#9ca5b3" }],
        },
        {
          featureType: "road.highway",
          elementType: "geometry",
          stylers: [{ color: "#746855" }],
        },
        {
          featureType: "road.highway",
          elementType: "geometry.stroke",
          stylers: [{ color: "#1f2835" }],
        },
        {
          featureType: "road.highway",
          elementType: "labels.text.fill",
          stylers: [{ color: "#f3d19c" }],
        },
        {
          featureType: "transit",
          elementType: "geometry",
          stylers: [{ color: "#2f3948" }],
        },
        {
          featureType: "transit.station",
          elementType: "labels.text.fill",
          stylers: [{ color: "#d59563" }],
        },
        {
          featureType: "water",
          elementType: "geometry",
          stylers: [{ color: "#17263c" }],
        },
        {
          featureType: "water",
          elementType: "labels.text.fill",
          stylers: [{ color: "#515c6d" }],
        },
        {
          featureType: "water",
          elementType: "labels.text.stroke",
          stylers: [{ color: "#17263c" }],
        },
      ],
    });

    var iconoFoto = '../images/mascotas.png';

    new google.maps.Marker({
      position: center,
      map,
      draggable: false,
      icon: {
        url: iconoFoto,
        scaledSize: new google.maps.Size(50, 50), // scaled size
      },
    });

    var circle = new google.maps.Circle({
      strokeColor: "#FF0000",
      strokeOpacity: 0.6,
      strokeWeight: 2,
      fillColor: "#FF0000",
      fillOpacity: 0.2,
      map,
      center: center,
      radius: 300,
    });

    // var lastZoom = 16;
    // var rMin = 150, rMax = 300, step = 10;
    // google.maps.event.addListener(map, 'zoom_changed', function() {
    //   var zoom = map.getZoom();
    //   if (zoom > lastZoom) {
    //     rMax /= 2;
    //     rMin /= 2;
    //     step /= 2;
    //   } else {
    //     rMax *= 2;
    //     rMin *= 2;
    //     step *= 2;
    //   }
    //   lastZoom = zoom;
    //   circle.setRadius(rMax);
    // });
  }
}

function verImgsMascotaVista(idRespMascota) {
  var params = {
    funct: "verImagenesMascotaVista",
    idRespMascota: idRespMascota,
  };

  ajaxData(params, function (data) {
    var html = '';
    if (data.imagenesMascota.length === 0) {
      html += '<div style="color: ghostwhite;padding: 10px;font-size: 14px;"> Sin im&aacute;genes subidas por el usuario que report&oacute;. </div>'
    } else {
      html += '<ul>';
      $.each(data.imagenesMascota, function (i, v) {
        html += '<li class="sinVineta">';
        html += '<img src="' + '../upload/mascotas_perdidas' + '/' + v.urlImg + '" onclick="window.open(this.src)">';
        html += '</li>';
      });
      html += '</ul>';
    }

    $("#imgsMascotaVista").html(html);
  });
}

function verImagenesPersonaPerdida(idRptPersona) {
  var params = {
    funct: "verImagenesPersonaPerdida",
    idRptPersona: idRptPersona,
  };

  ajaxData(params, function (data) {
    var html = '';

    html += '<ul>';
    $.each(data.imagenesPersona, function (i, v) {
      html += '<li class="sinVineta">';
      html += '<img src="' + '../upload/personas_desaparecidas' + '/' + v.urlImg + '" onclick="window.open(this.src)">';
      html += '</li>';
    });
    html += '</ul>';

    $("#mostrarFotosPersonaPerdida").html(html);
  });
}

function verZonaPersonaReportada(lat, long) {
  var html = '';
  if (lat === null || lat === undefined) {
    html += "No existe ninguna zona reportada."
    $("#mapaZonaPersona").html(html);
  } else {
    var center = {
      lat: lat,
      lng: long
    }

    const map = new google.maps.Map(document.getElementById("mapaZonaPersona"), {
      zoom: 16,
      // maxZoom: 16,
      center: center,
      draggable: true,
      styles: [
        { elementType: "geometry", stylers: [{ color: "#242f3e" }] },
        { elementType: "labels.text.stroke", stylers: [{ color: "#242f3e" }] },
        { elementType: "labels.text.fill", stylers: [{ color: "#746855" }] },
        {
          featureType: "administrative.locality",
          elementType: "labels.text.fill",
          stylers: [{ color: "#d59563" }],
        },
        {
          featureType: "poi",
          elementType: "labels.text.fill",
          stylers: [{ color: "#d59563" }],
        },
        {
          featureType: "poi.park",
          elementType: "geometry",
          stylers: [{ color: "#263c3f" }],
        },
        {
          featureType: "poi.park",
          elementType: "labels.text.fill",
          stylers: [{ color: "#6b9a76" }],
        },
        {
          featureType: "road",
          elementType: "geometry",
          stylers: [{ color: "#38414e" }],
        },
        {
          featureType: "road",
          elementType: "geometry.stroke",
          stylers: [{ color: "#212a37" }],
        },
        {
          featureType: "road",
          elementType: "labels.text.fill",
          stylers: [{ color: "#9ca5b3" }],
        },
        {
          featureType: "road.highway",
          elementType: "geometry",
          stylers: [{ color: "#746855" }],
        },
        {
          featureType: "road.highway",
          elementType: "geometry.stroke",
          stylers: [{ color: "#1f2835" }],
        },
        {
          featureType: "road.highway",
          elementType: "labels.text.fill",
          stylers: [{ color: "#f3d19c" }],
        },
        {
          featureType: "transit",
          elementType: "geometry",
          stylers: [{ color: "#2f3948" }],
        },
        {
          featureType: "transit.station",
          elementType: "labels.text.fill",
          stylers: [{ color: "#d59563" }],
        },
        {
          featureType: "water",
          elementType: "geometry",
          stylers: [{ color: "#17263c" }],
        },
        {
          featureType: "water",
          elementType: "labels.text.fill",
          stylers: [{ color: "#515c6d" }],
        },
        {
          featureType: "water",
          elementType: "labels.text.stroke",
          stylers: [{ color: "#17263c" }],
        },
      ],
    });

    var iconoFoto = '../images/persona.png';

    new google.maps.Marker({
      position: center,
      map,
      draggable: false,
      icon: {
        url: iconoFoto,
        scaledSize: new google.maps.Size(50, 50), // scaled size
      },
    });

    var circle = new google.maps.Circle({
      strokeColor: "#FF0000",
      strokeOpacity: 0.6,
      strokeWeight: 2,
      fillColor: "#FF0000",
      fillOpacity: 0.2,
      map,
      center: center,
      radius: 300,
    });

  }
}

function verImgsPersonaVista(idRespPersona) {
  var params = {
    funct: "verImagenesPersonaVista",
    idRespPersona: idRespPersona,
  };

  ajaxData(params, function (data) {
    var html = '';
    if (data.imagenesPersona.length === 0) {
      html += '<div style="color: ghostwhite;padding: 10px;font-size: 14px;"> Sin im&aacute;genes subidas por el usuario que report&oacute;. </div>'
    } else {
      html += '<ul>';
      $.each(data.imagenesPersona, function (i, v) {
        html += '<li class="sinVineta">';
        html += '<img src="' + '../upload/personas_desaparecidas' + '/' + v.urlImg + '" onclick="window.open(this.src)">';
        html += '</li>';
      });
      html += '</ul>';
    }

    $("#imgsPersonaVista").html(html);
  });
}

function activarPersonaPerdida(idRptPersona, activo) {
  alertify.confirm(
    "Cambiar estatus de la persona desaparecida",
    activo == 0 ? "Se activara el registro de esta persona y se podr&aacute; visualizar en la aplicaci&oacute;n.<br/> &#191;Esta seguro de realizar esta acci&oacute;n?" :
      "Se desactivara el registro de esta persona y no se podr&aacute; visualizar en la aplicaci&oacute;n.<br/> &#191;Esta seguro de realizar esta acci&oacute;n?",
    function () {
      var enviarStatus = (activo == 0) ? 1 : 0;

      var params = {
        funct: "activarDesactivarPersonaPerdida",
        idRptPersona: idRptPersona,
        activo: enviarStatus
      };

      ajaxData(params, function (data) {
        console.log(data)
        if (data.success) {
          location.reload();
        }
      })
    },
    function () { }
  ).set({
    labels: {
      ok: "Aceptar",
      cancel: "Cancelar"
    }
  });
}

// ------------------------------- Pop reportes persona vista -------------------------------
function verReportesPersonaVista(idRptPersona, totalReportes) {
  $('#tabla-reportespersona').html('');
  if (totalReportes === 0) {
    $("#sin-reportes").show();
    return true;
  } else {
    var params = {
      funct: "mostrarReportesPersonaVista",
      idRptPersona: idRptPersona,
    };

    ajaxData(params, function (data) {
      let tablaReportesPersonas = document.getElementById('tabla-reportespersonas');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');
      let head1 = document.createElement('th');
      head1.innerHTML = "ID Reporte";
      let head2 = document.createElement('th');
      head2.innerHTML = "Persona que hizo el reporte";
      let head3 = document.createElement('th');
      head3.innerHTML = "Correo";
      let head4 = document.createElement('th');
      head4.innerHTML = "Tel&eacute;fono";
      let head5 = document.createElement('th');
      head5.innerHTML = "Descripci&oacute;n";
      let head6 = document.createElement('th');
      head6.innerHTML = "Fecha en que vio a la persona";
      let head7 = document.createElement('th');
      head7.innerHTML = "Creaci&oacute;n del reporte";
      let head8 = document.createElement('th');
      head8.innerHTML = "Zona donde se vio a la persona";
      let head9 = document.createElement('th');
      head9.innerHTML = "Evidencias";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      rowHead.appendChild(head7);
      rowHead.appendChild(head8);
      rowHead.appendChild(head9);
      tablaHead.appendChild(rowHead);

      data.reportes.forEach(llenartablaReportes => {
        let fila = document.createElement('tr');
        let td = document.createElement('td');
        td.innerText = llenartablaReportes.idRespPersona;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.nombreContacto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.emailContacto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.telContacto;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.descripcion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerText = llenartablaReportes.fechaVisto.substr(0, 10);
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerHTML = llenartablaReportes.fechaCreacion;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerHTML = `<a class="cta" data-toggle="modal" data-target="#popup_mapaZonaPersona" onclick="verZonaPersonaReportada(` + llenartablaReportes.ubicacion + `)"> Ver zona </a>`;
        fila.appendChild(td);
        td = document.createElement('td');
        td.innerHTML = `<a class="cta" data-toggle="modal" data-target="#popup_imagenesPersonaVista" onclick="verImgsPersonaVista(` + llenartablaReportes.idRespPersona + `)"> Ver </a>`;
        fila.appendChild(td);

        cuerpoTabla.appendChild(fila);
      });
      tablaReportesPersonas.appendChild(cuerpoTabla);
      tablaReportesPersonas.appendChild(tablaHead);
    });

    $("#tabla-divRepoPersonas").show();
    $("#body-asignacion").show();
    $("#sin-reportes").hide();
  }
}


function eliminarPersonaDesaparecida(idRptPersona) {
  alertify.confirm("¿Esta seguro de eliminar a este persona?", "Una vez confirmada la acción, los cambios son irreversibles.",
    function () {
      var params = {
        funct: "eliminarPersonaDesaparecida",
        idRptPersona: idRptPersona,
      };
      ajaxData(params, function (data) {
        if (data.success) {
          alertify.success('Persona eliminada correctamente');
          setTimeout(() => {
            gridPersonas.refresh();
            gridPersonas.commit();
          }, "1000");
        } else {
          alertify.error('Algo sali&oacute; mal al intentar eliminar a esta persona.')
        }
      });
    },
    function () {
      alertify.error('Acci&oacute;n cancelada.')
    }
  );
}

function eliminarMascotaDesaparecida(idRptMascota) {
  alertify.confirm("¿Esta seguro de eliminar a este persona?", "Una vez confirmada la acción, los cambios son irreversibles.",
    function () {
      var params = {
        funct: "eliminarMascotaDesaparecida",
        idRptMascota: idRptMascota,
      };
      ajaxData(params, function (data) {
        if (data.success) {
          alertify.success('Mascota eliminada correctamente');
          setTimeout(() => {
            gridMascotas.refresh();
            gridMascotas.commit();
          }, "1000");
        } else {
          alertify.error('Algo sali&oacute; mal al intentar eliminar a esta mascota.')
        }
      });
    },
    function () {
      alertify.error('Acci&oacute;n cancelada.')
    }
  );
}

function verEvidenciaBuzon(idBuzon) {
  $("#mostrarEvidenciaBuzon").html("");

  var params = {
    funct: "verBuzonPorID",
    idBuzon: idBuzon,
  };

  ajaxData(params, function (data) {
    if (data.datosBuzon.evidencias === "") {
      var html = '';
      html += '<ul>';
      html += '<li class="sinVineta">';
      html += '<p style="margin-top: 10px;"> Sin evidencias disponibles </p>';
      html += '</li>';
      html += '</ul>';
    } else {
      var extensions = new RegExp(/.jpg|.jpeg|.png/i);
      var ext = data.datosBuzon.evidencias.substring(data.datosBuzon.evidencias, data.datosBuzon.evidencias.length);

      if (!extensions.test(ext)) {
        var html = '';
        html += '<ul>';
        html += '<li class="sinVineta">';
        html += '<video style="width:80%;height: 500px;margin: 10px 0px;" src="' + '../upload/buzon_ciudadano' + '/' + data.datosBuzon.evidencias + '" onclick="window.open(this.src)" autoplay controls>';
        html += '</li>';
        html += '</ul>';
      } else {
        var html = '';
        html += '<ul>';
        html += '<li class="sinVineta">';
        html += '<img src="' + '../upload/buzon_ciudadano' + '/' + data.datosBuzon.evidencias + '" onclick="window.open(this.src)" style="margin: 10px 0px;">';
        html += '</li>';
        html += '</ul>';
      }
    }

    $("#mostrarEvidenciaBuzon").html(html);
  })
}


function guardarFrmUsuarioAdministrativo() {
  var Irol = "";
  var nombre = "";
  var email = "";
  var password = "";
  var activo = "";
  var idUsuario = "";
  var nombreIrol = "";
  var activoValor = "";
  var permiso = "";
  var permisoValor = "";

  Irol = document.getElementById("IrolU").value;
  nombre = document.getElementById("nombreU").value;
  email = document.getElementById("emailU").value;
  password = document.getElementById("passU").value;
  activo = document.getElementById("activoU").value;
  idUsuario = document.getElementById("idUsuario").value;
  permiso = document.getElementById("PermisoU").value;

  if (Irol == 2) {
    nombreIrol = "Administrador";
  }
  if (Irol == 5) {
    nombreIrol = "Empadronamiento";
  }
  if (Irol == 6) {
    nombreIrol = "Supervisor";
  }
  if (Irol == 7) {
    nombreIrol = "Analista";
  }

  if (Irol == 8) {
    nombreIrol = "Dashboard";
  }

  if (Irol == 9) {
    nombreIrol = "Empadronamiento TI";
  }

  if (Irol == 11) {
    nombreIrol = "Prevención del delito";
  }
  if (Irol == 12) {
    nombreIrol = "Atención a Víctimas";
  }
  if (Irol == 13) {
    nombreIrol = "Coordinación operativa";
  }
  if (Irol == 14) {
    nombreIrol = "Área operativa de la policía municipal";
  }
  if (Irol == 15) {
    nombreIrol = "Instituto Municipal de la Mujer";
  }
  if (Irol == 16) {
    nombreIrol = "Unidad de analisi de la Central de emergencias";
  }
  if (Irol == 17) {
    nombreIrol = "Atención Ciudadana";
  }
  if (Irol == 18) {
    nombreIrol = "Coordinación de juntas auxiliares";
  }
  if (Irol == 19) {
    nombreIrol = "Dashboard Tehuacán 1";
  }
  if (Irol == 20) {
    nombreIrol = "Dashboard Tehuacán 2";
  }
  if (Irol == 21) {
    nombreIrol = "Bienestar animal";
  }
  if (Irol == 22) {
    nombreIrol = "Central de Emergencias y Respuesta inmedita";
  }
  if (Irol == 23) {
    nombreIrol = "Supervisor Tehuacán";
  }
  if (Irol == 24) {
    nombreIrol = "Segundo al mando";
  }
  if (Irol == 25) {
    nombreIrol = "Monitorista Tehuacán";
  }
  if (Irol == 26) {
    nombreIrol = "Guardia Civil Turistica";
  }
  if (Irol == 27) {
    nombreIrol = "Tránsito Municipal";
  }


  if (activo == 1) {
    activoValor = "Si";
  }
  if (activo == 0) {
    activoValor = "No";
  }
  if (permiso == 0) {
    permisoValor = "No";
  }
  if (permiso == 1) {
    permisoValor = "Si";
  }


  if (Irol != 0) {
    if (Irol == 2) {
      alertify.confirm('¿Está seguro de cambiar los datos de este usuario?', 'Recuerde que editar la informaci&oacute;n puede tener alteraciones en el uso del sistema <br/> <br/> Los datos del usuario quedarían de la siguiente manera: <br/> <b>&nbsp&nbspRol:</b> ' + nombreIrol + '<br/>' + '<b>&nbsp&nbspNombre:</b> ' + nombre + '<br/>' + '<b>&nbsp&nbspEmail:</b> ' + email + '<br/>' + '<b>&nbsp&nbspContraseña:</b> ' + "<p id ='passwordEditUserAdmin' class='hide' style='display: contents'>" + password + "</p> <br/> <a onclick ='eyes2()' style='color: black; text-decoration: none;cursor: grab; display: flex; padding-left: 10px; align-items: center;'><i class='fa fa-eye-slash fa-2x' aria-hidden='true' style='font-size: 1.5em;'></i><div style='padding-left: 10px'> Ver contraseña </div></a>" + '<b>&nbsp&nbspUsuario activo:</b> ' + activoValor + '<br/>' + '<b>&nbsp&nbspUsuario con permiso :</b> ' + permisoValor,
        function () {
          var param = {
            funct: "UpdateUsuarioAdministrador",
            idUsuario: idUsuario,
            nombre: nombre,
            email: email,
            password: password,
            Irol: Irol,
            activo: activo,
            permiso: permiso
          }
          ajaxData(param, function (data) {
            if (data.success) {
              alertify.success(data.usuario);
              setTimeout(() => {
                window.location.href = "catalogos.php?catalog=usuariosAdmistrador";
              }, "1000");
            } else {
              alertify.warning(data.usuario);
            }

          });
        }, function () { alertify.error('Cancel') });

    } else {
      alertify.confirm('¿Está seguro de cambiar los datos de este usuario?', 'Recuerde que editar la informaci&oacute;n puede tener alteraciones en el uso del sistema <br/> <br/> Los datos del usuario quedarían de la siguiente manera: <br/> <b>&nbsp&nbspRol:</b> ' + nombreIrol + '<br/>' + '<b>&nbsp&nbspNombre:</b> ' + nombre + '<br/>' + '<b>&nbsp&nbspEmail:</b> ' + email + '<br/>' + '<b>&nbsp&nbspContraseña:</b> ' + "<p id ='passwordEditUserAdmin' class='hide' style='display: contents'>" + password + "</p> <br/> <a onclick ='eyes2()' style='color: black; text-decoration: none;cursor: grab; display: flex; padding-left: 10px; align-items: center;'><i class='fa fa-eye-slash fa-2x' aria-hidden='true' style='font-size: 1.5em;'></i><div style='padding-left: 10px'> Ver contraseña </div></a>" + '<b>&nbsp&nbspUsuario activo:</b> ' + activoValor,
        function () {
          permiso = 0;
          var param = {
            funct: "UpdateUsuarioAdministrador",
            idUsuario: idUsuario,
            nombre: nombre,
            email: email,
            password: password,
            Irol: Irol,
            activo: activo,
            permiso: permiso
          }
          ajaxData(param, function (data) {
            if (data.success) {
              alertify.success(data.usuario);
              setTimeout(() => {
                window.location.href = "catalogos.php?catalog=usuariosAdmistrador";
              }, "1000");
            } else {
              alertify.warning(data.usuario);
            }

          });
        }, function () { alertify.error('Cancel') });
    }
  } else {
    alertify.warning("Favor de selecionar un Rol");
  }



}

function deleteUsuarioAdministrativo(idUsuario) {
  alertify.confirm("¿Esta seguro de eliminar a este usuario?", "Una vez confirmada la acción, los cambios son irreversibles.",
    function () {
      var param = {
        funct: "deleteUsuarioAdministrativo",
        idUsuario: idUsuario
      }
      ajaxData(param, function (data) {
        if (data.success) {
          alertify.success(data.usuario);
          setTimeout(() => {
            usuariosAdministrativo.refresh();
            usuariosAdministrativo.commit();
          }, "1000");
        } else {
          alertify.warning(data.usuario);
        }
      });
    },
    function () {
      // alertify.error('Cancel')
    }
  );
}

function AltaUsuarioAdministrador() {
  var nombre = "";
  var correo = "";
  var password = "";
  var Irol = "";
  var permiso = "";

  nombre = document.getElementById('txtNombre').value;
  correo = document.getElementById("txtCorreo").value;
  password = document.getElementById("txtPassword").value;
  Irol = document.getElementById("textIrol").value;
  permiso = document.getElementById("textPermiso").value;

  if (nombre != "" && correo != "" && password != "" && Irol != "" && Irol > 0) {
    if (Irol != 2) {
      permiso = 0;
    }
    var param = {
      funct: "AltaUsuarioAdministrativo",
      nombre: nombre,
      correo: correo,
      password: password,
      Irol: Irol,
      Permiso: permiso
    }
    ajaxData(param, function (data) {
      if (data.success) {
        alertify.success("El registro del nuevo Usuario se realizo correctamente");
        setTimeout(function () {
          window.location.href = "catalogos.php?catalog=usuariosAdmistrador";
        }, 1500);
      } else if (data.success === false) {
        alertify.warning(data.usuario);
      } else {
        alertify.warning("No se pudo registrar el Usuario , intentelo mas tarde");
      }
    });
  } else {
    alertify.warning("Favor de llenar todos los campos solicitados");
  }
}

function regresarUsuariosAdmins() {
  window.location.href = "catalogos.php?catalog=usuariosAdmistrador";
}

function ObteneIrol() {
  var Irol = "2,5,6,7,8,9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27";
  var param = {
    funct: "ObteneIrol",
    Irol: Irol
  }
  ajaxData(param, function (data) {
    if (data.success) {
      var html = "";
      html += '<option value =' + 0 + ' >Selecione un Rol</option>';
      for (var i = 0; i < data.Irol.length; i++) {
        html += '<option value =' + data.Irol[i].idRol + '>' + data.Irol[i].rol + '</option>';
      }
      $("#textIrol").html(html);
    }
  });
}

function eyes() {
  var x = document.getElementById("txtPassword");
  var B = document.getElementById("eyes1");
  var E = document.getElementById("eyes2");
  if (x.type === "password") {
    x.type = "text";

    B.style.display = "block";
    E.style.display = "none";
  } else {
    x.type = "password";
    B.style.display = "none";
    E.style.display = "block";
  }
}

function ROLctual(iDrol) {
  var Irol = "2,5,6,7,8,9,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27";
  var param = {
    funct: "RolActual",
    Irol: Irol,
    iDrol: iDrol
  }
  ajaxData(param, function (data) {
    if (data.success) {
      var html = "";
      html += '<option value =' + 0 + ' >Selecione un Rol</option>';
      for (var i = 0; i < data.selector.length; i++) {
        html += '<option value =' + data.selector[i].idRol + '>' + data.selector[i].rol + '</option>';
      }
      $("#IrolU").html(html);
    }
  });
}

var oculto = true;
function eyes2() {
  if (oculto === true) {
    $("#passwordEditUserAdmin").removeClass("hide");
    oculto = false;
  }
  else {
    $("#passwordEditUserAdmin").addClass("hide");
    oculto = true;
  }
}

function dataIdRol() {

  var idIrol = document.getElementById('textIrol').value;

  var visionDelDiv = document.getElementById("perimisotext");
  if (idIrol == 2) {
    if (visionDelDiv.style.display === "none") {
      visionDelDiv.style.display = "block";
    }
  } else {
    visionDelDiv.style.display = "none";
  }

}

function verGridPersonasDesaparecidas() {
  $("#gridPersonasDesaparecidas").css("display", "block");
  $("#gridPersonasEncontradas").css("display", "none");

  $("#btnVerPersonasDesaparecidas").css("opacity", "0.5");
  $("#btnVerPersonasEncontradas").css("opacity", "1.0");
}

function verGridPersonasEncontradas() {
  $("#gridPersonasEncontradas").css("display", "block");
  $("#gridPersonasDesaparecidas").css("display", "none");

  $("#btnVerPersonasDesaparecidas").css("opacity", "1.0");
  $("#btnVerPersonasEncontradas").css("opacity", "0.5");
}

//mostrar si hay mensajes en las peticiones

function verMensajes(idPeticion, numMensajes) {
  $('#tabla-mensajes').html('');
  $("#no-mensaje").hide();

  if (numMensajes === 0) {
    $("#no-mensaje").show();
    return true;
  } else {
    var params = {
      funct: "mostrarMensajesPeticion",
      idPeticion: idPeticion,
    };

    ajaxData(params, function (data) {
      let tablaMensajes = document.getElementById('tabla-mensajes');
      let tablaHead = document.createElement('thead');
      let cuerpoTabla = document.createElement('tbody');

      let rowHead = document.createElement('tr');

      let head1 = document.createElement('th');
      head1.innerHTML = "ID Peticion";

      let head2 = document.createElement('th');
      head2.innerHTML = "Usuario";

      let head3 = document.createElement('th');
      head3.innerHTML = "Tipo Mensaje";

      let head4 = document.createElement('th');
      head4.innerHTML = "T&iacute;tulo";

      let head5 = document.createElement('th');
      head5.innerHTML = "Contenido mensaje";

      let head6 = document.createElement('th');
      head6.innerHTML = "Fecha";

      let head7 = document.createElement('th');
      head7.innerHTML = "Imagen";

      rowHead.appendChild(head1);
      rowHead.appendChild(head2);
      rowHead.appendChild(head3);
      rowHead.appendChild(head4);
      rowHead.appendChild(head5);
      rowHead.appendChild(head6);
      rowHead.appendChild(head7);
      tablaHead.appendChild(rowHead);

      data.mensajes.forEach(llenarTablaMensajes => {
        let fila = document.createElement('tr');

        let td = document.createElement('td');
        td.innerText = llenarTablaMensajes.idReporte;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.nombre;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.idConcepto;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.titulo;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.contenido;
        fila.appendChild(td);

        td = document.createElement('td');
        td.innerText = llenarTablaMensajes.fechaCreacion;
        fila.appendChild(td);
        if (llenarTablaMensajes.imagen != "") {
          td = document.createElement('td');
          td.innerHTML = '<a href="../upload/mensajes/' + llenarTablaMensajes.imagen + '" target="_blank"><img class="imagen-celda" src="../upload/mensajes/' + llenarTablaMensajes.imagen + '"></a>'
          fila.appendChild(td);//aqui va imagen

        } else {
          td = document.createElement('td');
          td.innerText = '';
          fila.appendChild(td);
        }
        cuerpoTabla.appendChild(fila);
      });
      tablaMensajes.appendChild(cuerpoTabla);
      tablaMensajes.appendChild(tablaHead);
    });

    $("#tabla-div").show();
    $("#body-mensajes").show();

  }//fin de else
}

function dataIdRolUpdate() {

  var idIrol = document.getElementById('IrolU').value;

  var visionDelDiv = document.getElementById("permisoUPDATE");
  if (idIrol == 2) {
    if (visionDelDiv.style.display === "none") {
      visionDelDiv.style.display = "block";
    }
  } else {
    visionDelDiv.style.display = "none";
  }

}

function generarPasswordAdministrativo() {
  var params = {
    funct: 'generarPasswordAdministrativo'
  };
  ajaxData(params, function (data) {
    if (data.success) {
      alertify.success("Contrase&ntilde;a generada");
      $("#txtPassword").val(data.password);
    }
    else {
      alertify.error("No es posible generar contrase&ntilde;a en este momento, intente mas tarde");
    }
  });


}

function enviarCorreoAdministrativo(id) {
  var params = {
    funct: 'enviarCorreoAdministrativo',
    idUsuario: id
  };
  ajaxData(params, function (data) {
    console.table(data)
    if (data.success) {
      alertify.success(data.correo);
    }
    else {
      alertify.error(data.correo);
    }
  });
}

var fotosPersonaDesaparecida = [];
// Enviar reporte de persona desaparecida
$("#btnSubmitPersonaDesaparecida").click(function () {
  var params = {
    funct: 'reportePersonaPerdidaMonitor',
    nombreContacto: $("#txtNombreContactoDesaparecidos").val(),
    correoContacto: $("#txtCorreoContactoDesaparecidos").val(),
    telefonoContacto: $("#txtTelefonoContactoDesaparecidos").val(),
    nombrePersona: $("#txtNombreDesaparecido").val(),
    coloniaPersona: $("#txtColoniaDesaparecido").val(),
    fechaPersona: fechaFormateada($("#txtFechaDesaparecido").val()),
    descripcionPersona: $("#txtDescripcionDesaparecido").val(),
    arrfotosSubidas: fotosPersonaDesaparecida.join(),
    idUsuario: $("#usuarioSesionId").val()
  };
  ajaxData(params, function (data) {
    if (data.success) {
      alertify.success("Registro generado exitosamente.");
      $("#txtNombreContactoDesaparecidos").val(''),
        $("#txtCorreoContactoDesaparecidos").val(''),
        $("#txtTelefonoContactoDesaparecidos").val(''),
        $("#txtNombreDesaparecido").val(''),
        $("#txtColoniaDesaparecido").val(''),
        $("#txtFechaDesaparecido").val(''),
        $("#txtDescripcionDesaparecido").val('')
      $("#previsualizarFotoDesaparecidos").html('')
    }
    else {
      alertify.error('Algo sali&oacute; mal, int&eacute;ntelo de nuevo.')
    }
  });
});

function fechaFormateada(date) {
  // Separar el valor en año, mes y día
  var partesFecha = date.split('-');
  var anio = partesFecha[0];
  var mes = partesFecha[1];
  var dia = partesFecha[2];

  var fechaFormateada = dia + '/' + mes + '/' + anio;

  return fechaFormateada;
}

function altaUnidad() {
  Matricula = document.getElementById("txtMatricula").value;
  Unidad = document.getElementById("txtUnidad").value;

  console.log(Matricula)
  console.log(Unidad)
  var params = {
    funct: 'altaUnidad',
    Unidad: Unidad,
    Matricula: Matricula
  };
  ajaxData(params, function (data) {
    if (data.success) {
      alertify.success("El registro de la patrulla correctamente");
      setTimeout(function () {
        window.history.back()
      }, 2000);
    }
    else {
      alertify.error('Algo sali&oacute; mal, int&eacute;ntelo de nuevo.')
    }
  });

}

// metodo para asignar patrullero si es que lo rechazo el patrullero
function asignarPatrullero($Peticiones) {

  $Peticiones.forEach(Peticion => {

    var params = {
      funct: 'asignarPatrullero',
      Peticion: Peticion.idPeticion
    };

    ajaxData(params, function (data) {

    });

  });

}



function muestraReporteStatusAsignacion(idPeticion) {
  $("#bodyHistoricoUser").empty();


  var params = {
    funct: 'obetnerlogPeticionOperador',
    Peticion: idPeticion
  };
  var html = "";

  ajaxData(params, function (data) {
    if (data.success) {

      if (data.tipo == 1) {
        data.Historico.forEach(function (historico) {

          html += '<tr>';
          html += '<th scope="row">' + historico.idhistorico + ' </th>';
          html += '<td >' + historico.nombre + '</td>';
          html += '<td>' + historico.fecha_creacion + '</td>';

          html += '</tr>';

        });

      } else {
        html += '<tr>';
        html += '<th scope="row"> 1 </th>';
        html += '<td >' + data.Historico + '</td>';
        html += '<td>' + data.dtaosPeticion + '</td>';

        html += '</tr>';

      }

      $("#bodyHistoricoUser").html(html);
    }
  });


}

function cargarMapaUsuarioPeticiones(idPeticion) {
  // Parámetros para la petición AJAX
  var params = {
    funct: 'cargarMapaUsuarioPet',
    Peticion: idPeticion
  };

  // Llamada AJAX para obtener los datos de las ubicaciones
  ajaxData(params, function (data) {


    // Crear un array para almacenar las coordenadas
    var coordenadas = [];
      var inicio, final;

      function formatearFecha(fecha) {
          var fechaObj = new Date(fecha);
          var dia = String(fechaObj.getDate()).padStart(2, '0');
          var mes = String(fechaObj.getMonth() + 1).padStart(2, '0'); // Los meses empiezan desde 0
          var anio = fechaObj.getFullYear();
          var hora = String(fechaObj.getHours()).padStart(2, '0');
          var minutos = String(fechaObj.getMinutes()).padStart(2, '0');
          var segundos = String(fechaObj.getSeconds()).padStart(2, '0');
          return {
              fecha: `${dia}/${mes}/${anio}`,
              hora: `${hora}:${minutos}:${segundos}`
          };
      }

    // Recorre los datos y obtiene las coordenadas
      data.datosUbicacionUsuario.forEach(function(elemento, index) {
      if (elemento.latitud && elemento.longitud) {
              var coordenada = {
          lat: parseFloat(elemento.latitud),
                  lng: parseFloat(elemento.longitud),
                  fecha: formatearFecha(elemento.fechaHcreacion).fecha,
                  hora: formatearFecha(elemento.fechaHcreacion).hora
              };
              coordenadas.push(coordenada);
              if (index === 0) {
                  final = coordenada; 
      }
              if (index === coordenadas.length - 1) {
                  inicio = coordenada; 
              }
          }
    });

    // Si hay coordenadas, crear el mapa
    if (coordenadas.length > 0) {
      // Crear el mapa con un mayor zoom (por ejemplo, zoom 18)
      var map = new google.maps.Map(document.getElementById('mapaRecorrido'), {
              zoom: 20,
              center: coordenadas[0]
      });

      var flightPath = new google.maps.Polyline({
        path: coordenadas, // Pasar el array de coordenadas
        geodesic: true,     // Hacer que la línea siga la curvatura de la Tierra
              strokeColor: '#00008B',
        strokeOpacity: 1.0,      // Opacidad de la línea
              strokeWeight: 3
      });

      flightPath.setMap(map);

          if (inicio.lat === final.lat && inicio.lng === final.lng) {
              var marcadorUnico = new google.maps.Marker({
                  position: inicio,
                  map: map,
                  title: "Punto de Inicio y Final",
                  icon: {
                      url: "https://maps.google.com/mapfiles/ms/icons/green-dot.png"
                  }
              });
              var infoUnico = new google.maps.InfoWindow({
                  content: `<strong>Punto de Inicio y Final</strong><br>Fecha: ${inicio.fecha}<br>Hora: ${inicio.hora}`
              });
              marcadorUnico.addListener('click', function() {
                  infoUnico.open(map, marcadorUnico);
              });
          } else {
              var marcadorInicio = new google.maps.Marker({
                  position: inicio,
                  map: map,
                  title: "Punto de Inicio",
                  icon: {
                      url: "https://maps.google.com/mapfiles/ms/icons/blue-dot.png"
                  }
              });

              // Marcador de final (primer punto)
              var marcadorFinal = new google.maps.Marker({
                  position: final,
                  map: map,
                  title: "Punto de Final",
                  icon: {
                      url: "https://maps.google.com/mapfiles/ms/icons/red-dot.png"
                  }
              });

              // Ventana de información para el punto de inicio
              var infoInicio = new google.maps.InfoWindow({
                  content: `<strong>Ubicación Inicio</strong><br>Fecha: ${inicio.fecha}<br>Hora: ${inicio.hora}`
              });

              // Ventana de información para el punto final
              var infoFinal = new google.maps.InfoWindow({
                  content: `<strong>Ubicación Final</strong><br>Fecha: ${final.fecha}<br>Hora: ${final.hora}`
              });
              
              // Asignar eventos a los marcadores para abrir las ventanas de información
              marcadorInicio.addListener('click', function() {
                  infoInicio.open(map, marcadorInicio);
              });

              marcadorFinal.addListener('click', function() {
                  infoFinal.open(map, marcadorFinal);
              });
          }

          // Mostrar el botón de descarga debajo del mapa
          var descargaContenedor = document.getElementById('descargaContenedorRecorrido');
          descargaContenedor.style.display = 'block';

          var descargarBtn = document.getElementById('descargarBtnRecorrido');
          descargarBtn.onclick = function() {
              descargarMapa(idPeticion);
          };

      } else {
        alertify.notify('No se encontraron coordenadas', 'error', 5);

          // Si no hay coordenadas, ocultar el contenedor del mapa y el botón de descarga
          document.getElementById('mapaRecorrido').innerHTML = "";
          document.getElementById('descargaContenedorRecorrido').style.display = 'none';
         
          
        

      
    }
  });
}
 



function descargarMapa(idPeticion) {
  // Obtener el contenedor del mapa
  var mapaContenedor = document.getElementById('popup_mapaZonarecorrido');

  // Obtener el contenedor del botón de descarga y ocultarlo
  var descargaContenedor = document.getElementById('descargaContenedorRecorrido');
  descargaContenedor.style.display = 'none'; // Ocultar el botón de descarga
  // Cerrar todas las ventanas de información abiertas
  var infoWindows = document.querySelectorAll('.gm-style-iw');
  infoWindows.forEach(function(infoWindow) {
    infoWindow.style.display = 'none';  
  });


  html2canvas(mapaContenedor, {
    scale: 4,  
    logging: false,  
    allowTaint: true, 
    useCORS: true  
  }).then(function(canvas) {
    
    const imgData = canvas.toDataURL('image/png');

    const link = document.createElement('a');
    link.href = imgData;  
    link.download = 'mapa_peticion_' + idPeticion + '.png';  

    link.click();  
   
    alertify.notify('El mapa está descargando...', 'success', 5); // 5 segundos de duración

    // Restaurar el botón de descarga
    descargaContenedor.style.display = ''; // Restaurar el botón de descarga

  }).catch(function(error) {
    console.error("Error al capturar el mapa:", error);

    // Restaurar el botón de descarga en caso de error
    descargaContenedor.style.display = ''; // Restaurar el botón de descarga
  });
}




function obtenerVehiculosMapa2() {
  var params = {
    funct: "obtenerVehiculosMapa",
  };


  ajaxData(params, function (data) {
    if (data.success) {
      //console.log(data.vehiculosdisponibles);
      actualizaVehiculosMapa2(data.vehiculosdisponibles);
    }
  });
}

function buscarPatrulla() {
  var nombrePatrulla = document.getElementById('txtBuscarPatrulla').value;
  console.log(nombrePatrulla);

  if (nombrePatrulla != "" && nombrePatrulla != null) {
    var params = {
      funct: 'buscarPatrulla',
      nombrePatrulla: nombrePatrulla
    };
    ajaxData(params, function (data) {
      if (data.success) {
        clearMarkers();
        seleccionaOpcion(6);
        clearMarkers2();
        var pos = new google.maps.LatLng(data.patrulla.latitud, data.patrulla.longitud);
        map.setZoom(17);
        map.setCenter(pos);
      } else {
        alertify.warning("No se encontraron coincidencias");
      }
    });
  }
}
function insertarToken(token) {
  var params = {
      funct: 'insertaToken',
      token: token  // Aquí usamos el token recibido
  };
  
  console.log("Token recibido en insertarToken:", token); // Esto debería mostrar "hola" en la consola

  ajaxData(params, function(data) {
      if (data.success) {
         // alertify.success("Token registrado correctamente: " + data.datostoken);
      } else {
          //alertify.warning("No se concedieron permisos");
      }
  });
}
